/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.bean.MGL_QRCodeLogo;
import tech.mgl.core.utils.MGL_Asserts;
import tech.mgl.core.utils.MGL_FileIOUtils;

public class MGL_QRCodeUtils {
    private static final Logger logger = LoggerFactory.getLogger(MGL_QRCodeUtils.class);
    private static final int QR_COLOR = -16777216;
    private static final int BG_WHITE = -1;
    private static final String CHARSET = "utf-8";
    private static final String FORMAT_NAME = "PNG";
    private final PictureType pictureType;
    private String path;
    private final int width;
    private final int height;
    private final String content;
    private final MGL_QRCodeLogo logo;

    public PictureType getPictureType() {
        return this.pictureType;
    }

    public String getPath() {
        return this.path;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public MGL_QRCodeLogo getLogo() {
        return this.logo;
    }

    public String getContent() {
        return this.content;
    }

    public MGL_QRCodeUtils(Builder builder) {
        this.width = builder.getWidth();
        this.height = builder.getHeight();
        this.logo = builder.getLogo();
        this.path = builder.getPath();
        this.pictureType = builder.getPictureType();
        this.content = builder.getContent();
    }

    private BufferedImage createQRCodeImage() throws Exception {
        MGL_Asserts.notBlank(this.content, "qrcode content is not empty");
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(this.content, BarcodeFormat.QR_CODE, this.width, this.height, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        bitMatrix = this.updateBit(bitMatrix, 6);
        BufferedImage image = this.toBufferedImage(bitMatrix);
        bitMatrix.clear();
        MGL_QRCodeLogo logo = this.logo;
        if (null != logo) {
            this.insertLogo2QRCode(image, logo);
        }
        return image;
    }

    private BufferedImage toBufferedImage(BitMatrix matrix) {
        BufferedImage image = null;
        try {
            int w = matrix.getWidth();
            int h = matrix.getHeight();
            image = new BufferedImage(w, h, 1);
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error: {}", (Object)e.getMessage());
        }
        return image;
    }

    private BitMatrix updateBit(BitMatrix matrix, int margin) {
        int tempM = margin * 2;
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + tempM;
        int resHeight = rec[3] + tempM;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = margin; i < resWidth - margin; ++i) {
            for (int j = margin; j < resHeight - margin; ++j) {
                if (!matrix.get(i - margin + rec[0], j - margin + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    public synchronized String encodeQRCode2Base64() throws Exception {
        BufferedImage bufferImage = this.createQRCodeImage();
        ByteArrayOutputStream baOs = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferImage, this.pictureType.name(), baOs);
        bufferImage.flush();
        byte[] bytes = baOs.toByteArray();
        return Base64.getEncoder().encodeToString(bytes).trim();
    }

    private void insertLogo2QRCode(BufferedImage source, MGL_QRCodeLogo logo) throws Exception {
        if (!logo.getFile().exists()) {
            return;
        }
        Image src = ImageIO.read(logo.getFile());
        int width = src.getWidth(null);
        int height = src.getHeight(null);
        if (logo.isNeedCompress()) {
            if (width > logo.getWidth()) {
                width = logo.getWidth();
            }
            if (height > logo.getHeight()) {
                height = logo.getHeight();
            }
        }
        Image image = src.getScaledInstance(width, height, 4);
        BufferedImage tag = new BufferedImage(width, height, 1);
        Graphics g = tag.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        src = image;
        image.flush();
        Graphics2D graph = source.createGraphics();
        int x = (source.getWidth() - width) / 2;
        int y = (source.getHeight() - height) / 2;
        graph.drawImage(src, x, y, width, height, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
        src.flush();
    }

    public boolean encodeToOutput(OutputStream output) throws Exception {
        BufferedImage image = this.createQRCodeImage();
        boolean yn = ImageIO.write((RenderedImage)image, FORMAT_NAME, output);
        image.flush();
        return yn;
    }

    public boolean encode() throws Exception {
        MGL_Asserts.notBlank(this.path, "\u751f\u6210\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        BufferedImage image = this.createQRCodeImage();
        Object tempFilePath = MGL_FileIOUtils.getEndWithSlashPath(this.path);
        if (!this.path.toLowerCase().endsWith(".".concat(this.getPictureType().name()))) {
            tempFilePath = (String)tempFilePath + "qrcode".concat("" + System.currentTimeMillis()).concat("." + this.pictureType.name());
        }
        if ("./".equals(this.path)) {
            this.path = tempFilePath;
        }
        System.out.println((String)tempFilePath);
        File f = new File((String)tempFilePath);
        boolean mkOk = true;
        if (null != f.getParentFile() && !f.getParentFile().exists()) {
            mkOk = f.getParentFile().mkdirs();
        }
        if (!mkOk) {
            return false;
        }
        boolean yesNo = ImageIO.write((RenderedImage)image, this.pictureType.name(), f);
        image.flush();
        return yesNo;
    }

    public String decode(File file) throws Exception {
        BufferedImage image = ImageIO.read(file);
        if (image == null) {
            return null;
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, CHARSET);
        image.flush();
        return new MultiFormatReader().decode(bitmap, hints).getText();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum PictureType {
        png,
        jpg,
        jpeg;

    }

    public static class Builder {
        private PictureType pictureType = PictureType.png;
        private String path = "./";
        private int width = 200;
        private int height = 200;
        private String content;
        private MGL_QRCodeLogo logo;

        public MGL_QRCodeLogo getLogo() {
            return this.logo;
        }

        public Builder setLogo(MGL_QRCodeLogo logo) {
            this.logo = logo;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public int getHeight() {
            return this.height;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public PictureType getPictureType() {
            return this.pictureType;
        }

        public Builder setPictureType(PictureType pictureType) {
            this.pictureType = pictureType;
            return this;
        }

        public String getPath() {
            return this.path;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public String getContent() {
            return this.content;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public MGL_QRCodeUtils build() {
            return new MGL_QRCodeUtils(this);
        }
    }
}

