/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.i.impl.translator;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.i.MGLTranslator;

public class DefaultTranslator
implements MGLTranslator {
    private static final String LIBRE_TRANSLATE_URL = "https://translator.mgl.ee/translate";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String translate(String text) {
        return this.translate(text, "en", "auto");
    }

    @Override
    public String translate(String text, String targetLanguage, String sourceLanguage) {
        try {
            URI url = new URI(LIBRE_TRANSLATE_URL);
            CloseableHttpClient client = HttpClients.createDefault();
            HttpPost request = new HttpPost(url);
            request.setHeader("referer", (Object)"https://translator.mgl.ee");
            request.setHeader("origin", (Object)"https://translator.mgl.ee");
            request.setHeader("accept", (Object)"application/json");
            request.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            request.setHeader("charset", (Object)"utf-8");
            request.setHeader("sec-fetch-site", (Object)"same-origin");
            StringEntity entity = new StringEntity("q=" + URLEncoder.encode(text, StandardCharsets.UTF_8) + "&source=" + sourceLanguage + "&api_key=&target=" + targetLanguage + "&format=text", StandardCharsets.UTF_8);
            request.setEntity((HttpEntity)entity);
            String response = (String)client.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
            JSONObject jsonResponse = JSON.parseObject((String)response);
            System.out.println(jsonResponse);
            return jsonResponse.getString("translatedText");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return "Translation failed due to an error with the LibreTranslate API.";
        }
    }
}

