/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.i.impl.mfa;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import tech.mgl.core.i.MFAProvider;
import tech.mgl.core.qrcode.MGL_QRCodeUtils;

public class TOTPProvider
implements MFAProvider {
    private final GoogleAuthenticator googleAuthenticator = new GoogleAuthenticator();

    @Override
    public String generateSecretKey() {
        GoogleAuthenticatorKey key = this.googleAuthenticator.createCredentials();
        return key.getKey();
    }

    @Override
    public String generateSecretKey(String user) {
        GoogleAuthenticatorKey key = this.googleAuthenticator.createCredentials(user);
        return key.getKey();
    }

    @Override
    public boolean validateOtp(String secretKey, int otp) {
        return this.googleAuthenticator.authorize(secretKey, otp);
    }

    @Override
    public String getOtpAuthUrl(String secretKey, String account, String issuer) {
        return String.format("otpauth://totp/%s:%s?secret=%s&issuer=%s", issuer, account, secretKey, issuer);
    }

    @Override
    public String getOtpAuthUrlQRCode(String secretKey, String account, String issuer) {
        String otpAuthUrl = this.getOtpAuthUrl(secretKey, account, issuer);
        try {
            return MGL_QRCodeUtils.builder().setContent(otpAuthUrl).build().encodeQRCode2Base64();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate QR code", e);
        }
    }
}

