/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.i.impl;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.i.BeanMapConverter;

public class PureJavaBeanMapConverter
implements BeanMapConverter {
    private final Logger logger = LoggerFactory.getLogger(PureJavaBeanMapConverter.class);

    @Override
    public <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) {
        try {
            T bean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (PropertyDescriptor pd : Introspector.getBeanInfo(beanClass).getPropertyDescriptors()) {
                String propertyName = pd.getName();
                if (!map.containsKey(propertyName) || pd.getWriteMethod() == null) continue;
                Object value = map.get(propertyName);
                Class<?> targetType = pd.getPropertyType();
                if (targetType.isAnnotation() || targetType.isInterface()) continue;
                value = this.convertValue(value, targetType);
                pd.getWriteMethod().invoke(bean, value);
            }
            return bean;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> beanToMap(Object bean) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (PropertyDescriptor pd : Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
                if (pd.getReadMethod() == null || "class".equals(pd.getName())) continue;
                map.put(pd.getName(), pd.getReadMethod().invoke(bean, new Object[0]));
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private Object convertValue(Object value, Class<?> targetType) throws Exception {
        if (value == null) {
            return null;
        }
        if (targetType.isArray()) {
            Class<?> componentType = targetType.getComponentType();
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Object array = Array.newInstance(componentType, collection.size());
                int i = 0;
                for (Object item : collection) {
                    Array.set(array, i++, this.convertValue(item, componentType));
                }
                return array;
            }
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                Object array = Array.newInstance(componentType, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(array, i, this.convertValue(Array.get(value, i), componentType));
                }
                return array;
            }
            Object array = Array.newInstance(componentType, 1);
            Array.set(array, 0, this.convertValue(value, componentType));
            return array;
        }
        if (targetType.isEnum()) {
            if (value instanceof String) {
                return Enum.valueOf(targetType, (String)value);
            }
            if (value instanceof Enum && targetType.isInstance(value)) {
                return value;
            }
            throw new IllegalArgumentException("Cannot convert " + String.valueOf(value) + " to enum type " + targetType.getName());
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return Integer.parseInt(value.toString());
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return Long.parseLong(value.toString());
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return Double.parseDouble(value.toString());
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return Boolean.parseBoolean(value.toString());
        }
        if (targetType == String.class) {
            return value.toString();
        }
        return value;
    }
}

