/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.c;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.c.MGL_HexUtils;
import tech.mgl.core.utils.MGL_Base64Utils;

public class MGL_CryptoCommonUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MGL_CryptoCommonUtils.class.getSimpleName());
    private static final String ALGORITHM_SHA1 = "SHA-1";
    private static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_SHA256 = "SHA-256";
    public static final String ALGORITHM_SHA512 = "SHA-512";
    public static final String ALGORITHM_AES = "AES";

    public static String SHA1(String decrypt) {
        return MGL_CryptoCommonUtils.SHA(decrypt, ALGORITHM_SHA1, null);
    }

    public static String SHA1(String decrypt, Provider provider) {
        return MGL_CryptoCommonUtils.SHA(decrypt, ALGORITHM_SHA1, provider);
    }

    public static String SHA256(String decrypt) {
        return MGL_CryptoCommonUtils.SHA(decrypt, ALGORITHM_SHA256, null);
    }

    public static String SHA256(String decrypt, Provider provider) {
        return MGL_CryptoCommonUtils.SHA(decrypt, ALGORITHM_SHA256, provider);
    }

    public static String SHA512(String decrypt) {
        return MGL_CryptoCommonUtils.SHA(decrypt, ALGORITHM_SHA512, null);
    }

    public static String SHA512(String decrypt, Provider provider) {
        return MGL_CryptoCommonUtils.SHA(decrypt, ALGORITHM_SHA512, provider);
    }

    public static String SHA1(File file) {
        try {
            return MGL_CryptoCommonUtils.SHA1_BIG_File(file);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String SHA1(InputStream file) {
        try {
            return MGL_CryptoCommonUtils.SHA_BIG_File(file, ALGORITHM_SHA1, null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String SHA1File(String path) {
        try {
            return MGL_CryptoCommonUtils.SHA1_BIG_File(path);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String SHA1_BIG_File(String path) {
        return MGL_CryptoCommonUtils.SHA_BIG_File(path, ALGORITHM_SHA1, null);
    }

    private static String SHA1_BIG_File(File file) {
        return MGL_CryptoCommonUtils.SHA_BIG_File(file, ALGORITHM_SHA1, null);
    }

    private static String SHA1_BIG_File(String path, Provider provider) {
        return MGL_CryptoCommonUtils.SHA_BIG_File(path, ALGORITHM_SHA1, provider);
    }

    public static String SHA_BIG_File(String path, String algorithm, Provider provider) {
        File file = new File(path);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return MGL_CryptoCommonUtils.SHA_BIG_File(in, algorithm, provider);
    }

    public static String SHA_BIG_File(File file, String algorithm, Provider provider) {
        try {
            return MGL_CryptoCommonUtils.SHA_BIG_File(new FileInputStream(file), algorithm, provider);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String SHA_BIG_File(InputStream in, String algorithm, Provider provider) {
        try {
            MessageDigest messagedigest = null != provider ? MessageDigest.getInstance(algorithm, provider) : MessageDigest.getInstance(algorithm);
            byte[] buffer = new byte[0xA00000];
            int length = 0;
            while ((length = in.read(buffer)) > 0) {
                messagedigest.update(buffer, 0, length);
            }
            in.close();
            return MGL_HexUtils.toHexString(messagedigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("getFileSha1->NoSuchAlgorithmException###", (Throwable)e);
        }
        catch (IOException | OutOfMemoryError e) {
            logger.error("getFileSha1->OutOfMemoryError###", e);
        }
        return null;
    }

    public static String SHA1(byte[] buffer, Provider provider) {
        return MGL_CryptoCommonUtils.sum(buffer, ALGORITHM_SHA1, provider);
    }

    public static String SHA1(byte[] buffer) {
        return MGL_CryptoCommonUtils.sum(buffer, ALGORITHM_SHA1, null);
    }

    public static String sum(byte[] buffer, String algorithm, Provider provider) {
        try {
            MessageDigest messagedigest = null != provider ? MessageDigest.getInstance(algorithm, provider) : MessageDigest.getInstance(algorithm);
            messagedigest.update(buffer, 0, buffer.length);
            return MGL_HexUtils.toHexString(messagedigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("getFileSha1->NoSuchAlgorithmException###", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            logger.error("getFileSha1->OutOfMemoryError###", (Throwable)e);
            throw e;
        }
        return null;
    }

    public static synchronized String SHA(String strText, String crpType, Provider provider) {
        if (null != strText && !strText.isEmpty()) {
            try {
                MessageDigest messageDigest = null != provider ? MessageDigest.getInstance(crpType, provider) : MessageDigest.getInstance(crpType);
                messageDigest.update(strText.getBytes(StandardCharsets.UTF_8));
                byte[] byteBuffer = messageDigest.digest();
                return MGL_HexUtils.toHexString(byteBuffer);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static String MD5(String input) {
        try {
            MessageDigest mdInst = MessageDigest.getInstance(ALGORITHM_MD5);
            mdInst.update(input.getBytes());
            byte[] md = mdInst.digest();
            return MGL_HexUtils.toHexString(md);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String MD5(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM_MD5);
            byte[] hash = md.digest(input);
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String MD5(InputStream in) {
        try {
            MessageDigest messagedigest = MessageDigest.getInstance(ALGORITHM_MD5);
            byte[] buffer = new byte[0xA00000];
            int length = 0;
            while ((length = in.read(buffer)) > 0) {
                messagedigest.update(buffer, 0, length);
            }
            in.close();
            return MGL_HexUtils.toHexString(messagedigest.digest());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String MD5(File file) {
        try {
            return MGL_CryptoCommonUtils.MD5(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static byte[] encryptAES(String content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(ALGORITHM_AES);
            kgen.init(128, new SecureRandom(password.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, ALGORITHM_AES);
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES);
            byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
            cipher.init(1, key);
            return cipher.doFinal(byteContent);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String encryptAESToString(String content, String key) {
        return MGL_Base64Utils.encode(MGL_HexUtils.byte2hex(Objects.requireNonNull(MGL_CryptoCommonUtils.encryptAES(content, key))));
    }

    public static String decryptAESToString(String content, String key) {
        return new String(Objects.requireNonNull(MGL_CryptoCommonUtils.decryptAES(MGL_HexUtils.hex2byte(Objects.requireNonNull(MGL_Base64Utils.decode(content))), key)));
    }

    private static byte[] decryptAES(byte[] content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(ALGORITHM_AES);
            kgen.init(128, new SecureRandom(password.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, ALGORITHM_AES);
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES);
            cipher.init(2, key);
            return cipher.doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

