/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.c;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import tech.mgl.core.utils.MGL_Base64Utils;
import tech.mgl.core.utils.MGL_StringUtils;

public class MGL_AES {
    private static final String ALGORITHM_AES = "AES";
    private static final String ALGORITHM_ACP = "AES/CBC/PKCS5Padding";
    private static final int KEY_LENGTH = 128;

    public static SecretKey generateAESKey() {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(ALGORITHM_AES);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        keyGenerator.init(128);
        return keyGenerator.generateKey();
    }

    public static SecretKey getAESKeyByBase64String(String keyBase64) {
        byte[] keyBytes = Base64.getDecoder().decode(keyBase64);
        return new SecretKeySpec(keyBytes, ALGORITHM_AES);
    }

    public static byte[] generateIV(int length) {
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[length];
        random.nextBytes(iv);
        return iv;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String encrypt(String plaintext, String key) {
        return MGL_AES.encrypt(plaintext, MGL_AES.getAESKeyByBase64String(key));
    }

    public static String encrypt(String plaintext, Key key) {
        return MGL_AES.encrypt(plaintext, key, null);
    }

    public static String encrypt(String plaintext, Key key, String iVBase64) {
        try {
            Cipher cipher;
            if (MGL_StringUtils.isNotBlank((CharSequence)iVBase64)) {
                byte[] decode = MGL_Base64Utils.decode(iVBase64);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(decode);
                cipher = Cipher.getInstance(ALGORITHM_ACP);
                cipher.init(1, key, ivParameterSpec);
            } else {
                cipher = Cipher.getInstance(ALGORITHM_AES);
                cipher.init(1, key);
            }
            byte[] encryptedBytes = cipher.doFinal(plaintext.getBytes());
            return Base64.getEncoder().encodeToString(encryptedBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String ciphertext, String key) {
        return MGL_AES.decrypt(ciphertext, MGL_AES.getAESKeyByBase64String(key));
    }

    public static String decrypt(String ciphertext, Key key) {
        return MGL_AES.decrypt(ciphertext, key, null);
    }

    public static String decrypt(String ciphertext, String key, String ivBase64) {
        return MGL_AES.decrypt(ciphertext, MGL_AES.getAESKeyByBase64String(key), ivBase64);
    }

    public static String decrypt(String ciphertext, Key key, String ivBase64) {
        try {
            Cipher cipher;
            if (MGL_StringUtils.isNotBlank((CharSequence)ivBase64)) {
                byte[] iv = Base64.getDecoder().decode(ivBase64);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
                cipher = Cipher.getInstance(ALGORITHM_ACP);
                cipher.init(2, key, ivParameterSpec);
            } else {
                cipher = Cipher.getInstance(ALGORITHM_AES);
                cipher.init(2, key);
            }
            byte[] decode = Base64.getDecoder().decode(ciphertext);
            byte[] decryptedBytes = cipher.doFinal(decode);
            return new String(decryptedBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }
}

