/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.bean;

import java.awt.Color;
import java.io.File;

public class MGL_QRCodeLogo {
    private final int border;
    private final Color borderColor;
    private final int logoPart;
    private final int width;
    private final int height;
    private final boolean needCompress;
    private final File file;

    public MGL_QRCodeLogo(Builder builder) {
        this.border = builder.getBorder();
        this.file = builder.getFile();
        this.borderColor = builder.getBorderColor();
        this.logoPart = builder.getLogoPart();
        this.width = builder.getWidth();
        this.height = builder.getHeight();
        this.needCompress = builder.isNeedCompress();
    }

    public boolean isNeedCompress() {
        return this.needCompress;
    }

    public File getFile() {
        return this.file;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorder() {
        return this.border;
    }

    public int getLogoPart() {
        return this.logoPart;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public static final Color DEFAULT_BORDER_COLOR = Color.WHITE;
        public static final int DEFAULT_BORDER = 2;
        public static final int DEFAULT_LOGO_PART = 5;
        private int border = 2;
        private Color borderColor = DEFAULT_BORDER_COLOR;
        private int logoPart = 5;
        private int width = 60;
        private int height = 60;
        private boolean needCompress = true;
        private File file;

        public int getBorder() {
            return this.border;
        }

        public void setBorder(int border) {
            this.border = border;
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public Builder setBorderColor(Color borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public int getLogoPart() {
            return this.logoPart;
        }

        public Builder setLogoPart(int logoPart) {
            this.logoPart = logoPart;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public int getHeight() {
            return this.height;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public boolean isNeedCompress() {
            return this.needCompress;
        }

        public Builder setNeedCompress(boolean needCompress) {
            this.needCompress = needCompress;
            return this;
        }

        public File getFile() {
            return this.file;
        }

        public Builder setFile(File file) {
            this.file = file;
            return this;
        }

        public Builder setFile(String path) {
            this.file = new File(path);
            return this;
        }

        public MGL_QRCodeLogo build() {
            return new MGL_QRCodeLogo(this);
        }
    }
}

