/*
 * Decompiled with CFR 0.152.
 */
package tech.mappie.resolving.classes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.name.Name;
import tech.mappie.MappieLogger;
import tech.mappie.config.options.UseDefaultArgumentsKt;
import tech.mappie.exceptions.MappiePanicException;
import tech.mappie.resolving.ClassMappingRequest;
import tech.mappie.resolving.MappieDefinition;
import tech.mappie.resolving.MappieDefinitionsKt;
import tech.mappie.resolving.ResolverContext;
import tech.mappie.resolving.classes.ClassMappingRequestBuilder;
import tech.mappie.resolving.classes.sources.ClassMappingSource;
import tech.mappie.resolving.classes.sources.ExplicitClassMappingSource;
import tech.mappie.resolving.classes.sources.ExplicitPropertyMappingSource;
import tech.mappie.resolving.classes.sources.FunctionMappingSource;
import tech.mappie.resolving.classes.sources.GeneratedViaMapperTransformation;
import tech.mappie.resolving.classes.sources.ImplicitClassMappingSource;
import tech.mappie.resolving.classes.sources.ImplicitClassMappingSourcesCollector;
import tech.mappie.resolving.classes.sources.ImplicitPropertyMappingSource;
import tech.mappie.resolving.classes.sources.ParameterDefaultValueMappingSource;
import tech.mappie.resolving.classes.sources.PropertyMappingTransformation;
import tech.mappie.resolving.classes.sources.PropertyMappingViaMapperTransformation;
import tech.mappie.resolving.classes.targets.ClassMappingTarget;
import tech.mappie.resolving.classes.targets.ValueParameterTarget;
import tech.mappie.util.MessageCollectorKt;
import tech.mappie.util.TypeUtilsKt;
import tech.mappie.validation.Problem;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u001a\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130 J \u0010\u000b\u001a\u00020\u00002\u0018\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0 0\u0010J\u0014\u0010\b\u001a\u00020\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltech/mappie/resolving/classes/ClassMappingRequestBuilder;", "", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "context", "Ltech/mappie/resolving/ResolverContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;Ltech/mappie/resolving/ResolverContext;)V", "targets", "", "Ltech/mappie/resolving/classes/targets/ClassMappingTarget;", "sources", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "implicit", "", "Ltech/mappie/resolving/classes/sources/ImplicitClassMappingSource;", "explicit", "Ltech/mappie/resolving/classes/sources/ExplicitClassMappingSource;", "construct", "Ltech/mappie/resolving/ClassMappingRequest;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "target", "useDefaultArguments", "", "transformation", "Ltech/mappie/resolving/classes/sources/PropertyMappingTransformation;", "source", "Ltech/mappie/resolving/classes/sources/ClassMappingSource;", "entry", "Lkotlin/Pair;", "entries", "compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nClassMappingRequestBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassMappingRequestBuilder.kt\ntech/mappie/resolving/classes/ClassMappingRequestBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 collections.kt\norg/jetbrains/kotlin/utils/CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1279#2,2:120\n1293#2,4:122\n2632#2,3:129\n1557#2:140\n1628#2,3:141\n1557#2:144\n1628#2,3:145\n1557#2:150\n1628#2,2:151\n1630#2:155\n487#3,3:126\n490#3,4:132\n126#4:136\n153#4,3:137\n216#4,2:153\n58#5:148\n1#6:149\n*S KotlinDebug\n*F\n+ 1 ClassMappingRequestBuilder.kt\ntech/mappie/resolving/classes/ClassMappingRequestBuilder\n*L\n30#1:120,2\n30#1:122,4\n34#1:129,3\n48#1:140\n48#1:141,3\n59#1:144\n59#1:145,3\n109#1:150\n109#1:151,2\n109#1:155\n33#1:126,3\n33#1:132,4\n39#1:136\n39#1:137,3\n110#1:153,2\n69#1:148\n*E\n"})
public final class ClassMappingRequestBuilder {
    @NotNull
    private final IrConstructor constructor;
    @NotNull
    private final ResolverContext context;
    @NotNull
    private final List<ClassMappingTarget> targets;
    @NotNull
    private final Map<Name, IrType> sources;
    @NotNull
    private final Map<Name, List<ImplicitClassMappingSource>> implicit;
    @NotNull
    private final Map<Name, List<ExplicitClassMappingSource>> explicit;

    public ClassMappingRequestBuilder(@NotNull IrConstructor constructor, @NotNull ResolverContext context) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.constructor = constructor;
        this.context = context;
        this.targets = new ArrayList();
        this.sources = new LinkedHashMap();
        this.implicit = new LinkedHashMap();
        this.explicit = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassMappingRequest construct(@NotNull IrFunction origin) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrFunction irFunction;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        boolean useDefaultArguments = UseDefaultArgumentsKt.useDefaultArguments(this.context, origin);
        Iterable $this$associateWith$iv = this.targets;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void target;
            ClassMappingTarget classMappingTarget = (ClassMappingTarget)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Object object = this.explicit((ClassMappingTarget)target);
            if (object == null) {
                object = this.implicit((ClassMappingTarget)target, useDefaultArguments);
            }
            irFunction = object;
            map.put(t, irFunction);
        }
        Map mappings = result$iv;
        Map<Name, List<ExplicitClassMappingSource>> $this$filterKeys$iv = this.explicit;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<Name, List<ExplicitClassMappingSource>> result$iv2 = new LinkedHashMap<Name, List<ExplicitClassMappingSource>>();
        for (Map.Entry<Name, List<ExplicitClassMappingSource>> entry$iv : $this$filterKeys$iv.entrySet()) {
            boolean bl;
            block7: {
                Name name = entry$iv.getKey();
                boolean bl2 = false;
                Iterable $this$none$iv = this.targets;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ClassMappingTarget it = (ClassMappingTarget)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            result$iv2.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map unknowns = result$iv2;
        $this$filterKeys$iv = this.sources;
        irFunction = origin;
        boolean $i$f$map = false;
        result$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry $this$none$iv = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((IrType)it.getValue());
        }
        Map map = unknowns;
        Map map2 = mappings;
        IrConstructor irConstructor = this.constructor;
        List list = (List)destination$iv$iv;
        IrFunction irFunction2 = irFunction;
        return new ClassMappingRequest(irFunction2, list, irConstructor, map2, map);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ExplicitClassMappingSource> explicit(ClassMappingTarget target) {
        List list;
        List<ExplicitClassMappingSource> list2 = this.explicit.get(target.getName());
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            List<ExplicitClassMappingSource> sources2 = list2;
            boolean bl = false;
            Iterable $this$map$iv = sources2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void source;
                ExplicitClassMappingSource explicitClassMappingSource = (ExplicitClassMappingSource)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(source instanceof ExplicitPropertyMappingSource && ((ExplicitPropertyMappingSource)source).getTransformation() == null && !TypeUtilsKt.isMappableFrom(((ExplicitPropertyMappingSource)source).getType(), target.getType()) ? (ExplicitClassMappingSource)ExplicitPropertyMappingSource.copy$default((ExplicitPropertyMappingSource)source, null, this.transformation((ClassMappingSource)source, target), false, 5, null) : source);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ImplicitClassMappingSource> implicit(ClassMappingTarget target, boolean useDefaultArguments) {
        Collection collection;
        void $this$ifEmpty$iv;
        void $this$mapTo$iv$iv;
        List<ImplicitClassMappingSource> sources2 = this.implicit.getOrDefault(target.getName(), CollectionsKt.emptyList());
        boolean bl = false;
        Iterable $this$map$iv = sources2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ImplicitClassMappingSource implicitClassMappingSource;
            void source;
            ImplicitClassMappingSource implicitClassMappingSource2 = (ImplicitClassMappingSource)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            if (TypeUtilsKt.isMappableFrom(source.getType(), target.getType())) {
                implicitClassMappingSource = source;
            } else {
                void var15_16 = source;
                if (var15_16 instanceof ImplicitPropertyMappingSource) {
                    implicitClassMappingSource = ImplicitPropertyMappingSource.copy$default((ImplicitPropertyMappingSource)source, null, null, null, this.transformation((ClassMappingSource)source, target), 7, null);
                } else if (var15_16 instanceof FunctionMappingSource) {
                    implicitClassMappingSource = FunctionMappingSource.copy$default((FunctionMappingSource)source, null, null, null, this.transformation((ClassMappingSource)source, target), 7, null);
                } else {
                    throw new MappiePanicException("Only ImplicitPropertyMappingSource should occur when resolving a transformation. Got " + Reflection.getOrCreateKotlinClass(source.getClass()), null, 2, null);
                }
            }
            collection2.add(implicitClassMappingSource);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$ifEmpty = false;
        if ($this$ifEmpty$iv.isEmpty()) {
            boolean bl3 = false;
            collection = target instanceof ValueParameterTarget && IrUtilsKt.hasDefaultValue((IrValueParameter)((ValueParameterTarget)target).getValue()) && useDefaultArguments ? CollectionsKt.listOf((Object)new ParameterDefaultValueMappingSource(((ValueParameterTarget)target).getValue())) : CollectionsKt.emptyList();
        } else {
            collection = $this$ifEmpty$iv;
        }
        return (List)collection;
    }

    private final PropertyMappingTransformation transformation(ClassMappingSource source, ClassMappingTarget target) {
        PropertyMappingTransformation propertyMappingTransformation;
        List<MappieDefinition> mappers = MappieDefinitionsKt.matching(this.context.getDefinitions(), source.getType(), target.getType());
        if (mappers.size() == 1) {
            propertyMappingTransformation = new PropertyMappingViaMapperTransformation((MappieDefinition)CollectionsKt.single(mappers), null);
        } else if (mappers.size() > 1) {
            CompilerMessageLocation compilerMessageLocation;
            if (source instanceof ExplicitClassMappingSource) {
                IrFunction irFunction = this.context.getFunction();
                Intrinsics.checkNotNull((Object)irFunction);
                compilerMessageLocation = MessageCollectorKt.location(AdditionalIrUtilsKt.getFileEntry((IrDeclaration)((IrDeclaration)irFunction)), ((ExplicitClassMappingSource)source).getOrigin());
            } else {
                IrFunction irFunction = this.context.getFunction();
                Intrinsics.checkNotNull((Object)irFunction);
                compilerMessageLocation = MessageCollectorKt.location((IrDeclaration)irFunction);
            }
            CompilerMessageLocation location = compilerMessageLocation;
            Object[] objectArray = new String[]{"Call one of " + CollectionsKt.joinToString$default((Iterable)mappers, null, null, null, (int)0, null, ClassMappingRequestBuilder::transformation$lambda$9, (int)31, null) + " explicitly.", "Delete all except one of " + CollectionsKt.joinToString$default((Iterable)mappers, null, null, null, (int)0, null, ClassMappingRequestBuilder::transformation$lambda$10, (int)31, null) + "."};
            Problem error = Problem.Companion.error("Multiple mappers resolved to be used in an implicit via", location, CollectionsKt.listOf((Object[])objectArray));
            MappieLogger.log$default(this.context.getLogger(), error, null, 2, null);
            propertyMappingTransformation = new PropertyMappingViaMapperTransformation((MappieDefinition)CollectionsKt.first(mappers), null);
        } else {
            propertyMappingTransformation = !TypeUtilsKt.isPrimitive(source.getType()) && !TypeUtilsKt.isPrimitive(target.getType()) ? (PropertyMappingTransformation)new GeneratedViaMapperTransformation(source, target) : null;
        }
        return propertyMappingTransformation;
    }

    @NotNull
    public final ClassMappingRequestBuilder explicit(@NotNull Pair<Name, ? extends ExplicitClassMappingSource> entry) {
        ClassMappingRequestBuilder classMappingRequestBuilder;
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        ClassMappingRequestBuilder $this$explicit_u24lambda_u2412 = classMappingRequestBuilder = this;
        boolean bl = false;
        $this$explicit_u24lambda_u2412.explicit.merge((Name)entry.getFirst(), CollectionsKt.listOf((Object)entry.getSecond()), (arg_0, arg_1) -> ClassMappingRequestBuilder.explicit$lambda$12$lambda$11(explicit.2.1.INSTANCE, arg_0, arg_1));
        return classMappingRequestBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassMappingRequestBuilder sources(@NotNull List<? extends Pair<Name, ? extends IrType>> entries) {
        void $this$mapTo$iv$iv;
        ClassMappingRequestBuilder classMappingRequestBuilder;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        ClassMappingRequestBuilder $this$sources_u24lambda_u2416 = classMappingRequestBuilder = this;
        boolean bl = false;
        MapsKt.putAll($this$sources_u24lambda_u2416.sources, (Iterable)entries);
        Iterable $this$map$iv = entries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Name name = (Name)pair.component1();
            IrType type = (IrType)pair.component2();
            IrClass irClass = IrTypesKt.getClass((IrType)type);
            Intrinsics.checkNotNull((Object)irClass);
            Map $this$forEach$iv = (Map)irClass.accept((IrElementVisitor)new ImplicitClassMappingSourcesCollector(), (Object)TuplesKt.to((Object)name, (Object)type));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl3 = false;
                Name name2 = (Name)entry.getKey();
                ImplicitClassMappingSource source = (ImplicitClassMappingSource)entry.getValue();
                $this$sources_u24lambda_u2416.implicit.merge(name2, CollectionsKt.listOf((Object)source), (arg_0, arg_1) -> ClassMappingRequestBuilder.sources$lambda$16$lambda$15$lambda$14$lambda$13(sources.1.1.1.1.INSTANCE, arg_0, arg_1));
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return classMappingRequestBuilder;
    }

    @NotNull
    public final ClassMappingRequestBuilder targets(@NotNull List<? extends ClassMappingTarget> targets) {
        ClassMappingRequestBuilder classMappingRequestBuilder;
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        ClassMappingRequestBuilder $this$targets_u24lambda_u2417 = classMappingRequestBuilder = this;
        boolean bl = false;
        $this$targets_u24lambda_u2417.targets.addAll((Collection<ClassMappingTarget>)targets);
        return classMappingRequestBuilder;
    }

    private static final CharSequence transformation$lambda$9(MappieDefinition it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getClazz().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private static final CharSequence transformation$lambda$10(MappieDefinition it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getClazz().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private static final List explicit$lambda$12$lambda$11(Function2 $tmp0, Object p0, Object p1) {
        return (List)$tmp0.invoke(p0, p1);
    }

    private static final List sources$lambda$16$lambda$15$lambda$14$lambda$13(Function2 $tmp0, Object p0, Object p1) {
        return (List)$tmp0.invoke(p0, p1);
    }
}

