package tech.mappie.validation.problems

import org.jetbrains.kotlin.name.Name
import tech.mappie.resolving.ConstructorCallMapping
import tech.mappie.validation.Problem

class UnknownParameterNameProblems(private val unknowns: List<Name>) {

    fun all(): List<Problem> = unknowns.map {
        Problem.error("Identifier ${it.asString()} does not occur as as setter or as a parameter in constructor")
    }

    companion object {
        fun of(mapping: ConstructorCallMapping): UnknownParameterNameProblems =
            UnknownParameterNameProblems(mapping.unknowns.map { it.key })
    }
}
