/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.widgets;

import java.util.HashMap;
import java.util.Map;
import processing.core.PGraphics;
import processing.event.KeyEvent;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.Label;
import tech.lity.rea.skatolo.gui.controllers.ControllerView;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;

@Skatolo.Layout
public class PixelSelect
extends Controller<PixelSelect> {
    protected int triggerId = 2;
    public static int autoWidth = 20;
    public static int autoHeight = 20;
    protected Map<Integer, PixelSelectCommand> keyMapping;
    protected boolean isKeyboardControlled = false;

    public PixelSelect(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0.0f, 0.0f, 20, 20);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public PixelSelect(Skatolo theskatolo, ControllerGroup<?> theParent, String theName, float theX, float theY, int theWidth, int theHeight) {
        super(theskatolo, theParent, theName, theX, theY, theWidth, theHeight);
        this._myCaptionLabel.setPadding(0, Label.defaultPaddingY).align(37, 13);
        this._myArrayValue = new float[]{0.0f, 0.0f};
        this.keyMapping = new HashMap<Integer, PixelSelectCommand>();
        this.keyMapping.put(37, new MoveLeft());
        this.keyMapping.put(39, new MoveRight());
        this.keyMapping.put(38, new MoveUp());
        this.keyMapping.put(40, new MoveDown());
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    public void onLeave() {
        this.isActive = false;
    }

    @Override
    protected void mousePressed() {
        this._myArrayValue[0] = this.currentPointer.getX();
        this._myArrayValue[1] = this.currentPointer.getY();
        this.isActive = true;
        this.update();
    }

    @Override
    protected void onDrag() {
        this.isActive = true;
        this._myArrayValue[0] = this.currentPointer.getX();
        this._myArrayValue[1] = this.currentPointer.getY();
        this.update();
    }

    public void setKeyboardControlled(boolean control) {
        this.isKeyboardControlled = control;
    }

    @Override
    protected void mouseReleased() {
        this.isActive = true;
        this.update();
    }

    @Override
    protected void mouseReleasedOutside() {
        this.onLeave();
    }

    @Skatolo.Layout
    public PixelSelect setTriggerEvent(int theEventID) {
        this.triggerId = theEventID;
        return this;
    }

    @Skatolo.Layout
    public int getTriggerEvent() {
        return this.triggerId;
    }

    @Override
    public PixelSelect setArrayValue(float[] theValue) {
        this._myArrayValue = theValue;
        this.setPosition(theValue[0] - (float)(this.width / 2), theValue[1] - (float)(this.height / 2));
        this.broadcast(5);
        return this;
    }

    @Override
    public PixelSelect update() {
        return this.setArrayValue(this._myArrayValue);
    }

    @Override
    public PixelSelect updateDisplayMode(int theMode) {
        this.updateViewMode(theMode);
        return this;
    }

    public PixelSelect updateViewMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new PixelSelectView();
                break;
            }
            case 1: {
                this._myControllerView = new PixelSelectImageView();
                break;
            }
        }
        return this;
    }

    @Override
    public void keyEvent(KeyEvent theKeyEvent) {
        if (this.isUserInteraction && (this.isActive || this.isKeyboardControlled) && theKeyEvent.getAction() == 1 && this.keyMapping.containsKey(this.skatolo.getKeyCode())) {
            this.keyMapping.get(this.skatolo.getKeyCode()).execute();
        }
    }

    @Override
    public String getInfo() {
        return "type:\tPixelSelect\n" + super.getInfo();
    }

    @Override
    public String toString() {
        return super.toString() + " [ " + this.getValue() + " ] PixelSelect (" + this.getClass().getSuperclass() + ")";
    }

    private class PixelSelectImageView
    implements ControllerView<PixelSelect> {
        private PixelSelectImageView() {
        }

        @Override
        public void display(PGraphics graphics, PixelSelect theController) {
            if (PixelSelect.this.isActive) {
                graphics.image(PixelSelect.this.availableImages[2] ? PixelSelect.this.images[2] : PixelSelect.this.images[0], 0.0f, 0.0f);
            } else {
                graphics.image(PixelSelect.this.availableImages[1] ? PixelSelect.this.images[1] : PixelSelect.this.images[0], 0.0f, 0.0f);
            }
            if (!PixelSelect.this.isActive) {
                graphics.image(PixelSelect.this.images[0], 0.0f, 0.0f);
            }
        }
    }

    private class PixelSelectView
    implements ControllerView<PixelSelect> {
        private PixelSelectView() {
        }

        @Override
        public void display(PGraphics graphics, PixelSelect theController) {
            graphics.noFill();
            graphics.strokeWeight(1.0f);
            if (PixelSelect.this.isActive) {
                graphics.stroke(PixelSelect.this.color.getActive());
            } else {
                graphics.stroke(PixelSelect.this.color.getForeground());
            }
            if (PixelSelect.this.isKeyboardControlled) {
                graphics.strokeWeight(2.0f);
                graphics.stroke(PixelSelect.this.color.getActive());
            }
            graphics.rect(0.0f, 0.0f, (float)PixelSelect.this.width, (float)PixelSelect.this.height);
            graphics.strokeWeight(1.0f);
            graphics.ellipse((float)(PixelSelect.this.width / 4), (float)(PixelSelect.this.height / 4), (float)(PixelSelect.this.width / 2), (float)(PixelSelect.this.height / 2));
            if (PixelSelect.this.isLabelVisible) {
                PixelSelect.this._myCaptionLabel.draw(graphics, 0, 0, theController);
            }
        }
    }

    class MoveDown
    implements PixelSelectCommand {
        MoveDown() {
        }

        @Override
        public void execute() {
            PixelSelect.this.setPosition(PixelSelect.this.getPosition().x, PixelSelect.this.getPosition().y + 1.0f);
        }
    }

    class MoveUp
    implements PixelSelectCommand {
        MoveUp() {
        }

        @Override
        public void execute() {
            PixelSelect.this.setPosition(PixelSelect.this.getPosition().x, PixelSelect.this.getPosition().y - 1.0f);
        }
    }

    class MoveRight
    implements PixelSelectCommand {
        MoveRight() {
        }

        @Override
        public void execute() {
            PixelSelect.this.setPosition(PixelSelect.this.getPosition().x + 1.0f, PixelSelect.this.getPosition().y);
        }
    }

    class MoveLeft
    implements PixelSelectCommand {
        MoveLeft() {
        }

        @Override
        public void execute() {
            PixelSelect.this.setPosition(PixelSelect.this.getPosition().x - 1.0f, PixelSelect.this.getPosition().y);
        }
    }

    static interface PixelSelectCommand {
        public void execute();
    }
}

