/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.layout;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.events.ControlEvent;
import tech.lity.rea.skatolo.events.ControlListener;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.ControllerInterface;
import tech.lity.rea.skatolo.gui.controllers.Bang;
import tech.lity.rea.skatolo.gui.controllers.Knob;
import tech.lity.rea.skatolo.gui.controllers.Numberbox;
import tech.lity.rea.skatolo.gui.controllers.Slider;
import tech.lity.rea.skatolo.gui.controllers.Textfield;
import tech.lity.rea.skatolo.gui.controllers.Textlabel;
import tech.lity.rea.skatolo.gui.controllers.Toggle;
import tech.lity.rea.skatolo.gui.group.DropdownList;
import tech.lity.rea.skatolo.gui.group.ListBox;
import tech.lity.rea.skatolo.gui.layout.ControlElement;

public class ControllerAutomator {
    static Map<Set<Class<?>>, Class<? extends Controller<?>>> mapping = new HashMap();
    static Map<String, Class<? extends ControllerInterface<?>>> types;
    private Skatolo skatolo;

    static Set<Class<?>> makeKey(Class<?> ... cs) {
        HashSet set = new HashSet();
        for (Class<?> c : cs) {
            set.add(c);
        }
        return set;
    }

    public ControllerAutomator(Skatolo c) {
        this.skatolo = c;
    }

    private Object[] getParameters(Class<?>[] cs, String v) {
        if (cs[0] == Integer.TYPE) {
            return new Object[]{Integer.parseInt(v)};
        }
        if (cs[0] == Float.TYPE) {
            return new Object[]{Float.valueOf(Float.parseFloat(v))};
        }
        if (cs[0] == String.class) {
            return new Object[]{v};
        }
        if (cs[0] == Boolean.TYPE) {
            return new Object[]{Boolean.parseBoolean(v)};
        }
        return new Object[0];
    }

    public void addControllersFor(String theAddressSpace, final Object t) {
        Object[] os;
        String v;
        Object cntr;
        Object[] a;
        Class<ControllerInterface<?>> type;
        HashMap<String, String> params;
        ControlElement ce;
        if (t instanceof List) {
            return;
        }
        Class<?> c = t.getClass();
        Field[] fs = c.getDeclaredFields();
        Method[] ms = c.getDeclaredMethods();
        for (Method method : ms) {
            if (!method.isAnnotationPresent(ControlElement.class)) continue;
            ce = method.getAnnotation(ControlElement.class);
            params = new HashMap<String, String>();
            type = null;
            for (String s : ce.properties()) {
                a = s.split("=");
                if (a[0].startsWith("type")) {
                    type = types.get(a[1].toLowerCase());
                    continue;
                }
                params.put("set" + ControllerAutomator.capitalize(a[0]), a[1]);
            }
            if (type == null) {
                type = mapping.get(ControllerAutomator.makeKey(method.getParameterTypes()));
            }
            if (type == null) continue;
            cntr = null;
            if (params.containsKey("setItems")) {
                if (type.equals(ListBox.class)) {
                    cntr = this.skatolo.addListBox(method.getName(), ce.x(), ce.y(), 100, 100);
                    ((ListBox)cntr).addItems(((String)params.get("setItems")).split(","));
                } else if (type.equals(DropdownList.class)) {
                    cntr = this.skatolo.addDropdownList(method.getName(), ce.x(), ce.y(), 100, 100);
                    ((DropdownList)cntr).addItems(((String)params.get("setItems")).split(","));
                }
                try {
                    final Method method2 = t.getClass().getDeclaredMethod(method.getName(), Integer.TYPE);
                    cntr.addListener(new ControlListener(){

                        @Override
                        public void controlEvent(ControlEvent ev) {
                            try {
                                method2.setAccessible(true);
                                method2.invoke(t, (int)ev.getValue());
                            }
                            catch (Exception e) {
                                Skatolo.logger.severe(e.toString());
                            }
                        }
                    });
                }
                catch (Exception e1) {
                    System.out.println(e1);
                }
            } else {
                cntr = this.skatolo.addController(t, theAddressSpace, method.getName(), type, ce.x(), ce.y());
            }
            if (ce.label().length() > 0) {
                cntr.setCaptionLabel(ce.label());
            }
            for (String k : params.keySet()) {
                v = (String)params.get(k);
                for (Method method3 : cntr.getClass().getMethods()) {
                    if (!method3.getName().equals(k)) continue;
                    try {
                        os = this.getParameters(method3.getParameterTypes(), v);
                        method3.setAccessible(true);
                        method3.invoke(cntr, os);
                    }
                    catch (Exception e) {
                        Skatolo.logger.severe(e.toString());
                    }
                }
            }
        }
        for (AccessibleObject accessibleObject : fs) {
            block40: {
                if (!accessibleObject.isAnnotationPresent(ControlElement.class)) continue;
                ce = ((Field)accessibleObject).getAnnotation(ControlElement.class);
                params = new HashMap();
                type = null;
                for (String s : ce.properties()) {
                    a = s.split("=");
                    if (a[0].startsWith("type")) {
                        type = types.get(a[1].toLowerCase());
                        continue;
                    }
                    params.put("set" + ControllerAutomator.capitalize(a[0]), a[1]);
                }
                cntr = null;
                ((Field)accessibleObject).setAccessible(true);
                if (((Field)accessibleObject).getType() == Float.TYPE || ((Field)accessibleObject).getType() == Integer.TYPE) {
                    cntr = type == Knob.class ? this.skatolo.addKnob(t, theAddressSpace, ((Field)accessibleObject).getName()) : (type == Numberbox.class ? this.skatolo.addNumberbox(t, theAddressSpace, ((Field)accessibleObject).getName()) : this.skatolo.addSlider(t, theAddressSpace, ((Field)accessibleObject).getName()));
                    try {
                        if (((Field)accessibleObject).getType() == Float.TYPE) {
                            cntr.setValue(((Field)accessibleObject).getFloat(t));
                            break block40;
                        }
                        cntr.setValue(((Field)accessibleObject).getInt(t));
                    }
                    catch (Exception e) {
                        Skatolo.logger.severe(e.toString());
                    }
                } else if (((Field)accessibleObject).getType() == String.class) {
                    if (type == Textlabel.class) {
                        String s = "";
                        try {
                            s = "" + ((Field)accessibleObject).get(t);
                            if (((Field)accessibleObject).get(t) == null) {
                                s = ce.label();
                            }
                        }
                        catch (Exception k) {
                            // empty catch block
                        }
                        cntr = this.skatolo.addTextlabel(t, theAddressSpace, ((Field)accessibleObject).getName(), s);
                    } else {
                        cntr = this.skatolo.addTextfield(t, theAddressSpace, ((Field)accessibleObject).getName());
                    }
                } else if (((Field)accessibleObject).getType() == Boolean.TYPE) {
                    cntr = this.skatolo.addToggle(t, theAddressSpace, ((Field)accessibleObject).getName());
                    try {
                        cntr.setValue(((Field)accessibleObject).getBoolean(t) ? 1.0f : 0.0f);
                    }
                    catch (Exception e) {
                        Skatolo.logger.severe(e.toString());
                    }
                }
            }
            if (cntr == null) continue;
            if (ce.label().length() > 0) {
                cntr.setCaptionLabel(ce.label());
            }
            cntr.setPosition(ce.x(), ce.y());
            for (String k : params.keySet()) {
                v = (String)params.get(k);
                for (Method method : cntr.getClass().getMethods()) {
                    if (!method.getName().equals(k)) continue;
                    try {
                        os = this.getParameters(method.getParameterTypes(), v);
                        method.setAccessible(true);
                        method.invoke(cntr, os);
                    }
                    catch (Exception e) {
                        Skatolo.logger.severe(e.toString());
                    }
                }
            }
        }
    }

    static String capitalize(String theString) {
        StringBuilder result = new StringBuilder(theString.length());
        String[] words = theString.split("\\s");
        int l = words.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(words[i].charAt(0))).append(words[i].substring(1));
        }
        return result.toString();
    }

    static {
        mapping.put(ControllerAutomator.makeKey(Boolean.TYPE), Toggle.class);
        mapping.put(ControllerAutomator.makeKey(Integer.TYPE), Slider.class);
        mapping.put(ControllerAutomator.makeKey(Float.TYPE), Slider.class);
        mapping.put(ControllerAutomator.makeKey(String.class), Textfield.class);
        types = new HashMap();
        types.put("slider", Slider.class);
        types.put("knob", Knob.class);
        types.put("numberbox", Numberbox.class);
        types.put("toggle", Toggle.class);
        types.put("bang", Bang.class);
        types.put("toggle", Toggle.class);
        types.put("textfield", Textfield.class);
        types.put("label", Textlabel.class);
        types.put("textlabel", Textlabel.class);
        types.put("list", ListBox.class);
        types.put("dropdown", DropdownList.class);
    }
}

