/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.group;

import processing.core.PGraphics;
import processing.core.PVector;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.events.ControlEvent;
import tech.lity.rea.skatolo.gui.ControlWindow;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;

public class Tab
extends ControllerGroup<Tab> {
    protected int _myOffsetX = -1000;
    protected int _myOffsetY = -1000;
    public boolean isActive = false;
    private boolean isAlwaysActive = false;
    protected boolean isEventActive = false;
    private float _myValue = 0.0f;
    protected String _myStringValue = "";
    public static int padding = 4;
    public boolean autoWidth = true;

    public Tab(Skatolo theskatolo, ControlWindow theControlWindow, String theName) {
        super(theskatolo, null, theName, 0.0f, 0.0f);
        this.position = new PVector();
        this.absolutePosition = new PVector();
        this.isMoveable = false;
        this.isEventActive = theskatolo.isTabEventsActive;
        this._myHeight = 16;
        this._myWidth = this._myLabel.getWidth() + padding * 2;
        this._myLabel.align(37, 3).setPadding(0, 0);
    }

    public void setOffset(int theValueX, int theValueY) {
        this._myOffsetX = theValueX;
        this._myOffsetY = theValueY;
    }

    public int height() {
        return this._myHeight;
    }

    public boolean updateLabel() {
        this.isInside = this.inside();
        return this.skatolo.getWindow().getTabs().size() > 2;
    }

    public void drawLabel(PGraphics graphics) {
        if (this.autoWidth) {
            this._myWidth = this._myLabel.getWidth() + padding * 2;
        }
        graphics.pushMatrix();
        graphics.fill(this.isInside ? this.getColor().getForeground() : this.getColor().getBackground());
        if (this.isActive) {
            graphics.fill(this.getColor().getActive());
        }
        graphics.translate((float)this._myOffsetX, (float)this._myOffsetY);
        graphics.rect(0.0f, 0.0f, (float)(this._myWidth - 1), (float)this._myHeight);
        this._myLabel.draw(graphics, padding, 0, this);
        graphics.popMatrix();
    }

    @Override
    public Tab setLabel(String theLabel) {
        this._myLabel.set(theLabel);
        return this;
    }

    public int width() {
        return this._myWidth;
    }

    @Override
    public Tab setWidth(int theWidth) {
        this._myWidth = theWidth + padding;
        this.autoWidth = false;
        return this;
    }

    @Override
    public Tab setHeight(int theHeight) {
        this._myHeight = theHeight;
        return this;
    }

    @Override
    protected boolean inside() {
        return this.skatolo.getWindow().getPointerX() > this._myOffsetX && this.skatolo.getWindow().getPointerX() < this._myOffsetX + this._myWidth && this.skatolo.getWindow().getPointerY() > this._myOffsetY && this.skatolo.getWindow().getPointerY() < this._myOffsetY + this._myHeight;
    }

    @Override
    public void mousePressed() {
        this.skatolo.getWindow().activateTab(this);
        if (this.isEventActive) {
            this.skatolo.getControlBroadcaster().broadcast(new ControlEvent(this), 0);
        }
    }

    public Tab setActive(boolean theFlag) {
        this.isActive = theFlag;
        return this;
    }

    public Tab setAlwaysActive(boolean theFlag) {
        this.isAlwaysActive = theFlag;
        return this;
    }

    public boolean isActive() {
        return this.isAlwaysActive ? true : this.isActive;
    }

    public boolean isAlwaysActive() {
        return this.isAlwaysActive;
    }

    @Override
    public Tab bringToFront() {
        this.skatolo.getWindow().activateTab(this);
        return this;
    }

    @Override
    public Tab moveTo(ControlWindow theWindow) {
        this.skatolo.getWindow().removeTab(this);
        this.setTab(theWindow, this.getName());
        return this;
    }

    public Tab activateEvent(boolean theFlag) {
        this.isEventActive = theFlag;
        return this;
    }

    @Override
    public String getStringValue() {
        return this._myStringValue;
    }

    @Override
    public float getValue() {
        return this._myValue;
    }

    @Override
    public Tab setValue(float theValue) {
        this._myValue = theValue;
        return this;
    }

    @Override
    @Deprecated
    public float value() {
        return this._myValue;
    }

    @Override
    @Deprecated
    public String stringValue() {
        return this._myStringValue;
    }
}

