/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.group;

import java.lang.reflect.Method;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.CColor;
import tech.lity.rea.skatolo.gui.group.ControlGroup;

public class ListBoxItem {
    protected String name;
    protected String text;
    protected int value;
    protected boolean isActive;
    protected CColor color;
    protected int id = -1;
    protected ControlGroup<?> parent;
    private boolean toUpperCase = true;

    protected ListBoxItem(ControlGroup<?> theListBox, String theName, int theValue) {
        this.name = theName;
        this.text = theName;
        this.value = theValue;
        this.parent = theListBox;
        this.color = new CColor(theListBox.getColor());
    }

    public CColor getColor() {
        return this.color;
    }

    public void setColor(CColor theColor) {
        this.color.set(theColor);
        this.updateListBoxItems();
    }

    public void setColorActive(int theColor) {
        this.color.setActive(theColor);
        this.updateListBoxItems();
    }

    public void setColorForeground(int theColor) {
        this.color.setForeground(theColor);
        this.updateListBoxItems();
    }

    public void setColorBackground(int theColor) {
        this.color.setBackground(theColor);
        this.updateListBoxItems();
    }

    public void setColorLabel(int theColor) {
        this.color.setCaptionLabel(theColor);
        this.updateListBoxItems();
    }

    public void setId(int theId) {
        this.id = theId;
    }

    public int getId() {
        return this.id;
    }

    public ListBoxItem setText(String theText) {
        this.text = theText;
        this.updateListBoxItems();
        return this;
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isActive() {
        Skatolo.logger().info("no effect for isActive, please dont use yet.");
        return this.isActive;
    }

    public String toString() {
        return "\ntype:\t" + this.getClass() + "\nname:\t" + this.name + "\nlabel:\t" + this.text + "\nid:\t" + this.id + "\nvalue:\t" + this.value + "\ncolor:\t" + this.getColor() + "\n";
    }

    public void toUpperCase(boolean theFlag) {
        this.toUpperCase = theFlag;
        this.updateListBoxItems();
    }

    public boolean getToUpperCase() {
        return this.toUpperCase;
    }

    private void updateListBoxItems() {
        try {
            Method m = this.parent.getClass().getMethod("updateListBoxItems", new Class[0]);
            m.invoke(this.parent, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

