/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.core.PApplet;
import processing.event.KeyEvent;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.events.ControlEvent;
import tech.lity.rea.skatolo.events.ControlListener;
import tech.lity.rea.skatolo.gui.CColor;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.controllers.Button;
import tech.lity.rea.skatolo.gui.controllers.Slider;
import tech.lity.rea.skatolo.gui.group.ControlGroup;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;
import tech.lity.rea.skatolo.gui.group.ListBoxItem;

public class DropdownList
extends ControlGroup<DropdownList> {
    protected int _myItemHeight = 13;
    protected int maxButtons = 0;
    protected int _myOriginalBackgroundHeight = 0;
    protected Slider _myScrollbar;
    protected String _myName;
    protected float _myScrollValue = 0.0f;
    protected boolean isScrollbarVisible = true;
    private int _myScrollbarWidth = 6;
    protected int _myHeight;
    protected List<ListBoxItem> items = new ArrayList<ListBoxItem>();
    protected List<Button> buttons = new ArrayList<Button>();
    protected int spacing = 1;
    protected boolean isMultipleChoice = false;
    protected boolean pulldown;
    private int itemOffset = 0;
    private boolean isToUpperCase = true;
    private boolean bulkadding;

    public DropdownList(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0, 0, 99, 99);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public DropdownList(Skatolo theskatolo, ControllerGroup<?> theGroup, String theName, int theX, int theY, int theW, int theH) {
        super(theskatolo, theGroup, theName, theX, theY, theW, 9);
        this._myWidth = theW;
        this._myName = theName;
        this._myBackgroundHeight = theH < 10 ? 10 : theH;
        this._myScrollbar = new Slider(this.skatolo, this._myParent, theName + "Scroller", 0.0f, 1.0f, 1.0f, this._myWidth - this._myScrollbarWidth, 0, this._myScrollbarWidth, this._myBackgroundHeight);
        this._myScrollbar.setBroadcast(false);
        this._myScrollbar.setSliderMode(0);
        this._myScrollbar.setMoveable(false);
        this._myScrollbar.setLabelVisible(false);
        this._myScrollbar.setParent(this);
        this._myScrollbar.addListener(this);
        this._myScrollbar.setVisible(false);
        this._myScrollbar.hide();
        this._myScrollbar.updateDisplayMode(0);
        this.add(this._myScrollbar);
        this.setHeight(this._myBackgroundHeight);
        this.actAsPulldownMenu(true);
    }

    @Override
    public String getStringValue() {
        return this.getCaptionLabel().toString();
    }

    @Override
    public DropdownList setValue(float theValue) {
        for (ListBoxItem l : this.items) {
            if ((float)l.value != theValue) continue;
            this._myValue = l.value;
            this.setLabel(l.name);
            this.skatolo.getControlBroadcaster().broadcast(new ControlEvent(this), 2);
            break;
        }
        return this;
    }

    public DropdownList setIndex(int theIndex) {
        if (theIndex >= this.items.size() || theIndex < 0) {
            return this;
        }
        this.setValue(this.items.get(theIndex).getValue());
        return this;
    }

    public DropdownList hideScrollbar() {
        this.isScrollbarVisible = false;
        this._myScrollbar.hide();
        return this;
    }

    public DropdownList showScrollbar() {
        this.isScrollbarVisible = true;
        if (this.items.size() * this._myItemHeight > this._myBackgroundHeight && this.isScrollbarVisible) {
            this._myScrollbar.show();
        }
        return this;
    }

    public boolean isScrollbarEnabled() {
        return this.isScrollbarVisible;
    }

    public DropdownList setScrollbarVisible(boolean theValue) {
        if (theValue) {
            return this.showScrollbar();
        }
        return this.hideScrollbar();
    }

    public boolean isScrollable() {
        return this._myScrollbar.isVisible();
    }

    public DropdownList scroll(float theValue) {
        if (this.items.size() * this._myItemHeight > this._myBackgroundHeight) {
            this._myScrollbar.setValue(PApplet.abs((float)(1.0f - PApplet.min((float)PApplet.max((float)0.0f, (float)theValue), (float)1.0f))));
        }
        return this;
    }

    public float getScrollPosition() {
        return this._myScrollbar.getValue();
    }

    public void scrolled(int theStep) {
        float step = 1.0f / (float)this.items.size();
        this.scroll(1.0f - this.getScrollPosition() + (float)theStep * step);
    }

    protected void scroll() {
        this.itemOffset = 0;
        if (this.buttons.size() < this.items.size() && this.isScrollbarVisible) {
            this._myScrollbar.show();
            this.itemOffset = (int)Math.abs(this._myScrollValue * (float)(this.items.size() - this.buttons.size()));
        } else {
            this._myScrollbar.hide();
        }
        if (!this.bulkadding) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                ListBoxItem item = this.items.get(this.itemOffset + i);
                Button b = this.buttons.get(i);
                b.getCaptionLabel().toUpperCase(this.isToUpperCase);
                b.setColor(item.getColor());
                b.getCaptionLabel().set(item.getText());
                b._myValue = item.getValue();
            }
        }
    }

    public DropdownList updateListBoxItems() {
        this.scroll();
        return this;
    }

    public DropdownList toUpperCase(boolean theFlag) {
        this._myLabel.toUpperCase(theFlag);
        this.isToUpperCase = theFlag;
        this.updateListBoxItems();
        return this;
    }

    public DropdownList setItemHeight(int theHeight) {
        this._myItemHeight = theHeight;
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get((int)i).height = theHeight;
            this.buttons.get((int)i).position.y = (theHeight + this.spacing) * i;
        }
        this.setHeight(this._myOriginalBackgroundHeight);
        return this;
    }

    @Override
    public DropdownList setHeight(int theHeight) {
        this._myOriginalBackgroundHeight = theHeight;
        this._myBackgroundHeight = this._myOriginalBackgroundHeight / (this._myItemHeight + this.spacing) * (this._myItemHeight + this.spacing);
        this.maxButtons = this._myBackgroundHeight / (this._myItemHeight + this.spacing);
        int n = this._myBackgroundHeight / (this._myItemHeight + this.spacing);
        int pn = this.buttons.size();
        if (n < pn) {
            for (int i = this.buttons.size() - 1; i >= n; --i) {
                this.skatolo.remove(this.skatolo.getController(this.buttons.get(i).getName()));
                this.controllers.remove(this.buttons.get(i));
                this.buttons.remove(i);
            }
        } else if (pn < n) {
            int nn = Math.min(n, this.items.size());
            this.addListButton(nn -= pn);
        }
        this.updateBackground();
        this.scroll();
        return this;
    }

    @Override
    public DropdownList updateInternalEvents(PApplet theApplet) {
        boolean yy;
        boolean xx = (float)this.skatolo.getWindow().getPointerX() > this.getAbsolutePosition().x && (float)this.skatolo.getWindow().getPointerX() < this.getAbsolutePosition().x + (float)this._myWidth;
        boolean bl = yy = (float)this.skatolo.getWindow().getPointerY() > this.getAbsolutePosition().y - 1.0f && (float)this.skatolo.getWindow().getPointerY() < this.getAbsolutePosition().y + (float)this._myBackgroundHeight;
        boolean bl2 = this.isOpen() ? xx && yy : (this.isInsideGroup = false);
        if (this.isBarVisible && this.isInside || this.isInsideGroup) {
            this.skatolo.getWindow().setMouseOverController(this);
        }
        return this;
    }

    private void updateScroll() {
        this._myScrollValue = this._myScrollbar.getValue();
        this._myScrollbar.setValue(this._myScrollValue);
        if (this.buttons.size() < this.items.size() && this.isScrollbarVisible) {
            this._myScrollbar.show();
        }
        this.updateBackground();
        this.scroll();
    }

    private void updateBackground() {
        if (this.items.size() * (this._myItemHeight + this.spacing) < this._myOriginalBackgroundHeight) {
            this._myBackgroundHeight = this.items.size() * (this._myItemHeight + this.spacing);
        }
        if (this.buttons.size() < this.items.size()) {
            this._myScrollbar.setHeight(this._myBackgroundHeight - this.spacing);
            this._myScrollbar.show();
        } else {
            this._myScrollbar.hide();
        }
        this.updateButtonWidth();
    }

    private void updateButtonWidth() {
        boolean b;
        boolean bl = b = this.buttons.size() < this.items.size() && this.isScrollbarVisible;
        if (b) {
            for (int i = 1; i < this.controllers.size(); ++i) {
                ((Button)this.controllers.get((int)i)).width = this._myWidth - this._myScrollbarWidth - 1;
            }
        } else {
            for (int i = 1; i < this.controllers.size(); ++i) {
                ((Button)this.controllers.get((int)i)).width = this._myWidth;
            }
        }
    }

    public DropdownList setScrollbarWidth(int theWidth) {
        this._myScrollbar.setWidth(theWidth);
        this._myScrollbarWidth = theWidth;
        this.setWidth(this.getWidth());
        return this;
    }

    @Override
    public DropdownList setWidth(int theWidth) {
        this._myWidth = theWidth;
        this.updateButtonWidth();
        this._myScrollbar.position.x = this._myWidth - this._myScrollbarWidth;
        return this;
    }

    @Override
    public DropdownList setSize(int theWidth, int theHeight) {
        this.setWidth(theWidth);
        this.setHeight(theHeight);
        return this;
    }

    protected DropdownList addListButton(int theNum) {
        for (int i = 0; i < theNum && this.buttons.size() < this.maxButtons; ++i) {
            int index = this.buttons.size();
            Button b = new Button(this.skatolo, this, this._myName + "Button" + index, index, 0, index * (this._myItemHeight + this.spacing), this._myWidth, this._myItemHeight);
            b.setMoveable(false);
            this.add(b);
            this.skatolo.register(null, "", b);
            b.setBroadcast(false);
            b.addListener(this);
            this.buttons.add(b);
        }
        this.updateScroll();
        return this;
    }

    public void beginItems() {
        this.bulkadding = true;
    }

    public void endItems() {
        this.bulkadding = false;
        this.scroll();
    }

    public ListBoxItem addItem(String theName, int theValue) {
        ListBoxItem lbi = new ListBoxItem(this, theName, theValue);
        this.items.add(lbi);
        this.addListButton(1);
        return lbi;
    }

    public DropdownList addItems(String[] theItems) {
        this.addItems(Arrays.asList(theItems), 0);
        return this;
    }

    public DropdownList addItems(List<?> theItems) {
        this.addItems(theItems, 0);
        return this;
    }

    public DropdownList addItems(List<?> theItems, int theOffset) {
        for (int i = 0; i < theItems.size(); ++i) {
            this.addItem(theItems.get(i).toString(), i + theOffset);
        }
        return this;
    }

    public DropdownList removeItem(String theItemName) {
        try {
            for (int i = this.items.size() - 1; i >= 0; --i) {
                if (!this.items.get((int)i).name.equals(theItemName)) continue;
                this.items.remove(i);
            }
            if (this.buttons.size() > this.items.size()) {
                String buttonName = ((Button)this.controllers.get(this.buttons.size())).getName();
                this.buttons.remove(this.skatolo.getController(buttonName));
                this.controllers.remove(this.skatolo.getController(buttonName));
                this.skatolo.remove(buttonName);
            }
            this.updateScroll();
        }
        catch (Exception e) {
            Skatolo.logger().finer("ScrollList.removeItem exception:" + e);
        }
        return this;
    }

    public ListBoxItem getItem(int theIndex) {
        return this.items.get(theIndex);
    }

    public ListBoxItem getItem(String theItemName) {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (!this.items.get((int)i).name.equals(theItemName)) continue;
            return this.items.get(i);
        }
        return null;
    }

    public ListBoxItem getItem(Controller<?> theButton) {
        int n;
        if (theButton instanceof Button && (n = this.buttons.indexOf(theButton)) >= 0) {
            return this.items.get(n + this.itemOffset);
        }
        return null;
    }

    @Override
    public void controlEvent(ControlEvent theEvent) {
        if (theEvent.getController() instanceof Button) {
            try {
                this._myValue = theEvent.getController().getValue();
                ControlEvent myEvent = new ControlEvent(this);
                if (this.pulldown) {
                    this.close();
                    this.setLabel(theEvent.getController().getLabel());
                }
                for (ControlListener cl : this._myControlListener) {
                    cl.controlEvent(myEvent);
                }
                this.skatolo.getControlBroadcaster().broadcast(myEvent, 2);
                theEvent.getController().onLeave();
                theEvent.getController().setPointerOver(false);
            }
            catch (Exception e) {
                Skatolo.logger().warning("ListBox.controlEvent exception:" + e);
            }
        } else {
            this._myScrollValue = -(1.0f - theEvent.getValue());
            this.scroll();
        }
    }

    @Override
    public void keyEvent(KeyEvent theEvent) {
        boolean b;
        super.keyEvent(theEvent);
        float x = this.getAbsolutePosition().x;
        float y = this.getAbsolutePosition().y;
        boolean bl = b = (float)this.getWindow().getPointerX() > x && (float)this.getWindow().getPointerX() < x + (float)this._myWidth && (float)this.getWindow().getPointerY() > y - (float)this.getBarHeight() && (float)this.getWindow().getPointerY() < y + (float)this._myOriginalBackgroundHeight;
        if (b && this.isOpen()) {
            float step = 1.0f / (float)this.items.size();
            if (this.skatolo.isShiftDown()) {
                step *= 10.0f;
            } else if (this.skatolo.isAltDown()) {
                step = 1.0f;
            }
            if (theEvent.getAction() == 1) {
                switch (theEvent.getKeyCode()) {
                    case 38: {
                        this._myScrollbar.setValue(PApplet.constrain((float)(this._myScrollbar.getValue() + step), (float)0.0f, (float)1.0f));
                        break;
                    }
                    case 40: {
                        this._myScrollbar.setValue(PApplet.constrain((float)(this._myScrollbar.getValue() - step), (float)0.0f, (float)1.0f));
                    }
                }
            }
        }
    }

    public DropdownList actAsPulldownMenu(boolean theValue) {
        this.pulldown = theValue;
        if (this.pulldown) {
            this.close();
        }
        return this;
    }

    public DropdownList clear() {
        int i;
        for (i = this.items.size() - 1; i >= 0; --i) {
            this.items.remove(i);
        }
        this.items.clear();
        for (i = this.buttons.size() - 1; i >= 0; --i) {
            String buttonName = ((Button)this.controllers.get(this.buttons.size())).getName();
            this.buttons.remove(this.skatolo.getController(buttonName));
            this.controllers.remove(this.skatolo.getController(buttonName));
            this.skatolo.remove(buttonName);
        }
        this.updateScroll();
        this._myBackgroundHeight = 0;
        return this;
    }

    @Override
    public DropdownList setColor(CColor theColor) {
        this.setColorActive(theColor.getActive());
        this.setColorForeground(theColor.getForeground());
        this.setColorBackground(theColor.getBackground());
        this.setColorLabel(theColor.getCaptionLabel());
        this.setColorValue(theColor.getValueLabel());
        return this;
    }

    @Override
    public DropdownList setColorActive(int theColor) {
        super.setColorActive(theColor);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).getColor().setActive(theColor);
        }
        this.scroll();
        return this;
    }

    @Override
    public DropdownList setColorForeground(int theColor) {
        super.setColorForeground(theColor);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).getColor().setForeground(theColor);
        }
        this.scroll();
        return this;
    }

    @Override
    public DropdownList setColorBackground(int theColor) {
        super.setColorBackground(theColor);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).getColor().setBackground(theColor);
        }
        this.scroll();
        return this;
    }

    @Override
    public DropdownList setColorLabel(int theColor) {
        super.setColorLabel(theColor);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).getColor().setCaptionLabel(theColor);
        }
        this.scroll();
        return this;
    }

    @Override
    public DropdownList setColorValue(int theColor) {
        super.setColorValue(theColor);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).getColor().setValueLabel(theColor);
        }
        this.scroll();
        return this;
    }

    public String[][] getListBoxItems() {
        String[][] l = new String[this.items.size()][3];
        for (int i = 0; i < l.length; ++i) {
            l[i] = new String[]{this.items.get((int)i).name, this.items.get((int)i).text, Integer.toString(this.items.get((int)i).value)};
        }
        return l;
    }

    public DropdownList setListBoxItems(String[][] l) {
        this.clear();
        for (String[] s : l) {
            this.addItem(s[0], new Integer(s[2])).setText(s[1]);
        }
        return this;
    }

    @Deprecated
    public ListBoxItem item(int theIndex) {
        return this.getItem(theIndex);
    }

    @Deprecated
    public ListBoxItem item(String theItemName) {
        return this.getItem(theItemName);
    }

    @Deprecated
    public ListBoxItem item(Controller<?> theButton) {
        return this.getItem(theButton);
    }

    @Deprecated
    public boolean isScrollbarVisible() {
        return this.isScrollbarVisible;
    }

    @Override
    @Deprecated
    public String stringValue() {
        return this.captionLabel().toString();
    }
}

