/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.group;

import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;
import processing.event.KeyEvent;
import tech.lity.rea.skatolo.ControlFont;
import tech.lity.rea.skatolo.Hacks;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.SkatoloConstants;
import tech.lity.rea.skatolo.events.ControlEvent;
import tech.lity.rea.skatolo.events.ControlListener;
import tech.lity.rea.skatolo.file.ControllerProperty;
import tech.lity.rea.skatolo.gui.CColor;
import tech.lity.rea.skatolo.gui.CDrawable;
import tech.lity.rea.skatolo.gui.Canvas;
import tech.lity.rea.skatolo.gui.ControlWindow;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.ControllerInterface;
import tech.lity.rea.skatolo.gui.ControllerList;
import tech.lity.rea.skatolo.gui.Label;
import tech.lity.rea.skatolo.gui.Pointer;
import tech.lity.rea.skatolo.gui.controllers.Button;
import tech.lity.rea.skatolo.gui.group.Tab;

public abstract class ControllerGroup<T>
implements ControllerInterface<T>,
SkatoloConstants,
ControlListener {
    protected ControllerList controllers;
    protected List<ControlListener> _myControlListener;
    protected Skatolo skatolo;
    protected ControllerGroup<?> _myParent;
    protected String _myName;
    protected int _myId = -1;
    protected PVector position;
    protected PVector positionBuffer;
    protected PVector absolutePosition;
    private final CColor color = new CColor();
    protected Pointer currentPointer = Pointer.invalidPointer;
    protected boolean isMousePressed = false;
    private boolean mouseover;
    protected boolean isInside = false;
    protected boolean isArrowVisible = true;
    protected boolean isInsideGroup = false;
    protected boolean isVisible = true;
    protected boolean isOpen = true;
    protected boolean isBarVisible = true;
    protected boolean isMoveable = true;
    protected Button closeButton;
    protected Label _myLabel;
    protected Label _myValueLabel;
    protected int _myWidth = 99;
    protected int _myHeight = 9;
    protected boolean isUpdate;
    protected List<Canvas> _myCanvas;
    protected float _myValue;
    protected String _myStringValue;
    protected float[] _myArrayValue;
    protected boolean isCollapse = true;
    protected int _myPickingColor = 0x6600FFFF;
    public PVector autoPosition = new PVector(10.0f, 30.0f, 0.0f);
    public float tempAutoPositionHeight = 0.0f;
    public float autoPositionOffsetX = 10.0f;
    private String _myAddress = "";
    protected final T me;

    public ControllerGroup(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0.0f, 0.0f);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public ControllerGroup(Skatolo theskatolo, ControllerGroup<?> theParent, String theName, float theX, float theY) {
        this.position = new PVector(theX, theY, 0.0f);
        this.skatolo = theskatolo;
        this.me = this;
        this.color.set(theParent == null ? this.skatolo.getColor() : theParent.getColor());
        this._myName = theName;
        this.controllers = new ControllerList();
        this._myCanvas = new ArrayList<Canvas>();
        this._myControlListener = new ArrayList<ControlListener>();
        this._myLabel = new Label(this.skatolo, this._myName);
        this._myLabel.setText(this._myName);
        this._myLabel.setColor(this.color.getCaptionLabel());
        this._myLabel.align(37, 101);
        this.setParent(theParent == null ? this : theParent);
    }

    protected ControllerGroup(int theX, int theY) {
        this.position = new PVector((float)theX, (float)theY, 0.0f);
        this.me = this;
        this.controllers = new ControllerList();
        this._myCanvas = new ArrayList<Canvas>();
    }

    @Override
    public void init() {
    }

    @Override
    public ControllerInterface<?> getParent() {
        return this._myParent;
    }

    void setParent(ControllerGroup<?> theParent) {
        if (this._myParent != null && this._myParent != this) {
            this._myParent.remove(this);
        }
        this._myParent = theParent;
        if (this._myParent != this) {
            this._myParent.add(this);
        }
        this.absolutePosition = new PVector(this.position.x, this.position.y);
        this.absolutePosition.add(this._myParent.absolutePosition);
        this.positionBuffer = new PVector(this.position.x, this.position.y);
        if (this.skatolo.getWindow() != null) {
            this.setPointerOver(false);
        }
    }

    public final T setGroup(ControllerGroup<?> theGroup) {
        this.setParent(theGroup);
        return this.me;
    }

    public final T setGroup(String theName) {
        this.setParent(this.skatolo.getGroup(theName));
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> theGroup, Tab theTab, ControlWindow theControlWindow) {
        if (theGroup != null) {
            this.setGroup(theGroup);
            return this.me;
        }
        if (theControlWindow == null) {
            theControlWindow = this.skatolo.controlWindow;
        }
        this.setTab(theControlWindow, theTab.getName());
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> theGroup) {
        this.moveTo(theGroup, null, null);
        return this.me;
    }

    public final T moveTo(Tab theTab) {
        this.moveTo(null, theTab, theTab.getWindow());
        return this.me;
    }

    public T moveTo(PApplet thePApplet) {
        this.moveTo(this.skatolo.controlWindow);
        return this.me;
    }

    public T moveTo(ControlWindow theControlWindow) {
        this.moveTo(null, theControlWindow.getTab("default"), theControlWindow);
        return this.me;
    }

    public final T moveTo(String theTabName) {
        this.moveTo(null, this.skatolo.controlWindow.getTab(theTabName), this.skatolo.controlWindow);
        return this.me;
    }

    public final T moveTo(String theTabName, ControlWindow theControlWindow) {
        this.moveTo(null, theControlWindow.getTab(theTabName), theControlWindow);
        return this.me;
    }

    public final T moveTo(ControlWindow theControlWindow, String theTabName) {
        this.moveTo(null, theControlWindow.getTab(theTabName), theControlWindow);
        return this.me;
    }

    public final T moveTo(Tab theTab, ControlWindow theControlWindow) {
        this.moveTo(null, theTab, theControlWindow);
        return this.me;
    }

    public final T setTab(String theName) {
        this.setParent(this.skatolo.getTab(theName));
        return this.me;
    }

    public final T setTab(ControlWindow theWindow, String theName) {
        this.setParent(this.skatolo.getTab(theWindow, theName));
        return this.me;
    }

    public final T setTab(Tab theTab) {
        this.setParent(theTab);
        return this.me;
    }

    @Override
    public Tab getTab() {
        if (this instanceof Tab) {
            return (Tab)this;
        }
        if (this._myParent instanceof Tab) {
            return (Tab)this._myParent;
        }
        return this._myParent.getTab();
    }

    public void updateFont(ControlFont theControlFont) {
        this._myLabel.updateFont(theControlFont);
        if (this._myValueLabel != null) {
            this._myValueLabel.updateFont(theControlFont);
        }
        for (int i = 0; i < this.controllers.size(); ++i) {
            if (this.controllers.get(i) instanceof Controller) {
                ((Controller)this.controllers.get(i)).updateFont(theControlFont);
                continue;
            }
            ((ControllerGroup)this.controllers.get(i)).updateFont(theControlFont);
        }
    }

    @Override
    public PVector getAbsolutePosition() {
        return new PVector(this.absolutePosition.x, this.absolutePosition.y);
    }

    @Override
    public T setAbsolutePosition(PVector thePVector) {
        this.absolutePosition.set(thePVector.x, thePVector.y, thePVector.z);
        return this.me;
    }

    @Override
    public PVector getPosition() {
        return new PVector(this.position.x, this.position.y);
    }

    @Override
    public T setPosition(float theX, float theY) {
        this.position.set((float)((int)theX), (float)((int)theY), 0.0f);
        this.positionBuffer.set(this.position);
        this.updateAbsolutePosition();
        return this.me;
    }

    @Override
    public T setPosition(PVector thePVector) {
        this.setPosition(thePVector.x, thePVector.y);
        return this.me;
    }

    @Override
    public T updateAbsolutePosition() {
        this.absolutePosition.set(this.position);
        this.absolutePosition.add(this._myParent.getAbsolutePosition());
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).updateAbsolutePosition();
        }
        return this.me;
    }

    @Override
    public void continuousUpdateEvents() {
        if (this.controllers.size() <= 0) {
            return;
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            this.controllers.get(i).continuousUpdateEvents();
        }
    }

    @Override
    public T update() {
        if (this.controllers.size() <= 0) {
            return this.me;
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            if (!this.controllers.get(i).isUpdate()) continue;
            this.controllers.get(i).update();
        }
        return this.me;
    }

    @Override
    public T setUpdate(boolean theFlag) {
        this.isUpdate = theFlag;
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).setUpdate(theFlag);
        }
        return this.me;
    }

    @Override
    public boolean isUpdate() {
        return this.isUpdate;
    }

    @Override
    public T updateEvents() {
        if (this.isOpen) {
            for (int i = this.controllers.size() - 1; i >= 0; --i) {
                this.controllers.get(i).updateEvents();
            }
        }
        if (!this.isVisible) {
            return this.me;
        }
        if (this.currentPointer == this.skatolo.getWindow().getCurrentPointer() || this.currentPointer == Pointer.invalidPointer) {
            if (this.isMovingGroup()) {
                this.moveGroup();
            } else if (this.inside()) {
                if (!this.isInside) {
                    this.isInside = true;
                    this.onEnter();
                    this.setPointerOver(true);
                }
            } else if (this.isInside && !this.isMousePressed) {
                this.onLeave();
                this.isInside = false;
                this.setPointerOver(false);
            }
        }
        return this.me;
    }

    private boolean isMovingGroup() {
        return this.isMousePressed && this.skatolo.isAltDown() && this.isMoveable && !this.skatolo.isMoveable;
    }

    private void moveGroup() {
        this.positionBuffer.x += (float)(this.skatolo.getWindow().getPointerX() - this.skatolo.getWindow().getPointerPrevX());
        this.positionBuffer.y += (float)(this.skatolo.getWindow().getPointerY() - this.skatolo.getWindow().getPointerPrevY());
        if (this.skatolo.isShiftDown()) {
            this.position.x = (int)this.positionBuffer.x / 10 * 10;
            this.position.y = (int)this.positionBuffer.y / 10 * 10;
        } else {
            this.position.set(this.positionBuffer);
        }
        this.updateAbsolutePosition();
    }

    @Override
    public T updateInternalEvents(PApplet theApplet) {
        return this.me;
    }

    @Override
    public boolean isPointerOver() {
        this.mouseover = this.isInside || this.isInsideGroup || !this.isBarVisible;
        return this.mouseover;
    }

    @Override
    public T setPointerOver(boolean theFlag) {
        boolean bl = this.mouseover = !this.isBarVisible ? false : theFlag;
        if (!this.mouseover) {
            this.isInside = false;
            this.isInsideGroup = false;
            this.skatolo.getWindow().removeMouseOverFor(this);
            for (int i = this.controllers.size() - 1; i >= 0; --i) {
                this.controllers.get(i).setPointerOver(false);
            }
            this.currentPointer = this.skatolo.getWindow().getCurrentPointer();
        } else {
            this.skatolo.getWindow().setMouseOverController(this);
            this.currentPointer = Pointer.invalidPointer;
        }
        return this.me;
    }

    public final void draw(PApplet theApplet, PGraphics graphics) {
        if (this.isVisible) {
            graphics.pushMatrix();
            graphics.translate(this.position.x, this.position.y);
            this.preDraw(graphics);
            this.updateControllers(theApplet);
            this.drawControllers(graphics);
            this.postDraw(graphics);
            if (this._myValueLabel != null) {
                this._myValueLabel.draw(graphics, 2, 2, this);
            }
            graphics.popMatrix();
        }
    }

    @Override
    public final void draw(PGraphics graphics) {
        if (this.isVisible) {
            graphics.pushMatrix();
            graphics.translate(this.position.x, this.position.y);
            this.preDraw(graphics);
            this.drawControllers(graphics);
            this.postDraw(graphics);
            if (this._myValueLabel != null) {
                this._myValueLabel.draw(graphics, 2, 2, this);
            }
            graphics.popMatrix();
        }
    }

    protected void drawControllers(PGraphics graphics) {
        if (this.isOpen) {
            for (Canvas canvas : this._myCanvas) {
                if (canvas.mode() != 0) continue;
                canvas.draw(graphics);
            }
            for (ControllerInterface controllerInterface : this.controllers.get()) {
                if (!controllerInterface.isVisible()) continue;
                controllerInterface.draw(graphics);
                controllerInterface.updateInternalEvents(this.skatolo.getPApplet());
            }
            for (CDrawable cDrawable : this.controllers.getDrawables()) {
                cDrawable.draw(graphics);
            }
            for (Canvas canvas : this._myCanvas) {
                if (canvas.mode() != 1) continue;
                canvas.draw(graphics);
            }
        }
    }

    protected void updateControllers(PApplet theApplet) {
        if (this.isOpen) {
            for (ControllerInterface<?> ci : this.controllers.get()) {
                if (!ci.isVisible()) continue;
                ci.updateInternalEvents(theApplet);
            }
        }
    }

    protected void preDraw(PGraphics graphics) {
    }

    protected void postDraw(PGraphics graphics) {
    }

    public Canvas addCanvas(Canvas theCanvas) {
        this._myCanvas.add(theCanvas);
        theCanvas.setup(this.skatolo.getPApplet());
        return theCanvas;
    }

    public T removeCanvas(Canvas theCanvas) {
        this._myCanvas.remove(theCanvas);
        return this.me;
    }

    @Override
    public T add(ControllerInterface<?> theElement) {
        this.controllers.add(theElement);
        return this.me;
    }

    @Override
    public T bringToFront() {
        return this.bringToFront(this);
    }

    @Override
    public T bringToFront(ControllerInterface<?> theController) {
        if (this._myParent instanceof Tab) {
            this.moveTo((Tab)this._myParent);
        } else {
            this._myParent.bringToFront(theController);
        }
        if (theController != this && this.controllers.get().contains(theController)) {
            this.controllers.remove(theController);
            this.controllers.add(theController);
        }
        return this.me;
    }

    @Override
    public T remove(ControllerInterface<?> theElement) {
        if (theElement != null) {
            theElement.setPointerOver(false);
        }
        this.controllers.remove(theElement);
        return this.me;
    }

    public T addDrawable(CDrawable theElement) {
        this.controllers.addDrawable(theElement);
        return this.me;
    }

    public T remove(CDrawable theElement) {
        this.controllers.removeDrawable(theElement);
        return this.me;
    }

    @Override
    public void remove() {
        this.skatolo.getWindow().removeMouseOverFor(this);
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.skatolo != null) {
            this.skatolo.remove((Object)this);
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            this.controllers.get(i).remove();
        }
        this.controllers.clear();
        this.controllers.clearDrawable();
        this.controllers = new ControllerList();
        if (this instanceof Tab) {
            this.skatolo.getWindow().removeTab((Tab)this);
        }
    }

    @Override
    public String getName() {
        return this._myName;
    }

    @Override
    public String getAddress() {
        return this._myAddress;
    }

    @Override
    public T setAddress(String theAddress) {
        if (this._myAddress.length() == 0) {
            this._myAddress = theAddress;
        }
        return this.me;
    }

    @Override
    public ControlWindow getWindow() {
        return this.skatolo.getWindow();
    }

    @Override
    public void keyEvent(KeyEvent theEvent) {
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).keyEvent(theEvent);
        }
    }

    @Override
    public boolean setMousePressed(boolean theStatus) {
        if (!this.isVisible) {
            return false;
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            if (!this.controllers.get(i).setMousePressed(theStatus)) continue;
            return true;
        }
        if (theStatus) {
            if (this.isInside) {
                this.isMousePressed = true;
                this.mousePressed();
                return true;
            }
        } else if (this.isMousePressed) {
            this.isMousePressed = false;
            this.mouseReleased();
        }
        return false;
    }

    protected void mousePressed() {
    }

    public void mouseReleased() {
    }

    protected void onEnter() {
    }

    protected void onLeave() {
    }

    public void onScroll(int theAmount) {
    }

    @Override
    public T setId(int theId) {
        this._myId = theId;
        return this.me;
    }

    @Override
    public int getId() {
        return this._myId;
    }

    @Override
    public T setColor(CColor theColor) {
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColor(theColor);
        }
        return this.me;
    }

    @Override
    public T setColorActive(int theColor) {
        this.color.setActive(theColor);
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColorActive(theColor);
        }
        return this.me;
    }

    @Override
    public T setColorForeground(int theColor) {
        this.color.setForeground(theColor);
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColorForeground(theColor);
        }
        return this.me;
    }

    @Override
    public T setColorBackground(int theColor) {
        this.color.setBackground(theColor);
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColorBackground(theColor);
        }
        return this.me;
    }

    @Override
    public T setColorLabel(int theColor) {
        this.color.setCaptionLabel(theColor);
        if (this._myLabel != null) {
            this._myLabel.setColor(this.color.getCaptionLabel());
        }
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColorLabel(theColor);
        }
        return this.me;
    }

    @Override
    public T setColorValue(int theColor) {
        this.color.setValueLabel(theColor);
        if (this._myValueLabel != null) {
            this._myValueLabel.setColor(this.color.getValueLabel());
        }
        for (ControllerInterface<?> ci : this.controllers.get()) {
            ci.setColorValue(theColor);
        }
        return this.me;
    }

    @Override
    public T setLabel(String theLabel) {
        this._myLabel.set(theLabel);
        return this.me;
    }

    @Override
    public boolean isVisible() {
        if (this._myParent != null && this._myParent != this && !this.getParent().isVisible()) {
            return false;
        }
        return this.isVisible;
    }

    public T setVisible(boolean theFlag) {
        this.isVisible = theFlag;
        return this.me;
    }

    @Override
    public T hide() {
        this.isVisible = false;
        return this.me;
    }

    @Override
    public T show() {
        this.isVisible = true;
        return this.me;
    }

    public T setMoveable(boolean theFlag) {
        this.isMoveable = theFlag;
        return this.me;
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public T setOpen(boolean theFlag) {
        this.isOpen = theFlag;
        return this.me;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public T open() {
        this.setOpen(true);
        return this.me;
    }

    public T close() {
        this.setOpen(false);
        return this.me;
    }

    public T removeCloseButton() {
        if (this.closeButton == null) {
            this.closeButton.remove();
        }
        this.closeButton = null;
        return this.me;
    }

    public T setTitle(String theTitle) {
        this.getCaptionLabel().set(theTitle);
        return this.me;
    }

    public T hideBar() {
        this.isBarVisible = false;
        return this.me;
    }

    public T showBar() {
        this.isBarVisible = true;
        return this.me;
    }

    public boolean isBarVisible() {
        return this.isBarVisible;
    }

    public T hideArrow() {
        this.isArrowVisible = false;
        return this.me;
    }

    public T showArrow() {
        this.isArrowVisible = true;
        return this.me;
    }

    public T addCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new Button(this.skatolo, this, this.getName() + "close", 1.0f, this._myWidth + 1, -10, 12, 9);
            this.closeButton.setCaptionLabel("X");
            this.closeButton.addListener(this);
        }
        return this.me;
    }

    @Override
    public int getPickingColor() {
        return this._myPickingColor;
    }

    @Override
    public CColor getColor() {
        return this.color;
    }

    @Override
    public T setValue(float theValue) {
        this._myValue = theValue;
        return this.me;
    }

    @Override
    public float getValue() {
        return this._myValue;
    }

    @Override
    public String getStringValue() {
        return this._myStringValue;
    }

    @Override
    public T setStringValue(String theValue) {
        this._myStringValue = theValue;
        return this.me;
    }

    @Override
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    @Override
    public float getArrayValue(int theIndex) {
        if (theIndex >= 0 && theIndex < this._myArrayValue.length) {
            return this._myArrayValue[theIndex];
        }
        return Float.NaN;
    }

    @Override
    public T setArrayValue(int theIndex, float theValue) {
        if (theIndex >= 0 && theIndex < this._myArrayValue.length) {
            this._myArrayValue[theIndex] = theValue;
        }
        return this.me;
    }

    @Override
    public T setArrayValue(float[] theArray) {
        this._myArrayValue = theArray;
        return this.me;
    }

    public Controller<?> getController(String theController) {
        return this.skatolo.getController(theController);
    }

    @Override
    public T setCaptionLabel(String theValue) {
        this.getCaptionLabel().set(theValue);
        return this.me;
    }

    public Label getCaptionLabel() {
        return this._myLabel;
    }

    public Label getValueLabel() {
        return this._myValueLabel;
    }

    public T enableCollapse() {
        this.isCollapse = true;
        return this.me;
    }

    public T disableCollapse() {
        this.isCollapse = false;
        return this.me;
    }

    public boolean isCollapse() {
        return this.isCollapse;
    }

    @Override
    public int getWidth() {
        return this._myWidth;
    }

    @Override
    public int getHeight() {
        return this._myHeight;
    }

    public T setWidth(int theWidth) {
        this._myWidth = theWidth;
        return this.me;
    }

    public T setHeight(int theHeight) {
        this._myHeight = theHeight;
        return this.me;
    }

    public T setSize(int theWidth, int theHeight) {
        this.setWidth(theWidth);
        return this.me;
    }

    protected boolean inside() {
        return (float)this.skatolo.getWindow().getPointerX() > this.position.x + this._myParent.absolutePosition.x && (float)this.skatolo.getWindow().getPointerX() < this.position.x + this._myParent.absolutePosition.x + (float)this._myWidth && (float)this.skatolo.getWindow().getPointerY() > this.position.y + this._myParent.absolutePosition.y - (float)this._myHeight && (float)this.skatolo.getWindow().getPointerY() < this.position.y + this._myParent.absolutePosition.y;
    }

    @Override
    public ControllerProperty getProperty(String thePropertyName) {
        return this.skatolo.getProperties().getProperty(this, thePropertyName);
    }

    @Override
    public ControllerProperty getProperty(String theSetter, String theGetter) {
        return this.skatolo.getProperties().getProperty(this, theSetter, theGetter);
    }

    @Override
    public T registerProperty(String thePropertyName) {
        this.skatolo.getProperties().register(this, thePropertyName);
        return this.me;
    }

    @Override
    public T registerProperty(String theSetter, String theGetter) {
        this.skatolo.getProperties().register(this, theSetter, theGetter);
        return this.me;
    }

    @Override
    public T removeProperty(String thePropertyName) {
        this.skatolo.getProperties().remove((ControllerInterface<?>)this, thePropertyName);
        return this.me;
    }

    @Override
    public T removeProperty(String theSetter, String theGetter) {
        this.skatolo.getProperties().remove((ControllerInterface<?>)this, theSetter, theGetter);
        return this.me;
    }

    @Override
    public void controlEvent(ControlEvent theEvent) {
    }

    @Override
    public T addListener(ControlListener theListener) {
        this._myControlListener.add(theListener);
        return this.me;
    }

    public T removeListener(ControlListener theListener) {
        this._myControlListener.remove(theListener);
        return this.me;
    }

    public int listenerSize() {
        return this._myControlListener.size();
    }

    public String toString() {
        return this.getName() + " [" + this.getClass().getSimpleName() + "]";
    }

    public String getInfo() {
        return "type:\tControllerGroup\nname:\t" + this._myName + "\nlabel:\t" + this._myLabel.getText() + "\nid:\t" + this._myId + "\nvalue:\t" + this._myValue + "\narrayvalue:\t" + Hacks.arrayToString(this._myArrayValue) + "\nposition:\t" + this.position + "\nabsolute:\t" + this.absolutePosition + "\nwidth:\t" + this.getWidth() + "\nheight:\t" + this.getHeight() + "\ncolor:\t" + this.getColor() + "\nvisible:\t" + this.isVisible + "\nmoveable:\t" + this.isMoveable + "\n";
    }

    @Deprecated
    public PVector absolutePosition() {
        return this.getAbsolutePosition();
    }

    @Deprecated
    public PVector position() {
        return this.getPosition();
    }

    @Deprecated
    public CColor color() {
        return this.color;
    }

    @Deprecated
    public float value() {
        return this._myValue;
    }

    @Deprecated
    public String stringValue() {
        return this.getStringValue();
    }

    @Deprecated
    public float[] arrayValue() {
        return this.getArrayValue();
    }

    @Deprecated
    public String name() {
        return this._myName;
    }

    @Deprecated
    public int id() {
        return this._myId;
    }

    @Deprecated
    public Controller<?> controller(String theController) {
        return this.skatolo.getController(theController);
    }

    @Override
    @Deprecated
    public ControllerInterface<?> parent() {
        return this._myParent;
    }

    @Deprecated
    public Label captionLabel() {
        return this._myLabel;
    }

    @Deprecated
    public Label valueLabel() {
        return this._myValueLabel;
    }
}

