/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.group;

import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;
import processing.core.PGraphics;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.events.ControlEvent;
import tech.lity.rea.skatolo.events.ControlListener;
import tech.lity.rea.skatolo.gui.Label;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;

public class ControlGroup<T>
extends ControllerGroup<T>
implements ControlListener {
    protected int _myBackgroundHeight = 0;
    protected int _myBackgroundColor = 0xFFFFFF;
    protected boolean isEventActive = false;
    protected List<ControlListener> _myControlListener = new ArrayList<ControlListener>();

    public ControlGroup(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0, 0, 100, 9);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public ControlGroup(Skatolo theskatolo, ControllerGroup<?> theParent, String theName, int theX, int theY, int theW, int theH) {
        super(theskatolo, theParent, theName, theX, theY);
        this._myValueLabel = new Label(this.skatolo, "");
        this._myWidth = theW;
        this._myHeight = theH;
    }

    @Override
    public void mousePressed() {
        if (this.isBarVisible && this.isCollapse && !this.skatolo.isAltDown()) {
            boolean bl = this.isOpen = !this.isOpen;
            if (this.isEventActive) {
                ControlEvent myEvent = new ControlEvent(this);
                this.skatolo.getControlBroadcaster().broadcast(myEvent, 0);
                for (ControlListener cl : this._myControlListener) {
                    cl.controlEvent(myEvent);
                }
            }
        }
    }

    public T activateEvent(boolean theFlag) {
        this.isEventActive = theFlag;
        return (T)this.me;
    }

    @Override
    public T setSize(int theWidth, int theHeight) {
        super.setSize(theWidth, theHeight);
        this.setBackgroundHeight(theHeight);
        return (T)this.me;
    }

    public int getBackgroundHeight() {
        return this._myBackgroundHeight;
    }

    public T setBackgroundHeight(int theHeight) {
        this._myBackgroundHeight = theHeight;
        return (T)this.me;
    }

    public T setBackgroundColor(int theColor) {
        this._myBackgroundColor = theColor;
        return (T)this.me;
    }

    public T setBarHeight(int theHeight) {
        this._myHeight = theHeight;
        return (T)this.me;
    }

    public int getBarHeight() {
        return this._myHeight;
    }

    @Override
    public T updateInternalEvents(PApplet theApplet) {
        if (this.isInside && this.isBarVisible) {
            this.skatolo.getWindow().setMouseOverController(this);
        }
        return (T)this.me;
    }

    @Override
    protected void preDraw(PGraphics graphics) {
        if (this.isOpen) {
            graphics.fill(this._myBackgroundColor);
            graphics.rect(0.0f, 0.0f, (float)this._myWidth, (float)(this._myBackgroundHeight - 1));
        }
    }

    @Override
    protected void postDraw(PGraphics graphics) {
        if (this.isBarVisible) {
            graphics.fill(this.isInside ? this.getColor().getForeground() : this.getColor().getBackground());
            graphics.rect(0.0f, -1.0f, (float)this._myWidth, (float)(-this._myHeight));
            this._myLabel.draw(graphics, 0, -this._myHeight - 1, this);
            if (this.isCollapse && this.isArrowVisible) {
                graphics.fill(this._myLabel.getColor());
                graphics.pushMatrix();
                graphics.translate(2.0f, 0.0f);
                if (this.isOpen) {
                    graphics.triangle((float)(this._myWidth - 10), (float)(-this._myHeight / 2 - 3), (float)(this._myWidth - 4), (float)(-this._myHeight / 2 - 3), (float)(this._myWidth - 7), (float)(-this._myHeight / 2));
                } else {
                    graphics.triangle((float)(this._myWidth - 10), (float)(-this._myHeight / 2), (float)(this._myWidth - 4), (float)(-this._myHeight / 2), (float)(this._myWidth - 7), (float)(-this._myHeight / 2 - 3));
                }
                graphics.popMatrix();
            }
        }
    }

    @Override
    public void controlEvent(ControlEvent theEvent) {
        if (theEvent.getController().getName().equals(this.getName() + "close")) {
            this.hide();
        }
    }

    @Override
    public String stringValue() {
        return Float.toString(this._myValue);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public String getInfo() {
        return "type:\tControlGroup\n" + super.getInfo();
    }

    @Override
    public T addListener(ControlListener theListener) {
        this._myControlListener.add(theListener);
        return (T)this.me;
    }

    @Override
    public T removeListener(ControlListener theListener) {
        this._myControlListener.remove(theListener);
        return (T)this.me;
    }

    @Override
    public int listenerSize() {
        return this._myControlListener.size();
    }
}

