/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.group;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import processing.core.PImage;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.events.ControlEvent;
import tech.lity.rea.skatolo.events.ControllerPlug;
import tech.lity.rea.skatolo.gui.Label;
import tech.lity.rea.skatolo.gui.controllers.Toggle;
import tech.lity.rea.skatolo.gui.group.ControlGroup;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;

public class CheckBox
extends ControlGroup<CheckBox> {
    private Object _myPlug;
    private String _myPlugName;
    protected List<Toggle> _myRadioToggles;
    protected int spacingRow = 1;
    protected int spacingColumn = 1;
    protected int itemsPerRow = -1;
    protected boolean isMultipleChoice;
    protected int itemHeight = 9;
    protected int itemWidth = 9;
    protected boolean[] availableImages = new boolean[3];
    protected PImage[] images = new PImage[3];
    protected boolean noneSelectedAllowed = true;

    public CheckBox(Skatolo theskatolo, String theName) {
        this(theskatolo, (ControllerGroup<?>)theskatolo.getDefaultTab(), theName, 0, 0);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public CheckBox(Skatolo theskatolo, ControllerGroup<?> theParent, String theName, int theX, int theY) {
        super(theskatolo, theParent, theName, theX, theY, 99, 9);
        this.isBarVisible = false;
        this.isCollapse = false;
        this._myRadioToggles = new ArrayList<Toggle>();
        this.setItemsPerRow(1);
        this.isMultipleChoice = true;
        this._myPlug = this.skatolo.getObjectForIntrospection();
        this._myPlugName = this.getName();
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{float[].class})) {
            this._myPlug = null;
        }
    }

    public final CheckBox activateAll() {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            this._myRadioToggles.get(i).activate();
        }
        this.updateValues();
        return this;
    }

    public final CheckBox activate(int theIndex) {
        if (theIndex < this._myRadioToggles.size()) {
            this._myRadioToggles.get(theIndex).activate();
            this.updateValues();
        }
        return this;
    }

    public final CheckBox deactivate(int theIndex) {
        if (theIndex < this._myRadioToggles.size()) {
            this._myRadioToggles.get(theIndex).deactivate();
            this.updateValues();
        }
        return this;
    }

    public final CheckBox toggle(int theIndex) {
        if (theIndex < this._myRadioToggles.size()) {
            Toggle t = this._myRadioToggles.get(theIndex);
            if (t.getState()) {
                t.deactivate();
            } else {
                t.activate();
            }
            this.updateValues();
        }
        return this;
    }

    public final void toggle(String theName) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle t = this._myRadioToggles.get(i);
            if (!theName.equals(t.getName())) continue;
            if (t.getState()) {
                t.deactivate();
            } else {
                t.activate();
            }
            this.updateValues();
            return;
        }
    }

    public final CheckBox activate(String theName) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle t = this._myRadioToggles.get(i);
            if (!theName.equals(t.getName())) continue;
            t.activate();
            this.updateValues();
            return this;
        }
        return this;
    }

    public final CheckBox deactivate(String theName) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle t = this._myRadioToggles.get(i);
            if (!theName.equals(t.getName())) continue;
            t.deactivate();
            this.updateValues();
            return this;
        }
        return this;
    }

    private final void updateValues() {
        this._myValue = -1.0f;
        this.updateValues(true);
    }

    @Override
    public CheckBox setArrayValue(float[] theArray) {
        for (int i = 0; i < theArray.length; ++i) {
            if (this._myArrayValue[i] == theArray[i]) continue;
            if (theArray[i] == 0.0f) {
                this._myRadioToggles.get(i).deactivate();
                continue;
            }
            this._myRadioToggles.get(i).activate();
        }
        super.setArrayValue(theArray);
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tCheckBox\n" + super.getInfo();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public CheckBox addItem(String theName, float theValue) {
        Toggle t = this.skatolo.addToggle(theName, 0.0f, 0.0f, this.itemWidth, this.itemHeight);
        t.getCaptionLabel().align(11, 3).setPadding(Label.defaultPaddingX, 0);
        t.setMode(0);
        t.setImages(this.images[0], this.images[1], this.images[2]);
        t.setSize(this.images[0]);
        this.addItem(t, theValue);
        return this;
    }

    public CheckBox addItem(Toggle theToggle, float theValue) {
        theToggle.setGroup(this);
        theToggle.isMoveable = false;
        theToggle.setInternalValue(theValue);
        theToggle.isBroadcast = false;
        this._myRadioToggles.add(theToggle);
        this.updateLayout();
        this.getColor().copyTo(theToggle);
        theToggle.addListener(this);
        this.updateValues(false);
        this.skatolo.removeProperty(theToggle);
        return this;
    }

    public CheckBox removeItem(String theName) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            if (!this._myRadioToggles.get(i).getName().equals(theName)) continue;
            this._myRadioToggles.get(i).removeListener(this);
            this._myRadioToggles.remove(i);
        }
        this.updateValues(false);
        return this;
    }

    public CheckBox setImages(PImage theDefaultImage, PImage theOverImage, PImage theActiveImage) {
        this.setImage(theDefaultImage, 0);
        this.setImage(theOverImage, 1);
        this.setImage(theActiveImage, 2);
        return this;
    }

    public CheckBox setImage(PImage theImage) {
        return this.setImage(theImage, 0);
    }

    public CheckBox setImage(PImage theImage, int theState) {
        if (theImage != null) {
            this.images[theState] = theImage;
            this.availableImages[theState] = true;
            for (int i = 0; i < this._myRadioToggles.size(); ++i) {
                this._myRadioToggles.get(i).setImage(theImage, theState);
            }
        }
        return this;
    }

    public CheckBox setSize(PImage theImage) {
        return this.setSize(theImage.width, theImage.height);
    }

    @Override
    public CheckBox setSize(int theWidth, int theHeight) {
        this.setItemWidth(theWidth);
        this.setItemHeight(theHeight);
        return this;
    }

    public CheckBox setItemHeight(int theItemHeight) {
        this.itemHeight = theItemHeight;
        for (Toggle t : this._myRadioToggles) {
            t.setHeight(theItemHeight);
        }
        this.updateLayout();
        return this;
    }

    public CheckBox setItemWidth(int theItemWidth) {
        this.itemWidth = theItemWidth;
        for (Toggle t : this._myRadioToggles) {
            t.setWidth(theItemWidth);
        }
        this.updateLayout();
        return this;
    }

    public Toggle getItem(int theIndex) {
        return this._myRadioToggles.get(theIndex);
    }

    public List<Toggle> getItems() {
        return this._myRadioToggles;
    }

    public boolean getState(int theIndex) {
        if (theIndex < this._myRadioToggles.size() && theIndex >= 0) {
            return this._myRadioToggles.get(theIndex).getState();
        }
        return false;
    }

    public boolean getState(String theName) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle t = this._myRadioToggles.get(i);
            if (!theName.equals(t.getName())) continue;
            return t.getState();
        }
        return false;
    }

    public void updateLayout() {
        int nn = 0;
        int xx = 0;
        int yy = 0;
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle t = this._myRadioToggles.get(i);
            t.position.y = yy;
            t.position.x = xx;
            xx += t.width + this.spacingColumn;
            if (++nn == this.itemsPerRow) {
                nn = 0;
                this._myWidth = xx;
                yy += t.height + this.spacingRow;
                xx = 0;
                continue;
            }
            this._myWidth = xx;
        }
    }

    public CheckBox setItemsPerRow(int theValue) {
        this.itemsPerRow = theValue;
        this.updateLayout();
        return this;
    }

    public CheckBox setSpacingColumn(int theSpacing) {
        this.spacingColumn = theSpacing;
        this.updateLayout();
        return this;
    }

    public CheckBox setSpacingRow(int theSpacing) {
        this.spacingRow = theSpacing;
        this.updateLayout();
        return this;
    }

    public CheckBox deactivateAll() {
        if (!this.isMultipleChoice && !this.noneSelectedAllowed) {
            return this;
        }
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            this._myRadioToggles.get(i).deactivate();
        }
        this._myValue = -1.0f;
        this.updateValues(true);
        return this;
    }

    @Override
    public void controlEvent(ControlEvent theEvent) {
        if (!this.isMultipleChoice) {
            if (!this.noneSelectedAllowed && theEvent.getController().getValue() < 1.0f && theEvent.getController() instanceof Toggle) {
                Toggle t = (Toggle)theEvent.getController();
                boolean b = t.isBroadcast();
                t.setBroadcast(false);
                t.setState(true);
                t.setBroadcast(b);
                return;
            }
            this._myValue = -1.0f;
            int n = this._myRadioToggles.size();
            for (int i = 0; i < n; ++i) {
                Toggle t = this._myRadioToggles.get(i);
                if (!t.equals(theEvent.getController())) {
                    t.deactivate();
                    continue;
                }
                if (!t.isOn) continue;
                this._myValue = t.internalValue();
            }
        }
        this.updateValues(true);
        if (this._myPlug != null) {
            try {
                Method method = this._myPlug.getClass().getMethod(this._myPlugName, float[].class);
                method.invoke(this._myPlug, new Object[]{this.getArrayValue()});
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
    }

    public CheckBox plugTo(Object theObject) {
        this._myPlug = theObject;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{float[].class})) {
            this._myPlug = null;
        }
        return this;
    }

    public CheckBox plugTo(Object theObject, String thePlugName) {
        this._myPlug = theObject;
        this._myPlugName = thePlugName;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{float[].class})) {
            this._myPlug = null;
        }
        return this;
    }

    protected void updateValues(boolean theBroadcastFlag) {
        int n = this._myRadioToggles.size();
        this._myArrayValue = new float[n];
        for (int i = 0; i < n; ++i) {
            Toggle t = this._myRadioToggles.get(i);
            this._myArrayValue[i] = t.getValue();
        }
        if (theBroadcastFlag) {
            ControlEvent myEvent = new ControlEvent(this);
            this.skatolo.getControlBroadcaster().broadcast(myEvent, 2);
        }
    }

    public CheckBox setNoneSelectedAllowed(boolean theValue) {
        this.noneSelectedAllowed = theValue;
        return this;
    }

    public CheckBox setColorLabels(int theColor) {
        for (Toggle t : this._myRadioToggles) {
            t.getCaptionLabel().setColor(theColor);
        }
        return this;
    }

    public CheckBox hideLabels() {
        for (Toggle t : this._myRadioToggles) {
            t.getCaptionLabel().setVisible(false);
        }
        return this;
    }

    public CheckBox showLabels() {
        for (Toggle t : this._myRadioToggles) {
            t.getCaptionLabel().setVisible(true);
        }
        return this;
    }

    public CheckBox toUpperCase(boolean theValue) {
        for (Toggle t : this._myRadioToggles) {
            t.getCaptionLabel().toUpperCase(theValue);
        }
        return this;
    }

    @Deprecated
    public CheckBox add(String theName, float theValue) {
        return this.addItem(theName, theValue);
    }
}

