/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.group;

import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.events.ControlEvent;
import tech.lity.rea.skatolo.gui.ControllerInterface;
import tech.lity.rea.skatolo.gui.group.ControlGroup;
import tech.lity.rea.skatolo.gui.group.Tab;

public class Accordion
extends ControlGroup<Accordion> {
    protected int spacing = 1;
    protected int minHeight = 100;
    protected int itemheight;
    protected int _myMode = 0;

    public Accordion(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0, 0, 200);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public Accordion(Skatolo theskatolo, Tab theTab, String theName, int theX, int theY, int theW) {
        super(theskatolo, theTab, theName, theX, theY, theW, 9);
        this.hideBar();
    }

    public Accordion addItem(ControlGroup<?> theGroup) {
        theGroup.close();
        theGroup.moveTo(this);
        theGroup.activateEvent(true);
        theGroup.addListener(this);
        theGroup.setMoveable(false);
        if (theGroup.getBackgroundHeight() < this.minHeight) {
            theGroup.setBackgroundHeight(this.minHeight);
        }
        this.controllers.add(theGroup);
        this.updateItems();
        return this;
    }

    @Override
    public Accordion remove(ControllerInterface<?> theGroup) {
        if (theGroup instanceof ControlGroup) {
            this.controllers.remove(theGroup);
            ((ControlGroup)theGroup).removeListener(this);
            this.updateItems();
        }
        super.remove(theGroup);
        return this;
    }

    public Accordion removeItem(ControlGroup<?> theGroup) {
        if (theGroup == null) {
            return this;
        }
        this.controllers.remove(theGroup);
        theGroup.removeListener(this);
        theGroup.moveTo(this.skatolo.controlWindow);
        this.updateItems();
        return this;
    }

    public Accordion updateItems() {
        int n = 0;
        this.setWidth(this._myWidth);
        for (ControllerInterface<?> cg : this.controllers.get()) {
            if (!(cg instanceof ControlGroup)) continue;
            cg.setPosition(0.0f, n += ((ControlGroup)cg).getBarHeight() + this.spacing);
            if (!((ControlGroup)cg).isOpen()) continue;
            n += ((ControlGroup)cg).getBackgroundHeight();
        }
        return this;
    }

    public Accordion setMinItemHeight(int theHeight) {
        this.minHeight = theHeight;
        for (ControllerInterface<?> cg : this.controllers.get()) {
            if (!(cg instanceof ControlGroup) || ((ControlGroup)cg).getBackgroundHeight() >= this.minHeight) continue;
            ((ControlGroup)cg).setBackgroundHeight(this.minHeight);
        }
        this.updateItems();
        return this;
    }

    public int getMinItemHeight() {
        return this.minHeight;
    }

    public Accordion setItemHeight(int theHeight) {
        this.itemheight = theHeight;
        for (ControllerInterface<?> cg : this.controllers.get()) {
            if (!(cg instanceof ControlGroup)) continue;
            ((ControlGroup)cg).setBackgroundHeight(this.itemheight);
        }
        this.updateItems();
        return this;
    }

    public int getItemHeight() {
        return this.itemheight;
    }

    @Override
    public Accordion setWidth(int theWidth) {
        super.setWidth(theWidth);
        for (ControllerInterface<?> cg : this.controllers.get()) {
            if (!(cg instanceof ControlGroup)) continue;
            ((ControlGroup)cg).setWidth(theWidth);
        }
        return this;
    }

    @Override
    public void controlEvent(ControlEvent theEvent) {
        if (theEvent.isGroup()) {
            int n = 0;
            for (ControllerInterface<?> cg : this.controllers.get()) {
                if (!(cg instanceof ControlGroup)) continue;
                cg.setPosition(0.0f, n += ((ControlGroup)cg).getBarHeight() + this.spacing);
                if (this._myMode == 0) {
                    if (cg == theEvent.getGroup() && ((ControlGroup)cg).isOpen()) {
                        n += ((ControlGroup)cg).getBackgroundHeight();
                        continue;
                    }
                    ((ControlGroup)cg).close();
                    continue;
                }
                if (!((ControlGroup)cg).isOpen()) continue;
                n += ((ControlGroup)cg).getBackgroundHeight();
            }
        }
    }

    @Override
    public Accordion open() {
        int[] n = new int[this.controllers.size()];
        for (int i = 0; i < this.controllers.size(); ++i) {
            n[i] = i;
        }
        return this.open(n);
    }

    @Override
    public Accordion close() {
        int[] n = new int[this.controllers.size()];
        for (int i = 0; i < this.controllers.size(); ++i) {
            n[i] = i;
        }
        return this.close(n);
    }

    public Accordion open(int ... theId) {
        if (theId[0] == -1) {
            return this.open();
        }
        int n = 0;
        int i = 0;
        for (ControllerInterface<?> cg : this.controllers.get()) {
            if (!(cg instanceof ControlGroup)) continue;
            boolean a = false;
            for (int j = 0; j < theId.length; ++j) {
                if (theId[j] != i) continue;
                a = true;
            }
            boolean b = ((ControlGroup)cg).isOpen() || a;
            ++i;
            cg.setPosition(0.0f, n += ((ControlGroup)cg).getBarHeight() + this.spacing);
            if (!b) continue;
            n += ((ControlGroup)cg).getBackgroundHeight();
            ((ControlGroup)cg).open();
        }
        return this;
    }

    public Accordion close(int ... theId) {
        if (theId[0] == -1) {
            return this.close();
        }
        int n = 0;
        int i = 0;
        for (ControllerInterface<?> cg : this.controllers.get()) {
            if (!(cg instanceof ControlGroup)) continue;
            boolean a = false;
            for (int j = 0; j < theId.length; ++j) {
                if (theId[j] != i) continue;
                a = true;
            }
            boolean b = !((ControlGroup)cg).isOpen() || a;
            ++i;
            ((ControlGroup)cg).setPosition(0.0f, n += ((ControlGroup)cg).getBarHeight() + this.spacing);
            if (b) {
                ((ControlGroup)cg).close();
                continue;
            }
            n += ((ControlGroup)cg).getBackgroundHeight();
        }
        return this;
    }

    public Accordion setCollapseMode(int theMode) {
        this._myMode = theMode == 0 ? 0 : 1;
        return this;
    }
}

