/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.controllers;

import processing.core.PGraphics;
import processing.core.PVector;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.Label;
import tech.lity.rea.skatolo.gui.controllers.ControllerView;
import tech.lity.rea.skatolo.gui.group.Tab;

public class Toggle
extends Controller<Toggle> {
    protected int cnt;
    public boolean isOn = false;
    protected float internalValue = -1.0f;
    public static int autoWidth = 39;
    public static int autoHeight = 19;
    public PVector autoSpacing = new PVector(10.0f, 20.0f, 0.0f);

    public Toggle(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0.0f, 0.0f, 0.0f, autoWidth, autoHeight);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public Toggle(Skatolo theskatolo, Tab theParent, String theName, float theValue, float theX, float theY, int theWidth, int theHeight) {
        super(theskatolo, theParent, theName, theX, theY, theWidth, theHeight);
        this._myValue = theValue;
        this._myCaptionLabel.align(37, 13).setPadding(0, Label.defaultPaddingY);
    }

    @Override
    public void draw(PGraphics graphics) {
        graphics.pushMatrix();
        graphics.translate(this.position.x, this.position.y);
        this._myControllerView.display(graphics, this);
        graphics.popMatrix();
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    public void onLeave() {
        this.isActive = false;
    }

    @Override
    public void mousePressed() {
        this.setState(!this.isOn);
        this.isActive = false;
    }

    @Override
    public Toggle setValue(float theValue) {
        if (theValue == 0.0f) {
            this.setState(false);
        } else {
            this.setState(true);
        }
        return this;
    }

    public Toggle setValue(boolean theValue) {
        this.setValue(theValue ? 1.0f : 0.0f);
        return this;
    }

    @Override
    public Toggle update() {
        return this.setValue(this._myValue);
    }

    public Toggle setState(boolean theFlag) {
        this.isOn = theFlag;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
        this.broadcast(2);
        return this;
    }

    public boolean getState() {
        return this.isOn;
    }

    public void deactivate() {
        this.isOn = false;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
    }

    public void activate() {
        this.isOn = true;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
    }

    public Toggle toggle() {
        if (this.isOn) {
            this.setState(false);
        } else {
            this.setState(true);
        }
        return this;
    }

    public Toggle setMode(int theMode) {
        this.updateDisplayMode(theMode);
        return this;
    }

    public void setInternalValue(float theInternalValue) {
        this.internalValue = theInternalValue;
    }

    public float internalValue() {
        return this.internalValue;
    }

    @Override
    public Toggle linebreak() {
        this.skatolo.linebreak(this, true, autoWidth, autoHeight, this.autoSpacing);
        return this;
    }

    @Override
    public Toggle updateDisplayMode(int theState) {
        this._myDisplayMode = theState;
        switch (theState) {
            case 0: {
                this._myControllerView = new ToggleView();
                break;
            }
            case 1: {
                this._myControllerView = new ToggleImageView();
                break;
            }
            case 100: {
                this._myControllerView = new ToggleSwitchView();
                break;
            }
        }
        return this;
    }

    class ToggleSwitchView
    implements ControllerView<Toggle> {
        ToggleSwitchView() {
        }

        @Override
        public void display(PGraphics graphics, Toggle theController) {
            graphics.fill(Toggle.this.color.getBackground());
            graphics.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
            graphics.fill(Toggle.this.color.getActive());
            if (Toggle.this.isOn) {
                graphics.rect(0.0f, 0.0f, (float)(Toggle.this.width / 2), (float)Toggle.this.height);
            } else {
                graphics.rect((float)((Toggle.this.width % 2 == 0 ? 0 : 1) + Toggle.this.width / 2), 0.0f, (float)(Toggle.this.width / 2), (float)Toggle.this.height);
            }
            if (Toggle.this.isLabelVisible) {
                Toggle.this._myCaptionLabel.draw(graphics, 0, 0, theController);
            }
        }
    }

    class ToggleImageView
    implements ControllerView<Toggle> {
        ToggleImageView() {
        }

        @Override
        public void display(PGraphics graphics, Toggle theController) {
            if (Toggle.this.isActive) {
                graphics.image(Toggle.this.availableImages[2] ? Toggle.this.images[2] : Toggle.this.images[0], 0.0f, 0.0f);
            } else if (Toggle.this.isOn) {
                graphics.image(Toggle.this.availableImages[2] ? Toggle.this.images[2] : Toggle.this.images[0], 0.0f, 0.0f);
            } else {
                graphics.image(Toggle.this.images[0], 0.0f, 0.0f);
            }
            graphics.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
        }
    }

    class ToggleView
    implements ControllerView<Toggle> {
        ToggleView() {
        }

        @Override
        public void display(PGraphics graphics, Toggle theController) {
            if (Toggle.this.isActive) {
                graphics.fill(Toggle.this.isOn ? Toggle.this.color.getActive() : Toggle.this.color.getForeground());
            } else {
                graphics.fill(Toggle.this.isOn ? Toggle.this.color.getActive() : Toggle.this.color.getBackground());
            }
            graphics.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
            if (Toggle.this.isLabelVisible) {
                Toggle.this._myCaptionLabel.draw(graphics, 0, 0, theController);
            }
        }
    }
}

