/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.controllers;

import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.Label;
import tech.lity.rea.skatolo.gui.controllers.ControllerView;
import tech.lity.rea.skatolo.gui.group.Tab;

public class Numberbox
extends Controller<Numberbox> {
    protected int cnt;
    public static int LEFT = 0;
    public static int UP = 1;
    public static int RIGHT = 2;
    public static int DOWN = 3;
    protected int _myNumberCount = 1;
    protected float _myMultiplier = 1.0f;
    public static int autoWidth = 69;
    public static int autoHeight = 19;
    public PVector autoSpacing = new PVector(10.0f, 20.0f, 0.0f);
    protected float scrollSensitivity = 0.1f;

    public Numberbox(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0.0f, 0, 0, autoWidth, autoHeight);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public Numberbox(Skatolo theskatolo, Tab theParent, String theName, float theDefaultValue, int theX, int theY, int theWidth, int theHeight) {
        super(theskatolo, theParent, theName, theX, theY, theWidth, theHeight);
        this._myMin = -3.4028235E38f;
        this._myMax = Float.MAX_VALUE;
        this._myValue = theDefaultValue;
        this._myValueLabel = new Label(this.skatolo, "" + this._myValue, theWidth, 12, this.color.getValueLabel());
        if (Float.isNaN(this._myValue)) {
            this._myValue = 0.0f;
        }
    }

    @Override
    public Numberbox updateInternalEvents(PApplet theApplet) {
        if (this.isActive && !this.skatolo.isAltDown()) {
            if (this._myNumberCount == 1) {
                this.setValue(this._myValue + (float)(this.controlWindow.getPointerY() - this.controlWindow.getPointerPrevY()) * this._myMultiplier);
            } else {
                this.setValue(this._myValue + (float)(this.controlWindow.getPointerX() - this.controlWindow.getPointerPrevX()) * this._myMultiplier);
            }
        }
        return this;
    }

    @Override
    public void mousePressed() {
        this.isActive = true;
    }

    @Override
    public void mouseReleased() {
        this.isActive = false;
    }

    @Override
    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    public Numberbox setMultiplier(float theMultiplier) {
        this._myMultiplier = theMultiplier;
        return this;
    }

    public float getMultiplier() {
        return this._myMultiplier;
    }

    @Override
    public Numberbox setValue(float theValue) {
        this._myValue = theValue;
        this._myValue = Math.max(this._myMin, Math.min(this._myMax, this._myValue));
        this.broadcast(2);
        this._myValueLabel.set(this.adjustValue(this._myValue));
        return this;
    }

    public Numberbox shuffle() {
        float r = (float)Math.random();
        if (this.getMax() != Float.MAX_VALUE && this.getMin() != -3.4028235E38f) {
            this.setValue(PApplet.map((float)r, (float)0.0f, (float)1.0f, (float)this.getMin(), (float)this.getMax()));
        }
        return this;
    }

    public Numberbox setRange(float theMin, float theMax) {
        this.setMin(theMin);
        this.setMax(theMax);
        this.setValue(this.getValue());
        return this;
    }

    public Numberbox setScrollSensitivity(float theValue) {
        this.scrollSensitivity = theValue;
        return this;
    }

    public Numberbox scrolled(int theRotationValue) {
        float f = this.getValue();
        this.setValue(f += this._myMultiplier == 1.0f ? (float)theRotationValue * this.scrollSensitivity : (float)theRotationValue * this._myMultiplier);
        return this;
    }

    public Numberbox setDirection(int theValue) {
        this._myNumberCount = theValue == 0 || theValue == 1 ? theValue : 1;
        return this;
    }

    @Override
    public Numberbox update() {
        return this.setValue(this._myValue);
    }

    @Override
    public Numberbox linebreak() {
        this.skatolo.linebreak(this, true, autoWidth, autoHeight, this.autoSpacing);
        return this;
    }

    @Override
    public Numberbox updateDisplayMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new NumberboxView();
            }
        }
        return this;
    }

    @Deprecated
    public Numberbox setSensitivity(float theValue) {
        return this.setScrollSensitivity(theValue);
    }

    class NumberboxView
    implements ControllerView<Numberbox> {
        NumberboxView() {
            Numberbox.this._myValueLabel.align(LEFT, 3).setPadding(0, Label.defaultPaddingY);
            Numberbox.this._myCaptionLabel.align(LEFT, 13).setPadding(0, Label.defaultPaddingY);
        }

        @Override
        public void display(PGraphics graphics, Numberbox theController) {
            graphics.fill(Numberbox.this.color.getBackground());
            graphics.rect(0.0f, 0.0f, (float)Numberbox.this.width, (float)Numberbox.this.height);
            graphics.fill(Numberbox.this.isActive ? Numberbox.this.color.getActive() : Numberbox.this.color.getForeground());
            int h = Numberbox.this.height / 2;
            graphics.triangle(0.0f, (float)(h - 6), 6.0f, (float)h, 0.0f, (float)(h + 6));
            Numberbox.this._myValueLabel.draw(graphics, 10, 0, theController);
            Numberbox.this._myCaptionLabel.draw(graphics, 0, 0, theController);
        }
    }
}

