/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.controllers;

import java.util.ArrayList;
import java.util.List;
import tech.lity.rea.skatolo.Hacks;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.controllers.Button;
import tech.lity.rea.skatolo.gui.controllers.MultiList;
import tech.lity.rea.skatolo.gui.controllers.MultiListInterface;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;

public class MultiListButton
extends Button
implements MultiListInterface {
    private Controller parent;
    private MultiList root;
    private int[] _myRect = new int[4];
    protected int _myDirection = 39;
    private boolean isUpperCase = true;

    protected MultiListButton(Skatolo theskatolo, String theName, float theValue, int theX, int theY, int theWidth, int theHeight, Controller theParent, MultiList theRoot) {
        super(theskatolo, (ControllerGroup)theRoot.getParent(), theName, theValue, theX, theY, theWidth, theHeight);
        this.parent = theParent;
        this.root = theRoot;
        this.updateRect(this.position.x, this.position.y, this.width, this.height);
        this._myCaptionLabel.align(37, 3);
    }

    @Override
    public MultiListButton toUpperCase(boolean theValue) {
        this.isUpperCase = theValue;
        for (Controller<?> c : this.getSubelements()) {
            c.getCaptionLabel().toUpperCase(this.isUpperCase);
        }
        this._myCaptionLabel.toUpperCase(this.isUpperCase);
        return this;
    }

    @Override
    public void remove() {
        int i;
        int myYoffset = 0;
        for (i = 0; i < this.parent.getSubelements().size(); ++i) {
            if (this.parent.getSubelements().get(i) == this) {
                myYoffset = this.height + 1;
            }
            ((MultiListButton)this.parent.getSubelements().get(i)).updateLocation(0.0f, -myYoffset);
        }
        if (this._myParent != null) {
            this.removeListener(this.root);
            this._myParent.remove(this);
        }
        if (this.skatolo != null) {
            this.removeListener(this.root);
            this.skatolo.remove((Object)this);
        }
        for (i = 0; i < this.getSubelements().size(); ++i) {
            ((MultiListButton)this.getSubelements().get(i)).remove();
        }
    }

    @Override
    public int getDirection() {
        return this._myDirection;
    }

    protected void setDirection(int theDirection) {
        this._myDirection = theDirection;
    }

    public void updateRect(float theX, float theY, float theW, float theH) {
        this._myRect = new int[]{(int)theX, (int)theY, (int)theW, (int)theH};
    }

    @Override
    public void updateLocation(float theX, float theY) {
        this.position.x += theX;
        this.position.y += theY;
        this.updateRect(this.position.x, this.position.y, this.width, this.height);
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            ((MultiListInterface)((Object)this.getSubelements().get(i))).updateLocation(theX, theY);
        }
    }

    @Override
    public MultiListButton setWidth(int theWidth) {
        int dif = this._myDirection == 37 ? theWidth - this.width : 0;
        this.width = theWidth;
        this.updateLocation(-dif, 0.0f);
        return this;
    }

    @Override
    public MultiListButton setHeight(int theHeight) {
        int difHeight = this.height;
        this.height = theHeight;
        difHeight = this.height - difHeight;
        int myYoffset = 0;
        for (int i = 0; i < this.parent.getSubelements().size(); ++i) {
            if (!(this.parent.getSubelements().get(i) instanceof MultiListInterface)) continue;
            ((MultiListInterface)((Object)this.parent.getSubelements().get(i))).updateLocation(0.0f, myYoffset);
            if (this.parent.getSubelements().get(i) != this) continue;
            myYoffset = difHeight;
        }
        this.updateLocation(0.0f, 0.0f);
        return this;
    }

    public MultiListButton add(String theName, float theValue) {
        int myHeight = -(this.height + 1);
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            myHeight += this.getSubelements().get((int)i).height + 1;
        }
        int xx = (int)this.position.x + (this.width + 1);
        MultiListButton b = new MultiListButton(this.skatolo, theName, theValue, xx, (int)this.position.y + (this.height + 1) + myHeight, this.width, this.height, this, this.root);
        b.isMoveable = false;
        b.toUpperCase(this.isUpperCase);
        b.hide();
        this.skatolo.register(null, "", b);
        b.addListener(this.root);
        this.getSubelements().add(b);
        this.updateRect(xx, this.position.y, this.width, this.height + 1 + myHeight);
        return b;
    }

    @Override
    protected void onEnter() {
        if (!this.root.isUpdateLocation) {
            this.isActive = true;
            this.root.occupied(true);
            this.root.mostRecent = this;
            if (this.parent instanceof MultiListInterface) {
                ((MultiListInterface)((Object)this.parent)).close(this);
            }
            this.open();
        }
    }

    @Override
    public void onLeave() {
        if (this.parent instanceof MultiListInterface && !((MultiListInterface)((Object)this.parent)).observe() && !this.root.isUpdateLocation && this.root.mostRecent == this) {
            this.isActive = false;
            this.root.occupied(false);
        }
    }

    @Override
    public void mouseReleasedOutside() {
    }

    @Override
    public boolean observe() {
        return Hacks.inside(this._myRect, this.controlWindow.getPointerX(), this.controlWindow.getPointerY());
    }

    @Override
    public void close(MultiListInterface theInterface) {
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            if (theInterface == (MultiListInterface)((Object)this.getSubelements().get(i))) continue;
            ((MultiListInterface)((Object)this.getSubelements().get(i))).close();
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            ((MultiListButton)this.getSubelements().get(i)).close();
            ((MultiListButton)this.getSubelements().get(i)).hide();
        }
    }

    @Override
    public void open() {
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            ((MultiListButton)this.getSubelements().get(i)).show();
        }
    }

    @Deprecated
    public List<MultiListButton> getChildren() {
        System.out.println("skatolo.MultiListButton.getChildren() is deprecated since 0.7.6, use getSubelement().\nFor convenience an empty List is returned here.");
        return new ArrayList<MultiListButton>();
    }
}

