/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.controllers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PGraphics;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.controllers.ControllerView;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;

public class Matrix
extends Controller<Matrix> {
    protected int cnt;
    protected int[][] _myCells;
    protected int stepX;
    protected int stepY;
    protected int cellX;
    protected int cellY;
    protected boolean isPressed;
    protected int _myCellX;
    protected int _myCellY;
    protected int sum;
    protected int _myInterval = 100;
    protected int currentX = -1;
    protected int currentY = -1;
    protected int _myMode = 1;
    private Thread t;
    protected int gapX = 1;
    protected int gapY = 1;
    private Object _myPlug;
    private String _myPlugName;
    private boolean playing = true;
    private int bg = 0;

    public Matrix(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 10, 10, 0, 0, 100, 100);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public Matrix(Skatolo theskatolo, ControllerGroup<?> theParent, String theName, int theCellX, int theCellY, int theX, int theY, int theWidth, int theHeight) {
        super(theskatolo, theParent, theName, theX, theY, theWidth, theHeight);
        this.setGrid(theCellX, theCellY);
        this._myPlug = theskatolo.getObjectForIntrospection();
        this._myPlugName = this.getName();
        this._myCaptionLabel.align(37, 13);
        this._myCaptionLabel.setPadding(0, 4);
        this.runThread();
    }

    public Matrix setGrid(int theCellX, int theCellY) {
        this._myCellX = theCellX;
        this._myCellY = theCellY;
        this.sum = this._myCellX * this._myCellY;
        this.stepX = this.width / this._myCellX;
        this.stepY = this.height / this._myCellY;
        this._myCells = new int[this._myCellX][this._myCellY];
        for (int x = 0; x < this._myCellX; ++x) {
            for (int y = 0; y < this._myCellY; ++y) {
                this._myCells[x][y] = 0;
            }
        }
        return this;
    }

    public Matrix setInterval(int theInterval) {
        this._myInterval = theInterval;
        return this;
    }

    public int getInterval() {
        return this._myInterval;
    }

    @Override
    public Matrix updateInternalEvents(PApplet theApplet) {
        this.setPointerOver(this.computeIsInside());
        if (this.getMouseOver() && this.isPressed) {
            int tX = (int)(((float)this.getWindow().getPointerX() - this.position.x) / (float)this.stepX);
            int tY = (int)(((float)this.getWindow().getPointerY() - this.position.y) / (float)this.stepY);
            if (tX != this.currentX || tY != this.currentY) {
                boolean isMarkerActive = this._myCells[tX = PApplet.min((int)PApplet.max((int)0, (int)tX), (int)this._myCellX)][tY = PApplet.min((int)PApplet.max((int)0, (int)tY), (int)this._myCellY)] == 1;
                switch (this._myMode) {
                    default: {
                        for (int i = 0; i < this._myCellY; ++i) {
                            this._myCells[tX][i] = 0;
                        }
                        this._myCells[tX][tY] = !isMarkerActive ? 1 : this._myCells[tX][tY];
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < this._myCellY; ++i) {
                            this._myCells[tX][i] = 0;
                        }
                        this._myCells[tX][tY] = !isMarkerActive ? 1 : this._myCells[tX][tY];
                        break;
                    }
                    case 2: {
                        this._myCells[tX][tY] = this._myCells[tX][tY] == 1 ? 0 : 1;
                    }
                }
                this.currentX = tX;
                this.currentY = tY;
            }
        }
        return this;
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    public void onLeave() {
        this.isActive = false;
    }

    @Override
    public void mousePressed() {
        this.isActive = this.getMouseOver();
        if (this.getMouseOver()) {
            this.isPressed = true;
        }
    }

    @Override
    protected void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    public void mouseReleased() {
        if (this.isActive) {
            this.isActive = false;
        }
        this.isPressed = false;
        this.currentX = -1;
        this.currentY = -1;
    }

    @Override
    public Matrix setValue(float theValue) {
        this._myValue = theValue;
        this.broadcast(2);
        return this;
    }

    public Matrix play() {
        this.playing = true;
        return this;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public Matrix pause() {
        this.playing = false;
        return this;
    }

    public Matrix stop() {
        this.playing = false;
        this.cnt = 0;
        return this;
    }

    public Matrix trigger(int theColumn) {
        if (theColumn < 0 || theColumn >= this._myCells.length) {
            return this;
        }
        for (int i = 0; i < this._myCellY; ++i) {
            if (this._myCells[theColumn][i] != 1) continue;
            this._myValue = 0.0f;
            this._myValue = (theColumn << 0) + (i << 8);
            this.setValue(this._myValue);
            try {
                Method method = this._myPlug.getClass().getMethod(this._myPlugName, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                method.invoke(this._myPlug, theColumn, i);
                continue;
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        return this;
    }

    @Override
    public Matrix update() {
        return this.setValue(this._myValue);
    }

    public Matrix setGap(int theX, int theY) {
        this.gapX = theX;
        this.gapY = theY;
        return this;
    }

    @Override
    public Matrix plugTo(Object theObject) {
        this._myPlug = theObject;
        return this;
    }

    @Override
    public Matrix plugTo(Object theObject, String thePlugName) {
        this._myPlug = theObject;
        this._myPlugName = thePlugName;
        return this;
    }

    public Matrix set(int theX, int theY, boolean theValue) {
        this._myCells[theX][theY] = theValue ? 1 : 0;
        return this;
    }

    public boolean get(int theX, int theY) {
        return this._myCells[theX][theY] == 1;
    }

    public Matrix clear() {
        for (int x = 0; x < this._myCells.length; ++x) {
            for (int y = 0; y < this._myCells[x].length; ++y) {
                this._myCells[x][y] = 0;
            }
        }
        return this;
    }

    public static int getX(int thePosition) {
        return thePosition >> 0 & 0xFF;
    }

    public static int getY(int thePosition) {
        return thePosition >> 8 & 0xFF;
    }

    public static int getX(float thePosition) {
        return (int)thePosition >> 0 & 0xFF;
    }

    public static int getY(float thePosition) {
        return (int)thePosition >> 8 & 0xFF;
    }

    public Matrix setCells(int[][] theCells) {
        this.setGrid(theCells.length, theCells[0].length);
        this._myCells = theCells;
        return this;
    }

    public int[][] getCells() {
        return this._myCells;
    }

    private void triggerEventFromThread() {
        if (this.playing) {
            ++this.cnt;
            this.cnt %= this._myCellX;
            this.trigger(this.cnt);
        }
    }

    private void runThread() {
        if (this.t == null) {
            this.t = new Thread(this.getName()){

                @Override
                public void run() {
                    while (true) {
                        Matrix.this.triggerEventFromThread();
                        try {
                            1.sleep(Matrix.this._myInterval);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            this.t.start();
        }
    }

    @Override
    public void remove() {
        if (this.t != null) {
            this.t.interrupt();
        }
        super.remove();
    }

    public Matrix setMode(int theMode) {
        this._myMode = theMode;
        return this;
    }

    public int getMode() {
        return this._myMode;
    }

    public Matrix setBackground(int c) {
        this.bg = 0;
        if ((c >> 24 & 0xFF) > 0) {
            this.bg = c >> 24 << 24 | c >> 16 << 16 | c >> 8 << 8 | c >> 0 << 0;
        }
        return this;
    }

    @Override
    public Matrix updateDisplayMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new MatrixView();
                break;
            }
        }
        return this;
    }

    class MatrixView
    implements ControllerView<Matrix> {
        MatrixView() {
        }

        @Override
        public void display(PGraphics graphics, Matrix theController) {
            int y;
            int x;
            graphics.noStroke();
            graphics.fill(Matrix.this.bg);
            graphics.rect(0.0f, 0.0f, (float)Matrix.this.width, (float)Matrix.this.height);
            for (x = 0; x < Matrix.this._myCellX; ++x) {
                for (y = 0; y < Matrix.this._myCellY; ++y) {
                    if (Matrix.this._myCells[x][y] == 1) {
                        graphics.fill(Matrix.this.color.getActive());
                        graphics.rect((float)(x * Matrix.this.stepX), (float)(y * Matrix.this.stepY), (float)(Matrix.this.stepX - Matrix.this.gapX), (float)(Matrix.this.stepY - Matrix.this.gapY));
                        continue;
                    }
                    graphics.fill(Matrix.this.color.getBackground());
                    graphics.rect((float)(x * Matrix.this.stepX), (float)(y * Matrix.this.stepY), (float)(Matrix.this.stepX - Matrix.this.gapX), (float)(Matrix.this.stepY - Matrix.this.gapY));
                }
            }
            if (Matrix.this.isPointerOver()) {
                x = (int)(((float)Matrix.this.getWindow().getPointerX() - Matrix.this.position.x) / (float)Matrix.this.stepX);
                y = (int)(((float)Matrix.this.getWindow().getPointerY() - Matrix.this.position.y) / (float)Matrix.this.stepY);
                if (x >= 0 && x < Matrix.this._myCellX && y >= 0 && y < Matrix.this._myCellY) {
                    graphics.fill(Matrix.this._myCells[x][y] == 1 ? Matrix.this.color.getActive() : Matrix.this.color.getForeground());
                    graphics.rect((float)(x * Matrix.this.stepX), (float)(y * Matrix.this.stepY), (float)(Matrix.this.stepX - Matrix.this.gapX), (float)(Matrix.this.stepY - Matrix.this.gapY));
                }
            }
            graphics.fill(Matrix.this.color.getActive());
            graphics.rect((float)(Matrix.this.cnt * Matrix.this.stepX), 0.0f, 1.0f, (float)(Matrix.this.height - Matrix.this.gapY));
            if (Matrix.this.isLabelVisible) {
                Matrix.this._myCaptionLabel.draw(graphics, 0, 0, theController);
            }
        }
    }
}

