/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.controllers;

import processing.core.PGraphics;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.controllers.ControllerView;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;
import tech.lity.rea.skatolo.gui.group.Tab;

public class HoverButton
extends Controller<HoverButton> {
    public static int autoWidth = 69;
    public static int autoHeight = 19;
    protected int activateBy = 2;
    protected boolean isOn = false;
    protected boolean isSwitch = false;

    public HoverButton(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0.0f, 0, 0, autoWidth, autoHeight);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public HoverButton(Skatolo theskatolo, ControllerGroup<?> theParent, String theName, float theDefaultValue, int theX, int theY, int theWidth, int theHeight) {
        super(theskatolo, theParent, theName, theX, theY, theWidth, theHeight);
        this._myValue = theDefaultValue;
        this._myCaptionLabel.align(37, 3);
    }

    public HoverButton() {
        super(null, null, null, 0.0f, 0.0f, 1, 1);
    }

    public HoverButton activateBy(int theValue) {
        this.activateBy = theValue == 2 ? 2 : 4;
        return this;
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
        if (this.activateBy == 2) {
            this.activate();
        }
    }

    @Override
    public void onLeave() {
        this.isActive = false;
        if (this.activateBy == 4) {
            this.activate();
        }
    }

    @Override
    public void mousePressed() {
        System.out.println("MousePressed/Released is not working with Hover Button.");
    }

    @Override
    public void mouseReleased() {
    }

    protected void activate() {
        if (this.getParent() instanceof Tab) {
            this.setPointerOver(false);
        }
        this.isOn = !this.isOn;
        this.setValue(this._myValue);
    }

    @Override
    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    public HoverButton setValue(float theValue) {
        this._myValue = theValue;
        this.broadcast(2);
        return this;
    }

    @Override
    public HoverButton update() {
        return this.setValue(this._myValue);
    }

    public HoverButton setSwitch(boolean theFlag) {
        this.isSwitch = theFlag;
        return this;
    }

    public HoverButton setOn() {
        if (this.isSwitch) {
            this.isOn = false;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public HoverButton setOff() {
        if (this.isSwitch) {
            this.isOn = true;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public boolean isOn() {
        return this.isOn;
    }

    public boolean getBooleanValue() {
        return this.isOn;
    }

    @Override
    public HoverButton updateDisplayMode(int theMode) {
        return this.updateViewMode(theMode);
    }

    public HoverButton updateViewMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new ButtonView();
                break;
            }
            case 1: {
                this._myControllerView = new ButtonImageView();
                break;
            }
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tButton\n" + super.getInfo();
    }

    @Override
    public String toString() {
        return super.toString() + " [ " + this.getValue() + " ] Button (" + this.getClass().getSuperclass() + ")";
    }

    @Deprecated
    public boolean booleanValue() {
        return this.isOn;
    }

    private class ButtonImageView
    implements ControllerView<HoverButton> {
        private ButtonImageView() {
        }

        @Override
        public void display(PGraphics graphics, HoverButton theController) {
            if (HoverButton.this.isOn && HoverButton.this.isSwitch) {
                graphics.image(HoverButton.this.availableImages[3] ? HoverButton.this.images[3] : HoverButton.this.images[0], 0.0f, 0.0f, (float)HoverButton.this.width, (float)HoverButton.this.height);
                return;
            }
            if (HoverButton.this.getMouseOver()) {
                graphics.image(HoverButton.this.availableImages[2] ? HoverButton.this.images[2] : HoverButton.this.images[0], 0.0f, 0.0f, (float)HoverButton.this.width, (float)HoverButton.this.height);
            } else {
                graphics.image(HoverButton.this.images[0], 0.0f, 0.0f, (float)HoverButton.this.width, (float)HoverButton.this.height);
            }
        }
    }

    private class ButtonView
    implements ControllerView<HoverButton> {
        private ButtonView() {
        }

        @Override
        public void display(PGraphics graphics, HoverButton theController) {
            graphics.noStroke();
            if (HoverButton.this.isOn && HoverButton.this.isSwitch) {
                graphics.fill(HoverButton.this.color.getActive());
            } else if (HoverButton.this.getMouseOver()) {
                graphics.fill(HoverButton.this.color.getActive());
            } else {
                graphics.fill(HoverButton.this.color.getBackground());
            }
            graphics.rect(0.0f, 0.0f, (float)HoverButton.this.width, (float)HoverButton.this.height);
            if (HoverButton.this.isLabelVisible) {
                HoverButton.this._myCaptionLabel.draw(graphics, 0, 0, theController);
            }
        }
    }
}

