/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.controllers;

import java.util.Iterator;
import java.util.LinkedHashMap;
import processing.core.PApplet;
import processing.core.PGraphics;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.controllers.ChartData;
import tech.lity.rea.skatolo.gui.controllers.ChartDataSet;
import tech.lity.rea.skatolo.gui.controllers.ControllerView;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;

public class Chart
extends Controller<Chart> {
    public static final int LINE = 0;
    public static final int BAR = 1;
    public static final int BAR_CENTERED = 2;
    public static final int HISTOGRAM = 3;
    public static final int PIE = 4;
    public static final int AREA = 5;
    protected final LinkedHashMap<String, ChartDataSet> _myDataSet;
    protected float resolution = 1.0f;
    protected float strokeWeight = 1.0f;
    protected float _myMin = 0.0f;
    protected float _myMax = 1.0f;

    public Chart(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0.0f, 0.0f, 200, 100);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public Chart(Skatolo theskatolo, ControllerGroup<?> theParent, String theName, float theX, float theY, int theWidth, int theHeight) {
        super(theskatolo, theParent, theName, theX, theY, theWidth, theHeight);
        this.setRange(0.0f, theHeight);
        this._myDataSet = new LinkedHashMap();
    }

    public Chart setRange(float theMin, float theMax) {
        this._myMin = theMin;
        this._myMax = theMax;
        return this;
    }

    public Chart setColors(String theSetIndex, int ... theColors) {
        this.getDataSet().get(theSetIndex).setColors(theColors);
        return this;
    }

    public Chart addData(ChartData theItem) {
        return this.addData(this.getFirstDataSetIndex(), theItem);
    }

    private String getFirstDataSetIndex() {
        return this.getDataSet().keySet().iterator().next();
    }

    private String getLastDataSetIndex() {
        Iterator<String> it = this.getDataSet().keySet().iterator();
        String last = null;
        while (it.hasNext()) {
            last = it.next();
        }
        return last;
    }

    public Chart addData(String theSetIndex, ChartData theItem) {
        this.getDataSet(theSetIndex).add(theItem);
        return this;
    }

    public Chart addData(float theValue) {
        ChartData cdi = new ChartData(theValue);
        this.getDataSet(this.getFirstDataSetIndex()).add(cdi);
        return this;
    }

    public Chart addData(String theSetIndex, float theValue) {
        ChartData cdi = new ChartData(theValue);
        this.getDataSet(theSetIndex).add(cdi);
        return this;
    }

    public Chart addData(ChartDataSet theChartData, float theValue) {
        ChartData cdi = new ChartData(theValue);
        theChartData.add(cdi);
        return this;
    }

    public Chart unshift(float theValue) {
        return this.unshift(this.getFirstDataSetIndex(), theValue);
    }

    public Chart unshift(String theSetIndex, float theValue) {
        if ((float)this.getDataSet(theSetIndex).size() > (float)this.width / this.resolution) {
            this.removeLast(theSetIndex);
        }
        return this.addFirst(theSetIndex, theValue);
    }

    public Chart push(float theValue) {
        return this.push(this.getFirstDataSetIndex(), theValue);
    }

    public Chart push(String theSetIndex, float theValue) {
        if ((float)this.getDataSet(theSetIndex).size() > (float)this.width / this.resolution) {
            this.removeFirst(theSetIndex);
        }
        return this.addLast(theSetIndex, theValue);
    }

    public Chart addFirst(float theValue) {
        return this.addFirst(this.getFirstDataSetIndex(), theValue);
    }

    public Chart addFirst(String theSetIndex, float theValue) {
        ChartData cdi = new ChartData(theValue);
        this.getDataSet(theSetIndex).add(0, cdi);
        return this;
    }

    public Chart addLast(float theValue) {
        return this.addLast(this.getFirstDataSetIndex(), theValue);
    }

    public Chart addLast(String theSetIndex, float theValue) {
        ChartData cdi = new ChartData(theValue);
        this.getDataSet(theSetIndex).add(cdi);
        return this;
    }

    public Chart removeLast() {
        return this.removeLast(this.getFirstDataSetIndex());
    }

    public Chart removeLast(String theSetIndex) {
        return this.removeData(theSetIndex, this.getDataSet(theSetIndex).size() - 1);
    }

    public Chart removeFirst() {
        return this.removeFirst(this.getFirstDataSetIndex());
    }

    public Chart removeFirst(String theSetIndex) {
        return this.removeData(theSetIndex, 0);
    }

    public Chart removeData(ChartData theItem) {
        this.removeData(this.getFirstDataSetIndex(), theItem);
        return this;
    }

    public Chart removeData(String theSetIndex, ChartData theItem) {
        this.getDataSet(theSetIndex).remove(theItem);
        return this;
    }

    public Chart removeData(int theItemIndex) {
        this.removeData(this.getFirstDataSetIndex(), theItemIndex);
        return this;
    }

    public Chart removeData(String theSetIndex, int theItemIndex) {
        if (this.getDataSet(theSetIndex).size() < 1) {
            return this;
        }
        this.getDataSet(theSetIndex).remove(theItemIndex);
        return this;
    }

    public Chart setData(int theItemIndex, ChartData theItem) {
        this.getDataSet(this.getFirstDataSetIndex()).set(theItemIndex, theItem);
        return this;
    }

    public Chart setData(String theSetItem, int theItemIndex, ChartData theItem) {
        this.getDataSet(theSetItem).set(theItemIndex, theItem);
        return this;
    }

    public Chart addDataSet(String theName) {
        this.getDataSet().put(theName, new ChartDataSet(theName));
        return this;
    }

    public Chart setDataSet(ChartDataSet theItems) {
        this.setDataSet(this.getFirstDataSetIndex(), theItems);
        return this;
    }

    public Chart setDataSet(String theSetIndex, ChartDataSet theChartData) {
        this.getDataSet().put(theSetIndex, theChartData);
        return this;
    }

    public Chart removeDataSet(String theIndex) {
        this.getDataSet().remove(theIndex);
        return this;
    }

    public Chart setData(float ... theValues) {
        this.setData(this.getFirstDataSetIndex(), theValues);
        return this;
    }

    public Chart setData(String theSetIndex, float ... theValues) {
        if (this.getDataSet().get(theSetIndex).size() != theValues.length) {
            this.getDataSet().get(theSetIndex).clear();
            for (int i = 0; i < theValues.length; ++i) {
                this.getDataSet().get(theSetIndex).add(new ChartData(0.0f));
            }
        }
        int n = 0;
        this.resolution = (float)this.width / (float)(this.getDataSet().get(theSetIndex).size() - 1);
        for (float f : theValues) {
            ((ChartData)this.getDataSet().get(theSetIndex).get(n++)).setValue(f);
        }
        return this;
    }

    public Chart updateData(float ... theValues) {
        return this.setData(theValues);
    }

    public Chart updateData(String theSetIndex, float ... theValues) {
        return this.setData(theSetIndex, theValues);
    }

    public LinkedHashMap<String, ChartDataSet> getDataSet() {
        return this._myDataSet;
    }

    public ChartDataSet getDataSet(String theIndex) {
        return this.getDataSet().get(theIndex);
    }

    public float[] getValuesFrom(String theIndex) {
        return this.getDataSet(theIndex).getValues();
    }

    public ChartData getData(String theIndex, int theItemIndex) {
        return (ChartData)this.getDataSet(theIndex).get(theItemIndex);
    }

    public int size() {
        return this.getDataSet().size();
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onLeave() {
    }

    @Override
    public Chart setValue(float theValue) {
        return this;
    }

    public Chart setStrokeWeight(float theWeight) {
        this.strokeWeight = theWeight;
        for (ChartDataSet c : this.getDataSet().values()) {
            c.setStrokeWeight(theWeight);
        }
        return this;
    }

    public float getStrokeWeight() {
        return this.strokeWeight;
    }

    public Chart setResolution(int theValue) {
        this.resolution = theValue;
        return this;
    }

    public int getResolution() {
        return (int)this.resolution;
    }

    @Override
    public Chart updateDisplayMode(int theMode) {
        return this.updateViewMode(theMode);
    }

    public Chart updateViewMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new ChartViewPie();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        return this;
    }

    public Chart setView(int theType) {
        switch (theType) {
            case 4: {
                this.setView(new ChartViewPie());
                break;
            }
            case 0: {
                this.setView(new ChartViewLine());
                break;
            }
            case 1: {
                this.setView(new ChartViewBar());
                break;
            }
            case 2: {
                this.setView(new ChartViewBarCentered());
                break;
            }
            case 5: {
                this.setView(new ChartViewArea());
                break;
            }
            default: {
                System.out.println("Sorry, this ChartView does not exist");
            }
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tChart\n" + super.toString();
    }

    @Override
    public String toString() {
        return super.toString() + " [ " + this.getValue() + " ] Chart (" + this.getClass().getSuperclass() + ")";
    }

    public class ChartViewPie
    implements ControllerView<Chart> {
        @Override
        public void display(PGraphics graphics, Chart theController) {
            graphics.pushStyle();
            graphics.pushMatrix();
            Iterator<String> it = Chart.this.getDataSet().keySet().iterator();
            String index = null;
            while (it.hasNext()) {
                index = it.next();
                float total = 0.0f;
                for (int i = 0; i < Chart.this.getDataSet(index).size(); ++i) {
                    total += ((ChartData)Chart.this.getDataSet(index).get(i)).getValue();
                }
                float segment = (float)Math.PI * 2 / total;
                float angle = -1.5707964f;
                graphics.noStroke();
                for (int i = 0; i < Chart.this.getDataSet(index).size(); ++i) {
                    graphics.fill(Chart.this.getDataSet(index).getColor(i));
                    float nextAngle = angle + ((ChartData)Chart.this.getDataSet(index).get(i)).getValue() * segment;
                    float a = PApplet.max((float)0.0f, (float)PApplet.map((float)Chart.this.getWidth(), (float)0.0f, (float)200.0f, (float)0.05f, (float)0.01f));
                    graphics.arc(0.0f, 0.0f, (float)Chart.this.getWidth(), (float)Chart.this.getHeight(), angle - a, nextAngle);
                    angle = nextAngle;
                }
                graphics.translate(0.0f, (float)(Chart.this.getHeight() + 10));
            }
            graphics.popMatrix();
            graphics.popStyle();
        }
    }

    public class ChartViewArea
    implements ControllerView<Chart> {
        @Override
        public void display(PGraphics graphics, Chart theController) {
            graphics.pushStyle();
            graphics.fill(Chart.this.getColor().getBackground());
            graphics.rect(0.0f, 0.0f, (float)Chart.this.getWidth(), (float)Chart.this.getHeight());
            graphics.noStroke();
            Iterator<String> it = Chart.this.getDataSet().keySet().iterator();
            String index = null;
            while (it.hasNext()) {
                index = it.next();
                float res = (float)Chart.this.getWidth() / (float)(Chart.this.getDataSet(index).size() - 1);
                graphics.fill(Chart.this.getDataSet(index).getColor(0));
                graphics.beginShape();
                graphics.vertex(0.0f, (float)Chart.this.getHeight());
                for (int i = 0; i < Chart.this.getDataSet(index).size(); ++i) {
                    float hh = PApplet.map((float)((ChartData)Chart.this.getDataSet(index).get(i)).getValue(), (float)Chart.this._myMin, (float)Chart.this._myMax, (float)Chart.this.getHeight(), (float)0.0f);
                    graphics.vertex((float)i * res, PApplet.min((float)Chart.this.getHeight(), (float)PApplet.max((float)0.0f, (float)hh)));
                }
                graphics.vertex((float)Chart.this.getWidth(), (float)Chart.this.getHeight());
                graphics.endShape(2);
            }
            graphics.noStroke();
            graphics.popStyle();
        }
    }

    public class ChartViewLine
    implements ControllerView<Chart> {
        @Override
        public void display(PGraphics graphics, Chart theController) {
            graphics.pushStyle();
            graphics.fill(Chart.this.getColor().getBackground());
            graphics.rect(0.0f, 0.0f, (float)Chart.this.getWidth(), (float)Chart.this.getHeight());
            graphics.noFill();
            Iterator<String> it = Chart.this.getDataSet().keySet().iterator();
            String index = null;
            while (it.hasNext()) {
                index = it.next();
                graphics.stroke(Chart.this.getDataSet(index).getColor(0));
                graphics.strokeWeight(Chart.this.getDataSet(index).getStrokeWeight());
                graphics.beginShape();
                float res = (float)Chart.this.getWidth() / (float)(Chart.this.getDataSet(index).size() - 1);
                for (int i = 0; i < Chart.this.getDataSet(index).size(); ++i) {
                    float hh = PApplet.map((float)((ChartData)Chart.this.getDataSet(index).get(i)).getValue(), (float)Chart.this._myMin, (float)Chart.this._myMax, (float)Chart.this.getHeight(), (float)0.0f);
                    graphics.vertex((float)i * res, PApplet.min((float)Chart.this.getHeight(), (float)PApplet.max((float)0.0f, (float)hh)));
                }
                graphics.endShape();
            }
            graphics.noStroke();
            graphics.popStyle();
        }
    }

    public class ChartViewBarCentered
    implements ControllerView<Chart> {
        @Override
        public void display(PGraphics graphics, Chart theController) {
            graphics.pushStyle();
            graphics.fill(Chart.this.getColor().getBackground());
            graphics.rect(0.0f, 0.0f, (float)Chart.this.getWidth(), (float)Chart.this.getHeight());
            graphics.noStroke();
            Iterator<String> it = Chart.this.getDataSet().keySet().iterator();
            String index = null;
            float o = 0.0f;
            int n = 4;
            int off = (Chart.this.getDataSet().size() - 1) * n;
            while (it.hasNext()) {
                index = it.next();
                int s = Chart.this.getDataSet(index).size();
                float step = (float)Chart.this.width / (float)s;
                float ww = step - (float)Chart.this.width % step;
                ww -= 1.0f;
                ww = PApplet.max((float)1.0f, (float)ww);
                for (int i = 0; i < s; ++i) {
                    graphics.fill(Chart.this.getDataSet(index).getColor(i));
                    ww = (float)(Chart.this.width / s) * 0.5f;
                    float hh = PApplet.map((float)((ChartData)Chart.this.getDataSet(index).get(i)).getValue(), (float)Chart.this._myMin, (float)Chart.this._myMax, (float)0.0f, (float)Chart.this.getHeight());
                    graphics.rect((float)(-off / 2) + o + (float)(i * (Chart.this.width / s)) + ww / 2.0f, (float)Chart.this.getHeight(), ww, -PApplet.min((float)Chart.this.getHeight(), (float)PApplet.max((float)0.0f, (float)hh)));
                }
                o += (float)n;
            }
            graphics.popStyle();
        }
    }

    public class ChartViewBar
    implements ControllerView<Chart> {
        @Override
        public void display(PGraphics graphics, Chart theController) {
            graphics.pushStyle();
            graphics.fill(Chart.this.getColor().getBackground());
            graphics.rect(0.0f, 0.0f, (float)Chart.this.getWidth(), (float)Chart.this.getHeight());
            graphics.noStroke();
            Iterator<String> it = Chart.this.getDataSet().keySet().iterator();
            String index = null;
            float o = 0.0f;
            while (it.hasNext()) {
                index = it.next();
                float s = Chart.this.getDataSet(index).size();
                int i = 0;
                while ((float)i < s) {
                    graphics.fill(Chart.this.getDataSet(index).getColor(i));
                    float ww = (float)Chart.this.width / s;
                    float hh = PApplet.map((float)((ChartData)Chart.this.getDataSet(index).get(i)).getValue(), (float)Chart.this._myMin, (float)Chart.this._myMax, (float)0.0f, (float)Chart.this.getHeight());
                    graphics.rect(o + (float)i * ww, (float)Chart.this.getHeight(), ww / (float)Chart.this.getDataSet().size(), -PApplet.min((float)Chart.this.getHeight(), (float)PApplet.max((float)0.0f, (float)hh)));
                    ++i;
                }
                o += (float)Chart.this.width / s / (float)Chart.this.getDataSet().size();
            }
            graphics.popStyle();
        }
    }
}

