/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.controllers;

import processing.core.PGraphics;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.controllers.ControllerView;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;
import tech.lity.rea.skatolo.gui.group.Tab;

public class Button
extends Controller<Button> {
    public static int autoWidth = 69;
    public static int autoHeight = 19;
    protected int activateBy = 1;
    protected boolean isOn = false;
    protected boolean isPressed;
    protected boolean isSwitch = false;

    public Button(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0.0f, 0, 0, autoWidth, autoHeight);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public Button(Skatolo theskatolo, ControllerGroup<?> theParent, String theName, float theDefaultValue, int theX, int theY, int theWidth, int theHeight) {
        super(theskatolo, theParent, theName, theX, theY, theWidth, theHeight);
        this._myValue = theDefaultValue;
        this._myCaptionLabel.align(37, 3);
    }

    public Button() {
        super(null, null, null, 0.0f, 0.0f, 1, 1);
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    public void onLeave() {
        this.isActive = false;
    }

    @Override
    public void mousePressed() {
        this.isActive = this.getMouseOver();
        this.isPressed = true;
        if (this.activateBy == 2) {
            this.activate();
        }
    }

    @Override
    public void mouseReleased() {
        this.isPressed = false;
        if (this.activateBy == 1) {
            this.activate();
        }
        this.isActive = false;
    }

    public Button activateBy(int theValue) {
        this.activateBy = theValue == 2 ? 2 : 1;
        return this;
    }

    protected void activate() {
        if (this.isActive) {
            this.isActive = false;
            if (this.getParent() instanceof Tab) {
                this.setPointerOver(false);
            }
            this.isOn = !this.isOn;
            this.setValue(this._myValue);
        }
    }

    @Override
    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    public Button setValue(float theValue) {
        this._myValue = theValue;
        this.broadcast(2);
        return this;
    }

    @Override
    public Button update() {
        return this.setValue(this._myValue);
    }

    public Button setSwitch(boolean theFlag) {
        this.isSwitch = theFlag;
        return this;
    }

    public Button setOn() {
        if (this.isSwitch) {
            this.isOn = false;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public Button setOff() {
        if (this.isSwitch) {
            this.isOn = true;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public boolean isOn() {
        return this.isOn;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public boolean getBooleanValue() {
        return this.isOn;
    }

    @Override
    public Button updateDisplayMode(int theMode) {
        return this.updateViewMode(theMode);
    }

    public Button updateViewMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new ButtonView();
                break;
            }
            case 1: {
                this._myControllerView = new ButtonImageView();
                break;
            }
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tButton\n" + super.getInfo();
    }

    @Override
    public String toString() {
        return super.toString() + " [ " + this.getValue() + " ] Button (" + this.getClass().getSuperclass() + ")";
    }

    @Deprecated
    public boolean booleanValue() {
        return this.isOn;
    }

    private class ButtonImageView
    implements ControllerView<Button> {
        private ButtonImageView() {
        }

        @Override
        public void display(PGraphics graphics, Button theController) {
            if (Button.this.isOn && Button.this.isSwitch) {
                graphics.image(Button.this.availableImages[3] ? Button.this.images[3] : Button.this.images[0], 0.0f, 0.0f, (float)Button.this.width, (float)Button.this.height);
                return;
            }
            if (Button.this.getMouseOver()) {
                if (Button.this.isPressed) {
                    graphics.image(Button.this.availableImages[2] ? Button.this.images[2] : Button.this.images[0], 0.0f, 0.0f, (float)Button.this.width, (float)Button.this.height);
                } else {
                    graphics.image(Button.this.availableImages[1] ? Button.this.images[1] : Button.this.images[0], 0.0f, 0.0f, (float)Button.this.width, (float)Button.this.height);
                }
            } else {
                graphics.image(Button.this.images[0], 0.0f, 0.0f, (float)Button.this.width, (float)Button.this.height);
            }
        }
    }

    private class ButtonView
    implements ControllerView<Button> {
        private ButtonView() {
        }

        @Override
        public void display(PGraphics graphics, Button theController) {
            graphics.noStroke();
            if (Button.this.isOn && Button.this.isSwitch) {
                graphics.fill(Button.this.color.getActive());
            } else if (Button.this.getMouseOver()) {
                if (Button.this.isPressed) {
                    graphics.fill(Button.this.color.getActive());
                } else {
                    graphics.fill(Button.this.color.getForeground());
                }
            } else {
                graphics.fill(Button.this.color.getBackground());
            }
            graphics.rect(0.0f, 0.0f, (float)Button.this.width, (float)Button.this.height);
            if (Button.this.isLabelVisible) {
                Button.this._myCaptionLabel.draw(graphics, 0, 0, theController);
            }
        }
    }
}

