/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui.controllers;

import processing.core.PGraphics;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.Label;
import tech.lity.rea.skatolo.gui.controllers.ControllerView;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;

@Skatolo.Layout
public class Bang
extends Controller<Bang> {
    protected int cnt;
    protected int triggerId = 2;

    public Bang(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0.0f, 0.0f, 20, 20);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    public Bang(Skatolo theskatolo, ControllerGroup<?> theParent, String theName, float theX, float theY, int theWidth, int theHeight) {
        super(theskatolo, theParent, theName, theX, theY, theWidth, theHeight);
        this._myCaptionLabel.setPadding(0, Label.defaultPaddingY).align(37, 13);
        this._myValue = 1.0f;
    }

    @Override
    protected void onEnter() {
        this.cnt = 0;
        this.isActive = true;
    }

    @Override
    public void onLeave() {
        this.isActive = false;
    }

    @Override
    protected void mousePressed() {
        if (this.triggerId == 2) {
            this.cnt = -3;
            this.isActive = true;
            this.update();
        }
    }

    @Override
    protected void mouseReleased() {
        if (this.triggerId == 1) {
            this.cnt = -3;
            this.isActive = true;
            this.update();
        }
    }

    @Override
    protected void mouseReleasedOutside() {
        this.onLeave();
    }

    @Skatolo.Layout
    public Bang setTriggerEvent(int theEventID) {
        this.triggerId = theEventID;
        return this;
    }

    @Skatolo.Layout
    public int getTriggerEvent() {
        return this.triggerId;
    }

    @Override
    public Bang setValue(float theValue) {
        this._myValue = theValue;
        this.broadcast(2);
        return this;
    }

    @Override
    public Bang update() {
        return this.setValue(this._myValue);
    }

    @Override
    public Bang updateDisplayMode(int theMode) {
        this.updateViewMode(theMode);
        return this;
    }

    public Bang updateViewMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = new BangView();
                break;
            }
            case 1: {
                this._myControllerView = new BangImageView();
                break;
            }
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tBang\n" + super.getInfo();
    }

    @Override
    public String toString() {
        return super.toString() + " [ " + this.getValue() + " ] Bang (" + this.getClass().getSuperclass() + ")";
    }

    private class BangImageView
    implements ControllerView<Bang> {
        private BangImageView() {
        }

        @Override
        public void display(PGraphics graphics, Bang theController) {
            if (Bang.this.isActive) {
                graphics.image(Bang.this.availableImages[2] ? Bang.this.images[2] : Bang.this.images[0], 0.0f, 0.0f);
            } else {
                graphics.image(Bang.this.availableImages[1] ? Bang.this.images[1] : Bang.this.images[0], 0.0f, 0.0f);
            }
            if (Bang.this.cnt < 0) {
                graphics.image(Bang.this.availableImages[1] ? Bang.this.images[1] : Bang.this.images[0], 0.0f, 0.0f);
                ++Bang.this.cnt;
            }
            if (!Bang.this.isActive && Bang.this.cnt >= 0) {
                graphics.image(Bang.this.images[0], 0.0f, 0.0f);
            }
        }
    }

    private class BangView
    implements ControllerView<Bang> {
        private BangView() {
        }

        @Override
        public void display(PGraphics graphics, Bang theController) {
            if (Bang.this.isActive) {
                graphics.fill(Bang.this.color.getActive());
            } else {
                graphics.fill(Bang.this.color.getForeground());
            }
            if (Bang.this.cnt < 0) {
                graphics.fill(Bang.this.color.getForeground());
                ++Bang.this.cnt;
            }
            graphics.rect(0.0f, 0.0f, (float)Bang.this.width, (float)Bang.this.height);
            if (Bang.this.isLabelVisible) {
                Bang.this._myCaptionLabel.draw(graphics, 0, 0, theController);
            }
        }
    }
}

