/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui;

import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.ControlWindow;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.Label;
import tech.lity.rea.skatolo.gui.controllers.ControllerView;

public class Tooltip {
    private final Skatolo skatolo;
    private Controller<?> controller;
    private ControllerView<?> controllerView;
    private Map<Controller<?>, String> map;
    private PVector position = new PVector();
    private PVector currentPosition = new PVector();
    private PVector previousPosition = new PVector();
    private PVector offset = new PVector();
    private int height = 20;
    private int backgroundColor = -76;
    private int color = 0;
    private long startTime = 0L;
    private int currentAlpha = 0;
    private int maxAlpha = 255;
    private long delayInMillis = 500L;
    private int mode = 0;
    private Label label;
    private boolean enabled = true;
    private int borderSize;
    private int alignH = 39;

    public Tooltip(Skatolo theskatolo) {
        this.skatolo = theskatolo;
        this.position = new PVector(-1000.0f, -1000.0f);
        this.currentPosition = new PVector();
        this.previousPosition = new PVector();
        this.offset = new PVector(0.0f, 24.0f, 0.0f);
        this.map = new HashMap();
        this.label = new Label(this.skatolo, "tooltip");
        this.label.setColor(this.color);
        this.label.setPadding(0, 0);
        this.setView(new TooltipView());
        this.setBorder(4);
    }

    public Tooltip setBorder(int theValue) {
        this.borderSize = theValue;
        this.label.getStyle().setMargin(this.borderSize, this.borderSize, this.borderSize, this.borderSize);
        return this;
    }

    public int getBorder() {
        return this.borderSize;
    }

    public Tooltip setAlpha(int theValue) {
        this.maxAlpha = theValue;
        return this;
    }

    private void updateText(String theText) {
        int n = 1;
        for (char c : theText.toCharArray()) {
            if (c != '\n') continue;
            ++n;
        }
        if (this.label.getHeight() != this.label.getLineHeight() * n) {
            this.label.setHeight(this.label.getLineHeight() * n);
        }
        this.label.set(theText);
    }

    void draw(ControlWindow theWindow) {
        if (this.enabled && this.mode >= 1) {
            this.previousPosition.set(this.currentPosition);
            this.currentPosition.set((float)theWindow.getPointerX(), (float)theWindow.getPointerY(), 0.0f);
            if (this.controller != null && this.controller.getControlWindow().equals(theWindow)) {
                switch (this.mode) {
                    case 1: {
                        if (this.moved()) {
                            this.startTime = System.nanoTime();
                        }
                        if (System.nanoTime() <= this.startTime + this.delayInMillis * 1000000L) break;
                        this.position.set(this.currentPosition);
                        this.alignH = 39;
                        if (this.position.x > (float)(this.controller.getControlWindow().papplet().width - (this.getWidth() + 20))) {
                            this.position.sub(new PVector((float)this.getWidth(), 0.0f, 0.0f));
                            this.alignH = 37;
                        }
                        this.mode = 3;
                        this.startTime = System.nanoTime();
                        this.currentAlpha = 0;
                        break;
                    }
                    case 3: {
                        float t1 = System.nanoTime() - this.startTime;
                        this.currentAlpha = (int)PApplet.map((float)t1, (float)0.0f, (float)2.0E8f, (float)0.0f, (float)this.maxAlpha);
                        if (this.currentAlpha < 250) break;
                        this.mode = 4;
                        this.currentAlpha = 255;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        float t2 = System.nanoTime() - this.startTime;
                        this.currentAlpha = (int)PApplet.map((float)t2, (float)0.0f, (float)2.0E8f, (float)this.maxAlpha, (float)0.0f);
                        if (this.currentAlpha > 0) break;
                        this.mode = 6;
                        break;
                    }
                    case 6: {
                        this.controller = null;
                        this.mode = 0;
                        this.position.set(-1000.0f, -1000.0f, 0.0f);
                    }
                }
                this.currentAlpha = PApplet.max((int)0, (int)PApplet.min((int)this.currentAlpha, (int)this.maxAlpha));
                if (this.mode >= 1) {
                    this.currentAlpha = this.mode == 1 ? 0 : this.currentAlpha;
                    theWindow.graphics().pushMatrix();
                    theWindow.graphics().translate(this.position.x, this.position.y);
                    theWindow.graphics().translate(this.offset.x, this.offset.y);
                    this.controllerView.display(theWindow.graphics(), null);
                    theWindow.graphics().popMatrix();
                }
                if (this.mode < 5 && this.moved()) {
                    this.deactivate(0);
                }
            }
        }
    }

    private boolean moved() {
        return PApplet.abs((float)PApplet.dist((float)this.previousPosition.x, (float)this.previousPosition.y, (float)this.currentPosition.x, (float)this.currentPosition.y)) > 1.0f;
    }

    public Tooltip setDelay(long theMillis) {
        this.delayInMillis = theMillis;
        return this;
    }

    protected void activate(Controller<?> theController) {
        if (this.map.containsKey(theController)) {
            this.startTime = System.nanoTime();
            this.controller = theController;
            this.currentPosition.set((float)theController.getControlWindow().getPointerX(), (float)theController.getControlWindow().getPointerY(), 0.0f);
            this.updateText(this.map.get(this.controller));
            this.mode = 1;
        }
    }

    protected void deactivate() {
        this.deactivate(1);
    }

    protected void deactivate(int theNum) {
        if (theNum == 0) {
            if (this.mode >= 4) {
                if (this.mode < 5) {
                    this.startTime = System.nanoTime();
                }
                this.mode = 5;
            }
        } else {
            this.mode = this.mode >= 4 ? 5 : 6;
        }
    }

    public Tooltip setView(ControllerView<?> theDisplay) {
        this.controllerView = theDisplay;
        return this;
    }

    public Tooltip register(Controller<?> theController, String theText) {
        this.map.put(theController, theText);
        theController.registerProperty("setTooltipEnabled", "isTooltipEnabled");
        return this;
    }

    public Tooltip register(String theControllerName, String theText) {
        Controller<?> c = this.skatolo.getController(theControllerName);
        if (c == null) {
            return this;
        }
        this.map.put(c, theText);
        c.registerProperty("setTooltipEnabled", "isTooltipEnabled");
        return this;
    }

    public Tooltip unregister(Controller<?> theController) {
        this.map.remove(theController);
        theController.removeProperty("setTooltipEnabled", "isTooltipEnabled");
        return this;
    }

    public Tooltip unregister(String theControllerName) {
        Controller<?> c = this.skatolo.getController(theControllerName);
        if (c == null) {
            return this;
        }
        return this.unregister(c);
    }

    public Tooltip setWidth(int theWidth) {
        return this;
    }

    public int getWidth() {
        return this.label.getWidth();
    }

    public Tooltip setHeight(int theHeight) {
        Skatolo.logger().warning("Tooltip.setHeight is disabled with this version");
        this.height = theHeight;
        return this;
    }

    public Tooltip setPositionOffset(float theX, float theY) {
        this.offset.x = theX;
        this.offset.y = theY;
        return this;
    }

    public Tooltip disable() {
        this.enabled = false;
        return this;
    }

    public Tooltip enable() {
        this.enabled = true;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Tooltip setLabel(Label theLabel) {
        this.label = theLabel;
        return this;
    }

    public Label getLabel() {
        return this.label;
    }

    public Tooltip setColorBackground(int theColor) {
        this.backgroundColor = theColor;
        return this;
    }

    public Tooltip setColorLabel(int theColor) {
        this.color = theColor;
        this.label.setColor(theColor);
        return this;
    }

    class TooltipView
    implements ControllerView<Controller<?>> {
        TooltipView() {
        }

        @Override
        public void display(PGraphics graphics, Controller<?> theController) {
            Tooltip.this.height = Tooltip.this.label.getHeight();
            graphics.fill(Tooltip.this.backgroundColor, (float)Tooltip.this.currentAlpha);
            graphics.rect(0.0f, 0.0f, (float)(Tooltip.this.getWidth() + Tooltip.this.borderSize * 2), (float)(Tooltip.this.height + Tooltip.this.borderSize * 2));
            graphics.pushMatrix();
            if (Tooltip.this.alignH == 39) {
                graphics.translate(6.0f, 0.0f);
            } else {
                graphics.translate((float)(Tooltip.this.getWidth() - 6), 0.0f);
            }
            graphics.triangle(0.0f, 0.0f, 4.0f, -4.0f, 8.0f, 0.0f);
            graphics.popMatrix();
            int a = (int)PApplet.map((float)Tooltip.this.currentAlpha, (float)0.0f, (float)Tooltip.this.maxAlpha, (float)0.0f, (float)255.0f);
            Tooltip.this.label.setColor(a << 24 | Tooltip.this.color >> 16 << 16 | Tooltip.this.color >> 8 << 8 | Tooltip.this.color >> 0 << 0);
            Tooltip.this.label.draw(graphics, 0, 0, theController);
        }
    }
}

