/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui;

import java.util.HashMap;
import tech.lity.rea.skatolo.gui.Pointer;

public class PointerList
extends HashMap<Integer, Pointer> {
    static final int MOUSE = -128;

    public PointerList() {
        Pointer mousePointer = new Pointer().setType(Pointer.Type.MOUSE);
        this.put(-128, mousePointer);
    }

    public Pointer addPointer(int id) {
        Pointer p = new Pointer();
        this.put(id, p);
        return p;
    }

    public void removePointer(int id) {
        this.remove(id);
    }

    public void updatePointer(int id, int x, int y) throws IllegalArgumentException {
        if (!this.containsKey(id)) {
            throw new IllegalArgumentException("Pointer ID not found");
        }
        Pointer p = (Pointer)this.get(id);
        p.updatePosition(x, y);
    }

    public void updatePointer(int id, boolean pressed) throws IllegalArgumentException {
        if (this.containsKey(id)) {
            Pointer p = (Pointer)this.get(id);
            if (pressed) {
                p.setPressed();
            } else {
                p.setReleased();
            }
        } else {
            throw new IllegalArgumentException("Pointer ID not found");
        }
    }

    public void updateMousePointer(int x, int y) {
        this.updatePointer(-128, x, y);
    }

    public Pointer getMousePointer() {
        return (Pointer)this.get(-128);
    }
}

