/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui;

import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import tech.lity.rea.skatolo.ControlFont;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.gui.CDrawable;
import tech.lity.rea.skatolo.gui.ControllerInterface;
import tech.lity.rea.skatolo.gui.ControllerStyle;

public class Label
implements CDrawable {
    private ControllerStyle style = new ControllerStyle();
    private ControlFont font;
    private boolean isMultiline;
    private boolean isFixedSize;
    private boolean isVisible = true;
    private boolean isColorBackground;
    private boolean isToUpperCase = true;
    private boolean changed;
    private int mainColor = -1;
    private int colorBackground = -1;
    private String text = "";
    private int lineHeight = 0;
    private float offsetYratio = 0.0f;
    private int letterSpacing = 0;
    private int height = -1;
    private int width = -1;
    private int alignX = 37;
    private int alignY = 37;
    public int textAlign = 37;
    public static int defaultPaddingX = 4;
    public static int defaultPaddingY = 4;
    public int paddingX = defaultPaddingX;
    public int paddingY = defaultPaddingY;
    protected Labeltype _myLabeltype;
    private Skatolo skatolo;

    private Label(Label theLabel) {
        this.text = theLabel.getText();
        this.isToUpperCase = theLabel.isToUpperCase();
        this.letterSpacing = theLabel.getLetterSpacing();
        this.lineHeight = theLabel.getLineHeight();
        this.font = theLabel.getFont();
        this._myLabeltype = theLabel.getLabeltype();
    }

    public Label(Skatolo theskatolo, String theValue) {
        this.init(theskatolo, theValue, 0, 0, this.mainColor);
    }

    public Label(Skatolo theskatolo, String theValue, int theWidth, int theHeight, int theColor) {
        this.init(theskatolo, theValue, theWidth, theHeight, theColor);
    }

    private void init(Skatolo theskatolo, String theValue, int theWidth, int theHeight, int theColor) {
        this.skatolo = theskatolo;
        this.width = theWidth;
        this.height = theHeight;
        this.text = theValue;
        this.mainColor = theColor;
        this.setLabeltype(new SinglelineLabel());
        this.setFont(this.skatolo.controlFont);
        this.setLabeltype(new SinglelineLabel());
        this.set(this.text);
        this.style = new ControllerStyle();
    }

    public Label setLabeltype(Labeltype theType) {
        this._myLabeltype = theType;
        return this;
    }

    public Labeltype getLabeltype() {
        return this._myLabeltype;
    }

    public Label align(int[] a) {
        this.alignX = a[0];
        this.alignY = a[1];
        return this;
    }

    public Label align(int theX, int theY) {
        this.alignX = theX;
        this.alignY = theY;
        return this;
    }

    public Label alignX(int theX) {
        this.alignX = theX;
        return this;
    }

    public Label alignY(int theY) {
        this.alignY = theY;
        return this;
    }

    public int[] getAlign() {
        return new int[]{this.alignX, this.alignY};
    }

    public Label setPadding(int thePaddingX, int thePaddingY) {
        this.paddingX = thePaddingX;
        this.paddingY = thePaddingY;
        return this;
    }

    public Label setPaddingX(int thePaddingX) {
        this.paddingX = thePaddingX;
        return this;
    }

    public Label setPaddingY(int thePaddingY) {
        this.paddingY = thePaddingY;
        return this;
    }

    public void draw(PGraphics graphics, int theX, int theY, ControllerInterface<?> theController) {
        if (this.isVisible) {
            this.getLabeltype().draw(this, graphics, theX, theY, theController);
        }
    }

    @Override
    public void draw(PGraphics graphics) {
        if (this.isVisible) {
            this.font.adjust(graphics, this);
            this.draw(graphics, 0, 0);
        }
    }

    public void draw(PGraphics graphics, int theX, int theY) {
        if (this.isVisible) {
            graphics.pushMatrix();
            graphics.translate((float)this.style.marginLeft, (float)this.style.marginTop);
            graphics.translate((float)theX, (float)theY);
            if (this.isColorBackground) {
                float ww = this.getStyle().paddingRight + this.getStyle().paddingLeft;
                ww = this.getStyle().backgroundWidth > -1 ? (ww += (float)this.style.backgroundWidth) : (ww += (float)this.font.getWidth());
                float hh = this.getStyle().paddingBottom + this.getStyle().paddingTop;
                hh = this.getStyle().backgroundHeight > -1 ? (hh += (float)this.getStyle().backgroundHeight) : (hh += (float)this.font.getHeight());
                graphics.fill(this.colorBackground);
                graphics.rect(0.0f, 1.0f, ww, hh);
            }
            graphics.translate((float)this.style.paddingLeft, (float)this.style.paddingTop);
            this.font.draw(graphics, this);
            graphics.popMatrix();
        }
    }

    public Label hide() {
        return this.setVisible(false);
    }

    public Label show() {
        return this.setVisible(true);
    }

    public Label setVisible(boolean theValue) {
        this.isVisible = theValue;
        return this;
    }

    public Label updateFont(ControlFont theFont) {
        return this.setFont(theFont);
    }

    public Label set(String theValue) {
        return this.setText(theValue);
    }

    public Label setText(String theValue) {
        this.text = theValue;
        this.setChanged(true);
        return this;
    }

    public Label setFixedSize(boolean theValue) {
        this.isFixedSize = theValue;
        return this;
    }

    public boolean isFixedSize() {
        return this.isMultiline ? false : this.isFixedSize;
    }

    public String getText() {
        return this.text;
    }

    public String getTextFormatted() {
        return this.getLabeltype().getTextFormatted();
    }

    public ControllerStyle getStyle() {
        return this.style;
    }

    public Label setWidth(int theWidth) {
        this.width = theWidth;
        this.setChanged(true);
        return this;
    }

    public Label setHeight(int theHeight) {
        this.height = theHeight;
        this.setChanged(true);
        return this;
    }

    public int getWidth() {
        return this._myLabeltype.getWidth();
    }

    public int getHeight() {
        return this._myLabeltype.getHeight();
    }

    public int getOverflow() {
        return this.getLabeltype().getOverflow();
    }

    public Label setMultiline(boolean theValue) {
        this.isMultiline = theValue;
        this._myLabeltype = this.isMultiline ? new MultilineLabel() : new SinglelineLabel();
        return this;
    }

    public Label toUpperCase(boolean theValue) {
        this.isToUpperCase = theValue;
        this.setChanged(true);
        return this;
    }

    public ControlFont getFont() {
        return this.font;
    }

    public Label setFont(int theBitFontIndex) {
        Skatolo.logger.warning("BitFont is now of type PFont, use setFont(PFont) instead.");
        return this;
    }

    public Label setFont(PFont thePFont) {
        return this.setFont(new ControlFont(thePFont));
    }

    public Label setFont(ControlFont theFont) {
        this.setLineHeight(theFont.getSize());
        this.font = new ControlFont(theFont.getFont(), theFont.getSize());
        this.font.init(this);
        this.setChanged(true);
        return this;
    }

    public Label setSize(int theSize) {
        this.font.setSize(theSize);
        return this;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public Label setChanged(boolean theValue) {
        this.changed = theValue;
        return this;
    }

    public int getTextHeight() {
        return this.font.getTextHeight();
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public Label setOffsetY(int theValue) {
        return this;
    }

    public Label setOffsetYratio(float theValue) {
        this.offsetYratio = theValue;
        this.setChanged(true);
        return this;
    }

    public float getOffsetYratio() {
        return this.offsetYratio;
    }

    public Label setLineHeight(int theValue) {
        this.lineHeight = theValue;
        this.setChanged(true);
        return this;
    }

    public Label setColor(int theValue, boolean theFlag) {
        this.setColor(theValue);
        this.setFixedSize(theFlag);
        return this;
    }

    public Label setColor(int theColor) {
        this.mainColor = theColor;
        this.setChanged(true);
        return this;
    }

    public int getColor() {
        return this.mainColor;
    }

    public Label setColorBackground(int theColor) {
        this.enableColorBackground();
        this.colorBackground = theColor;
        return this;
    }

    public Label disableColorBackground() {
        this.isColorBackground = false;
        return this;
    }

    public Label enableColorBackground() {
        this.isColorBackground = true;
        return this;
    }

    public int getLetterSpacing() {
        return this.letterSpacing;
    }

    public Label setLetterSpacing(int theValue) {
        this.letterSpacing = theValue;
        this.setChanged(true);
        return this;
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isToUpperCase() {
        return this.isToUpperCase;
    }

    protected Label copy() {
        return new Label(this);
    }

    class MultilineLabel
    implements Labeltype {
        MultilineLabel() {
        }

        @Override
        public void draw(Label theLabel, PGraphics graphics, int theX, int theY, ControllerInterface<?> theController) {
            Label.this.font.adjust(graphics, theLabel);
            theLabel.draw(graphics, theX, theY);
        }

        @Override
        public int getWidth() {
            return Label.this.width;
        }

        @Override
        public int getHeight() {
            return Label.this.height;
        }

        @Override
        public int getOverflow() {
            return Label.this.font.getOverflow();
        }

        @Override
        public String getTextFormatted() {
            return Label.this.isToUpperCase ? Label.this.text.toUpperCase() : Label.this.text;
        }
    }

    public class SinglelineLabel
    implements Labeltype {
        private void align(PApplet theApplet, ControllerInterface<?> theController, int theAlignX, int theAlignY) {
            int x = 0;
            int y = 0;
            switch (theAlignX) {
                case 3: {
                    x = (theController.getWidth() - Label.this.font.getWidth()) / 2;
                    break;
                }
                case 37: {
                    x = Label.this.paddingX;
                    break;
                }
                case 39: {
                    x = theController.getWidth() - Label.this.font.getWidth() - Label.this.paddingX;
                    break;
                }
                case 10: {
                    x = -Label.this.font.getWidth() - Label.this.paddingX;
                    break;
                }
                case 11: {
                    x = theController.getWidth() + Label.this.paddingX;
                }
            }
            switch (theAlignY) {
                case 3: {
                    y = theController.getHeight() / 2 + Label.this.font.getTop() - Label.this.font.getCenter();
                    break;
                }
                case 101: {
                    y = 0;
                    break;
                }
                case 102: {
                    y = theController.getHeight() - Label.this.font.getHeight() - 1;
                    break;
                }
                case 0: {
                    y = theController.getHeight() + Label.this.font.getTop() - 1;
                    break;
                }
                case 13: {
                    y = theController.getHeight() + Label.this.paddingY;
                    break;
                }
                case 12: {
                    y = -Label.this.font.getHeight() - Label.this.paddingY;
                }
            }
            theApplet.translate((float)x, (float)y);
        }

        private void align(PGraphics graphics, ControllerInterface<?> theController, int theAlignX, int theAlignY) {
            int x = 0;
            int y = 0;
            switch (theAlignX) {
                case 3: {
                    x = (theController.getWidth() - Label.this.font.getWidth()) / 2;
                    break;
                }
                case 37: {
                    x = Label.this.paddingX;
                    break;
                }
                case 39: {
                    x = theController.getWidth() - Label.this.font.getWidth() - Label.this.paddingX;
                    break;
                }
                case 10: {
                    x = -Label.this.font.getWidth() - Label.this.paddingX;
                    break;
                }
                case 11: {
                    x = theController.getWidth() + Label.this.paddingX;
                }
            }
            switch (theAlignY) {
                case 3: {
                    y = theController.getHeight() / 2 + Label.this.font.getTop() - Label.this.font.getCenter();
                    break;
                }
                case 101: {
                    y = 0;
                    break;
                }
                case 102: {
                    y = theController.getHeight() - Label.this.font.getHeight() - 1;
                    break;
                }
                case 0: {
                    y = theController.getHeight() + Label.this.font.getTop() - 1;
                    break;
                }
                case 13: {
                    y = theController.getHeight() + Label.this.paddingY;
                    break;
                }
                case 12: {
                    y = -Label.this.font.getHeight() - Label.this.paddingY;
                }
            }
            graphics.translate((float)x, (float)y);
        }

        @Override
        public void draw(Label theLabel, PGraphics graphics, int theX, int theY, ControllerInterface<?> theController) {
            Label.this.font.adjust(graphics, theLabel);
            graphics.pushMatrix();
            this.align(graphics, theController, Label.this.alignX, Label.this.alignY);
            theLabel.draw(graphics, theX, theY);
            graphics.popMatrix();
        }

        @Override
        public int getWidth() {
            return Label.this.isFixedSize ? Label.this.width : Label.this.font.getWidth();
        }

        @Override
        public int getHeight() {
            return Label.this.font.getHeight();
        }

        @Override
        public int getOverflow() {
            return -1;
        }

        @Override
        public String getTextFormatted() {
            return Label.this.isToUpperCase ? Label.this.text.toUpperCase() : Label.this.text;
        }
    }

    public class SinglelineTextfield
    extends SinglelineLabel {
        @Override
        public String getTextFormatted() {
            return Label.this.text;
        }
    }

    public static interface Labeltype {
        public void draw(Label var1, PGraphics var2, int var3, int var4, ControllerInterface<?> var5);

        public int getWidth();

        public int getHeight();

        public int getOverflow();

        public String getTextFormatted();
    }
}

