/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.event.KeyEvent;
import tech.lity.rea.skatolo.ControlFont;
import tech.lity.rea.skatolo.Hacks;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.SkatoloConstants;
import tech.lity.rea.skatolo.events.CallbackEvent;
import tech.lity.rea.skatolo.events.CallbackListener;
import tech.lity.rea.skatolo.events.ControlEvent;
import tech.lity.rea.skatolo.events.ControlListener;
import tech.lity.rea.skatolo.events.ControllerPlug;
import tech.lity.rea.skatolo.file.ControllerProperty;
import tech.lity.rea.skatolo.gui.CColor;
import tech.lity.rea.skatolo.gui.CDrawable;
import tech.lity.rea.skatolo.gui.ControlWindow;
import tech.lity.rea.skatolo.gui.ControllerInterface;
import tech.lity.rea.skatolo.gui.Label;
import tech.lity.rea.skatolo.gui.Pointer;
import tech.lity.rea.skatolo.gui.controllers.ControlBehavior;
import tech.lity.rea.skatolo.gui.controllers.ControllerView;
import tech.lity.rea.skatolo.gui.controllers.Numberbox;
import tech.lity.rea.skatolo.gui.controllers.Textfield;
import tech.lity.rea.skatolo.gui.group.ControlGroup;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;
import tech.lity.rea.skatolo.gui.group.Tab;

public abstract class Controller<T>
implements ControllerInterface<T>,
CDrawable,
SkatoloConstants {
    protected ControllerInterface<?> _myParent;
    public PVector position = new PVector();
    protected PVector positionBuffer = new PVector();
    protected PVector absolutePosition = new PVector();
    protected final String name;
    protected ControlWindow controlWindow;
    private boolean isMousePressed = false;
    protected Skatolo skatolo;
    public int width;
    public int height;
    protected int _myId = -1;
    public float _myValue = Float.NaN;
    protected float _myDefaultValue = Float.NaN;
    protected String _myStringValue = "";
    protected float[] _myArrayValue;
    protected Label _myCaptionLabel;
    protected Label _myValueLabel;
    public boolean isLabelVisible = true;
    public boolean isMoveable = true;
    public boolean isBroadcast = true;
    protected boolean isVisible = true;
    public boolean isActive = false;
    protected boolean isLock = false;
    protected boolean isUserInteraction = true;
    protected boolean isInit = false;
    protected List<ControlListener> _myControlListener;
    public CColor color = new CColor();
    protected float _myMin;
    protected float _myMax;
    protected float _myUnit;
    protected String target;
    protected Object targetObject;
    protected ControlBehavior _myBehavior;
    protected boolean isBehavior;
    protected List<Controller<?>> subelements;
    protected int _myBroadcastType = 2;
    protected boolean isUpdate = false;
    protected int _myDecimalPoints = 2;
    public static int autoWidth = 49;
    public static int autoHeight = 19;
    public static PVector autoSpacing = new PVector(10.0f, 10.0f, 0.0f);
    protected boolean[] availableImages = new boolean[4];
    protected PImage[] images = new PImage[4];
    protected ControllerView<T> _myControllerView;
    protected ControllerView<T> _myDebugView;
    protected int _myDisplayMode = 0;
    protected int _myPickingColor = -256;
    protected String _myAddress = "";
    protected List<ControllerPlug> _myControllerPlugList;
    protected boolean tooltipEnabled;
    protected boolean listening;
    protected Pointer currentPointer = Pointer.invalidPointer;
    protected boolean isPointerOver;
    protected boolean dragged;
    private T me;

    public Controller(Skatolo theskatolo, String theName) {
        this(theskatolo, theskatolo.getDefaultTab(), theName, 0.0f, 0.0f, autoWidth, autoHeight);
        theskatolo.register(theskatolo.getObjectForIntrospection(), theName, this);
    }

    protected Controller(Skatolo theskatolo, ControllerGroup<?> theParent, String theName, float theX, float theY, int theWidth, int theHeight) {
        this.skatolo = theskatolo;
        this.me = this;
        if (this.skatolo == null) {
            this.isBroadcast = false;
        }
        this.name = theName;
        this.position = new PVector(theX, theY, 0.0f);
        this.positionBuffer = new PVector(theX, theY, 0.0f);
        this.setParent(theParent);
        if (theParent != null) {
            this.color.set(theParent.getColor());
        } else {
            this.color.set(Skatolo.DEFAULT_COLOR);
        }
        this.width = theWidth;
        this.height = theHeight;
        this._myCaptionLabel = new Label(this.skatolo, theName);
        this._myCaptionLabel.setColor(this.color.getCaptionLabel());
        this._myValueLabel = new Label(this.skatolo, "-");
        this._myValueLabel.setColor(this.color.getCaptionLabel());
        this._myControllerPlugList = new ArrayList<ControllerPlug>();
        this._myControlListener = new ArrayList<ControlListener>();
        this.subelements = new ArrayList();
        this._myArrayValue = new float[0];
        this._myDebugView = new DebugView();
        this.setView(this._myDebugView);
    }

    public List<Controller<?>> getSubelements() {
        return this.subelements;
    }

    @Override
    @Skatolo.Layout
    public String getAddress() {
        return this._myAddress;
    }

    @Override
    @Skatolo.Layout
    public T setAddress(String theAddress) {
        if (this._myAddress.length() == 0) {
            this._myAddress = theAddress;
        }
        return this.me;
    }

    protected Controller(Skatolo theskatolo, String theName, float theX, float theY, int theWidth, int theHeight) {
        this(theskatolo, theskatolo.getTab("default"), theName, theX, theY, theWidth, theHeight);
    }

    protected Controller(String theName, int theX, int theY) {
        this.name = theName;
        this.position = new PVector((float)theX, (float)theY, 0.0f);
    }

    @Override
    public void init() {
        this._myDefaultValue = this._myValue;
        this.skatolo.getControlBroadcaster().plug(this.skatolo.getObjectForIntrospection(), this, this.name);
        this.initControllerValue();
        this.isInit = this.skatolo.isAutoInitialization;
        this.setValue(this._myDefaultValue);
        this.isInit = true;
        this.updateDisplayMode(0);
    }

    protected final void initControllerValue() {
        boolean go = false;
        if (this.getClass().equals(Numberbox.class)) {
            go = this._myDefaultValue == 0.0f;
        } else {
            boolean bl = go = this._myDefaultValue == this.getMin() || Float.isNaN(this.getValue());
        }
        if (go) {
            if (this._myControllerPlugList.size() == 1) {
                if (this.getControllerPlugList().get(0).getValue() == null) {
                    this.setDefaultValue(this.getMin());
                } else {
                    float myInitValue = 0.0f;
                    if (this.getControllerPlugList().get(0).getValue() instanceof Boolean) {
                        boolean myBoolean = new Boolean(this.getControllerPlugList().get(0).getValue().toString());
                        myInitValue = myBoolean ? 1.0f : 0.0f;
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof Float) {
                        myInitValue = new Float(this.getControllerPlugList().get(0).getValue().toString()).floatValue();
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof Integer) {
                        myInitValue = new Integer(this.getControllerPlugList().get(0).getValue().toString()).intValue();
                    } else if (this.getControllerPlugList().get(0).getValue() instanceof String) {
                        this._myStringValue = this.getControllerPlugList().get(0).getValue().toString();
                    }
                    this.setDefaultValue(myInitValue);
                }
            } else if (Float.isNaN(this.getDefaultValue())) {
                this.setDefaultValue(this.getMin());
            }
        }
        this._myValue = this._myDefaultValue;
    }

    public void updateFont(ControlFont theControlFont) {
        this._myCaptionLabel.updateFont(theControlFont);
        this._myValueLabel.updateFont(theControlFont);
    }

    public T setBehavior(ControlBehavior theBehavior) {
        this.isBehavior = true;
        this._myBehavior = theBehavior;
        this._myBehavior.init(this);
        return this.me;
    }

    public T removeBehavior() {
        this.isBehavior = false;
        this._myBehavior = null;
        return this.me;
    }

    public ControlBehavior getBehavior() {
        return this._myBehavior;
    }

    @Skatolo.Layout
    public float getDefaultValue() {
        return this._myDefaultValue;
    }

    @Skatolo.Layout
    public T setDefaultValue(float theValue) {
        this._myDefaultValue = theValue;
        return this.me;
    }

    @Skatolo.Layout
    public T setMoveable(boolean theValue) {
        this.isMoveable = theValue;
        return this.me;
    }

    @Skatolo.Layout
    public boolean isMoveable() {
        return this.isMoveable;
    }

    @Skatolo.Layout
    public T setLabelVisible(boolean theValue) {
        this.isLabelVisible = theValue;
        return this.me;
    }

    @Skatolo.Layout
    public boolean isLabelVisible() {
        return this.isLabelVisible;
    }

    @Skatolo.Layout
    public T setBroadcast(boolean theFlag) {
        this.isBroadcast = theFlag;
        return this.me;
    }

    @Skatolo.Layout
    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    @Override
    @Skatolo.Layout
    public PVector getPosition() {
        return this.position;
    }

    @Override
    @Skatolo.Layout
    public T setPosition(PVector thePVector) {
        this.position.x = thePVector.x;
        this.position.y = thePVector.y;
        this.position.z = thePVector.z;
        this.positionBuffer.x = thePVector.x;
        this.positionBuffer.y = thePVector.y;
        this.positionBuffer.z = thePVector.z;
        return this.me;
    }

    @Override
    public T setPosition(float theX, float theY) {
        this.position.x = theX;
        this.position.y = theY;
        this.positionBuffer.x = this.position.x;
        this.positionBuffer.y = this.position.y;
        return this.me;
    }

    @Override
    public PVector getAbsolutePosition() {
        return this.absolutePosition;
    }

    @Override
    public T setAbsolutePosition(PVector thePVector) {
        this.absolutePosition.x = thePVector.x;
        this.absolutePosition.y = thePVector.y;
        this.absolutePosition.z = thePVector.z;
        return this.me;
    }

    @Override
    public T updateAbsolutePosition() {
        return this.me;
    }

    @Override
    public final void continuousUpdateEvents() {
        if (this.isBehavior && this._myBehavior.isActive() && !this.isMousePressed) {
            this._myBehavior.update();
        }
    }

    @Override
    public final T updateEvents() {
        if (!this.isVisible()) {
            return this.me;
        }
        if (this.currentPointer == this.controlWindow.getCurrentPointer() || this.currentPointer == Pointer.invalidPointer) {
            boolean goingIn;
            if (this.isMovingController()) {
                this.moveToPointer();
                return this.me;
            }
            if (this.isLock) {
                return this.me;
            }
            boolean goingOut = !this.computeIsInside();
            boolean bl = goingIn = !goingOut;
            if (this.isPointerOver()) {
                this.checkDragging();
                if (goingOut && !this.isMousePressed) {
                    this.onLeave();
                    this.setPointerOver(false);
                }
            } else if (goingIn) {
                this.onEnter();
                this.setPointerOver(true);
                this.currentPointer = this.controlWindow.getCurrentPointer();
            }
        }
        return this.me;
    }

    private boolean moved() {
        return this.controlWindow.getPointerX() - this.controlWindow.getPointerPrevX() != 0 || this.controlWindow.getPointerY() - this.controlWindow.getPointerPrevY() != 0;
    }

    private void moveToPointer() {
        this.positionBuffer.x += (float)(this.controlWindow.getPointerX() - this.controlWindow.getPointerPrevX());
        this.positionBuffer.y += (float)(this.controlWindow.getPointerY() - this.controlWindow.getPointerPrevY());
        if (this.skatolo.isShiftDown()) {
            this.position.x = (int)this.positionBuffer.x / 10 * 10;
            this.position.y = (int)this.positionBuffer.y / 10 * 10;
        } else {
            this.position.set(this.positionBuffer);
        }
    }

    private boolean isMovingController() {
        return this.isMousePressed && this.skatolo.isAltDown() && this.isMoveable && !this.skatolo.isMoveable;
    }

    private void checkDragging() {
        if (this.moved()) {
            if (this.isMousePressed) {
                this.onDrag();
                this.dragged = true;
            } else if (this.equals(this.controlWindow.getFirstFromMouseOverList())) {
                this.onMove();
            }
        }
    }

    @Override
    public final boolean setMousePressed(boolean theStatus) {
        if (!this.isVisible && !this.isUserInteraction) {
            return false;
        }
        if (theStatus) {
            if (this.isPointerOver()) {
                this.setMousePressed();
                return true;
            }
        } else {
            this.setMouseReleased();
        }
        return false;
    }

    private void setMousePressed() {
        this.isMousePressed = true;
        if (!this.skatolo.isAltDown()) {
            this.mousePressed();
            this.onPress();
            this.skatolo.getControlBroadcaster().invokeAction(new CallbackEvent(this, 1));
        }
    }

    private void setMouseReleased() {
        if (this.isMousePressed) {
            this.isMousePressed = false;
            if (this.computeIsInside()) {
                if (!this.skatolo.isAltDown()) {
                    if (!this.dragged) {
                        this.onClick();
                    }
                    this.mouseReleased();
                    this.onRelease();
                    this.dragged = false;
                    this.skatolo.getControlBroadcaster().invokeAction(new CallbackEvent(this, 8));
                }
            } else {
                this.mouseReleasedOutside();
                this.onReleaseOutside();
                this.skatolo.getControlBroadcaster().invokeAction(new CallbackEvent(this, 16));
            }
        } else if (!this.computeIsInside() && this instanceof Textfield) {
            this.mouseReleasedOutside();
            this.onReleaseOutside();
        }
    }

    public T listen(boolean theValue) {
        if (theValue == this.listening) {
            return this.me;
        }
        this.listening = theValue;
        if (this.listening) {
            this.skatolo.listenTo(this.name, this.skatolo.getObjectForController(this));
        } else {
            this.skatolo.stopListeningTo(this.name, this.skatolo.getObjectForController(this));
        }
        return this.me;
    }

    public boolean isListening() {
        return this.listening;
    }

    @Override
    public boolean isPointerOver() {
        return this.isPointerOver && this.controlWindow.getCurrentPointer() == this.currentPointer;
    }

    @Override
    public T setPointerOver(boolean theFlag) {
        if (this.isPointerOver == theFlag) {
            return this.me;
        }
        this.isPointerOver = theFlag;
        if (this.isPointerOver) {
            this.controlWindow.setMouseOverController(this);
            this.skatolo.getControlBroadcaster().invokeAction(new CallbackEvent(this, 2));
            this.skatolo.getTooltip().activate(this);
            this.currentPointer = this.controlWindow.getCurrentPointer();
        } else {
            this.skatolo.getControlBroadcaster().invokeAction(new CallbackEvent(this, 4));
            this.controlWindow.removeMouseOverFor(this);
            this.skatolo.getTooltip().deactivate();
            this.currentPointer = Pointer.invalidPointer;
        }
        return this.me;
    }

    @Override
    public T updateInternalEvents(PApplet theApplet) {
        return this.me;
    }

    @Override
    public void draw(PGraphics graphics) {
        graphics.pushMatrix();
        graphics.translate(this.position.x, this.position.y);
        this._myControllerView.display(graphics, this.me);
        graphics.popMatrix();
    }

    @Override
    public T add(ControllerInterface<?> theElement) {
        Skatolo.logger().warning(" add() not supported.");
        return this.me;
    }

    @Override
    public T remove(ControllerInterface<?> theElement) {
        Skatolo.logger().warning("remove() not supported.");
        return this.me;
    }

    @Override
    public void remove() {
        this.controlWindow.removeMouseOverFor(this);
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.skatolo != null) {
            this.skatolo.remove((Object)this);
        }
    }

    @Override
    public T bringToFront() {
        return this.bringToFront(this);
    }

    @Override
    public T bringToFront(ControllerInterface<?> theController) {
        if (this._myParent instanceof Tab) {
            this.moveTo((Tab)this._myParent);
        } else {
            this._myParent.bringToFront(theController);
        }
        if (theController != this && this.getSubelements().contains(theController) && theController instanceof Controller) {
            this.getSubelements().remove(theController);
            this.getSubelements().add((Controller)theController);
        }
        return this.me;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final T moveTo(String theTabName) {
        this.setTab(theTabName);
        for (Controller<?> c : this.getSubelements()) {
            c.moveTo(theTabName);
        }
        return this.me;
    }

    public final T moveTo(Tab theTab) {
        this.setTab(theTab.getWindow(), theTab.getName());
        for (Controller<?> c : this.getSubelements()) {
            c.moveTo(theTab);
        }
        return this.me;
    }

    public final T moveTo(PApplet theApplet) {
        this.setTab("default");
        for (Controller<?> c : this.getSubelements()) {
            c.moveTo(theApplet);
        }
        return this.me;
    }

    public final T moveTo(PApplet theApplet, String theTabName) {
        this.setTab(theTabName);
        for (Controller<?> c : this.getSubelements()) {
            c.moveTo(theApplet, theTabName);
        }
        return this.me;
    }

    public final T moveTo(ControlWindow theControlWindow) {
        this.setTab(theControlWindow, "default");
        for (Controller<?> c : this.getSubelements()) {
            c.moveTo(theControlWindow);
        }
        return this.me;
    }

    public final T moveTo(ControlWindow theControlWindow, String theTabName) {
        this.setTab(theControlWindow, theTabName);
        for (Controller<?> c : this.getSubelements()) {
            c.moveTo(theControlWindow, theTabName);
        }
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> theGroup, Tab theTab, ControlWindow theControlWindow) {
        for (Controller<?> c : this.getSubelements()) {
            c.moveTo(theGroup, theTab, theControlWindow);
        }
        if (theGroup != null) {
            this.setGroup(theGroup);
            return this.me;
        }
        if (theControlWindow == null) {
            theControlWindow = this.skatolo.controlWindow;
        }
        this.setTab(theControlWindow, theTab.getName());
        return this.me;
    }

    @Override
    public final T moveTo(ControlGroup<?> theGroup) {
        if (theGroup != null) {
            this.setGroup(theGroup);
        }
        return this.me;
    }

    @Override
    public final T moveTo(ControllerGroup<?> theGroup) {
        if (theGroup != null) {
            this.setGroup(theGroup);
        }
        return this.me;
    }

    public final T setTab(String theName) {
        this.setParent(this.skatolo.getTab(theName));
        for (Controller<?> c : this.getSubelements()) {
            c.setTab(theName);
        }
        return this.me;
    }

    public final T setTab(ControlWindow theWindow, String theName) {
        this.setParent(this.skatolo.getTab(theWindow, theName));
        for (Controller<?> c : this.getSubelements()) {
            c.setTab(theWindow, theName);
        }
        return this.me;
    }

    public final T setGroup(String theName) {
        this.setParent(this.skatolo.getGroup(theName));
        for (Controller<?> c : this.getSubelements()) {
            c.setGroup(theName);
        }
        return this.me;
    }

    public final T setGroup(ControllerGroup<?> theGroup) {
        this.setParent(theGroup);
        for (Controller<?> c : this.getSubelements()) {
            c.setGroup(theGroup);
        }
        return this.me;
    }

    @Override
    public Tab getTab() {
        if (this._myParent instanceof Tab) {
            return (Tab)this._myParent;
        }
        return this._myParent.getTab();
    }

    public final T setParent(ControllerInterface<?> theParent) {
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        this.absolutePosition = new PVector(this.position.x, this.position.y);
        if (theParent != null) {
            this._myParent = theParent;
            this._myParent.add(this);
            this.absolutePosition.add(this._myParent.getPosition());
            this.controlWindow = this._myParent.getWindow();
        }
        this.setPointerOver(false);
        return this.me;
    }

    @Override
    @Skatolo.Layout
    public ControllerInterface<?> getParent() {
        return this._myParent;
    }

    @Override
    public ControlWindow getWindow() {
        return this.controlWindow;
    }

    protected boolean computeIsInside() {
        return (float)this.controlWindow.getPointerX() > this.position.x + this._myParent.getAbsolutePosition().x && (float)this.controlWindow.getPointerX() < this.position.x + this._myParent.getAbsolutePosition().x + (float)this.width && (float)this.controlWindow.getPointerY() > this.position.y + this._myParent.getAbsolutePosition().y && (float)this.controlWindow.getPointerY() < this.position.y + this._myParent.getAbsolutePosition().y + (float)this.height;
    }

    public boolean isInside() {
        return this.computeIsInside();
    }

    @Skatolo.Layout
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isMousePressed() {
        return this.isMousePressed && this.currentPointer == this.controlWindow.getCurrentPointer();
    }

    protected void onEnter() {
    }

    public void onLeave() {
    }

    protected void onDrag() {
    }

    protected void onMove() {
    }

    protected void onClick() {
    }

    protected void onPress() {
    }

    protected void onRelease() {
    }

    protected void onScroll(int theAmount) {
    }

    protected void onReleaseOutside() {
    }

    protected void mousePressed() {
    }

    protected void mouseReleased() {
    }

    protected void mouseReleasedOutside() {
    }

    protected boolean getMouseOver() {
        return this.isPointerOver;
    }

    @Override
    public void keyEvent(KeyEvent theEvent) {
    }

    @Override
    @Skatolo.Layout
    public T setId(int theId) {
        this._myId = theId;
        return this.me;
    }

    @Override
    @Skatolo.Layout
    public int getId() {
        return this._myId;
    }

    protected ControllerPlug getControllerPlug(int theIndex) {
        return this._myControllerPlugList.get(theIndex);
    }

    public List<ControllerPlug> getControllerPlugList() {
        return this._myControllerPlugList;
    }

    public boolean checkControllerPlug(ControllerPlug thePlug) {
        for (ControllerPlug cp : this._myControllerPlugList) {
            if (!cp.getObject().equals(thePlug.getObject()) || !cp.getName().equals(thePlug.getName())) continue;
            return true;
        }
        return false;
    }

    public void addControllerPlug(ControllerPlug thePlug) {
        if (this.checkControllerPlug(thePlug)) {
            return;
        }
        this._myControllerPlugList.add(thePlug);
    }

    protected void removeControllerPlug(ControllerPlug thePlug) {
        this._myControllerPlugList.remove(thePlug);
    }

    public T plugTo(Object[] theObjects) {
        for (Object o : theObjects) {
            this.plugTo(o, this.name);
        }
        return this.me;
    }

    public T plugTo(Object[] theObjects, String theName) {
        for (Object o : theObjects) {
            this.plugTo(o, theName);
        }
        return this.me;
    }

    public T plugTo(Object theObject) {
        return this.plugTo(theObject, this.name);
    }

    public T plugTo(Object theObject, String theName) {
        if (theObject instanceof PApplet) {
            this.unplugFrom(theObject);
        }
        this.skatolo.getControlBroadcaster().plug(theObject, this, theName);
        this.skatolo.getControlBroadcaster().plug(theObject, this, this.skatolo.getControlBroadcaster().getEventMethod());
        return this.me;
    }

    public T unplugFrom(Object[] theObjects) {
        for (Object o : theObjects) {
            this.unplugFrom(o);
        }
        return this.me;
    }

    public T unplugFrom(Object theObject) {
        Iterator<ControllerPlug> i = this._myControllerPlugList.iterator();
        while (i.hasNext()) {
            if (!i.next().getObject().equals(theObject)) continue;
            i.remove();
        }
        return this.me;
    }

    @Override
    @Skatolo.Layout
    public T setValue(float theValue) {
        this._myValue = theValue;
        this.broadcast(2);
        return this.me;
    }

    @Override
    @Skatolo.Layout
    public float getValue() {
        return this._myValue;
    }

    @Override
    @Skatolo.Layout
    public T setStringValue(String theValue) {
        this._myStringValue = theValue;
        return this.me;
    }

    @Override
    @Skatolo.Layout
    public String getStringValue() {
        return this._myStringValue;
    }

    @Override
    @Skatolo.Layout
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    @Override
    public float getArrayValue(int theIndex) {
        if (theIndex >= 0 && theIndex < this._myArrayValue.length) {
            return this._myArrayValue[theIndex];
        }
        return Float.NaN;
    }

    @Override
    @Skatolo.Layout
    public T setArrayValue(float[] theArray) {
        this._myArrayValue = theArray;
        return this.me;
    }

    @Override
    public T setArrayValue(int theIndex, float theValue) {
        if (theIndex >= 0 && theIndex < this._myArrayValue.length) {
            this._myArrayValue[theIndex] = theValue;
        }
        return this.me;
    }

    public final T changeValue(float theValue) {
        boolean br = this.isBroadcast;
        this.isBroadcast = false;
        this.setValue(theValue);
        this.isBroadcast = br;
        return this.me;
    }

    @Override
    public T update() {
        return this.me;
    }

    @Override
    public T setUpdate(boolean theFlag) {
        this.isUpdate = theFlag;
        return this.me;
    }

    @Override
    public boolean isUpdate() {
        return this.isUpdate;
    }

    @Override
    public int getPickingColor() {
        return this._myPickingColor;
    }

    @Override
    @Skatolo.Layout
    public CColor getColor() {
        return this.color;
    }

    @Override
    @Skatolo.Layout
    public T setCaptionLabel(String theLabel) {
        this._myCaptionLabel.set(theLabel);
        return this.me;
    }

    @Skatolo.Layout
    public T setValueLabel(String theLabel) {
        this._myValueLabel.set(theLabel);
        return this.me;
    }

    public String getLabel() {
        return this._myCaptionLabel.getText();
    }

    @Override
    public T addListener(ControlListener theListener) {
        this._myControlListener.add(theListener);
        return this.me;
    }

    public T removeListener(ControlListener theListener) {
        this._myControlListener.remove(theListener);
        return this.me;
    }

    public int listenerSize() {
        return this._myControlListener.size();
    }

    public T addCallback(CallbackListener theListener) {
        this.skatolo.addCallback(theListener, this);
        return this.me;
    }

    public T removeCallback(CallbackListener theListener) {
        this.skatolo.removeCallback(theListener);
        return this.me;
    }

    public T removeCallback() {
        this.skatolo.removeCallback((Controller<?>)this);
        return this.me;
    }

    protected void broadcast() {
        this.broadcast(this._myBroadcastType);
    }

    protected void broadcast(int theType) {
        theType = this._myBroadcastType;
        ControlEvent myEvent = new ControlEvent(this);
        for (ControlListener cl : this._myControlListener) {
            cl.controlEvent(myEvent);
        }
        if (this.isBroadcast && this.isInit) {
            this.skatolo.getControlBroadcaster().broadcast(myEvent, theType);
            this.skatolo.getControlBroadcaster().invokeAction(new CallbackEvent(this, 32));
        }
        this.isInit = true;
    }

    @Override
    @Skatolo.Layout
    public boolean isVisible() {
        if (this.getParent() != null && !this.getParent().isVisible()) {
            return false;
        }
        return this.isVisible;
    }

    @Skatolo.Layout
    public T setVisible(boolean theFlag) {
        this.isVisible = theFlag;
        if (!theFlag) {
            this.isActive = false;
        }
        return this.me;
    }

    @Override
    public T hide() {
        this.setPointerOver(false);
        this.isVisible = false;
        this.isActive = false;
        return this.me;
    }

    @Override
    public T show() {
        this.isVisible = true;
        return this.me;
    }

    @Override
    public T setColor(CColor theColor) {
        this.color.set(theColor);
        this.setColorCaptionLabel(theColor.getCaptionLabel());
        this.setColorValueLabel(theColor.getValueLabel());
        return this.me;
    }

    @Override
    @Skatolo.Layout
    public T setColorActive(int theColor) {
        this.color.setActive(theColor);
        return this.me;
    }

    @Override
    @Skatolo.Layout
    public T setColorForeground(int theColor) {
        this.color.setForeground(theColor);
        return this.me;
    }

    @Override
    @Skatolo.Layout
    public T setColorBackground(int theColor) {
        this.color.setBackground(theColor);
        return this.me;
    }

    @Skatolo.Layout
    public T setColorCaptionLabel(int theColor) {
        this.color.setCaptionLabel(theColor);
        this._myCaptionLabel.setColor(this.color.getCaptionLabel());
        return this.me;
    }

    @Skatolo.Layout
    public T setColorValueLabel(int theColor) {
        this.color.setValueLabel(theColor);
        if (this._myValueLabel != null) {
            this._myValueLabel.setColor(this.color.getValueLabel());
        }
        return this.me;
    }

    public T setImages(PImage theImageDefault, PImage theImageOver, PImage theImageActive) {
        this.setImage(theImageDefault, 0);
        this.setImage(theImageOver, 1);
        this.setImage(theImageActive, 2);
        this.setImage(theImageActive, 3);
        return this.me;
    }

    public T setImages(PImage theImageDefault, PImage theImageOver, PImage theImageActive, PImage theImageHighlight) {
        this.setImage(theImageDefault, 0);
        this.setImage(theImageOver, 1);
        this.setImage(theImageActive, 2);
        this.setImage(theImageHighlight, 3);
        return this.me;
    }

    public T setImages(PImage ... imgs) {
        if (imgs.length < 3 || imgs.length > 4) {
            return this.me;
        }
        this.setImage(imgs[0], 0);
        this.setImage(imgs[1], 1);
        this.setImage(imgs[2], 2);
        this.setImage(imgs.length == 3 ? imgs[2] : imgs[3], 3);
        return this.me;
    }

    public T setImage(PImage theImage) {
        return this.setImage(theImage, 0);
    }

    public T setImage(PImage theImage, int theState) {
        if (theImage != null) {
            this.images[theState] = theImage;
            this.availableImages[theState] = true;
            this.updateDisplayMode(1);
        }
        return this.me;
    }

    public T updateSize() {
        if (this.images[0] != null) {
            this.setSize(this.images[0]);
        }
        return this.me;
    }

    public T setSize(PImage theImage) {
        if (theImage != null) {
            this.setSize(theImage.width, theImage.height);
        }
        return this.me;
    }

    public T setSize(int theWidth, int theHeight) {
        this.setWidth(theWidth);
        this.setHeight(theHeight);
        return this.me;
    }

    protected T updateDisplayMode(int theMode) {
        if (theMode != 0) {
            Skatolo.logger().warning("Image-based or custom displays are not yet implemented for this type of controller. (" + this.getClass().getName() + ")");
        }
        return this.me;
    }

    public T setView(ControllerView<T> theDisplay) {
        this.setView(theDisplay, 3);
        return this.me;
    }

    public void setView(ControllerView<T> theDisplay, int theMode) {
        this._myDisplayMode = theMode;
        this._myControllerView = theDisplay;
    }

    @Skatolo.Layout
    public Label getCaptionLabel() {
        return this._myCaptionLabel;
    }

    @Skatolo.Layout
    public Label getValueLabel() {
        return this._myValueLabel;
    }

    @Skatolo.Layout
    public float getMax() {
        return this._myMax;
    }

    @Skatolo.Layout
    public float getMin() {
        return this._myMin;
    }

    @Skatolo.Layout
    public T setMin(float theValue) {
        this._myMin = theValue;
        this.changeValue(this.getValue());
        return this.me;
    }

    @Skatolo.Layout
    public T setMax(float theValue) {
        this._myMax = theValue;
        this.changeValue(this.getValue());
        return this.me;
    }

    @Skatolo.Layout
    public T setWidth(int theWidth) {
        this.width = theWidth;
        return this.me;
    }

    @Skatolo.Layout
    public T setHeight(int theHeight) {
        this.height = theHeight;
        return this.me;
    }

    @Override
    @Skatolo.Layout
    public int getWidth() {
        return this.width;
    }

    @Override
    @Skatolo.Layout
    public int getHeight() {
        return this.height;
    }

    @Skatolo.Layout
    public T setDecimalPrecision(int theValue) {
        this._myDecimalPoints = theValue;
        int[] t = this._myValueLabel.getAlign();
        this._myValueLabel = new Label(this.skatolo, "" + (this.adjustValue(this._myMax).length() > this.adjustValue(this._myMin).length() ? this.adjustValue(this._myMax) : this.adjustValue(this._myMin)));
        this._myValueLabel.align(t);
        this._myValueLabel.setColor(this.color.getValueLabel());
        this._myValueLabel.set("" + this.adjustValue(this.getValue()));
        return this.me;
    }

    @Skatolo.Layout
    public int getDecimalPrecision() {
        return this._myDecimalPoints;
    }

    protected String adjustValue(float theValue) {
        return this.adjustValue(theValue, this._myDecimalPoints);
    }

    protected String adjustValue(float theValue, int theFloatPrecision) {
        String myLabelValue;
        block6: {
            int myFloatNumberLength;
            block5: {
                int n;
                int myIndex;
                myFloatNumberLength = theFloatPrecision + 1;
                if (this.getControllerPlugList().size() > 0) {
                    for (ControllerPlug cp : this.getControllerPlugList()) {
                        if (cp.getClassType() != Integer.TYPE) continue;
                        myFloatNumberLength = 0;
                    }
                }
                if ((myIndex = (myLabelValue = "" + theValue).indexOf(46)) <= 0) break block5;
                if (theFloatPrecision == 0) {
                    --myIndex;
                }
                if ((n = (myLabelValue = myLabelValue.substring(0, Math.min(myLabelValue.length(), myIndex + myFloatNumberLength))).length() - myIndex) >= myFloatNumberLength) break block6;
                for (int i = 0; i < myFloatNumberLength - n; ++i) {
                    myLabelValue = myLabelValue + "0";
                }
                break block6;
            }
            myLabelValue = myLabelValue + ".";
            for (int i = 0; i < myFloatNumberLength; ++i) {
                myLabelValue = myLabelValue + "0";
            }
        }
        return myLabelValue;
    }

    public T align(int theCaptionX, int theCaptionY, int theValueX, int theValueY) {
        this.getCaptionLabel().align(theCaptionX, theCaptionY);
        this.getCaptionLabel().align(theValueX, theValueY);
        return this.me;
    }

    public ControlWindow getControlWindow() {
        return this.controlWindow;
    }

    public T lock() {
        this.isLock = true;
        return this.me;
    }

    public T unlock() {
        this.isLock = false;
        return this.me;
    }

    @Skatolo.Layout
    public boolean isLock() {
        return this.isLock;
    }

    @Skatolo.Layout
    public T setLock(boolean theValue) {
        this.isLock = theValue;
        return this.me;
    }

    public T setUserInteraction(boolean theValue) {
        this.isUserInteraction = theValue;
        return this.me;
    }

    public boolean isUserInteraction() {
        return this.isUserInteraction;
    }

    public T registerTooltip(String theText) {
        this.skatolo.getTooltip().register(this, theText);
        return this.me;
    }

    public T unregisterTooltip() {
        this.skatolo.getTooltip().unregister(this);
        return this.me;
    }

    protected T setTooltipEnabled(boolean theValue) {
        this.tooltipEnabled = theValue;
        return this.me;
    }

    protected boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public T linebreak() {
        this.skatolo.linebreak(this, true, autoWidth, autoHeight, autoSpacing);
        return this.me;
    }

    @Override
    public ControllerProperty getProperty(String thePropertyName) {
        return this.skatolo.getProperties().getProperty(this, thePropertyName);
    }

    @Override
    public ControllerProperty getProperty(String theSetter, String theGetter) {
        return this.skatolo.getProperties().getProperty(this, theSetter, theGetter);
    }

    @Override
    public T registerProperty(String thePropertyName) {
        this.skatolo.getProperties().register(this, thePropertyName);
        return this.me;
    }

    @Override
    public T registerProperty(String theSetter, String theGetter) {
        this.skatolo.getProperties().register(this, theSetter, theGetter);
        return this.me;
    }

    @Override
    public T removeProperty(String thePropertyName) {
        this.skatolo.getProperties().remove((ControllerInterface<?>)this, thePropertyName);
        return this.me;
    }

    @Override
    public T removeProperty(String theSetter, String theGetter) {
        this.skatolo.getProperties().remove((ControllerInterface<?>)this, theSetter, theGetter);
        return this.me;
    }

    public String toString() {
        return this.getName() + " [" + this.getClass().getSimpleName() + "]";
    }

    public String getInfo() {
        return "[ type:\tController\nname:\t" + this.name + "\nlabel:\t" + this._myCaptionLabel.getText() + "\nid:\t" + this._myId + "\nvalue:\t" + this.getValue() + "\narrayvalue:\t" + Hacks.arrayToString(this._myArrayValue) + "\nposition:\t" + this.position + "\nabsolute:\t" + this.absolutePosition + "\nwidth:\t" + this.getWidth() + "\nheight:\t" + this.getHeight() + "\ncolor:\t" + this.getColor() + "\nvisible:\t" + this.isVisible + "\nmoveable:\t" + this.isMoveable + " ]";
    }

    @Deprecated
    public PVector position() {
        return this.getPosition();
    }

    @Deprecated
    public PVector absolutePosition() {
        return this.getAbsolutePosition();
    }

    @Deprecated
    public void setWindow(PApplet theApplet) {
        this.moveTo(theApplet);
    }

    @Deprecated
    public ControlWindow setWindow(ControlWindow theWindow) {
        this.moveTo(theWindow);
        return this.controlWindow;
    }

    @Deprecated
    public void trigger() {
        this.setValue(this.value());
    }

    @Override
    @Deprecated
    public T setColorLabel(int theColor) {
        this.setColorCaptionLabel(theColor);
        return this.me;
    }

    @Override
    @Deprecated
    public T setColorValue(int theColor) {
        this.setColorValueLabel(theColor);
        return this.me;
    }

    @Deprecated
    public float value() {
        return this.getValue();
    }

    @Deprecated
    public String stringValue() {
        return this.getStringValue();
    }

    @Deprecated
    public float[] arrayValue() {
        return this.getArrayValue();
    }

    @Deprecated
    public float min() {
        return this.getMin();
    }

    @Deprecated
    public float max() {
        return this.getMax();
    }

    @Deprecated
    public CColor color() {
        return this.color;
    }

    @Deprecated
    public ControlBehavior behavior() {
        return this.getBehavior();
    }

    @Deprecated
    public Label captionLabel() {
        return this.getCaptionLabel();
    }

    @Deprecated
    public float defaultValue() {
        return this.getDefaultValue();
    }

    @Deprecated
    public ControlWindow controlWindow() {
        return this.controlWindow;
    }

    @Deprecated
    public String label() {
        return this._myCaptionLabel.toString();
    }

    @Deprecated
    public T listen() {
        this.listen(true);
        return this.me;
    }

    @Deprecated
    public String name() {
        return this.getName();
    }

    @Deprecated
    public int id() {
        return this._myId;
    }

    @Override
    @Deprecated
    public T setLabel(String theLabel) {
        this.setCaptionLabel(theLabel);
        return this.me;
    }

    @Deprecated
    public Label valueLabel() {
        return this._myValueLabel;
    }

    @Deprecated
    public T setAutoUpdate(boolean theValue) {
        this.listen(theValue);
        return this.me;
    }

    @Deprecated
    protected ControllerPlug controllerPlug(int theIndex) {
        return this._myControllerPlugList.get(theIndex);
    }

    @Override
    @Deprecated
    public ControllerInterface<?> parent() {
        return this._myParent;
    }

    class DebugView
    implements ControllerView<T> {
        DebugView() {
        }

        @Override
        public void display(PGraphics graphics, T theController) {
            if (Controller.this.computeIsInside()) {
                graphics.fill(255.0f, 0.0f, 0.0f, 50.0f);
                graphics.stroke(255.0f, 0.0f, 0.0f);
            } else {
                graphics.fill(255, 50.0f);
                graphics.stroke(255);
            }
            graphics.pushMatrix();
            graphics.rect(0.0f, 0.0f, (float)Controller.this.width, (float)Controller.this.height);
            graphics.popMatrix();
        }
    }
}

