/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;
import processing.event.KeyEvent;
import processing.event.MouseEvent;
import tech.lity.rea.skatolo.ControlFont;
import tech.lity.rea.skatolo.ControlKey;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.SkatoloBase;
import tech.lity.rea.skatolo.gui.CColor;
import tech.lity.rea.skatolo.gui.CDrawable;
import tech.lity.rea.skatolo.gui.Canvas;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.ControllerInterface;
import tech.lity.rea.skatolo.gui.ControllerList;
import tech.lity.rea.skatolo.gui.Pointer;
import tech.lity.rea.skatolo.gui.PointerList;
import tech.lity.rea.skatolo.gui.controllers.Knob;
import tech.lity.rea.skatolo.gui.controllers.Numberbox;
import tech.lity.rea.skatolo.gui.controllers.Slider;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;
import tech.lity.rea.skatolo.gui.group.DropdownList;
import tech.lity.rea.skatolo.gui.group.ListBox;
import tech.lity.rea.skatolo.gui.group.Tab;
import tech.lity.rea.skatolo.gui.group.Textarea;

public final class ControlWindow {
    protected Skatolo skatolo;
    protected Controller<?> isControllerActive;
    private final PVector autoPosition = new PVector(10.0f, 30.0f, 0.0f);
    private final float tempAutoPositionHeight = 0.0f;
    private final boolean rendererNotification = false;
    public int background = 0;
    protected CColor color = new CColor();
    private String name = "main";
    private final PApplet applet;
    private PGraphics graphics;
    protected ControllerList tabs;
    private CDrawable cDrawable;
    protected List<Canvas> canvasList;
    private boolean isVisible = true;
    private boolean isInit = false;
    private boolean isAutoDraw;
    private boolean isUpdated;
    private boolean isDrawingBackground = true;
    private boolean isUndecorated = false;
    private boolean focused = true;
    private final PVector positionOfTabs = new PVector(0.0f, 0.0f, 0.0f);
    private int frameCount = 0;
    private boolean isUsingMouseForPointing = true;
    private int mouseWheelMoved = 0;
    private final List<ControllerInterface<?>> mouseoverList;
    private boolean isMouseOver;
    private PointerList pointers;
    private Pointer mousePointer;
    private Pointer currentPointer;
    private static final int NB_KEYS = 525;
    private char key;
    private int keyCode;
    private boolean[] keys = new boolean[525];
    private int numOfActiveKeys = 0;
    private boolean isReset = false;
    boolean pmouseReleased;
    boolean pmousePressed;

    public ControlWindow(Skatolo theskatolo, PApplet theApplet) {
        this.mouseoverList = new ArrayList();
        this.skatolo = theskatolo;
        this.applet = theApplet;
        this.graphics = this.skatolo.getGraphics();
        this.isAutoDraw = true;
        this.init();
    }

    protected void init() {
        this.pointers = new PointerList();
        this.currentPointer = this.mousePointer = this.pointers.getMousePointer();
        this.canvasList = new ArrayList<Canvas>();
        this.tabs = new ControllerList();
        this.tabs.add(new Tab(this.skatolo, this, "global"));
        this.tabs.add(new Tab(this.skatolo, this, "default"));
        this.activateTab(this.getDefaultTab());
        if (!this.isInit) {
            this.applet.registerMethod("pre", (Object)this);
            this.applet.registerMethod("draw", (Object)this);
            if (!this.skatolo.isAndroid) {
                this.applet.registerMethod("keyEvent", (Object)this);
                this.applet.registerMethod("mouseEvent", (Object)this);
            }
        }
        this.isInit = true;
    }

    public Tab getGlobalTab() {
        return (Tab)this.tabs.get(0);
    }

    public Tab getDefaultTab() {
        return (Tab)this.tabs.get(1);
    }

    public Tab getCurrentTab() {
        for (int i = 1; i < this.tabs.size(); ++i) {
            if (!((Tab)this.tabs.get(i)).isActive()) continue;
            return (Tab)this.tabs.get(i);
        }
        return null;
    }

    public ControlWindow activateTab(String theTab) {
        for (int i = 1; i < this.tabs.size(); ++i) {
            if (!((Tab)this.tabs.get(i)).getName().equals(theTab)) continue;
            if (!((Tab)this.tabs.get((int)i)).isActive) {
                this.resetMouseOver();
            }
            this.activateTab((Tab)this.tabs.get(i));
        }
        return this;
    }

    public ControlWindow removeTab(Tab theTab) {
        this.tabs.remove(theTab);
        return this;
    }

    public Tab add(Tab theTab) {
        this.tabs.add(theTab);
        return theTab;
    }

    public Tab addTab(String theTab) {
        return this.getTab(theTab);
    }

    public ControlWindow activateTab(Tab theTab) {
        for (int i = 1; i < this.tabs.size(); ++i) {
            if (this.tabs.get(i) == theTab) {
                if (!((Tab)this.tabs.get((int)i)).isActive) {
                    this.resetMouseOver();
                }
                ((Tab)this.tabs.get(i)).setActive(true);
                continue;
            }
            ((Tab)this.tabs.get(i)).setActive(false);
        }
        return this;
    }

    public ControllerList getTabs() {
        return this.tabs;
    }

    public Tab getTab(String theTabName) {
        return this.skatolo.getTab(this, theTabName);
    }

    public ControlWindow setPositionOfTabs(PVector thePVector) {
        this.positionOfTabs.set(thePVector);
        return this;
    }

    public ControlWindow setPositionOfTabs(int theX, int theY) {
        this.positionOfTabs.set((float)theX, (float)theY, this.positionOfTabs.z);
        return this;
    }

    public PVector getPositionOfTabs() {
        return this.positionOfTabs;
    }

    void setAllignmentOfTabs(int theValue, int theWidth) {
    }

    void setAllignmentOfTabs(int theValue, int theWidth, int theHeight) {
    }

    void setAllignmentOfTabs(int theValue) {
    }

    public void remove() {
        if (this.tabs.size() > 0) {
            for (int i = this.tabs.size() - 1; i >= 0; --i) {
                ((Tab)this.tabs.get(i)).remove();
            }
        }
        this.tabs.clear();
        this.tabs.clearDrawable();
    }

    public ControlWindow clear() {
        this.remove();
        return this;
    }

    public void updateFont(ControlFont theControlFont) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            ((Tab)this.tabs.get(i)).updateFont(theControlFont);
        }
    }

    public void updateEvents() {
        this.getGlobalTab().continuousUpdateEvents();
        this.getGlobalTab().updateEvents();
        for (int i = 0; i < this.tabs.size(); ++i) {
            ((Tab)this.tabs.get(i)).continuousUpdateEvents();
            if (!((Tab)this.tabs.get(i)).isActive() || !((Tab)this.tabs.get(i)).isVisible()) continue;
            this.tabs.get(i).updateEvents();
        }
    }

    public boolean isMouseOver() {
        if (this.frameCount + 1 < this.applet.frameCount) {
            this.resetMouseOver();
        }
        return this.isVisible ? this.isMouseOver : false;
    }

    public boolean isMouseOver(ControllerInterface<?> theController) {
        return this.mouseoverList.contains(theController);
    }

    public void resetMouseOver() {
        this.isMouseOver = false;
        for (int i = this.mouseoverList.size() - 1; i >= 0; --i) {
            this.mouseoverList.get(i).setPointerOver(false);
        }
        this.mouseoverList.clear();
    }

    public ControllerInterface<?> getFirstFromMouseOverList() {
        if (this.getMouseOverList().isEmpty()) {
            return null;
        }
        return this.getMouseOverList().get(0);
    }

    public List<ControllerInterface<?>> getMouseOverList() {
        return this.mouseoverList;
    }

    private ControlWindow handleMouseOver() {
        for (int i = this.mouseoverList.size() - 1; i >= 0; --i) {
            if (this.mouseoverList.get(i).isPointerOver() && this.isVisible) continue;
            this.mouseoverList.remove(i);
        }
        this.isMouseOver = this.mouseoverList.size() > 0;
        return this;
    }

    public ControlWindow removeMouseOverFor(ControllerInterface<?> theController) {
        this.mouseoverList.remove(theController);
        return this;
    }

    public ControlWindow setMouseOverController(ControllerInterface<?> theController) {
        if (!this.mouseoverList.contains(theController) && this.isVisible && theController.isVisible()) {
            this.mouseoverList.add(theController);
        }
        this.isMouseOver = true;
        return this;
    }

    public void update() {
        this.getGlobalTab().update();
        for (int i = 1; i < this.tabs.size(); ++i) {
            ((Tab)this.tabs.get(i)).update();
        }
    }

    public void setUpdated(boolean theFlag) {
        this.isUpdated = theFlag;
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.tabs.get(i).setUpdate(theFlag);
        }
    }

    public boolean isUpdate() {
        return this.isUpdated;
    }

    public ControlWindow addCanvas(Canvas theCanvas) {
        this.canvasList.add(theCanvas);
        theCanvas.setControlWindow(this);
        theCanvas.setup(this.applet);
        return this;
    }

    public ControlWindow removeCanvas(Canvas theCanvas) {
        this.canvasList.remove(theCanvas);
        return this;
    }

    public ControlWindow pre() {
        if (this.frameCount + 1 < this.applet.frameCount) {
            if (this.isReset) {
                this.resetMouseOver();
                this.isReset = false;
            }
        } else {
            this.isReset = true;
        }
        if (this.papplet().focused != this.focused) {
            this.clearKeys();
            this.mousePointer.resetPress();
            this.focused = this.papplet().focused;
        }
        return this;
    }

    public void mouseEvent(int theX, int theY, boolean pressed) {
        System.out.println("Android mouseEvent. Support stopped for now.");
    }

    public void mouseEvent(MouseEvent theMouseEvent) {
        if (theMouseEvent.getAction() == 1) {
            this.mousePointer.setStatus(Pointer.Status.PRESSED);
        }
        if (theMouseEvent.getAction() == 2) {
            this.mousePointer.setStatus(Pointer.Status.RELEASED);
        }
    }

    public boolean isPointerPressed() {
        return this.currentPointer.isMaintainedPressed();
    }

    public int getPointerX() {
        return this.currentPointer.getX();
    }

    public int getPointerY() {
        return this.currentPointer.getY();
    }

    public int getPointerPrevX() {
        return this.currentPointer.getPX();
    }

    public int getPointerPrevY() {
        return this.currentPointer.getPY();
    }

    public int getMouseX() {
        return this.mousePointer.getX();
    }

    public int getMouseY() {
        return this.mousePointer.getY();
    }

    public int getPMouseX() {
        return this.mousePointer.getPX();
    }

    public int getPMouseY() {
        return this.mousePointer.getPY();
    }

    public void keyEvent(KeyEvent theKeyEvent) {
        int eventKeyCode = theKeyEvent.getKeyCode();
        if (eventKeyCode >= 525) {
            return;
        }
        if (theKeyEvent.getAction() == 1) {
            if (this.keys[eventKeyCode] && eventKeyCode != 8 && eventKeyCode != 37 && eventKeyCode != 39) {
                return;
            }
            this.pressEvent(theKeyEvent);
        }
        if (theKeyEvent.getAction() == 2) {
            this.releaseEvent(theKeyEvent);
        }
        this.skatolo.updateKeyModifiers(theKeyEvent.getModifiers());
        this.checkShortcuts(theKeyEvent);
        this.handleKeyEvent(theKeyEvent);
    }

    private void pressEvent(KeyEvent theKeyEvent) {
        this.keys[theKeyEvent.getKeyCode()] = true;
        ++this.numOfActiveKeys;
        this.key = theKeyEvent.getKey();
        this.keyCode = theKeyEvent.getKeyCode();
    }

    private void releaseEvent(KeyEvent theKeyEvent) {
        this.keys[theKeyEvent.getKeyCode()] = false;
        --this.numOfActiveKeys;
    }

    private void checkShortcuts(KeyEvent theKeyEvent) {
        if (theKeyEvent.getAction() == 1 && this.skatolo.areShortcutsEnabled()) {
            int n = 0;
            for (boolean b : this.keys) {
                n += b ? 1 : 0;
            }
            char[] c = new char[n];
            n = 0;
            for (int i = 0; i < this.keys.length; ++i) {
                if (!this.keys[i]) continue;
                c[n++] = (char)i;
            }
            SkatoloBase.KeyCode code = new SkatoloBase.KeyCode(c);
            if (this.skatolo.keymap.containsKey(code)) {
                for (ControlKey ck : (List)this.skatolo.keymap.get(code)) {
                    ck.keyEvent();
                }
            }
        }
    }

    public void clearKeys() {
        this.keys = new boolean[525];
        this.numOfActiveKeys = 0;
    }

    private void updatePointerEvents() {
        if (this.skatolo.isAndroid) {
            this.mouseEvent(this.skatolo.getPApplet().mouseX, this.skatolo.getPApplet().mouseY, this.skatolo.getPApplet().mousePressed);
        } else {
            if (this.mousePointer.isEnabled()) {
                this.mousePointer.updatePosition(this.papplet().mouseX, this.papplet().mouseY, this.papplet().pmouseX, this.papplet().pmouseY);
            }
            int nbPointers = 0;
            for (Pointer p : this.pointers.values()) {
                if (!p.isEnabled()) continue;
                this.currentPointer = p;
                if (!p.isTouch() && !p.isHover()) {
                    if (p.isPressed()) {
                        p.eventSent();
                        this.mousePressedEvent();
                    }
                    if (p.isReleased()) {
                        p.eventSent();
                        this.mouseReleasedEvent();
                    }
                }
                this.updateEvents();
                this.handleMouseWheelMoved();
                ++nbPointers;
            }
            if (nbPointers == 0) {
                this.resetMouseOver();
            }
        }
    }

    public void draw() {
        this.frameCount = this.applet.frameCount;
        this.updatePointerEvents();
        if (this.isVisible) {
            int i;
            int myRectMode = this.graphics.rectMode;
            int myEllipseMode = this.graphics.ellipseMode;
            int myImageMode = this.graphics.imageMode;
            this.graphics.pushStyle();
            this.graphics.rectMode(0);
            this.graphics.ellipseMode(0);
            this.graphics.imageMode(0);
            this.graphics.noStroke();
            if (this.cDrawable != null) {
                this.cDrawable.draw(this.graphics);
            }
            for (int i2 = 0; i2 < this.canvasList.size(); ++i2) {
                if (this.canvasList.get(i2).mode() != 0) continue;
                this.canvasList.get(i2).draw(this.graphics);
            }
            this.graphics.noStroke();
            this.graphics.noFill();
            int myOffsetX = (int)this.getPositionOfTabs().x;
            int myOffsetY = (int)this.getPositionOfTabs().y;
            int myHeight = 0;
            if (this.tabs.size() > 0) {
                for (i = 1; i < this.tabs.size(); ++i) {
                    if (!((Tab)this.tabs.get(i)).isVisible()) continue;
                    if (myHeight < ((Tab)this.tabs.get(i)).height()) {
                        myHeight = ((Tab)this.tabs.get(i)).height();
                    }
                    ((Tab)this.tabs.get(i)).setOffset(myOffsetX, myOffsetY);
                    if (((Tab)this.tabs.get(i)).isActive()) {
                        ((Tab)this.tabs.get(i)).draw(this.graphics);
                    }
                    if (((Tab)this.tabs.get(i)).updateLabel()) {
                        ((Tab)this.tabs.get(i)).drawLabel(this.graphics);
                    }
                    myOffsetX += ((Tab)this.tabs.get(i)).width();
                }
                this.getGlobalTab().draw(this.graphics);
            }
            for (i = 0; i < this.canvasList.size(); ++i) {
                if (this.canvasList.get(i).mode() != 1) continue;
                this.canvasList.get(i).draw(this.graphics);
            }
            this.skatolo.getTooltip().draw(this);
            this.graphics.rectMode(myRectMode);
            this.graphics.ellipseMode(myEllipseMode);
            this.graphics.imageMode(myImageMode);
            this.graphics.popStyle();
        }
    }

    public void draw(PGraphics graphics) {
        this.graphics = graphics;
        this.draw();
    }

    public PGraphics graphics() {
        return this.graphics;
    }

    public ControlWindow setContext(CDrawable theDrawable) {
        this.cDrawable = theDrawable;
        return this;
    }

    public String name() {
        return this.name;
    }

    private void mousePressedEvent() {
        if (this.isVisible) {
            for (int i = 0; i < this.tabs.size(); ++i) {
                if (!this.tabs.get(i).setMousePressed(true)) continue;
                return;
            }
        }
    }

    private void mouseReleasedEvent() {
        if (this.isVisible) {
            for (int i = 0; i < this.tabs.size(); ++i) {
                this.tabs.get(i).setMousePressed(false);
            }
        }
    }

    public void setMouseWheelRotation(int theRotation) {
        if (this.isMouseOver()) {
            this.mouseWheelMoved = theRotation;
        }
    }

    private void handleMouseWheelMoved() {
        if (this.mouseWheelMoved != 0) {
            CopyOnWriteArrayList mouselist = new CopyOnWriteArrayList(this.mouseoverList);
            for (ControllerInterface<?> c : mouselist) {
                if (!c.isVisible()) continue;
                if (c instanceof Controller) {
                    ((Controller)c).onScroll(this.mouseWheelMoved);
                }
                if (c instanceof ControllerGroup) {
                    ((ControllerGroup)c).onScroll(this.mouseWheelMoved);
                }
                if (c instanceof Slider) {
                    ((Slider)c).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (c instanceof Knob) {
                    ((Knob)c).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (c instanceof Numberbox) {
                    ((Numberbox)c).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (c instanceof ListBox) {
                    ((ListBox)c).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (c instanceof DropdownList) {
                    ((DropdownList)c).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (!(c instanceof Textarea)) break;
                ((Textarea)c).scrolled(this.mouseWheelMoved);
                break;
            }
        }
        this.mouseWheelMoved = 0;
    }

    public boolean isMousePressed() {
        return this.mousePointer.isPressed();
    }

    public void handleKeyEvent(KeyEvent theKeyEvent) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.tabs.get(i).keyEvent(theKeyEvent);
        }
    }

    public ControlWindow setColorActive(int theColor) {
        this.color.setActive(theColor);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorActive(theColor);
        }
        return this;
    }

    public ControlWindow setColorForeground(int theColor) {
        this.color.setForeground(theColor);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorForeground(theColor);
        }
        return this;
    }

    public ControlWindow setColorBackground(int theColor) {
        this.color.setBackground(theColor);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorBackground(theColor);
        }
        return this;
    }

    public ControlWindow setColorLabel(int theColor) {
        this.color.setCaptionLabel(theColor);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorLabel(theColor);
        }
        return this;
    }

    public ControlWindow setColorValue(int theColor) {
        this.color.setValueLabel(theColor);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorValue(theColor);
        }
        return this;
    }

    public ControlWindow setBackground(int theValue) {
        this.background = theValue;
        return this;
    }

    public PApplet papplet() {
        return this.applet;
    }

    public ControlWindow frameRate(int theFrameRate) {
        this.applet.frameRate((float)theFrameRate);
        return this;
    }

    public ControlWindow show() {
        this.isVisible = true;
        return this;
    }

    public ControlWindow setDrawBackground(boolean theFlag) {
        this.isDrawingBackground = theFlag;
        return this;
    }

    public boolean isDrawBackground() {
        return this.isDrawingBackground;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected boolean isControllerActive(Controller<?> theController) {
        if (this.isControllerActive == null) {
            return false;
        }
        return this.isControllerActive.equals(theController);
    }

    protected ControlWindow setControllerActive(Controller<?> theController) {
        this.isControllerActive = theController;
        return this;
    }

    public ControlWindow toggleUndecorated() {
        this.setUndecorated(!this.isUndecorated());
        return this;
    }

    public ControlWindow setUndecorated(boolean theFlag) {
        if (theFlag != this.isUndecorated()) {
            this.isUndecorated = theFlag;
            this.applet.frame.removeNotify();
            this.applet.frame.setUndecorated(this.isUndecorated);
            this.applet.setSize(this.applet.width, this.applet.height);
            this.applet.frame.setBounds(0, 0, this.applet.width, this.applet.height);
            this.applet.frame.setSize(this.applet.width, this.applet.height);
            this.applet.frame.addNotify();
        }
        return this;
    }

    public boolean isUndecorated() {
        return this.isUndecorated;
    }

    public ControlWindow setPosition(int theX, int theY) {
        return this.setLocation(theX, theY);
    }

    public ControlWindow setLocation(int theX, int theY) {
        this.applet.frame.setLocation(theX, theY);
        return this;
    }

    public void setAutoDraw(boolean theFlag) {
        this.isAutoDraw = theFlag;
    }

    public ControlWindow enablePointer() {
        this.isUsingMouseForPointing = false;
        return this;
    }

    public ControlWindow disablePointer() {
        this.isUsingMouseForPointing = true;
        return this;
    }

    public boolean isPointerEnabled() {
        return !this.isUsingMouseForPointing;
    }

    public ControlWindow hide() {
        this.isVisible = false;
        this.isMouseOver = false;
        return this;
    }

    public PointerList getPointers() {
        return this.pointers;
    }

    public char getKey() {
        return this.key;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public boolean isIsVisible() {
        return this.isVisible;
    }

    public boolean isAutoDraw() {
        return this.isAutoDraw;
    }

    public Pointer getMousePointer() {
        return this.mousePointer;
    }

    public Pointer getCurrentPointer() {
        return this.currentPointer;
    }

    public void delete() {
        this.applet.unregisterMethod("pre", (Object)this);
        this.applet.unregisterMethod("draw", (Object)this);
        this.applet.unregisterMethod("keyEvent", (Object)this);
        this.applet.unregisterMethod("mouseEvent", (Object)this);
    }
}

