/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.events;

import java.lang.reflect.Field;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.events.FieldValue;

public class FieldChangedListener {
    private FieldValue value;
    private Skatolo skatolo;

    public FieldChangedListener(Skatolo theskatolo) {
        this.skatolo = theskatolo;
    }

    public void listenTo(final Object theObject, final String theFieldName) {
        try {
            Class<?> c = theObject.getClass();
            final Field field = c.getDeclaredField(theFieldName);
            field.setAccessible(true);
            if (field.getType().isAssignableFrom(Float.TYPE)) {
                this.value = new FieldValue(){
                    float then;

                    @Override
                    public void check() {
                        try {
                            float now = ((Float)field.get(theObject)).floatValue();
                            if (now != this.then) {
                                FieldChangedListener.this.skatolo.getController(theFieldName, theObject).setValue(now);
                                this.then = now;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            } else if (field.getType().isAssignableFrom(Integer.TYPE)) {
                this.value = new FieldValue(){
                    int then;

                    @Override
                    public void check() {
                        try {
                            int now = (Integer)field.get(theObject);
                            if (now != this.then) {
                                FieldChangedListener.this.skatolo.getController(theFieldName, theObject).setValue(now);
                                this.then = now;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            } else if (field.getType().isAssignableFrom(Boolean.TYPE)) {
                this.value = new FieldValue(){
                    boolean then;

                    @Override
                    public void check() {
                        try {
                            boolean now = (Boolean)field.get(theObject);
                            if (now != this.then) {
                                FieldChangedListener.this.skatolo.getController(theFieldName, theObject).setValue(now ? 1.0f : 0.0f);
                                this.then = now;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            } else if (field.getType().isAssignableFrom(String.class)) {
                this.value = new FieldValue(){
                    String then;

                    @Override
                    public void check() {
                        try {
                            String now = (String)field.get(theObject);
                            if (!now.equals(this.then)) {
                                FieldChangedListener.this.skatolo.getController(theFieldName, theObject).setStringValue(now);
                                this.then = now;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                };
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void update() {
        this.value.check();
    }
}

