/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.events;

import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.ControllerInterface;
import tech.lity.rea.skatolo.gui.group.ControlGroup;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;
import tech.lity.rea.skatolo.gui.group.Tab;

public class ControlEvent {
    public static int UNDEFINDED = -1;
    public static int CONTROLLER = 0;
    public static int TAB = 1;
    public static int GROUP = 2;
    protected final ControllerInterface<?> _myController;
    protected boolean isTab;
    protected boolean isController;
    protected boolean isGroup;
    protected int myAction;

    public ControlEvent(Controller<?> theController) {
        this._myController = theController;
        this.isTab = false;
        this.isController = true;
        this.isGroup = false;
    }

    public ControlEvent(Tab theController) {
        this._myController = theController;
        this.isTab = true;
        this.isGroup = false;
        this.isController = false;
    }

    public ControlEvent(ControllerGroup<?> theController) {
        this._myController = theController;
        this.isTab = false;
        this.isGroup = true;
        this.isController = false;
    }

    public float getValue() {
        return this._myController.getValue();
    }

    public String getStringValue() {
        return ((Controller)this._myController).getStringValue();
    }

    public float[] getArrayValue() {
        return this._myController.getArrayValue();
    }

    public float getArrayValue(int theIndex) {
        return this._myController.getArrayValue()[theIndex];
    }

    public Controller<?> getController() {
        return (Controller)this._myController;
    }

    public Tab getTab() {
        return (Tab)this._myController;
    }

    public ControlGroup<?> getGroup() {
        return (ControlGroup)this._myController;
    }

    public String getLabel() {
        return ((Controller)this._myController).getLabel();
    }

    public boolean isTab() {
        return this.isTab;
    }

    public boolean isController() {
        return this.isController;
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public String getName() {
        return this._myController.getName();
    }

    public int getId() {
        return this._myController.getId();
    }

    public int getType() {
        if (this.isController) {
            return CONTROLLER;
        }
        if (this.isTab) {
            return TAB;
        }
        if (this.isGroup) {
            return GROUP;
        }
        return -1;
    }

    public boolean isFrom(ControllerInterface<?> theController) {
        return this._myController.equals(theController);
    }

    public boolean isFrom(String theControllerName) {
        return this._myController.getName().equals(theControllerName);
    }

    public boolean isAssignableFrom(Class<?> c) {
        return this._myController.getClass().isAssignableFrom(c);
    }

    public String toString() {
        return "[ ControlEvent from:" + this._myController.getClass().getSimpleName() + " value:" + this.getValue() + " name:" + this.getName() + " ]";
    }
}

