/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo.events;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.SkatoloConstants;
import tech.lity.rea.skatolo.events.CallbackEvent;
import tech.lity.rea.skatolo.events.CallbackListener;
import tech.lity.rea.skatolo.events.ControlEvent;
import tech.lity.rea.skatolo.events.ControlListener;
import tech.lity.rea.skatolo.events.ControllerPlug;
import tech.lity.rea.skatolo.gui.Controller;

public class ControlBroadcaster {
    private Skatolo skatolo;
    private int controlEventType = -1;
    private ControllerPlug controlEventPlug = null;
    private ControllerPlug controllerCallbackEventPlug = null;
    private String controllerCallbackEventMethod = "controlEvent";
    private ArrayList<ControlListener> controlListeners;
    private Map<CallbackListener, Controller<?>> controllerCallbackListeners;
    private static boolean setPrintStackTrace = true;
    private static boolean ignoreErrorMessage = false;
    private static Map<Class<?>, Field[]> fieldcache = new HashMap();
    private static Map<Class<?>, Method[]> methodcache = new HashMap();
    public boolean broadcast = true;

    public ControlBroadcaster(Skatolo theskatolo) {
        this.skatolo = theskatolo;
        this.controlListeners = new ArrayList();
        this.controllerCallbackListeners = new ConcurrentHashMap();
        this.controlEventPlug = ControlBroadcaster.checkObject(this.skatolo.getObjectForIntrospection(), this.controllerCallbackEventMethod, new Class[]{ControlEvent.class});
        this.controllerCallbackEventPlug = ControlBroadcaster.checkObject(this.skatolo.getObjectForIntrospection(), this.controllerCallbackEventMethod, new Class[]{CallbackEvent.class});
        if (this.controlEventPlug != null) {
            this.controlEventType = 0;
        }
    }

    public ControlBroadcaster addListener(ControlListener ... theListeners) {
        for (ControlListener l : theListeners) {
            this.controlListeners.add(l);
        }
        return this;
    }

    public ControlBroadcaster removeListener(ControlListener ... theListeners) {
        for (ControlListener l : theListeners) {
            this.controlListeners.remove(l);
        }
        return this;
    }

    public ControlListener getListener(int theIndex) {
        if (theIndex < 0 || theIndex >= this.controlListeners.size()) {
            return null;
        }
        return this.controlListeners.get(theIndex);
    }

    public int listenerSize() {
        return this.controlListeners.size();
    }

    public ControlBroadcaster addCallback(CallbackListener ... theListeners) {
        for (CallbackListener l : theListeners) {
            this.controllerCallbackListeners.put(l, new EmptyController());
        }
        return this;
    }

    public ControlBroadcaster addCallback(CallbackListener theListener) {
        this.controllerCallbackListeners.put(theListener, new EmptyController());
        return this;
    }

    public void addCallback(CallbackListener theListener, Controller<?> ... theController) {
        for (Controller<?> c : theController) {
            this.controllerCallbackListeners.put(theListener, c);
        }
    }

    public ControlBroadcaster removeCallback(CallbackListener ... theListeners) {
        for (CallbackListener c : theListeners) {
            this.controllerCallbackListeners.remove(c);
        }
        return this;
    }

    public ControlBroadcaster removeCallback(CallbackListener theListener) {
        this.controllerCallbackListeners.remove(theListener);
        return this;
    }

    public ControlBroadcaster removeCallback(Controller<?> ... theControllers) {
        for (Controller<?> c : theControllers) {
            for (Map.Entry<CallbackListener, Controller<?>> entry : this.controllerCallbackListeners.entrySet()) {
                if (c == null || !entry.getValue().equals(c)) continue;
                this.controllerCallbackListeners.remove(entry.getKey());
            }
        }
        return this;
    }

    public ControlBroadcaster plug(Object theObject, String theControllerName, String theTargetMethod) {
        this.plug(theObject, this.skatolo.getController(theControllerName), theTargetMethod);
        return this;
    }

    public ControlBroadcaster plug(Object theObject, Controller<?> theController, String theTargetMethod) {
        if (theController != null) {
            ControllerPlug myControllerPlug = ControlBroadcaster.checkObject(theObject, theTargetMethod, SkatoloConstants.acceptClassList);
            if (myControllerPlug == null) {
                return this;
            }
            if (!theController.checkControllerPlug(myControllerPlug)) {
                theController.addControllerPlug(myControllerPlug);
            }
            return this;
        }
        return this;
    }

    static Field[] getFieldsFor(Class<?> theClass) {
        if (!fieldcache.containsKey(theClass)) {
            fieldcache.put(theClass, theClass.getDeclaredFields());
        }
        return fieldcache.get(theClass);
    }

    static Method[] getMethodFor(Class<?> theClass) {
        if (!methodcache.containsKey(theClass)) {
            methodcache.put(theClass, theClass.getDeclaredMethods());
        }
        return methodcache.get(theClass);
    }

    protected static ControllerPlug checkObject(Object theObject, String theTargetName, Class<?>[] theAcceptClassList) {
        Class<?> myClass = theObject.getClass();
        Method[] myMethods = ControlBroadcaster.getMethodFor(myClass);
        for (int i = 0; i < myMethods.length; ++i) {
            if (!myMethods[i].getName().equals(theTargetName)) continue;
            if (myMethods[i].getParameterTypes().length == 1) {
                if (theAcceptClassList.length == 1 && theAcceptClassList[0] == CallbackEvent.class) {
                    ControllerPlug cp = new ControllerPlug(CallbackEvent.class, theObject, theTargetName, 2, -1);
                    if (cp.getMethod() == null) {
                        return null;
                    }
                    return cp;
                }
                if (myMethods[i].getParameterTypes()[0] == SkatoloConstants.controlEventClass) {
                    return new ControllerPlug(ControlEvent.class, theObject, theTargetName, 2, -1);
                }
                for (int j = 0; j < theAcceptClassList.length; ++j) {
                    if (myMethods[i].getParameterTypes()[0] != theAcceptClassList[j]) continue;
                    return new ControllerPlug(theObject, theTargetName, 0, j, theAcceptClassList);
                }
                break;
            }
            if (myMethods[i].getParameterTypes().length != 0) break;
            return new ControllerPlug(theObject, theTargetName, 0, -1, theAcceptClassList);
        }
        Field[] myFields = ControlBroadcaster.getFieldsFor(myClass);
        for (int i = 0; i < myFields.length; ++i) {
            if (!myFields[i].getName().equals(theTargetName)) continue;
            for (int j = 0; j < theAcceptClassList.length; ++j) {
                if (myFields[i].getType() != theAcceptClassList[j]) continue;
                return new ControllerPlug(theObject, theTargetName, 1, j, theAcceptClassList);
            }
            break;
        }
        return null;
    }

    public ControlBroadcaster broadcast(ControlEvent theControlEvent, int theType) {
        if (this.broadcast) {
            for (ControlListener cl : this.controlListeners) {
                cl.controlEvent(theControlEvent);
            }
            boolean called = false;
            if (!theControlEvent.isTab() && !theControlEvent.isGroup() && theControlEvent.getController().getControllerPlugList().size() > 0) {
                if (theType == 4) {
                    for (ControllerPlug cp : theControlEvent.getController().getControllerPlugList()) {
                        this.callTarget(cp, theControlEvent.getStringValue());
                    }
                } else if (theType != 5) {
                    for (ControllerPlug cp : theControlEvent.getController().getControllerPlugList()) {
                        if (cp.checkType(2)) {
                            this.invokeMethod(cp.getObject(), cp.getMethod(), new Object[]{theControlEvent});
                            called = true;
                            continue;
                        }
                        this.callTarget(cp, theControlEvent.getValue());
                    }
                }
            }
            if (called) {
                return this;
            }
            if (this.controlEventType == 0) {
                this.invokeMethod(this.controlEventPlug.getObject(), this.controlEventPlug.getMethod(), new Object[]{theControlEvent});
            }
        }
        return this;
    }

    protected void callTarget(ControllerPlug thePlug, float theValue) {
        if (thePlug.checkType(0)) {
            this.invokeMethod(thePlug.getObject(), thePlug.getMethod(), thePlug.getMethodParameter(theValue));
        } else if (thePlug.checkType(1)) {
            this.invokeField(thePlug.getObject(), thePlug.getField(), thePlug.getFieldParameter(theValue));
        }
    }

    protected void callTarget(ControllerPlug thePlug, String theValue) {
        if (thePlug.checkType(0)) {
            this.invokeMethod(thePlug.getObject(), thePlug.getMethod(), new Object[]{theValue});
        } else if (thePlug.checkType(1)) {
            this.invokeField(thePlug.getObject(), thePlug.getField(), theValue);
        }
    }

    private void invokeField(Object theObject, Field theField, Object theParam) {
        try {
            theField.set(theObject, theParam);
        }
        catch (IllegalAccessException e) {
            Skatolo.logger().warning(e.toString());
        }
    }

    private void invokeMethod(Object theObject, Method theMethod, Object[] theParam) {
        try {
            if (theParam[0] == null) {
                theMethod.invoke(theObject, new Object[0]);
            } else {
                theMethod.invoke(theObject, theParam);
            }
        }
        catch (IllegalArgumentException e) {
            Skatolo.logger().warning(e.toString());
        }
        catch (IllegalAccessException e) {
            this.printMethodError(theMethod, e);
        }
        catch (InvocationTargetException e) {
            this.printMethodError(theMethod, e);
        }
        catch (NullPointerException e) {
            this.printMethodError(theMethod, e);
        }
    }

    public String getEventMethod() {
        return this.controllerCallbackEventMethod;
    }

    public void invokeAction(CallbackEvent theEvent) {
        for (Map.Entry<CallbackListener, Controller<?>> entry : this.controllerCallbackListeners.entrySet()) {
            boolean invoke = entry.getValue().getClass().equals(EmptyController.class) ? true : entry.getValue().equals(theEvent.getController());
            if (!invoke) continue;
            entry.getKey().controlEvent(theEvent);
        }
        if (this.controllerCallbackEventPlug != null) {
            this.invokeMethod(this.skatolo.getObjectForIntrospection(), this.controllerCallbackEventPlug.getMethod(), new Object[]{theEvent});
        }
    }

    private void printMethodError(Method theMethod, Exception theException) {
        if (!ignoreErrorMessage) {
            Skatolo.logger().severe("An error occured while forwarding a Controller event, please check your code at " + theMethod.getName() + (!setPrintStackTrace ? " exception:  " + theException : ""));
            if (setPrintStackTrace) {
                theException.printStackTrace();
            }
        }
    }

    public static void ignoreErrorMessage(boolean theFlag) {
        ignoreErrorMessage = theFlag;
    }

    public static void setPrintStackTrace(boolean theFlag) {
        setPrintStackTrace = theFlag;
    }

    @Deprecated
    public void plug(String theControllerName, String theTargetMethod) {
        this.plug(this.skatolo.getObjectForIntrospection(), theControllerName, theTargetMethod);
    }

    private class EmptyController
    extends Controller<EmptyController> {
        protected EmptyController() {
            this(0, 0);
        }

        protected EmptyController(int theX, int theY) {
            super("empty" + (int)(Math.random() * 1000000.0), theX, theY);
        }

        @Override
        public EmptyController setValue(float theValue) {
            return this;
        }
    }
}

