/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import processing.core.PApplet;
import processing.core.PVector;
import tech.lity.rea.skatolo.ControlKey;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.SkatoloConstants;
import tech.lity.rea.skatolo.events.FieldChangedListener;
import tech.lity.rea.skatolo.extra.Println;
import tech.lity.rea.skatolo.file.ControllerProperties;
import tech.lity.rea.skatolo.gui.CColor;
import tech.lity.rea.skatolo.gui.ControlWindow;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.ControllerInterface;
import tech.lity.rea.skatolo.gui.Tooltip;
import tech.lity.rea.skatolo.gui.controllers.Bang;
import tech.lity.rea.skatolo.gui.controllers.Button;
import tech.lity.rea.skatolo.gui.controllers.Chart;
import tech.lity.rea.skatolo.gui.controllers.FrameRate;
import tech.lity.rea.skatolo.gui.controllers.HoverButton;
import tech.lity.rea.skatolo.gui.controllers.HoverToggle;
import tech.lity.rea.skatolo.gui.controllers.Knob;
import tech.lity.rea.skatolo.gui.controllers.Matrix;
import tech.lity.rea.skatolo.gui.controllers.MultiList;
import tech.lity.rea.skatolo.gui.controllers.Numberbox;
import tech.lity.rea.skatolo.gui.controllers.Range;
import tech.lity.rea.skatolo.gui.controllers.Slider;
import tech.lity.rea.skatolo.gui.controllers.Slider2D;
import tech.lity.rea.skatolo.gui.controllers.Textfield;
import tech.lity.rea.skatolo.gui.controllers.Textlabel;
import tech.lity.rea.skatolo.gui.controllers.Toggle;
import tech.lity.rea.skatolo.gui.group.Accordion;
import tech.lity.rea.skatolo.gui.group.CheckBox;
import tech.lity.rea.skatolo.gui.group.ColorPicker;
import tech.lity.rea.skatolo.gui.group.ControlGroup;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;
import tech.lity.rea.skatolo.gui.group.DropdownList;
import tech.lity.rea.skatolo.gui.group.Group;
import tech.lity.rea.skatolo.gui.group.ListBox;
import tech.lity.rea.skatolo.gui.group.RadioButton;
import tech.lity.rea.skatolo.gui.group.Tab;
import tech.lity.rea.skatolo.gui.group.Textarea;
import tech.lity.rea.skatolo.gui.layout.ControllerAutomator;
import tech.lity.rea.skatolo.gui.layout.ControllerLayout;
import tech.lity.rea.skatolo.gui.widgets.PixelSelect;

public class SkatoloBase
implements SkatoloConstants {
    private Skatolo skatolo;
    ControllerProperties properties;
    private ControllerAutomator controllerAutomator;
    protected Map<Object, ArrayList<ControllerInterface<?>>> objectToControllerMap = new HashMap();
    protected Map<String, FieldChangedListener> fieldChangedListenerMap = new HashMap<String, FieldChangedListener>();
    public Map<KeyCode, List<ControlKey>> keymap = new HashMap<KeyCode, List<ControlKey>>();
    protected ControllerGroup<?> currentGroupPointer;
    protected boolean isCurrentGroupPointerClosed = true;
    protected int autoDirection = 0;
    private int keyModifiers;

    public Tab getDefaultTab() {
        return (Tab)this.skatolo.controlWindow.getTabs().get(1);
    }

    protected void init(Skatolo theskatolo) {
        this.skatolo = theskatolo;
        this.properties = new ControllerProperties(this.skatolo);
        this.controllerAutomator = new ControllerAutomator(this.skatolo);
        this.currentGroupPointer = this.skatolo.controlWindow.getTab("default");
    }

    public ControllerLayout getLayout() {
        return new ControllerLayout(this.skatolo);
    }

    public Tab addTab(String theName) {
        for (int i = 0; i < this.skatolo.getWindow().getTabs().size(); ++i) {
            if (!this.skatolo.getWindow().getTabs().get(i).getName().equals(theName)) continue;
            return (Tab)this.skatolo.getWindow().getTabs().get(i);
        }
        Tab myTab = new Tab(this.skatolo, this.skatolo.getWindow(), theName);
        this.skatolo.getWindow().getTabs().add(myTab);
        return myTab;
    }

    public Bang addBang(String theName) {
        return this.addBang(this.skatolo.getObjectForIntrospection(), "", theName);
    }

    public Bang addBang(Object theObject, String theIndex, String theName, int theX, int theY, int theWidth, int theHeight) {
        Bang myController = new Bang(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theX, theY, theWidth, theHeight);
        this.skatolo.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        myController.getProperty("value").disable();
        return myController;
    }

    public Toggle addToggle(Object theObject, String theIndex, String theName, boolean theDefaultValue, float theX, float theY, int theWidth, int theHeight) {
        Toggle myController = new Toggle(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theDefaultValue ? 1.0f : 0.0f, theX, theY, theWidth, theHeight);
        this.skatolo.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        return myController;
    }

    public Tooltip addTooltip() {
        return null;
    }

    public Matrix addMatrix(Object theObject, String theIndex, String theName, int theCellX, int theCellY, int theX, int theY, int theWidth, int theHeight) {
        Matrix myController = new Matrix(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theCellX, theCellY, theX, theY, theWidth, theHeight);
        this.skatolo.register(theObject, theIndex, myController);
        ((Matrix)myController.registerProperty("cells")).registerProperty("interval");
        return myController;
    }

    public Matrix addMatrix(String theName) {
        return this.addMatrix(theName, 10, 10, 0, 0, 100, 100);
    }

    public Matrix addMatrix(String theName, int theCellX, int theCellY, int theX, int theY, int theWidth, int theHeight) {
        return this.addMatrix(this.skatolo.getObjectForIntrospection(), "", theName, theCellX, theCellY, theX, theY, theWidth, theHeight);
    }

    public Slider2D addSlider2D(String theName) {
        return this.addSlider2D(this.skatolo.getObjectForIntrospection(), "", theName, 0.0f, 99.0f, 0.0f, 99.0f, 0.0f, 0.0f, 0, 0, 99, 99);
    }

    public Slider2D addSlider2D(Object theObject, String theIndex, String theName, float theMinX, float theMaxX, float theMinY, float theMaxY, float theDefaultValueX, float theDefaultValueY, int theX, int theY, int theW, int theH) {
        Slider2D myController = new Slider2D(this.skatolo, (ControllerGroup)this.skatolo.controlWindow.getTabs().get(1), theName, theX, theY, theW, theH);
        this.skatolo.register(theObject, theIndex, myController);
        myController.setMinX(theMinX);
        myController.setMaxX(theMaxX);
        myController.setMinY(theMinY);
        myController.setMaxY(theMaxY);
        myController.setArrayValue(new float[]{theDefaultValueX, theDefaultValueY});
        myController.updateValue();
        ((Slider2D)((Slider2D)((Slider2D)((Slider2D)myController.registerProperty("arrayValue")).registerProperty("minX")).registerProperty("maxX")).registerProperty("minY")).registerProperty("maxY");
        return myController;
    }

    public Slider addSlider(Object theObject, String theIndex, String theName, float theMin, float theMax, float theDefaultValue, int theX, int theY, int theW, int theH) {
        Slider myController = new Slider(this.skatolo, (ControllerGroup)this.skatolo.controlWindow.getTabs().get(1), theName, theMin, theMax, theDefaultValue, theX, theY, theW, theH);
        this.skatolo.register(theObject, theIndex, myController);
        ((Slider)((Slider)myController.registerProperty("value")).registerProperty("min")).registerProperty("max");
        return myController;
    }

    public Slider addSlider(String theName, float theMin, float theMax, float theDefaultValue, int theX, int theY, int theW, int theH) {
        return this.addSlider(this.skatolo.getObjectForIntrospection(), "", theName, theMin, theMax, theDefaultValue, theX, theY, theW, theH);
    }

    public Slider addSlider(String theName, float theMin, float theMax, int theX, int theY, int theWidth, int theHeight) {
        return this.addSlider(this.skatolo.getObjectForIntrospection(), "", theName, theMin, theMax, theMin, theX, theY, theWidth, theHeight);
    }

    public Slider addSlider(Object theObject, String theIndex, String theName, float theMin, float theMax, int theX, int theY, int theW, int theH) {
        return this.addSlider(theObject, theIndex, theName, theMin, theMax, theMin, theX, theY, theW, theH);
    }

    public Range addRange(String theName) {
        return this.addRange(theName, 0.0f, 100.0f, 0.0f, 100.0f, 0, 0, 99, 9);
    }

    public Range addRange(Object theObject, String theIndex, String theName, float theMin, float theMax, float theDefaultMinValue, float theDefaultMaxValue, int theX, int theY, int theW, int theH) {
        Range myController = new Range(this.skatolo, (ControllerGroup)this.skatolo.controlWindow.getTabs().get(1), theName, theMin, theMax, theDefaultMinValue, theDefaultMaxValue, theX, theY, theW, theH);
        this.skatolo.register(theObject, theIndex, myController);
        ((Range)myController.registerProperty("lowValue")).registerProperty("highValue");
        return myController;
    }

    public Range addRange(String theName, float theMin, float theMax, float theDefaultMinValue, float theDefaultMaxValue, int theX, int theY, int theW, int theH) {
        return this.addRange(this.skatolo.getObjectForIntrospection(), "", theName, theMin, theMax, theDefaultMinValue, theDefaultMaxValue, theX, theY, theW, theH);
    }

    public Range addRange(String theName, float theMin, float theMax, int theX, int theY, int theWidth, int theHeight) {
        return this.addRange(this.skatolo.getObjectForIntrospection(), "", theName, theMin, theMax, theMin, theMax, theX, theY, theWidth, theHeight);
    }

    public Range addRange(Object theObject, String theIndex, String theName, float theMin, float theMax, int theX, int theY, int theWidth, int theHeight) {
        return this.addRange(theObject, theIndex, theName, theMin, theMax, theMin, theMax, theX, theY, theWidth, theHeight);
    }

    public Numberbox addNumberbox(Object theObject, String theIndex, String theName, float theDefaultValue, int theX, int theY, int theWidth, int theHeight) {
        Numberbox myController = new Numberbox(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theDefaultValue, theX, theY, theWidth, theHeight);
        this.skatolo.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        return myController;
    }

    public Numberbox addNumberbox(String theName, int theX, int theY, int theWidth, int theHeight) {
        return this.addNumberbox(this.skatolo.getObjectForIntrospection(), "", theName, Float.NaN, theX, theY, theWidth, theHeight);
    }

    public Numberbox addNumberbox(Object theObject, String theIndex, String theName, int theX, int theY, int theWidth, int theHeight) {
        return this.addNumberbox(theObject, theIndex, theName, Float.NaN, theX, theY, theWidth, theHeight);
    }

    public Numberbox addNumberbox(String theName, float theDefaultValue, int theX, int theY, int theWidth, int theHeight) {
        return this.addNumberbox(this.skatolo.getObjectForIntrospection(), "", theName, theDefaultValue, theX, theY, theWidth, theHeight);
    }

    public Knob addKnob(Object theObject, String theIndex, String theName, float theMin, float theMax, float theDefaultValue, int theX, int theY, int theDiameter) {
        Knob myController = new Knob(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theMin, theMax, theDefaultValue, theX, theY, theDiameter);
        this.skatolo.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        return myController;
    }

    public Knob addKnob(String theName, float theMin, float theMax, int theX, int theY, int theDiameter) {
        return this.addKnob(this.skatolo.getObjectForIntrospection(), "", theName, theMin, theMax, theMin, theX, theY, theDiameter);
    }

    public Knob addKnob(Object theObject, String theIndex, String theName, float theMin, float theMax, int theX, int theY, int theDiameter) {
        return this.addKnob(theObject, theIndex, theName, theMin, theMax, theX, theY, theDiameter);
    }

    public Knob addKnob(String theName, float theMin, float theMax, float theDefaultValue, int theX, int theY, int theDiameter) {
        return this.addKnob(this.skatolo.getObjectForIntrospection(), "", theName, theMin, theMax, theDefaultValue, theX, theY, theDiameter);
    }

    public MultiList addMultiList(Object theObject, String theIndex, String theName, int theX, int theY, int theWidth, int theHeight) {
        MultiList myController = new MultiList(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theX, theY, theWidth, theHeight);
        this.skatolo.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        return myController;
    }

    public MultiList addMultiList(String theName, int theX, int theY, int theWidth, int theHeight) {
        return this.addMultiList(this.skatolo.getObjectForIntrospection(), "", theName, theX, theY, theWidth, theHeight);
    }

    public Textlabel addTextlabel(String theName) {
        return this.addTextlabel(theName, "", 0, 0);
    }

    public Textlabel addTextlabel(Object theObject, String theIndex, String theName, String theText, int theX, int theY) {
        Textlabel myController = new Textlabel(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theText, theX, theY);
        this.skatolo.register(theObject, theIndex, myController);
        ((Textlabel)myController.registerProperty("value")).registerProperty("stringValue");
        return myController;
    }

    public Textlabel addTextlabel(String theName, String theText, int theX, int theY) {
        return this.addTextlabel(this.skatolo.getObjectForIntrospection(), "", theName, theText, theX, theY);
    }

    public Textlabel addTextlabel(Object theObject, String theIndex, String theName, String theText) {
        return this.addTextlabel(theObject, theIndex, theName, theText, 0, 0);
    }

    public Textlabel addTextlabel(String theName, String theText) {
        return this.addTextlabel(this.skatolo.getObjectForIntrospection(), "", theName, theText, 0, 0);
    }

    public Textarea addTextarea(String theName) {
        return this.addTextarea(theName, "", 0, 0, 199, 99);
    }

    public Textarea addTextarea(String theName, String theText, int theX, int theY, int theW, int theH) {
        Textarea myController = new Textarea(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theText, theX, theY, theW, theH);
        this.skatolo.register(this.skatolo.getObjectForIntrospection(), "", myController);
        myController.registerProperty("text");
        return myController;
    }

    public Textfield addTextfield(String theIndex) {
        return this.addTextfield(theIndex, 0, 0, 199, 19);
    }

    public Textfield addTextfield(Object theObject, String theIndex, String theName, int theX, int theY, int theW, int theH) {
        Textfield myController = new Textfield(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, "", theX, theY, theW, theH);
        this.skatolo.register(theObject, theIndex, myController);
        myController.registerProperty("text");
        return myController;
    }

    public Textfield addTextfield(String theName, int theX, int theY, int theW, int theH) {
        return this.addTextfield(this.skatolo.getObjectForIntrospection(), "", theName, theX, theY, theW, theH);
    }

    public Textfield addTextfield(Object theObject, String theIndex, String theName) {
        return this.addTextfield(theObject, theIndex, theName, 0, 0, 99, 19);
    }

    public Accordion addAccordion(String theName) {
        Accordion myController = new Accordion(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, 0, 0, 200);
        this.skatolo.register(this.skatolo.getObjectForIntrospection(), "", myController);
        return myController;
    }

    public Accordion addAccordion(String theName, int theX, int theY, int theWidth) {
        Accordion myController = new Accordion(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theX, theY, theWidth);
        this.skatolo.register(this.skatolo.getObjectForIntrospection(), "", myController);
        return myController;
    }

    public RadioButton addRadioButton(String theName) {
        return this.addRadioButton(theName, 0, 0);
    }

    public RadioButton addRadioButton(String theName, int theX, int theY) {
        RadioButton myController = new RadioButton(this.skatolo, (ControllerGroup<?>)((Tab)this.skatolo.controlWindow.getTabs().get(1)), theName, theX, theY);
        this.skatolo.register(this.skatolo.getObjectForIntrospection(), "", myController);
        myController.registerProperty("arrayValue");
        return myController;
    }

    public RadioButton addRadio(String theName) {
        return this.addRadioButton(theName, 0, 0);
    }

    public RadioButton addRadio(String theName, int theX, int theY) {
        RadioButton myController = new RadioButton(this.skatolo, (ControllerGroup<?>)((Tab)this.skatolo.controlWindow.getTabs().get(1)), theName, theX, theY);
        this.skatolo.register(this.skatolo.getObjectForIntrospection(), "", myController);
        myController.registerProperty("arrayValue");
        return myController;
    }

    public CheckBox addCheckBox(String theName) {
        return this.addCheckBox(theName, 0, 0);
    }

    public CheckBox addCheckBox(String theName, int theX, int theY) {
        CheckBox myController = new CheckBox(this.skatolo, (ControllerGroup<?>)((Tab)this.skatolo.controlWindow.getTabs().get(1)), theName, theX, theY);
        this.skatolo.register(this.skatolo.getObjectForIntrospection(), "", myController);
        myController.registerProperty("arrayValue");
        return myController;
    }

    public ListBox addListBox(String theName) {
        return this.addListBox(theName, 0, 0, 99, 199);
    }

    public ListBox addListBox(String theName, int theX, int theY, int theW, int theH) {
        ListBox myController = new ListBox(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theX, theY, theW, theH);
        this.skatolo.register(this.skatolo.getObjectForIntrospection(), "", myController);
        ((ListBox)myController.registerProperty("listBoxItems")).registerProperty("value");
        return myController;
    }

    public DropdownList addDropdownList(String theName) {
        return this.addDropdownList(theName, 0, 0, 99, 99);
    }

    public DropdownList addDropdownList(String theName, int theX, int theY, int theW, int theH) {
        DropdownList myController = new DropdownList(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theX, theY, theW, theH);
        this.skatolo.register(this.skatolo.getObjectForIntrospection(), "", myController);
        ((DropdownList)myController.registerProperty("listBoxItems")).registerProperty("value");
        return myController;
    }

    public ColorPicker addColorPicker(String theName) {
        return this.addColorPicker(theName, 0, 0, 255, 10);
    }

    public ColorPicker addColorPicker(String theName, int theX, int theY, int theW, int theH) {
        ColorPicker myController = new ColorPicker(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theX, theY, theW, theH);
        this.skatolo.register(this.skatolo.getObjectForIntrospection(), "", myController);
        myController.registerProperty("arrayValue");
        return myController;
    }

    public Println addConsole(Textarea theTextarea) {
        return new Println(theTextarea);
    }

    public FrameRate addFrameRate() {
        FrameRate myController = new FrameRate(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), "-", 0, 4);
        this.skatolo.register(this.skatolo.getObjectForIntrospection(), "", myController);
        return myController;
    }

    public Chart addChart(String theName) {
        return this.addChart(theName, 0, 0, 200, 100);
    }

    public Chart addChart(String theName, int theX, int theY, int theW, int theH) {
        Chart myController = new Chart(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theX, theY, theW, theH);
        this.skatolo.register(this.skatolo.getObjectForIntrospection(), "", myController);
        return myController;
    }

    public Group addGroup(Object theObject, String theIndex, String theName, int theX, int theY, int theW) {
        Group myController = new Group(this.skatolo, (ControllerGroup)this.skatolo.controlWindow.getTabs().get(1), theName, theX, theY, theW, 9);
        this.skatolo.register(theObject, theIndex, myController);
        return myController;
    }

    public Group addGroup(String theName, int theX, int theY, int theW) {
        return this.addGroup(this.skatolo.getObjectForIntrospection(), "", theName, theX, theY, theW);
    }

    public Group addGroup(String theName) {
        return this.addGroup(theName, 0, 0);
    }

    public Group addGroup(String theName, int theX, int theY) {
        return this.addGroup(this.skatolo.getObjectForIntrospection(), "", theName, theX, theY, 99);
    }

    public Textlabel getTextlabel(String theText, int theX, int theY) {
        return new Textlabel(this.skatolo, theText, theX, theY);
    }

    public Textlabel getTextlabel() {
        return this.getTextlabel("", 0, 0);
    }

    protected void setCurrentPointer(ControllerGroup<?> theGroup) {
        this.currentGroupPointer = theGroup;
        this.isCurrentGroupPointerClosed = false;
    }

    protected void releaseCurrentPointer(ControllerGroup<?> theGroup) {
        if (!this.isCurrentGroupPointerClosed) {
            this.currentGroupPointer = theGroup;
            this.isCurrentGroupPointerClosed = true;
        } else {
            Skatolo.logger().warning("use .end() first before using .begin() again.");
        }
    }

    public void setAutoAddDirection(int theDirection) {
        if (theDirection == 0) {
            this.autoDirection = 0;
            return;
        }
        this.autoDirection = 1;
    }

    public void setAutoSpacing() {
        Controller.autoSpacing.x = 10.0f;
        Controller.autoSpacing.y = 10.0f;
        Controller.autoSpacing.z = 0.0f;
    }

    public void setAutoSpacing(float theX) {
        Controller.autoSpacing.x = theX;
    }

    public void setAutoSpacing(float theX, float theY) {
        Controller.autoSpacing.x = theX;
        Controller.autoSpacing.y = theY;
    }

    public void setAutoSpacing(float theX, float theY, float theZ) {
        Controller.autoSpacing.x = theX;
        Controller.autoSpacing.y = theY;
        Controller.autoSpacing.z = theZ;
    }

    public void linebreak(Controller<?> theController, boolean theFlag, int theW, int theH, PVector theSpacing) {
        if (this.currentGroupPointer.autoPosition.x + Controller.autoSpacing.x + (float)theW > (float)this.skatolo.getPApplet().width) {
            this.currentGroupPointer.autoPosition.y += this.currentGroupPointer.tempAutoPositionHeight;
            this.currentGroupPointer.autoPosition.x = this.currentGroupPointer.autoPositionOffsetX;
            this.currentGroupPointer.tempAutoPositionHeight = 0.0f;
            theController.position.x = this.currentGroupPointer.autoPosition.x;
            theController.position.y = this.currentGroupPointer.autoPosition.y;
            theFlag = false;
        }
        if (theFlag) {
            this.currentGroupPointer.autoPosition.y += this.currentGroupPointer.tempAutoPositionHeight;
            this.currentGroupPointer.autoPosition.x = this.currentGroupPointer.autoPositionOffsetX;
            this.currentGroupPointer.tempAutoPositionHeight = 0.0f;
        } else {
            if (theController instanceof Slider) {
                this.currentGroupPointer.autoPosition.x += (float)theController.getCaptionLabel().getWidth();
            }
            this.currentGroupPointer.autoPosition.x += Controller.autoSpacing.x + (float)theW;
            if ((float)theH + theSpacing.y > this.currentGroupPointer.tempAutoPositionHeight) {
                this.currentGroupPointer.tempAutoPositionHeight = (float)theH + theSpacing.y;
            }
        }
    }

    public Slider addSlider(String theName) {
        return this.addSlider(theName, 0.0f, 100.0f);
    }

    public Slider addSlider(Object theObject, String theIndex, String theName) {
        return this.addSlider(theObject, theIndex, theName, 0.0f, 100.0f);
    }

    public Slider addSlider(String theName, float theMin, float theMax) {
        return this.addSlider(this.skatolo.getObjectForIntrospection(), "", theName, theMin, theMax);
    }

    public Slider addSlider(Object theObject, String theIndex, String theName, float theMin, float theMax) {
        int x = (int)this.currentGroupPointer.autoPosition.x;
        int y = (int)this.currentGroupPointer.autoPosition.y;
        Slider s = this.addSlider(theObject, theIndex, theName, theMin, theMax, theMin, x, y, Slider.autoWidth, Slider.autoHeight);
        this.linebreak(s, false, Slider.autoWidth, Slider.autoHeight, Slider.autoSpacing);
        s.moveTo(this.currentGroupPointer);
        if (this.autoDirection == 1) {
            s.linebreak();
        }
        return s;
    }

    public Button addButton(String theName) {
        return this.addButton(this.skatolo.getObjectForIntrospection(), "", theName, 1.0f);
    }

    public Button addButton(Object theObject, String theIndex, String theName) {
        return this.addButton(theObject, theIndex, theName, 1.0f);
    }

    public Button addButton(String theName, float theValue) {
        return this.addButton(this.skatolo.getObjectForIntrospection(), "", theName, theValue);
    }

    public Button addButton(Object theObject, String theIndex, String theName, float theValue) {
        int x = (int)this.currentGroupPointer.autoPosition.x;
        int y = (int)this.currentGroupPointer.autoPosition.y;
        Button b = this.addButton(theObject, theIndex, theName, theValue, x, y, Button.autoWidth, Button.autoHeight);
        this.linebreak(b, false, Button.autoWidth, Button.autoHeight, Button.autoSpacing);
        b.moveTo(this.currentGroupPointer);
        return b;
    }

    public Button addButton(Object theObject, String theIndex, String theName, float theValue, int theX, int theY, int theW, int theH) {
        Button myController = new Button(this.skatolo, (ControllerGroup)this.skatolo.controlWindow.getTabs().get(1), theName, theValue, theX, theY, theW, theH);
        this.skatolo.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        myController.getProperty("value").disable();
        return myController;
    }

    public HoverButton addHoverButton(String theName) {
        return this.addHoverButton(this.skatolo.getObjectForIntrospection(), "", theName, 1.0f);
    }

    public HoverButton addHoverButton(Object theObject, String theIndex, String theName) {
        return this.addHoverButton(theObject, theIndex, theName, 1.0f);
    }

    public HoverButton addHoverButton(String theName, float theValue) {
        return this.addHoverButton(this.skatolo.getObjectForIntrospection(), "", theName, theValue);
    }

    public HoverButton addHoverButton(Object theObject, String theIndex, String theName, float theValue) {
        int x = (int)this.currentGroupPointer.autoPosition.x;
        int y = (int)this.currentGroupPointer.autoPosition.y;
        HoverButton b = this.addHoverButton(theObject, theIndex, theName, theValue, x, y, HoverButton.autoWidth, HoverButton.autoHeight);
        this.linebreak(b, false, HoverButton.autoWidth, HoverButton.autoHeight, HoverButton.autoSpacing);
        b.moveTo(this.currentGroupPointer);
        return b;
    }

    public HoverButton addHoverButton(Object theObject, String theIndex, String theName, float theValue, int theX, int theY, int theW, int theH) {
        HoverButton myController = new HoverButton(this.skatolo, (ControllerGroup)this.skatolo.controlWindow.getTabs().get(1), theName, theValue, theX, theY, theW, theH);
        this.skatolo.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        myController.getProperty("value").disable();
        return myController;
    }

    public HoverToggle addHoverToggle(String theName) {
        return this.addHoverToggle(this.skatolo.getObjectForIntrospection(), "", theName);
    }

    public HoverToggle addHoverToggle(String theName, boolean theValue) {
        return this.addHoverToggle(this.skatolo.getObjectForIntrospection(), "", theName, theValue);
    }

    public HoverToggle addHoverToggle(Object theObject, String theIndex, String theName) {
        return this.addHoverToggle(theObject, theIndex, theName, false);
    }

    public HoverToggle addHoverToggle(Object theObject, String theIndex, String theName, boolean theValue) {
        HoverToggle t = this.addHoverToggle(theObject, theIndex, theName, theValue, this.currentGroupPointer.autoPosition.x, this.currentGroupPointer.autoPosition.y, HoverToggle.autoWidth, HoverToggle.autoHeight);
        this.linebreak(t, false, HoverToggle.autoWidth, HoverToggle.autoHeight, t.autoSpacing);
        t.moveTo(this.currentGroupPointer);
        return t;
    }

    public HoverToggle addHoverToggle(Object theObject, String theIndex, String theName, boolean theDefaultValue, float theX, float theY, int theWidth, int theHeight) {
        HoverToggle myController = new HoverToggle(this.skatolo, (Tab)this.skatolo.controlWindow.getTabs().get(1), theName, theDefaultValue ? 1.0f : 0.0f, theX, theY, theWidth, theHeight);
        this.skatolo.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        return myController;
    }

    public Bang addBang(Object theObject, String theIndex, String theName) {
        int x = (int)this.currentGroupPointer.autoPosition.x;
        int y = (int)this.currentGroupPointer.autoPosition.y;
        Bang b = this.addBang(theObject, theIndex, theName, x, y, Bang.autoWidth, Bang.autoHeight);
        this.linebreak(b, false, Bang.autoWidth, Bang.autoHeight, Bang.autoSpacing);
        b.moveTo(this.currentGroupPointer);
        return b;
    }

    public Toggle addToggle(String theName) {
        return this.addToggle(this.skatolo.getObjectForIntrospection(), "", theName);
    }

    public Toggle addToggle(String theName, boolean theValue) {
        return this.addToggle(this.skatolo.getObjectForIntrospection(), "", theName, theValue);
    }

    public Toggle addToggle(Object theObject, String theIndex, String theName) {
        return this.addToggle(theObject, theIndex, theName, false);
    }

    public Toggle addToggle(Object theObject, String theIndex, String theName, boolean theValue) {
        Toggle t = this.addToggle(theObject, theIndex, theName, theValue, this.currentGroupPointer.autoPosition.x, this.currentGroupPointer.autoPosition.y, Toggle.autoWidth, Toggle.autoHeight);
        this.linebreak(t, false, Toggle.autoWidth, Toggle.autoHeight, t.autoSpacing);
        t.moveTo(this.currentGroupPointer);
        return t;
    }

    public Numberbox addNumberbox(Object theObject, String theIndex, String theName) {
        int x = (int)this.currentGroupPointer.autoPosition.x;
        int y = (int)this.currentGroupPointer.autoPosition.y;
        Numberbox n = this.addNumberbox(theObject, theIndex, theName, x, y, Numberbox.autoWidth, Numberbox.autoHeight);
        this.linebreak(n, false, Numberbox.autoWidth, Numberbox.autoHeight, n.autoSpacing);
        n.moveTo(this.currentGroupPointer);
        return n;
    }

    public Numberbox addNumberbox(String theName) {
        return this.addNumberbox(this.skatolo.getObjectForIntrospection(), "", theName);
    }

    public Knob addKnob(Object theObject, String theIndex, String theName, int theMin, int theMax) {
        Knob n = this.addKnob(theObject, theIndex, theName, theMin, theMax, theMin, (int)this.currentGroupPointer.autoPosition.x, (int)this.currentGroupPointer.autoPosition.y, Knob.autoWidth);
        this.linebreak(n, false, Knob.autoWidth, Knob.autoHeight, n.autoSpacing);
        n.moveTo(this.currentGroupPointer);
        return n;
    }

    public Knob addKnob(String theName) {
        return this.addKnob(theName, 0, 100);
    }

    public Knob addKnob(Object theObject, String theIndex, String theName) {
        return this.addKnob(theObject, theIndex, theName, 0, 100);
    }

    public Knob addKnob(String theName, int theMin, int theMax) {
        return this.addKnob(this.skatolo.getObjectForIntrospection(), "", theName, theMin, theMax);
    }

    public PixelSelect addPixelSelect(String theName) {
        return this.addPixelSelect(this.skatolo.getObjectForIntrospection(), "", theName);
    }

    public PixelSelect addPixelSelect(Object theObject, String theIndex, String theName) {
        int x = (int)this.currentGroupPointer.autoPosition.x;
        int y = (int)this.currentGroupPointer.autoPosition.y;
        PixelSelect b = this.addPixelSelect(theObject, theIndex, theName, x, y, PixelSelect.autoWidth, PixelSelect.autoHeight);
        this.linebreak(b, false, PixelSelect.autoWidth, PixelSelect.autoHeight, PixelSelect.autoSpacing);
        b.moveTo(this.currentGroupPointer);
        return b;
    }

    public PixelSelect addPixelSelect(Object theObject, String theIndex, String theName, int theX, int theY, int theW, int theH) {
        PixelSelect myController = new PixelSelect(this.skatolo, (ControllerGroup)this.skatolo.controlWindow.getTabs().get(1), theName, theX, theY, theW, theH);
        this.skatolo.register(theObject, theIndex, myController);
        myController.registerProperty("value");
        myController.getProperty("value").disable();
        return myController;
    }

    public ControlWindow addControlWindow(String theName) {
        Skatolo.logger().warning("ControlWindow has been disabled currently, please have a look at the changlog.txt file inside the src folder.");
        return null;
    }

    public <C> C addController(Object theObject, String theIndex, String theName, Class<C> theClass, int theX, int theY) {
        Controller c = null;
        if (theClass.equals(Slider.class)) {
            c = this.addSlider(theObject, theIndex, theName, 0.0f, 100.0f, 0.0f, 0, 0, 99, 9);
        } else if (theClass.equals(Bang.class)) {
            c = this.addBang(theObject, theIndex, theName, 0, 0, 19, 19);
        } else if (theClass.equals(Button.class)) {
            c = this.addButton(theObject, theIndex, theName, 0.0f, 0, 0, 49, 19);
        } else if (theClass.equals(Knob.class)) {
            c = this.addKnob(theObject, theIndex, theName, 0.0f, 100.0f, 0.0f, 0, 0, 49);
        } else if (theClass.equals(Numberbox.class)) {
            c = this.addNumberbox(theObject, theIndex, theName, 0.0f, 0, 0, 99, 19);
        } else if (theClass.equals(Toggle.class)) {
            c = this.addToggle(theObject, theIndex, theName, false, 0.0f, 0.0f, 49, 19);
        } else if (theClass.equals(Textfield.class)) {
            c = this.addTextfield(theObject, theIndex, theName, 0, 0, 99, 19);
        } else if (theClass.equals(Range.class)) {
            c = this.addRange(theObject, theIndex, theName, 0.0f, 100.0f, 0.0f, 100.0f, 0, 0, 99, 9);
        } else if (theClass.equals(Slider2D.class)) {
            c = this.addSlider2D(theObject, theIndex, theName, 0.0f, 100.0f, 0.0f, 100.0f, 0.0f, 0.0f, 0, 0, 99, 99);
        } else if (theClass.equals(Textlabel.class)) {
            c = this.addTextlabel(theName, "<empty>");
        }
        c.setPosition(theX, theY);
        return (C)c;
    }

    public <C> C addGroup(Object theObject, String theIndex, String theName, Class<C> theClass, int theX, int theY, int theW, int theH) {
        ControlGroup c = null;
        if (theClass.equals(DropdownList.class)) {
            c = this.addDropdownList(theName, theX, theY, theW, theH);
        } else if (theClass.equals(ListBox.class)) {
            c = this.addListBox(theName, theX, theY, theW, theH);
        } else if (theClass.equals(ListBox.class)) {
            c = this.addListBox(theName, theX, theY, theW, theH);
        } else if (theClass.equals(RadioButton.class)) {
            c = this.addRadioButton(theName, theX, theY);
        } else if (theClass.equals(CheckBox.class)) {
            c = this.addCheckBox(theName, theX, theY);
        } else if (theClass.equals(ControlGroup.class)) {
            c = this.addGroup(theName, theX, theY);
        } else if (theClass.equals(Group.class)) {
            c = this.addGroup(theName, theX, theY);
        }
        c.setPosition(theX, theY);
        ((ControllerGroup)c).setWidth(theW);
        ((ControllerGroup)c).setHeight(theH);
        return (C)c;
    }

    public <C> C addController(String theName, Class<C> theClass, int theX, int theY) {
        return this.addController(this.skatolo.getObjectForIntrospection(), "", theName, theClass, theX, theY);
    }

    public SkatoloBase addControllersFor(PApplet theApplet) {
        this.addControllersFor("", theApplet);
        return this;
    }

    public SkatoloBase addControllersFor(String theAddressSpace, Object t) {
        this.controllerAutomator.addControllersFor(theAddressSpace, t);
        return this;
    }

    public Controller<?> getController(String theName, Object theObject) {
        if (this.objectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this.objectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                if (!c.getName().equals(theName)) continue;
                return (Controller)c;
            }
        }
        return null;
    }

    public Object getObjectForController(ControllerInterface theController) {
        for (Map.Entry<Object, ArrayList<ControllerInterface<?>>> entry : this.objectToControllerMap.entrySet()) {
            Object key = entry.getKey();
            ArrayList<ControllerInterface<?>> value = entry.getValue();
            for (ControllerInterface<?> c : value) {
                if (!c.equals(theController)) continue;
                return key;
            }
        }
        return null;
    }

    public SkatoloBase setPosition(int theX, int theY, Object o) {
        if (o != null && this.objectToControllerMap.containsKey(o)) {
            ArrayList<ControllerInterface<?>> cs = this.objectToControllerMap.get(o);
            for (ControllerInterface<?> c : cs) {
                int x = (int)c.getPosition().x + theX;
                int y = (int)c.getPosition().y + theY;
                c.setPosition(x, y);
            }
        }
        return this;
    }

    public SkatoloBase hide(Object theObject) {
        if (theObject != null && this.objectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this.objectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                c.hide();
            }
        }
        return this;
    }

    public SkatoloBase show(Object theObject) {
        if (theObject != null && this.objectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this.objectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                c.show();
            }
        }
        return this;
    }

    public SkatoloBase remove(Object theObject) {
        if (theObject != null && this.objectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this.objectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                c.remove();
            }
        }
        return this;
    }

    public SkatoloBase setColor(CColor theColor, Object theObject) {
        if (this.objectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this.objectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                c.setColor(theColor);
            }
        }
        return this;
    }

    public SkatoloBase listenTo(String theFieldName, Object theObject) {
        String key = theObject.hashCode() + "" + theFieldName.hashCode();
        FieldChangedListener value = new FieldChangedListener(this.skatolo);
        value.listenTo(theObject, theFieldName);
        this.fieldChangedListenerMap.put(key, value);
        return this;
    }

    public SkatoloBase stopListeningTo(String theFieldName, Object theObject) {
        String key = theObject.hashCode() + "" + theFieldName.hashCode();
        this.fieldChangedListenerMap.remove(key);
        return this;
    }

    public SkatoloBase moveTo(ControllerGroup<?> theController, Object theObject) {
        if (this.objectToControllerMap.containsKey(theObject)) {
            ArrayList<ControllerInterface<?>> cs = this.objectToControllerMap.get(theObject);
            for (ControllerInterface<?> c : cs) {
                c.moveTo(theController);
            }
        }
        return this;
    }

    public ControllerProperties getProperties() {
        return this.properties;
    }

    public void removeProperty(ControllerInterface<?> theController) {
        this.properties.remove(theController);
    }

    public static void printPublicMethodsFor(Class<?> theClass, String ... thePattern) {
        Set<String> set = SkatoloBase.getPublicMethodsFor(theClass, true, thePattern);
        String str = "";
        str = str + "/**\n";
        str = str + "* skatolo " + theClass.getSimpleName() + "\n";
        str = str + "*\n";
        str = str + "*\n";
        str = str + "* find a list of public methods available for the " + theClass.getSimpleName() + " Controller\n";
        str = str + "* at the bottom of this sketch.\n";
        str = str + "*\n";
        str = str + "* by Andreas Schlegel, 2012\n";
        str = str + "* www.sojamo.de/libraries/skatolo\n";
        str = str + "*\n";
        str = str + "*/\n\n";
        str = str + "/*\n";
        str = str + "a list of all methods available for the " + theClass.getSimpleName() + " Controller\n";
        str = str + "use skatolo.printPublicMethodsFor(" + theClass.getSimpleName() + ".class);\n";
        str = str + "to print the following list into the console.\n\n";
        str = str + "You can find further details about class " + theClass.getSimpleName() + " in the javadoc.\n\n";
        str = str + "Format:\n";
        str = str + "ClassName : returnType methodName(parameter type)\n\n\n";
        for (String s : set) {
            str = str + s + "\n";
        }
        str = str + "\n\n*/\n\n";
        System.out.println(str);
    }

    public static void printPublicMethodsFor(Class<?> theClass) {
        SkatoloBase.printPublicMethodsFor(theClass, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> theClass) {
        return SkatoloBase.getPublicMethodsFor(theClass, true, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> theClass, String ... thePattern) {
        return SkatoloBase.getPublicMethodsFor(theClass, true, thePattern);
    }

    public static Set<String> getPublicMethodsFor(Class<?> theClass, boolean theFlag) {
        return SkatoloBase.getPublicMethodsFor(theClass, true, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> theClass, boolean isSuperclass, String ... thePattern) {
        TreeSet<String> s = new TreeSet<String>();
        Class<?> c = theClass;
        while (c != null) {
            for (Method method : c.getDeclaredMethods()) {
                if (method.isAnnotationPresent(Deprecated.class) || method.isAnnotationPresent(Skatolo.Invisible.class) || method.getModifiers() != 1) continue;
                for (String p : thePattern) {
                    if (p.length() > 0 && !method.getName().toLowerCase().contains(p.toLowerCase())) continue;
                    String params = "";
                    for (Class<?> t : method.getParameterTypes()) {
                        params = params + t.getSimpleName() + ", ";
                    }
                    if (params.length() > 0) {
                        params = params.substring(0, params.length() - 2);
                    }
                    s.add(c.getCanonicalName() + " : " + method.getReturnType().getSimpleName().replace("Object", theClass.getSimpleName()) + " " + method.getName() + "(" + params + ") ");
                }
            }
            if (isSuperclass) {
                c = c.getSuperclass();
                continue;
            }
            c = null;
        }
        return s;
    }

    public int getKeyCode() {
        return this.skatolo.getWindow().getKeyCode();
    }

    public char getKey() {
        return this.skatolo.getWindow().getKey();
    }

    private char[] fromIntToChar(int ... theChar) {
        char[] n = new char[theChar.length];
        for (int i = 0; i < n.length; ++i) {
            if (theChar[i] >= 97 && theChar[i] <= 122) {
                int n2 = i;
                theChar[n2] = theChar[n2] - 32;
            }
            n[i] = (char)theChar[i];
        }
        return n;
    }

    public Skatolo removeKeyFor(ControlKey theKey, int ... theChar) {
        this.removeKeyFor(theKey, this.fromIntToChar(theChar));
        return this.skatolo;
    }

    public Skatolo mapKeyFor(ControlKey theKey, Object ... os) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (Object o : os) {
            if (o instanceof Integer) {
                l.add((Integer)o);
                continue;
            }
            if (!(o instanceof Character)) continue;
            char c = ((Character)o).charValue();
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            l.add(Integer.valueOf(c));
        }
        char[] n = new char[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            n[i] = (char)((Integer)l.get(i)).intValue();
        }
        KeyCode kc = new KeyCode(n);
        if (!this.keymap.containsKey(kc)) {
            this.keymap.put(kc, new ArrayList());
        }
        this.keymap.get(kc).add(theKey);
        this.skatolo.enableShortcuts();
        return this.skatolo;
    }

    public Skatolo removeKeyFor(ControlKey theKey, char ... theChar) {
        List<ControlKey> l = this.keymap.get(new KeyCode(theChar));
        if (l != null) {
            l.remove(theKey);
        }
        return this.skatolo;
    }

    public Skatolo removeKeysFor(char ... theChar) {
        this.keymap.remove(new KeyCode(theChar));
        return this.skatolo;
    }

    public Skatolo removeKeysFor(int ... theChar) {
        this.removeKeysFor(this.fromIntToChar(theChar));
        return this.skatolo;
    }

    public void updateKeyModifiers(int modifiers) {
        this.keyModifiers = modifiers;
    }

    public boolean isShiftDown() {
        return (this.keyModifiers & 1 & (this.skatolo.areShortcutsEnabled() ? -1 : 1)) != 0;
    }

    public boolean isControlDown() {
        return (this.keyModifiers & 2 & (this.skatolo.areShortcutsEnabled() ? -1 : 1)) != 0;
    }

    public boolean isMetaDown() {
        return (this.keyModifiers & 4 & (this.skatolo.areShortcutsEnabled() ? -1 : 1)) != 0;
    }

    public boolean isAltDown() {
        return (this.keyModifiers & 8 & (this.skatolo.areShortcutsEnabled() ? -1 : 1)) != 0;
    }

    @Deprecated
    public Tab addTab(PApplet theWindow, String theName) {
        return this.addTab(this.skatolo.controlWindow, theName);
    }

    @Deprecated
    public Tab addTab(ControlWindow theWindow, String theName) {
        for (int i = 0; i < theWindow.getTabs().size(); ++i) {
            if (!theWindow.getTabs().get(i).getName().equals(theName)) continue;
            return (Tab)theWindow.getTabs().get(i);
        }
        Tab myTab = new Tab(this.skatolo, theWindow, theName);
        theWindow.getTabs().add(myTab);
        return myTab;
    }

    @Deprecated
    public ControlWindow addControlWindow(String theName, int theX, int theY, int theWidth, int theHeight, String theRenderer, int theFrameRate) {
        return this.addControlWindow(theName);
    }

    @Deprecated
    public ControlWindow addControlWindow(String theWindowName, int theWidth, int theHeight) {
        return this.addControlWindow(theWindowName, 100, 100, theWidth, theHeight, "", 30);
    }

    @Deprecated
    public ControlWindow addControlWindow(String theWindowName, int theX, int theY, int theWidth, int theHeight) {
        return this.addControlWindow(theWindowName, theX, theY, theWidth, theHeight, "", 30);
    }

    @Deprecated
    public ControlWindow addControlWindow(String theWindowName, int theX, int theY, int theWidth, int theHeight, int theFrameRate) {
        return this.addControlWindow(theWindowName, theX, theY, theWidth, theHeight, "", theFrameRate);
    }

    @Deprecated
    public Slider2D addSlider2D(String theName, int theX, int theY, int theW, int theH) {
        return this.addSlider2D(this.skatolo.getObjectForIntrospection(), "", theName, 0.0f, theW, 0.0f, theH, 0.0f, 0.0f, theX, theY, theW, theH);
    }

    @Deprecated
    public Slider2D addSlider2D(Object theObject, String theIndex, String theName, int theX, int theY, int theW, int theH) {
        return this.addSlider2D(theObject, theIndex, theName, 0.0f, theW, 0.0f, theH, 0.0f, 0.0f, theX, theY, theW, theH);
    }

    @Deprecated
    public Slider2D addSlider2D(String theName, float theMinX, float theMaxX, float theMinY, float theMaxY, float theDefaultValueX, float theDefaultValueY, int theX, int theY, int theW, int theH) {
        return this.addSlider2D(this.skatolo.getObjectForIntrospection(), "", theName, theMinX, theMaxX, theMinY, theMaxY, theDefaultValueX, theDefaultValueY, theX, theY, theW, theH);
    }

    @Deprecated
    public Button addButton(String theName, float theValue, int theX, int theY, int theW, int theH) {
        return this.addButton(this.skatolo.getObjectForIntrospection(), "", theName, theValue, theX, theY, theW, theH);
    }

    @Deprecated
    public Bang addBang(String theName, int theX, int theY) {
        return this.addBang(this.skatolo.getObjectForIntrospection(), "", theName, theX, theY, 20, 20);
    }

    @Deprecated
    public Bang addBang(String theName, int theX, int theY, int theWidth, int theHeight) {
        return this.addBang(this.skatolo.getObjectForIntrospection(), "", theName, theX, theY, theWidth, theHeight);
    }

    @Deprecated
    public Toggle addToggle(String theName, boolean theDefaultValue, float theX, float theY, int theWidth, int theHeight) {
        return this.addToggle(this.skatolo.getObjectForIntrospection(), "", theName, theDefaultValue, theX, theY, theWidth, theHeight);
    }

    @Deprecated
    public Toggle addToggle(String theName, float theX, float theY, int theWidth, int theHeight) {
        return this.addToggle(this.skatolo.getObjectForIntrospection(), "", theName, false, theX, theY, theWidth, theHeight);
    }

    @Deprecated
    public Toggle addToggle(Object theObject, String theIndex, String theName, float theX, float theY, int theWidth, int theHeight) {
        return this.addToggle(theObject, theIndex, theName, false, theX, theY, theWidth, theHeight);
    }

    public static class KeyCode {
        final char[] chars;

        public KeyCode(char ... theChars) {
            this.chars = theChars;
            Arrays.sort(this.chars);
        }

        public String toString() {
            String s = "";
            for (char c : this.chars) {
                s = s + c + "(" + c + ") ";
            }
            return s;
        }

        public int size() {
            return this.chars.length;
        }

        public char[] getChars() {
            return this.chars;
        }

        public char get(int theIndex) {
            if (theIndex >= 0 && theIndex < this.size()) {
                return this.chars[theIndex];
            }
            return '\u0000';
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KeyCode)) {
                return false;
            }
            KeyCode k = (KeyCode)obj;
            if (k.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == k.get(i)) continue;
                return false;
            }
            return true;
        }

        boolean contains(char n) {
            for (char c : this.chars) {
                if (n != c) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 0;
            int n = 1;
            for (char c : this.chars) {
                hashCode = (int)((double)hashCode + ((double)c + Math.pow(c, n++)));
            }
            return hashCode;
        }
    }
}

