/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo;

import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PVector;
import tech.lity.rea.skatolo.BitFont;
import tech.lity.rea.skatolo.ControlFont;
import tech.lity.rea.skatolo.ControlKey;
import tech.lity.rea.skatolo.Hacks;
import tech.lity.rea.skatolo.SkatoloBase;
import tech.lity.rea.skatolo.events.CallbackListener;
import tech.lity.rea.skatolo.events.ControlBroadcaster;
import tech.lity.rea.skatolo.events.ControlListener;
import tech.lity.rea.skatolo.events.FieldChangedListener;
import tech.lity.rea.skatolo.file.ControllerProperty;
import tech.lity.rea.skatolo.gui.CColor;
import tech.lity.rea.skatolo.gui.Canvas;
import tech.lity.rea.skatolo.gui.ControlWindow;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.ControllerInterface;
import tech.lity.rea.skatolo.gui.Pointer;
import tech.lity.rea.skatolo.gui.PointerList;
import tech.lity.rea.skatolo.gui.Tooltip;
import tech.lity.rea.skatolo.gui.controllers.Textfield;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;
import tech.lity.rea.skatolo.gui.group.Tab;

public class Skatolo
extends SkatoloBase {
    public ControlWindow controlWindow;
    public static final CColor RETRO = new CColor(-16750196, -16763310, -16211249, -1, -1);
    public static final CColor skatoloBLUE = new CColor(-16683874, -16632755, -16730902, -1, -1);
    public static final CColor RED = new CColor(-5636096, -10092544, -65536, -1, -1);
    public static final CColor WHITE = new CColor(-1711276033, 0x55FFFFFF, -1, -1, -1);
    public static boolean isApplet = false;
    public static CColor DEFAULT_COLOR = new CColor(skatoloBLUE);
    public CColor color = DEFAULT_COLOR;
    private final PApplet papplet;
    private PGraphics graphics;
    private Object objectForIntrospection = null;
    public PGraphics pgraphics;
    public static final String VERSION = "2.1.1";
    public static final int standard58 = 0;
    public static final int standard56 = 1;
    public static final int synt24 = 2;
    public static final int grixel = 3;
    public static final int J2D = 1;
    public static final int P2D = 2;
    public static final int P3D = 3;
    static int renderer = 1;
    public static boolean DEBUG;
    public static final Logger logger;
    private Map<String, ControllerInterface<?>> controllerMap;
    private ControlBroadcaster controlBroadcaster;
    protected ControlWindow window;
    protected Tooltip tooltip;
    public boolean isMoveable = false;
    public boolean isAutoInitialization = false;
    protected boolean isGlobalControllersAlwaysVisible = true;
    public boolean isTabEventsActive;
    protected boolean isUpdate;
    protected static final PFont BitFontStandard56;
    protected static final PFont BitFontStandard58;
    public ControlFont defaultFont = new ControlFont(BitFontStandard58);
    public ControlFont defaultFontForText = new ControlFont(BitFontStandard56);
    protected boolean isControlFont;
    public ControlFont controlFont = this.defaultFont;
    protected boolean shortcutsEnabled = false;
    public boolean isAndroid = false;
    static int welcome;

    public PApplet getPApplet() {
        return this.papplet;
    }

    public PGraphics getGraphics() {
        return this.graphics;
    }

    public Object getObjectForIntrospection() {
        return this.objectForIntrospection;
    }

    public Skatolo(PApplet theParent) {
        this.papplet = theParent;
        this.init();
    }

    public Skatolo(PApplet theParent, PFont thePFont) {
        this.papplet = theParent;
        this.init();
        this.setFont(thePFont);
    }

    public Skatolo(PApplet theParent, ControlFont theControlFont) {
        this.papplet = theParent;
        this.init();
        this.setFont(theControlFont);
    }

    public Skatolo(PApplet theParent, Object objForIntrospection) {
        this.papplet = theParent;
        this.objectForIntrospection = objForIntrospection;
        this.init();
    }

    public Skatolo(PApplet theParent, Object objForIntrospection, PFont thePFont) {
        this.papplet = theParent;
        this.objectForIntrospection = objForIntrospection;
        this.init();
        this.setFont(thePFont);
    }

    public Skatolo(PApplet theParent, Object objForIntrospection, ControlFont theControlFont) {
        this.papplet = theParent;
        this.objectForIntrospection = objForIntrospection;
        this.init();
        this.setFont(theControlFont);
    }

    private void checkIfAndroid() {
        Class<?> check = this.papplet.getClass();
        while (check != null) {
            if ((check = check.getSuperclass()) == null || check.toString().toLowerCase().indexOf("android.app.") <= -1) continue;
            this.isAndroid = true;
            break;
        }
    }

    private void checkGraphics() {
        try {
            if (this.objectForIntrospection == this.papplet) {
                this.graphics = this.papplet.g;
                return;
            }
            Method m = this.objectForIntrospection.getClass().getMethod("getGraphics", new Class[0]);
            this.graphics = (PGraphics)m.invoke(this.objectForIntrospection, new Object[0]);
            System.out.println("Graphics Found !" + this.graphics);
        }
        catch (NoSuchMethodException noMethod) {
            this.graphics = this.papplet.g;
            System.out.println("No Method");
        }
        catch (IllegalAccessException illegal) {
            logger.info("Illegal access to getGraphics(). ");
            System.out.println("Illegal access");
            this.graphics = this.papplet.g;
        }
        catch (IllegalArgumentException illegalArgement) {
            logger.info("Illegal argument in getGraphics(). ");
            System.out.println("Illegal argument");
            this.graphics = this.papplet.g;
        }
        catch (InvocationTargetException invocationTarget) {
            logger.info("Invocation targetException for getGraphics(). ");
            System.out.println("Invocation targetException for getGraphics(). ");
            this.graphics = this.papplet.g;
        }
    }

    protected void init() {
        if (this.objectForIntrospection == null) {
            this.objectForIntrospection = this.papplet;
            System.out.println("No object for introspection, we use PApplet.");
        }
        this.checkGraphics();
        renderer = this.papplet.g.getClass().getCanonicalName().indexOf("Java2D") > -1 ? 1 : 3;
        this.checkIfAndroid();
        this.isTabEventsActive = false;
        this.controlBroadcaster = new ControlBroadcaster(this);
        this.controlWindow = new ControlWindow(this, this.papplet);
        this.papplet.registerMethod("pre", (Object)this);
        this.papplet.registerMethod("dispose", (Object)this);
        this.controllerMap = new TreeMap();
        this.checkWelcomeMessage();
        this.tooltip = new Tooltip(this);
        super.init(this);
        this.setFont(this.defaultFont);
        this.loadDefaultKeyboardShortcuts();
        this.disableShortcuts();
    }

    private void loadDefaultKeyboardShortcuts() {
        this.mapKeyFor(new ControlKey(){

            @Override
            public void keyEvent() {
                Skatolo.this.saveProperties();
            }
        }, 18, 16, Character.valueOf('s'));
        this.mapKeyFor(new ControlKey(){

            @Override
            public void keyEvent() {
                Skatolo.this.loadProperties();
            }
        }, 18, 16, Character.valueOf('l'));
        this.mapKeyFor(new ControlKey(){

            @Override
            public void keyEvent() {
                if (Skatolo.this.controlWindow.isVisible()) {
                    Skatolo.this.hide();
                } else {
                    Skatolo.this.show();
                }
            }
        }, 18, 16, Character.valueOf('h'));
    }

    void checkWelcomeMessage() {
        if (welcome++ < 1) {
            this.welcome();
        }
    }

    private void welcome() {
        System.out.println("skatolo 2.1.1 infos, comments, questions at https://github.com/potioc/skatolo");
    }

    public void setTabEventsActive(boolean theFlag) {
        this.isTabEventsActive = theFlag;
    }

    public void setAutoInitialization(boolean theFlag) {
        this.isAutoInitialization = theFlag;
    }

    public void setAutoDraw(boolean theFlag) {
        if (this.isAutoDraw() && !theFlag) {
            this.controlWindow.papplet().unregisterMethod("draw", (Object)this.controlWindow);
        }
        if (!this.isAutoDraw() && theFlag) {
            this.controlWindow.papplet().registerMethod("draw", (Object)this.controlWindow);
        }
        this.controlWindow.setAutoDraw(theFlag);
    }

    public boolean isAutoDraw() {
        return this.controlWindow.isAutoDraw();
    }

    public ControlBroadcaster getControlBroadcaster() {
        return this.controlBroadcaster;
    }

    public Skatolo addListener(ControlListener ... theListeners) {
        this.getControlBroadcaster().addListener(theListeners);
        return this;
    }

    public Skatolo removeListener(ControlListener ... theListeners) {
        this.getControlBroadcaster().removeListener(theListeners);
        return this;
    }

    public Skatolo removeListener(ControlListener theListener) {
        this.getControlBroadcaster().removeListener(theListener);
        return this;
    }

    public ControlListener getListener(int theIndex) {
        return this.getControlBroadcaster().getListener(theIndex);
    }

    public Skatolo addCallback(CallbackListener ... theListeners) {
        this.getControlBroadcaster().addCallback(theListeners);
        return this;
    }

    public Skatolo addCallback(CallbackListener theListener) {
        this.getControlBroadcaster().addCallback(theListener);
        return this;
    }

    public Skatolo addCallback(CallbackListener theListener, Controller<?> ... theControllers) {
        this.getControlBroadcaster().addCallback(theListener, theControllers);
        return this;
    }

    public Skatolo removeCallback(CallbackListener ... theListeners) {
        this.getControlBroadcaster().removeCallback(theListeners);
        return this;
    }

    public Skatolo removeCallback(Controller<?> ... theControllers) {
        this.getControlBroadcaster().removeCallback(theControllers);
        return this;
    }

    public Skatolo removeCallback(Controller<?> theController) {
        this.getControlBroadcaster().removeCallback(theController);
        return this;
    }

    public void addControlsFor(Object theObject) {
    }

    public Tab getTab(String theName) {
        for (int i = 0; i < this.controlWindow.getTabs().size(); ++i) {
            if (!((Tab)this.controlWindow.getTabs().get(i)).getName().equals(theName)) continue;
            return (Tab)this.controlWindow.getTabs().get(i);
        }
        Tab myTab = this.addTab(theName);
        return myTab;
    }

    public Tab getTab(ControlWindow theWindow, String theName) {
        for (int i = 0; i < theWindow.getTabs().size(); ++i) {
            if (!((Tab)theWindow.getTabs().get(i)).getName().equals(theName)) continue;
            return (Tab)theWindow.getTabs().get(i);
        }
        Tab myTab = theWindow.add(new Tab(this, theWindow, theName));
        return myTab;
    }

    public Skatolo register(Object theObject, String theIndex, ControllerInterface<?> theController) {
        String address = "";
        if (theObject == this.papplet) {
            address = theController.getName().startsWith("/") ? "" : "/";
            address = address + theController.getName();
        } else {
            address = theIndex.length() == 0 || theIndex.startsWith("/") ? "" : "/";
            address = address + theIndex;
            address = address + (theController.getName().startsWith("/") ? "" : "/");
            address = address + theController.getName();
        }
        theController.setAddress(address);
        if (this.checkName(theController.getAddress())) {
            this.remove(theController.getAddress());
        }
        this.controllerMap.put(theController.getAddress(), theController);
        List<ControllerProperty> ps = this.getProperties().get(theController);
        if (ps != null) {
            for (ControllerProperty p : ps) {
                p.setAddress(theController.getAddress());
            }
        }
        theController.init();
        if (theController instanceof Controller) {
            if (theObject == null) {
                theObject = this.papplet;
            }
            if (!theObject.equals(this.papplet)) {
                ((Controller)((Controller)theController).unplugFrom(this.papplet)).plugTo(theObject);
            }
            if (!this.objectToControllerMap.containsKey(theObject)) {
                this.objectToControllerMap.put(theObject, new ArrayList());
            }
            ((ArrayList)this.objectToControllerMap.get(theObject)).add(theController);
        }
        return this;
    }

    public List<ControllerInterface<?>> getAll() {
        return new ArrayList(this.controllerMap.values());
    }

    public <T> List<T> getAll(Class<T> theClass) {
        ArrayList l = new ArrayList();
        for (ControllerInterface<?> ci : this.controllerMap.values()) {
            if (ci.getClass() != theClass && ci.getClass().getSuperclass() != theClass) continue;
            l.add(ci);
        }
        return l;
    }

    protected void deactivateControllers() {
        for (Textfield t : this.getAll(Textfield.class)) {
            t.setFocus(false);
        }
    }

    private String checkAddress(String theName) {
        if (!theName.startsWith("/")) {
            return "/" + theName;
        }
        return theName;
    }

    public void printControllerMap() {
        ArrayList<String> strs = new ArrayList<String>();
        System.out.println("============================================");
        for (Map.Entry<String, ControllerInterface<?>> entry : this.controllerMap.entrySet()) {
            String key = entry.getKey();
            ControllerInterface<?> value = entry.getValue();
            strs.add(key + " = " + value);
        }
        Collections.sort(strs);
        for (String s : strs) {
            System.out.println(s);
        }
        System.out.println("============================================");
    }

    protected void remove(ControllerInterface<?> theController) {
        this.controllerMap.remove(theController.getAddress());
    }

    public void remove(String theName) {
        String address = this.checkAddress(theName);
        if (this.getController(address) != null) {
            this.getController(address).remove();
        }
        if (this.getGroup(address) != null) {
            this.getGroup(address).remove();
        }
        for (int i = 0; i < this.controlWindow.getTabs().size(); ++i) {
            if (!this.controlWindow.getTabs().get(i).getAddress().equals(address)) continue;
            this.controlWindow.getTabs().get(i).remove();
        }
        this.controllerMap.remove(address);
    }

    public ControllerInterface<?> get(String theName) {
        String address = this.checkAddress(theName);
        if (this.controllerMap.containsKey(address)) {
            return this.controllerMap.get(address);
        }
        return null;
    }

    public <C> C get(Class<C> theClass, String theName) {
        for (ControllerInterface<?> ci : this.controllerMap.values()) {
            if (ci.getClass() != theClass && ci.getClass().getSuperclass() != theClass) continue;
            return (C)this.get(theName);
        }
        return null;
    }

    public List<ControllerInterface<?>> getList() {
        LinkedList l = new LinkedList();
        l.addAll(this.controlWindow.getTabs().get());
        l.addAll(this.getAll());
        return l;
    }

    public float getValue(String theIndex) {
        Controller<?> c = this.getController(theIndex);
        if (c != null) {
            return c.getValue();
        }
        return Float.NaN;
    }

    public Controller<?> getController(String theName) {
        String address = this.checkAddress(theName);
        if (this.controllerMap.containsKey(address) && this.controllerMap.get(address) instanceof Controller) {
            return (Controller)this.controllerMap.get(address);
        }
        return null;
    }

    public ControllerGroup<?> getGroup(String theGroupName) {
        String address = this.checkAddress(theGroupName);
        if (this.controllerMap.containsKey(address) && this.controllerMap.get(address) instanceof ControllerGroup) {
            return (ControllerGroup)this.controllerMap.get(address);
        }
        return null;
    }

    private boolean checkName(String theName) {
        if (this.controllerMap.containsKey(this.checkAddress(theName))) {
            Skatolo.logger().warning("Controller with name \"" + theName + "\" already exists. overwriting reference of existing controller.");
            return true;
        }
        return false;
    }

    public void moveControllersForObject(Object theObject, ControllerGroup<?> theGroup) {
        if (this.objectToControllerMap.containsKey(theObject)) {
            ArrayList cs = (ArrayList)this.objectToControllerMap.get(theObject);
            for (ControllerInterface c : cs) {
                ((Controller)c).moveTo(theGroup);
            }
        }
    }

    public void move(Object theObject, ControllerGroup<?> theGroup) {
        this.moveControllersForObject(theObject, theGroup);
    }

    protected void clear() {
        this.controlWindow.clear();
        this.controllerMap.clear();
    }

    public void pre() {
        Iterator itr = this.fieldChangedListenerMap.values().iterator();
        while (itr.hasNext()) {
            ((FieldChangedListener)itr.next()).update();
        }
    }

    public void draw() {
        if (!this.isAutoDraw()) {
            this.controlWindow.draw();
        }
    }

    public void draw(PGraphics graphics) {
        if (!this.isAutoDraw()) {
            this.controlWindow.draw(graphics);
        }
    }

    public void setGraphics(PGraphics graphics) {
        this.graphics = graphics;
    }

    public ControlWindow getWindow() {
        return this.getWindow(this.papplet);
    }

    public Pointer addPointer(int id) {
        return this.controlWindow.getPointers().addPointer(id);
    }

    public void updatePointer(int id, int x, int y) {
        try {
            this.controlWindow.getPointers().updatePointer(id, x, y);
        }
        catch (IllegalArgumentException exception) {
            System.out.println("Invalid pointer " + id + ". Update not done. ");
        }
    }

    public void updatePointerPress(int id, boolean pressed) {
        try {
            this.controlWindow.getPointers().updatePointer(id, pressed);
        }
        catch (IllegalArgumentException exception) {
            System.out.println("Invalid pointer " + id + ". Update not done. ");
        }
    }

    public void removePointer(int id) {
        this.controlWindow.getPointers().removePointer(id);
    }

    public PointerList getPointers() {
        return this.controlWindow.getPointers();
    }

    public Collection<Pointer> getPointerList() {
        return this.controlWindow.getPointers().values();
    }

    public Pointer getMousePointer() {
        return this.controlWindow.getMousePointer();
    }

    public int getMouseX() {
        return this.controlWindow.getPointerX();
    }

    public int getMouseY() {
        return this.controlWindow.getPointerY();
    }

    public boolean isMouseOver() {
        return this.getWindow(this.papplet).isMouseOver();
    }

    public boolean isMouseOver(ControllerInterface<?> theController) {
        return this.getWindow(this.papplet).isMouseOver(theController);
    }

    public List<ControllerInterface<?>> getMouseOverList() {
        return this.getWindow(this.papplet).getMouseOverList();
    }

    public ControlWindow getWindow(PApplet theApplet) {
        if (theApplet.equals(this.papplet)) {
            return this.controlWindow;
        }
        return this.controlWindow;
    }

    public Skatolo addCanvas(Canvas theCanvas) {
        this.getWindow().addCanvas(theCanvas);
        return this;
    }

    public Skatolo removeCanvas(Canvas theCanvas) {
        this.getWindow().removeCanvas(theCanvas);
        return this;
    }

    public Skatolo setColor(CColor theColor) {
        this.setColorBackground(theColor.getBackground());
        this.setColorForeground(theColor.getForeground());
        this.setColorActive(theColor.getActive());
        this.setColorCaptionLabel(theColor.getCaptionLabel());
        this.setColorValueLabel(theColor.getValueLabel());
        return this;
    }

    public CColor getColor() {
        return this.color;
    }

    public Skatolo setColorActive(int theColor) {
        this.color.setActive(theColor);
        this.controlWindow.setColorActive(theColor);
        return this;
    }

    public Skatolo setColorForeground(int theColor) {
        this.color.setForeground(theColor);
        this.controlWindow.setColorForeground(theColor);
        return this;
    }

    public Skatolo setColorBackground(int theColor) {
        this.color.setBackground(theColor);
        this.controlWindow.setColorBackground(theColor);
        return this;
    }

    public Skatolo setColorCaptionLabel(int theColor) {
        this.color.setCaptionLabel(theColor);
        this.controlWindow.setColorLabel(theColor);
        return this;
    }

    public Skatolo setColorValueLabel(int theColor) {
        this.color.setValueLabel(theColor);
        this.controlWindow.setColorValue(theColor);
        return this;
    }

    public Skatolo setMoveable(boolean theFlag) {
        this.isMoveable = theFlag;
        return this;
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public boolean saveProperties() {
        return this.properties.save();
    }

    public boolean saveProperties(String theFilePath) {
        return this.properties.saveAs(theFilePath);
    }

    public boolean saveProperties(String theFilePath, String ... theSets) {
        return this.properties.saveAs(theFilePath, theSets);
    }

    public boolean loadProperties() {
        return this.properties.load();
    }

    public boolean loadProperties(String theFilePath) {
        File f = new File(theFilePath = this.checkPropertiesPath(theFilePath));
        if (f.exists()) {
            return this.properties.load(theFilePath);
        }
        f = new File(theFilePath = this.checkPropertiesPath(theFilePath + ".ser"));
        if (f.exists()) {
            return this.properties.load(theFilePath);
        }
        logger.info("Properties File " + theFilePath + " does not exist.");
        return false;
    }

    public String checkPropertiesPath(String theFilePath) {
        theFilePath = theFilePath.startsWith("/") || theFilePath.startsWith(".") ? theFilePath : this.papplet.sketchPath(theFilePath);
        return theFilePath;
    }

    public boolean loadLayout(String theFilePath) {
        File f = new File(theFilePath = this.checkPropertiesPath(theFilePath));
        if (f.exists()) {
            this.getLayout().load(theFilePath);
            return true;
        }
        logger.info("Layout File " + theFilePath + " does not exist.");
        return false;
    }

    public void saveLayout(String theFilePath) {
        this.getLayout().save(theFilePath);
    }

    public String version() {
        return VERSION;
    }

    public void show() {
        this.controlWindow.show();
    }

    public Skatolo setBroadcast(boolean theValue) {
        this.controlBroadcaster.broadcast = theValue;
        return this;
    }

    public boolean isVisible() {
        return this.controlWindow.isVisible();
    }

    public void hide() {
        this.controlWindow.hide();
    }

    public void update() {
        this.controlWindow.update();
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setUpdate(boolean theFlag) {
        this.isUpdate = theFlag;
        this.controlWindow.setUpdated(theFlag);
    }

    @Deprecated
    public boolean setFont(int theBitFontIndex) {
        logger.warning("BitFont is now of type PFont, use setFont(PFont) instead.");
        return false;
    }

    public boolean setFont(ControlFont theControlFont) {
        this.controlFont = theControlFont;
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    public boolean setFont(PFont thePFont, int theFontSize) {
        this.controlFont = new ControlFont(thePFont, theFontSize);
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    public boolean setFont(PFont thePFont) {
        this.controlFont = new ControlFont(thePFont);
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    protected void updateFont(ControlFont theControlFont) {
        this.controlWindow.updateFont(theControlFont);
    }

    public ControlFont getFont() {
        return this.controlFont;
    }

    public void disableShortcuts() {
        this.shortcutsEnabled = false;
    }

    public void enableShortcuts() {
        this.shortcutsEnabled = true;
    }

    public boolean areShortcutsEnabled() {
        return this.shortcutsEnabled;
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(Tooltip theTooltip) {
        this.tooltip = theTooltip;
    }

    public void setMouseWheelRotation(int theRotation) {
        this.getWindow().setMouseWheelRotation(theRotation);
    }

    public ControllerGroup<?> begin() {
        return this.begin(this.controlWindow.getTab("default"));
    }

    public ControllerGroup<?> begin(ControllerGroup<?> theGroup) {
        this.setCurrentPointer(theGroup);
        return theGroup;
    }

    public ControllerGroup<?> begin(int theX, int theY) {
        return this.begin(this.controlWindow.getTab("default"), theX, theY);
    }

    public ControllerGroup<?> begin(ControllerGroup<?> theGroup, int theX, int theY) {
        this.setCurrentPointer(theGroup);
        theGroup.autoPosition.x = theX;
        theGroup.autoPosition.y = theY;
        theGroup.autoPositionOffsetX = theX;
        return theGroup;
    }

    public ControllerGroup<?> begin(ControlWindow theWindow) {
        return this.begin(theWindow.getTab("default"));
    }

    public ControllerGroup<?> begin(ControlWindow theWindow, int theX, int theY) {
        return this.begin(theWindow.getTab("default"), theX, theY);
    }

    public ControllerGroup<?> end(ControllerGroup<?> theGroup) {
        this.releaseCurrentPointer(theGroup);
        return theGroup;
    }

    public ControllerGroup<?> end() {
        return this.end(this.controlWindow.getTab("default"));
    }

    public void addPositionTo(int theX, int theY, List<ControllerInterface<?>> theControllers) {
        PVector v = new PVector((float)theX, (float)theY);
        for (ControllerInterface<?> c : theControllers) {
            c.setPosition(PVector.add((PVector)c.getPosition(), (PVector)v));
        }
    }

    public void addPositionTo(int theX, int theY, ControllerInterface<?> ... theControllers) {
        this.addPositionTo(theX, theY, Arrays.asList(theControllers));
    }

    public void dispose() {
        if (!isApplet) {
            this.clear();
        }
    }

    public void delete() {
        this.papplet.unregisterMethod("pre", (Object)this);
        this.papplet.unregisterMethod("draw", (Object)this);
        this.papplet.unregisterMethod("dispose", (Object)this);
        this.controlWindow.delete();
    }

    public static Logger logger() {
        return logger;
    }

    static {
        logger = Logger.getLogger(Skatolo.class.getName());
        BitFontStandard56 = new BitFont(Hacks.decodeBase64("AeYACQBgACAEAgQGBggHAgMDBgYDBQIFBgMGBgYGBgYGBgIDBAYEBggGBgYGBgYGBgIGBgUIBgYGBgYGBgYGCAYGBgMFAwYHAwUFBQUFAwUFAgMFAggFBQUFBAQEBQUIBQUFBAMEBQKgUgghRwoBAIAcOQ7yOZ/jAADAAXAe5/k+JwqKQlDkPM7jfFGUFEXfwghAQAAICIQUAgAAAAABAAAAQAkVqBSvJFJUEQCQaFHEBBEURQAAiDiiKIqCIIqCkjAWRVEURUQUJUURFCEFIBAAAgEBhAAAAABAAAAAAEikBIIvkFAQOQQAJBIEKU8ARVGiLyCRKAqiIAiioCJUTVEURQERRUmKgkQoAsAd40zcSambY447u5SSUnoSAYBAcRBMRNWHh4iEMAn0II4HBBAk6XuC6HmyL2gISVX0RI9DREoSQRAhAgBIKaW0lFIpKaWUIiSlpJRQhAAg+CCSFBFBACAiEdAHRUgEgfiIqIqiIAqCKAoqQlAWBVEBEZGSpBBCiAAAUgrpJaU0SkoppRBJKckkIxEAAJRHKkIEEACESEKERBERRUEAAVKiKIqCIIqKkhAURUGUREREJEVEECQAgJRSCkkplZJSSilIUkpKKUgEAAKFCHGhAIBAwdHnII5DOA4iIAiB6HGeL3CinOgFRU7gRA7hEDYR8QUJ+MEd40xcSqmkZI6LEWdsknsSAQAAAAAAAAAgAAAAAAAAAACAAACAAwAAAAAAAAAAAAAAQAAAAAAAAAADAwAAAAAABBAAAICAAAAAAIAAJQAAAAAAAAAABAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAACAAAgIAAAAAAYAAA="));
        BitFontStandard58 = new BitFont(Hacks.decodeBase64("AakACQBgACAEAgQGBggGAgMDBAYDBAIGBQMFBQUFBQUFBQICBAUEBQgFBQUFBQUFBQIFBQQGBQUFBQUFBAUGCAUGBQMFAwYGAwQEBAQEBAQEAgQEAgYEBAQEAwQEBAQGBAQEBAIEBQKgUgghIaUAAIiRMeiZZwwAAANgjjnvmRRKESVzzDGXoqQUvYURQCCAQCCSCAAAAAgAAABEqECleCVFkRAAiLSUWEgoJQAAiSOllEJIKVRiSymllCRFSSlCEVIAQQBBQAARAAAAEAAAACQpgeALJASiIwAQSQipE1BKRS+QSEohhRBSqES1UkopSIqSkkIiFAGwEZOwSaplZGx2VVXVSQIAgeIgSETy4RCSCEnoEONAgJCkd0I6p73QiKilk46RpCQZQoQIAFBVVVOVVFVVVUKqqiqKCACCDyKpiIoAICQJ9FAiCUE8ElUphRRCSqESUUohJSRJSUpECBEAoCrqoiqZqqqqiFRVUiIJAADKI5UQASEgSAoJpSRSCgECUlJKKYSUSiWilEJKSRKRlIgQJABAVVVEVVJVVVUhqaqqQhIACBQixEIBQFBg9AwyRhhDBEIIpGPOCyZl0kXJBJOMGMImEW9owAcbMQmrpKpKxjJiopQdFQAAAAAAAABAAAAAAAAAAIAAAOAAAAAAAAAAAAAACAAAAAAAAAAAAAAAAAQIAAAEAQAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAgAAAgCAAAAAgAA"));
        welcome = 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Layout {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Invisible {
    }
}

