/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;
import java.util.List;
import processing.core.PVector;
import tech.lity.rea.skatolo.Skatolo;

public class Hacks {
    private static final String fSTART_CHAR = "[";
    private static final String fEND_CHAR = "]";
    private static final String fSEPARATOR = ", ";
    private static final String fNULL = "null";

    public static String forURL(String aURLFragment) {
        String result = null;
        try {
            result = URLEncoder.encode(aURLFragment, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public static String forHTMLTag(String aTagFragment) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(aTagFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '\\') {
                result.append("&#092;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    String URLEncode(String string) {
        String output = new String();
        try {
            byte[] input = string.getBytes("UTF-8");
            for (int i = 0; i < input.length; ++i) {
                if (input[i] < 0) continue;
                output = input[i] == 32 ? output + '+' : output + (char)input[i];
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return output;
    }

    public static String replace(String theSourceString, String theSearchForString, String theReplaceString) {
        if (theSourceString.length() < 1) {
            return "";
        }
        for (int p = 0; p < theSourceString.length() && (p = theSourceString.indexOf(theSearchForString, p)) >= 0; p += theReplaceString.length()) {
            theSourceString = theSourceString.substring(0, p) + theReplaceString + theSourceString.substring(p + theSearchForString.length(), theSourceString.length());
        }
        return theSourceString;
    }

    public static int parseHex(String theHex) {
        int myLen = theHex.length();
        switch (myLen) {
            case 8: {
                break;
            }
            case 6: {
                theHex = "ff" + theHex;
                break;
            }
            default: {
                theHex = "ff000000";
            }
        }
        int a = new Integer(Integer.parseInt(theHex.substring(0, 2), 16));
        int r = new Integer(Integer.parseInt(theHex.substring(2, 4), 16));
        int g = new Integer(Integer.parseInt(theHex.substring(4, 6), 16));
        int b = new Integer(Integer.parseInt(theHex.substring(6, 8), 16));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static String intToString(int theInt) {
        int a = theInt >> 24 & 0xFF;
        int r = theInt >> 16 & 0xFF;
        int g = theInt >> 8 & 0xFF;
        int b = theInt >> 0 & 0xFF;
        String sa = Integer.toHexString(a).length() == 1 ? "0" + Integer.toHexString(a) : Integer.toHexString(a);
        String sr = Integer.toHexString(r).length() == 1 ? "0" + Integer.toHexString(r) : Integer.toHexString(r);
        String sg = Integer.toHexString(g).length() == 1 ? "0" + Integer.toHexString(g) : Integer.toHexString(g);
        String sb = Integer.toHexString(b).length() == 1 ? "0" + Integer.toHexString(b) : Integer.toHexString(b);
        return sa + sr + sg + sb;
    }

    @Deprecated
    protected boolean save(Skatolo theskatolo, String theFilePath) {
        Skatolo.logger().info("Saving skatolo settings in XML format has been removed, have a look at skatolo's properties instead.");
        return false;
    }

    public static String arrayToString(Object aArray) {
        if (aArray == null) {
            return fNULL;
        }
        Hacks.checkObjectIsArray(aArray);
        StringBuilder result = new StringBuilder(fSTART_CHAR);
        int length = Array.getLength(aArray);
        for (int idx = 0; idx < length; ++idx) {
            Object item = Array.get(aArray, idx);
            if (Hacks.isNonNullArray(item)) {
                result.append(Hacks.arrayToString(item));
            } else {
                result.append(item);
            }
            if (Hacks.isLastItem(idx, length)) continue;
            result.append(fSEPARATOR);
        }
        result.append(fEND_CHAR);
        return result.toString();
    }

    private static void checkObjectIsArray(Object aArray) {
        if (!aArray.getClass().isArray()) {
            throw new IllegalArgumentException("Object is not an array.");
        }
    }

    private static boolean isNonNullArray(Object aItem) {
        return aItem != null && aItem.getClass().isArray();
    }

    private static boolean isLastItem(int aIdx, int aLength) {
        return aIdx == aLength - 1;
    }

    public static String formatGetClass(Class<?> c) {
        if (c == null) {
            return null;
        }
        String pattern = "class ";
        return c.toString().startsWith("class ") ? c.toString().substring("class ".length()) : c.toString();
    }

    public static boolean inside(int[] theRect, PVector theVector) {
        return Hacks.inside(theRect, theVector.x, theVector.y);
    }

    public static boolean inside(int[] theRect, float theX, float theY) {
        if (theRect.length == 4) {
            return theX > (float)theRect[0] && theX < (float)theRect[2] && theY > (float)theRect[1] && theY < (float)theRect[3];
        }
        return false;
    }

    public static String encodeBase64(byte[] raw) {
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < raw.length; i += 3) {
            encoded.append(Hacks.encodeBlock(raw, i));
        }
        return encoded.toString();
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        for (int i = 0; i <= end; ++i) {
            int b = raw[offset + i];
            int neuter = b < 0 ? b + 256 : b;
            block += neuter << 8 * (2 - i);
        }
        char[] base64 = new char[4];
        for (int i = 0; i < 4; ++i) {
            int sixbit = block >>> 6 * (3 - i) & 0x3F;
            base64[i] = Hacks.getBase64Char(sixbit);
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    static char getBase64Char(int sixBit) {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '+';
        }
        if (sixBit == 63) {
            return '/';
        }
        return '?';
    }

    public static byte[] decodeBase64(String base64) {
        int pad = 0;
        int i = base64.length() - 1;
        while (base64.charAt(i) == '=') {
            ++pad;
            --i;
        }
        int length = base64.length() * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawIndex = 0;
        for (int i2 = 0; i2 < base64.length(); i2 += 4) {
            int block = (Hacks.getBase64Value(base64.charAt(i2)) << 18) + (Hacks.getBase64Value(base64.charAt(i2 + 1)) << 12) + (Hacks.getBase64Value(base64.charAt(i2 + 2)) << 6) + Hacks.getBase64Value(base64.charAt(i2 + 3));
            for (int j = 0; j < 3 && rawIndex + j < raw.length; ++j) {
                raw[rawIndex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
            }
            rawIndex += 3;
        }
        return raw;
    }

    static int getBase64Value(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        return -1;
    }

    public static int getBit(int theByte, int theIndex) {
        int bitmask = 1 << theIndex;
        return (theByte & bitmask) > 0 ? 1 : 0;
    }

    public static byte setHigh(byte theByte, int theIndex) {
        return (byte)(theByte | 1 << theIndex);
    }

    public static byte setLow(byte theByte, int theIndex) {
        return (byte)(theByte & ~(1 << theIndex));
    }

    public static byte[] intToByteArray(int a) {
        byte[] ret = new byte[2];
        ret[1] = (byte)(a & 0xFF);
        ret[0] = (byte)(a >> 8 & 0xFF);
        return ret;
    }

    public static int byteArrayToInt(byte[] b) {
        int value = 0;
        for (int i = 0; i < 2; ++i) {
            int shift = (1 - i) * 8;
            value += (b[i] & 0xFF) << shift;
        }
        return value;
    }

    public static String join(List<String> list, String delimiter) {
        StringBuilder b = new StringBuilder();
        for (String item : list) {
            b.append(item).append(delimiter);
        }
        return b.toString();
    }
}

