/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import tech.lity.rea.skatolo.gui.Label;

public class ControlFont {
    public static boolean DEBUG = false;
    public static boolean RENDER_2X;
    PFont pfont;
    List<String> txt;
    String s = "";
    private int top;
    private int bottom;
    private int center;
    private int height;
    private int width;
    private int baseline = 0;
    private int textHeight = 1;
    private int[] offset = new int[2];
    private int size;

    public static void sharp() {
        RENDER_2X = true;
    }

    public static void normal() {
        RENDER_2X = false;
    }

    public ControlFont(PFont theFont) {
        this(theFont, ControlFont.checkFontSize(theFont));
    }

    public ControlFont(PFont theFont, int theFontSize) {
        this(theFont, theFontSize, theFontSize + 2);
    }

    public ControlFont(PFont theFont, int theFontSize, int theLineHeight) {
        this.pfont = theFont;
        this.size = theFontSize;
        this.txt = new ArrayList<String>();
    }

    private static int checkFontSize(PFont theFont) {
        try {
            return theFont.getSize();
        }
        catch (NullPointerException e) {
            System.out.println("skatolo: could not find font-size details for font " + theFont.getName() + ", use constructor ControlFont(PFont theFont, int theFontSize) to specify the font size.");
            return 10;
        }
    }

    public void init(Label theLabel) {
    }

    public void setSize(int theSize) {
        this.size = theSize;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset(int theIndex) {
        return this.offset[theIndex];
    }

    public int getTextHeight() {
        return this.textHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getCenter() {
        return this.center;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getBaseline() {
        return this.baseline;
    }

    public PFont getFont() {
        return this.pfont;
    }

    public void adjust(PApplet theApplet, Label theLabel) {
        if (theLabel.isChanged()) {
            theApplet.textFont(this.pfont, (float)this.size);
            this.top = -((int)theApplet.textAscent());
            this.bottom = (int)theApplet.textDescent();
            this.center = -((-this.top - this.bottom) / 2);
            this.height = theLabel.isMultiline() ? theLabel.getHeight() : (int)(theApplet.textAscent() + theApplet.textDescent());
            int n = this.width = theLabel.isMultiline() ? theLabel.getWidth() : (int)theApplet.textWidth(theLabel.getTextFormatted());
            if (theLabel.isMultiline()) {
                this.calculateHeight(theApplet, theLabel);
            }
            theLabel.setChanged(false);
        }
    }

    private void calculateHeight(PApplet theApplet, Label theLabel) {
        this.txt.clear();
        String myString = theLabel.getTextFormatted();
        List<String> paragraphs = Arrays.asList(myString.split("\n"));
        myString = "";
        for (String p : paragraphs) {
            List<String> words = Arrays.asList(p.split("\\s"));
            for (String w : words) {
                StringBuilder stringBuilder = new StringBuilder();
                if (theApplet.textWidth(stringBuilder.append(myString).append(w).toString()) < (float)this.width) {
                    myString = myString + w + " ";
                    continue;
                }
                this.txt.add(myString.substring(0, PApplet.max((int)0, (int)(myString.length() - 1))));
                myString = w + " ";
            }
            this.txt.add(myString.substring(0, myString.length() - 1));
            myString = "";
        }
        if (theLabel.getHeight() % theLabel.getLineHeight() != 0) {
            this.txt.add("");
        }
        this.textHeight = PApplet.round((float)(this.txt.size() * theLabel.getLineHeight()));
        int maxLineNum = PApplet.round((float)(theLabel.getHeight() / theLabel.getLineHeight()));
        int offset = (int)((float)PApplet.max((int)0, (int)(this.txt.size() - maxLineNum)) * PApplet.abs((float)theLabel.getOffsetYratio()));
        int lim = PApplet.min((int)this.txt.size(), (int)maxLineNum);
        this.s = "";
        for (int i = 0; i < lim; ++i) {
            this.s = this.s + this.txt.get(i + offset) + "\n";
        }
    }

    public void adjust(PGraphics graphics, Label theLabel) {
        if (theLabel.isChanged()) {
            graphics.textFont(this.pfont, (float)this.size);
            this.top = -((int)graphics.textAscent());
            this.bottom = (int)graphics.textDescent();
            this.center = -((-this.top - this.bottom) / 2);
            this.height = theLabel.isMultiline() ? theLabel.getHeight() : (int)(graphics.textAscent() + graphics.textDescent());
            int n = this.width = theLabel.isMultiline() ? theLabel.getWidth() : (int)graphics.textWidth(theLabel.getTextFormatted());
            if (theLabel.isMultiline()) {
                this.calculateHeight(graphics, theLabel);
            }
            theLabel.setChanged(false);
        }
    }

    private void calculateHeight(PGraphics graphics, Label theLabel) {
        this.txt.clear();
        String myString = theLabel.getTextFormatted();
        List<String> paragraphs = Arrays.asList(myString.split("\n"));
        myString = "";
        for (String p : paragraphs) {
            List<String> words = Arrays.asList(p.split("\\s"));
            for (String w : words) {
                StringBuilder stringBuilder = new StringBuilder();
                if (graphics.textWidth(stringBuilder.append(myString).append(w).toString()) < (float)this.width) {
                    myString = myString + w + " ";
                    continue;
                }
                this.txt.add(myString.substring(0, PApplet.max((int)0, (int)(myString.length() - 1))));
                myString = w + " ";
            }
            this.txt.add(myString.substring(0, myString.length() - 1));
            myString = "";
        }
        if (theLabel.getHeight() % theLabel.getLineHeight() != 0) {
            this.txt.add("");
        }
        this.textHeight = PApplet.round((float)(this.txt.size() * theLabel.getLineHeight()));
        int maxLineNum = PApplet.round((float)(theLabel.getHeight() / theLabel.getLineHeight()));
        int offset = (int)((float)PApplet.max((int)0, (int)(this.txt.size() - maxLineNum)) * PApplet.abs((float)theLabel.getOffsetYratio()));
        int lim = PApplet.min((int)this.txt.size(), (int)maxLineNum);
        this.s = "";
        for (int i = 0; i < lim; ++i) {
            this.s = this.s + this.txt.get(i + offset) + "\n";
        }
    }

    public int getOverflow() {
        return this.textHeight - this.height;
    }

    public static int getWidthFor(String theText, Label theLabel, PApplet theApplet) {
        theApplet.textFont(theLabel.getFont().pfont, (float)theLabel.getFont().size);
        return (int)theApplet.textWidth(theText);
    }

    public void draw(PGraphics graphics, Label theLabel) {
        PFont loadedFont = graphics.textFont;
        float loadedSize = graphics.textSize;
        if (loadedFont == null) {
            graphics.textSize(loadedSize);
            loadedFont = graphics.textFont;
        }
        int loadedAlign = graphics.textAlign;
        graphics.textFont(this.pfont, (float)this.size);
        graphics.textAlign(theLabel.textAlign);
        graphics.fill(theLabel.getColor());
        if (theLabel.isMultiline()) {
            graphics.fill(theLabel.getColor());
            graphics.textLeading((float)theLabel.getLineHeight());
            graphics.text(this.s, 0.0f, 0.0f, (float)theLabel.getWidth(), (float)theLabel.getHeight());
        } else {
            graphics.translate(0.0f, (float)(-this.top + 1));
            this.debug(graphics, theLabel);
            graphics.fill(theLabel.getColor());
            graphics.textLeading((float)theLabel.getLineHeight());
            graphics.text(theLabel.getTextFormatted(), 0.0f, 0.0f);
            if (RENDER_2X) {
                graphics.text(theLabel.getTextFormatted(), 0.0f, 0.0f);
            }
        }
        graphics.textFont(loadedFont, loadedSize);
        graphics.textAlign(loadedAlign);
    }

    private void debug(PGraphics graphics, Label theLabel) {
        if (DEBUG) {
            graphics.stroke(0.0f, 255.0f, 0.0f);
            graphics.line(0.0f, (float)this.getBaseline(), graphics.textWidth(theLabel.getText()), (float)this.getBaseline());
            graphics.stroke(0.0f, 0.0f, 255.0f);
            graphics.line(0.0f, (float)this.getTop(), graphics.textWidth(theLabel.getText()), (float)this.getTop());
            graphics.stroke(255.0f, 255.0f, 0.0f);
            graphics.line(0.0f, (float)this.getBottom(), graphics.textWidth(theLabel.getText()), (float)this.getBottom());
            graphics.stroke(255.0f, 0.0f, 0.0f);
            graphics.line(0.0f, (float)this.getCenter(), graphics.textWidth(theLabel.getText()), (float)this.getCenter());
            graphics.stroke(255.0f, 128.0f, 0.0f);
            graphics.line(0.0f, (float)(this.getTop() / 2), graphics.textWidth(theLabel.getText()), (float)(this.getTop() / 2));
            graphics.noStroke();
        }
    }

    public static int getWidthFor(String theText, Label theLabel, PGraphics graphics) {
        graphics.textFont(theLabel.getFont().pfont, (float)theLabel.getFont().size);
        return (int)graphics.textWidth(theText);
    }
}

