/*
 * Decompiled with CFR 0.152.
 */
package tech.lity.rea.skatolo;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import processing.core.PFont;
import processing.core.PImage;
import tech.lity.rea.skatolo.Hacks;

public class BitFont
extends PFont {
    public static final String standard58base64 = "AakACQBgACAEAgQGBggGAgMDBAYDBAIGBQMFBQUFBQUFBQICBAUEBQgFBQUFBQUFBQIFBQQGBQUFBQUFBAUGCAUGBQMFAwYGAwQEBAQEBAQEAgQEAgYEBAQEAwQEBAQGBAQEBAIEBQKgUgghIaUAAIiRMeiZZwwAAANgjjnvmRRKESVzzDGXoqQUvYURQCCAQCCSCAAAAAgAAABEqECleCVFkRAAiLSUWEgoJQAAiSOllEJIKVRiSymllCRFSSlCEVIAQQBBQAARAAAAEAAAACQpgeALJASiIwAQSQipE1BKRS+QSEohhRBSqES1UkopSIqSkkIiFAGwEZOwSaplZGx2VVXVSQIAgeIgSETy4RCSCEnoEONAgJCkd0I6p73QiKilk46RpCQZQoQIAFBVVVOVVFVVVUKqqiqKCACCDyKpiIoAICQJ9FAiCUE8ElUphRRCSqESUUohJSRJSUpECBEAoCrqoiqZqqqqiFRVUiIJAADKI5UQASEgSAoJpSRSCgECUlJKKYSUSiWilEJKSRKRlIgQJABAVVVEVVJVVVUhqaqqQhIACBQixEIBQFBg9AwyRhhDBEIIpGPOCyZl0kXJBJOMGMImEW9owAcbMQmrpKpKxjJiopQdFQAAAAAAAABAAAAAAAAAAIAAAOAAAAAAAAAAAAAACAAAAAAAAAAAAAAAAAQIAAAEAQAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAgAAAgCAAAAAgAA";
    public static final String standard56base64 = "AeYACQBgACAEAgQGBggHAgMDBgYDBQIFBgMGBgYGBgYGBgIDBAYEBggGBgYGBgYGBgIGBgUIBgYGBgYGBgYGCAYGBgMFAwYHAwUFBQUFAwUFAgMFAggFBQUFBAQEBQUIBQUFBAMEBQKgUgghRwoBAIAcOQ7yOZ/jAADAAXAe5/k+JwqKQlDkPM7jfFGUFEXfwghAQAAICIQUAgAAAAABAAAAQAkVqBSvJFJUEQCQaFHEBBEURQAAiDiiKIqCIIqCkjAWRVEURUQUJUURFCEFIBAAAgEBhAAAAABAAAAAAEikBIIvkFAQOQQAJBIEKU8ARVGiLyCRKAqiIAiioCJUTVEURQERRUmKgkQoAsAd40zcSambY447u5SSUnoSAYBAcRBMRNWHh4iEMAn0II4HBBAk6XuC6HmyL2gISVX0RI9DREoSQRAhAgBIKaW0lFIpKaWUIiSlpJRQhAAg+CCSFBFBACAiEdAHRUgEgfiIqIqiIAqCKAoqQlAWBVEBEZGSpBBCiAAAUgrpJaU0SkoppRBJKckkIxEAAJRHKkIEEACESEKERBERRUEAAVKiKIqCIIqKkhAURUGUREREJEVEECQAgJRSCkkplZJSSilIUkpKKUgEAAKFCHGhAIBAwdHnII5DOA4iIAiB6HGeL3CinOgFRU7gRA7hEDYR8QUJ+MEd40xcSqmkZI6LEWdsknsSAQAAAAAAAAAgAAAAAAAAAACAAACAAwAAAAAAAAAAAAAAQAAAAAAAAAADAwAAAAAABBAAAICAAAAAAIAAJQAAAAAAAAAABAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAACAAAgIAAAAAAYAAA=";
    public static final String grixelbase64 = "AnoADABgACAFAgQICAoIAgQEBgYDBQIKCQMICAgICAcICAIDBQYFBwkICAgIBwcICAYHCAcJCAgICAgICAgICggICAQKBAQHBAcHBwcHBQcHAgUHBAoHBwcHBgcGBwcKBwcHBQIFCAJAJeIjkENBAAAAQHzk4wPz5/Pz8QEAAB4ePj8+Pz6fX9AHCgoECvL58fnx+QsKiigo6C8CIAEIIAAAARwgEAoEAAAAAAAABAAAAAAAICIAAZVIUiERBQEAAIAIWlAQSkAQKCgIICCEhAQFBQUFAgFBBCgoMGwoKCgoKAghKCiioCCgEIAKQIAAAAQIgAAgEAAAAAAAABAAAAAAAICIsAUEfwlCRBCkEAAAIUhAQCQBAaCgIEAAAcoUFBQQFAgEBBGgoECpoqCgoKAAhKCgiEREQIIAAgAAAgAQIAACgEAAAAAAAABAAAAAAAAAIrIBEIgkgBBBEEEAAIIgAQGJ/ARAgoKS+AioVFBQQFAgEBBEgEICmZKCgoKCAhCCgiKioIAIBAgA4Pl4fJ7n+YRC8c7H8/F5ni8UiigU+okIAEAg4gOBA0HfhwcEguTDEwL0g/DxAwFAoFJ/PwFBv1/eHwH6CASKCgoKCvJBCAqKCAEBISAgAAAoFAqFQigUikREoVAoFISEUCgiSQgSQgAAgQgSAlEEEQQACAhSANAfUBAhCAiIj2BKBQUFBAUCQUEEKCQQKCzoJ+gHCCEoKCIKBIIAgQAAvlAg9AuhUOgREYVCoVBgEEKhiBghhIgAAAB/SITEEKQQABAgSAFAIEBBhCAgQABByBMUFBAUCAQFEaGgQKCgoICgECCEIJGIRBAEAggCAIRCgVAghEKhSEQUCoVCAUYIhSJihAgiAgAAiCQJFUMQAAgggCAFBIEEBRGCghACAkBAUFBQUCAQFESEggKBgoICkoKCEIIoIgpCCAhACAAQCoVCoRAKhUIRUSgUCgUhISSJSBISiAgAQCDiE4gTQQAgUAB89OcD4uND8PFJAAAEfkE/Pj++gF/Q5wn6BQryCfAJ8kHwQXAnCOEvACIAgM/j8XiCLxQKWUQhz8cXeDgPw52Q7yciAAAAAAIAANgAQAAAAAAAAAAAAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAAAAAAAgAPg4AcAAAAAACAACAAAAAABEAAAAAAAACAAawAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB4ABgAAAAABEAAAAAAAAB4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=";
    protected int characters;
    protected int[] charWidth = new int[255];
    protected int charHeight;
    protected int[][] chars;
    protected int lineHeight = 10;
    protected int kerning = 0;
    protected int wh;
    protected PImage texture;

    public BitFont(byte[] theBytes) {
        this.texture = this.decodeBitFont(theBytes);
        this.make();
        this.size = this.lineHeight;
        this.glyphs = new PFont.Glyph[256];
        this.ascii = new int[128];
        Arrays.fill(this.ascii, -1);
        this.lazy = false;
        this.ascent = 4;
        this.descent = 4;
        this.glyphCount = 128;
        for (int i = 0; i < 128; ++i) {
            try {
                Constructor<?>[] constructors = PFont.Glyph.class.getDeclaredConstructors();
                Constructor<?> constructor = PFont.Glyph.class.getDeclaredConstructors()[0];
                constructor.setAccessible(true);
                for (Constructor<?> c : constructors) {
                    c.setAccessible(true);
                    if (c.getParameterTypes().length != 1) continue;
                    this.glyphs[i] = (PFont.Glyph)c.newInstance(new Object[]{this});
                    break;
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
            this.glyphs[i].value = i;
            if (this.glyphs[i].value < 128) {
                this.ascii[this.glyphs[i].value] = i;
            }
            this.glyphs[i].index = i;
            int id = i - 32;
            if (id >= 0) {
                this.glyphs[i].image = new PImage(this.charWidth[id], 9, 4);
                for (int n = 0; n < this.chars[id].length; ++n) {
                    this.glyphs[i].image.pixels[n] = this.chars[id][n] == 1 ? -1 : 0;
                }
                this.glyphs[i].height = 9;
                this.glyphs[i].width = this.charWidth[id];
                this.glyphs[i].index = i;
                this.glyphs[i].value = i;
                this.glyphs[i].setWidth = this.charWidth[id];
                this.glyphs[i].topExtent = 4;
                this.glyphs[i].leftExtent = 0;
                continue;
            }
            this.glyphs[i].image = new PImage(1, 1);
        }
    }

    public PFont.Glyph getGlyph(char c) {
        return this.glyphs[c];
    }

    PImage decodeBitFont(byte[] bytes) {
        int off;
        int w = Hacks.byteArrayToInt(new byte[]{bytes[0], bytes[1]});
        int h = Hacks.byteArrayToInt(new byte[]{bytes[2], bytes[3]});
        int s = Hacks.byteArrayToInt(new byte[]{bytes[4], bytes[5]});
        int c = Hacks.byteArrayToInt(new byte[]{bytes[6], bytes[7]});
        PImage tex = new PImage(w, h, 4);
        for (int i = off = 8 + s; i < bytes.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                tex.pixels[(i - off) * 8 + j] = Hacks.getBit(bytes[i], j) == 1 ? -16777216 : -1;
            }
        }
        byte cnt = 0;
        int n = 0;
        int i = 0;
        for (i = 0; i < s; ++i) {
            while (++cnt != bytes[i + 8]) {
            }
            tex.pixels[n += cnt] = -65536;
            cnt = 0;
        }
        return tex;
    }

    int getHeight() {
        return this.texture.height;
    }

    BitFont make() {
        this.lineHeight = this.charHeight = this.texture.height;
        int currWidth = 0;
        for (int i = 0; i < this.texture.width; ++i) {
            ++currWidth;
            if (this.texture.pixels[i] != -65536) continue;
            this.charWidth[this.characters++] = currWidth;
            currWidth = 0;
        }
        this.chars = new int[this.characters][];
        int indent = 0;
        for (int i = 0; i < this.characters; ++i) {
            this.chars[i] = new int[this.charWidth[i] * this.charHeight];
            for (int u = 0; u < this.charWidth[i] * this.charHeight; ++u) {
                this.chars[i][u] = this.texture.pixels[indent + u / this.charWidth[i] * this.texture.width + u % this.charWidth[i]] == -16777216 ? 1 : 0;
            }
            indent += this.charWidth[i];
        }
        return this;
    }
}

