/* 
 *  skatolo is a processing gui library.
 * 
 * Copyright (C)  2017 by RealityTechSASU
 * Copyright (C)  2015-2016 by Jeremy Laviole
 * Copyright (C)  2006-2012 by Andreas Schlegel
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301  USA
 * 
 * 
 */
package tech.lity.rea.skatolo.gui.controllers;

import tech.lity.rea.skatolo.Hacks;
import tech.lity.rea.skatolo.Skatolo;
import tech.lity.rea.skatolo.SkatoloConstants;
import tech.lity.rea.skatolo.gui.Controller;
import tech.lity.rea.skatolo.gui.group.ControllerGroup;
import java.util.ArrayList;
import java.util.List;

/**
 * Used by MultiList.
 * 
 * @example controllers/skatolomultiList
 * @nosuperclasses Controller Controller
 */
public class MultiListButton extends Button implements MultiListInterface {

	//	private MultiListInterface parent;

	private Controller parent;

	private MultiList root;

	private int[] _myRect = new int[4];

	protected int _myDirection = SkatoloConstants.RIGHT;

	private boolean isUpperCase = true;


	/**
	 * 
	 * @param theProperties ControllerProperties
	 * @param theParent MultiListInterface
	 * @param theRoot MultiList
	 */
	protected MultiListButton(Skatolo theskatolo, String theName, float theValue, int theX, int theY, int theWidth, int theHeight, Controller theParent, MultiList theRoot) {
		super(theskatolo, (ControllerGroup<?>) theRoot.getParent(), theName, theValue, theX, theY, theWidth, theHeight);
		parent = theParent;
		root = theRoot;
		updateRect(position.x, position.y, width, height);
		_myCaptionLabel.align(LEFT, CENTER);
	}


	public MultiListButton toUpperCase(boolean theValue) {
		isUpperCase = theValue;
		for (Controller<?> c : getSubelements()) {
			c.getCaptionLabel().toUpperCase(isUpperCase);
		}
		_myCaptionLabel.toUpperCase(isUpperCase);
		return this;
	}


	public void remove() {
		int myYoffset = 0;
		for (int i = 0; i < parent.getSubelements().size(); i++) {
			if (parent.getSubelements().get(i) == this) {
				myYoffset = height + 1;
			}
			((MultiListButton) parent.getSubelements().get(i)).updateLocation(0, -myYoffset);
		}

		if (_myParent != null) {
			removeListener(root);
			_myParent.remove(this);
		}
		if (skatolo != null) {
			removeListener(root);
			skatolo.remove(this);
		}
		for (int i = 0; i < getSubelements().size(); i++) {
			((MultiListButton) getSubelements().get(i)).remove();
		}
	}


	public int getDirection() {
		return _myDirection;
	}


	protected void setDirection(int theDirection) {
		_myDirection = theDirection;
	}


	public void updateRect(float theX, float theY, float theW, float theH) {
		_myRect = new int[] { (int) theX, (int) theY, (int) theW, (int) theH };
	}


	public void updateLocation(float theX, float theY) {
		position.x += theX;
		position.y += theY;
		updateRect(position.x, position.y, width, height);
		for (int i = 0; i < getSubelements().size(); i++) {
			((MultiListInterface) getSubelements().get(i)).updateLocation(theX, theY);
		}
	}


	/**
	 * set the width of a multlist button.
	 * 
	 * @param theWidth int
	 */
	public MultiListButton setWidth(int theWidth) {
		// negative direction
		int dif = (_myDirection == LEFT) ? theWidth - width : 0;
		width = theWidth;
		updateLocation(-dif, 0);
		return this;
	}


	/**
	 * set the height of a multlist button.
	 * 
	 * @param theHeight int
	 */
	public MultiListButton setHeight(int theHeight) {
		int difHeight = height;
		height = theHeight;
		difHeight = height - difHeight;
		int myYoffset = 0;
		for (int i = 0; i < parent.getSubelements().size(); i++) {
			if (parent.getSubelements().get(i) instanceof MultiListInterface) {
				((MultiListInterface) parent.getSubelements().get(i)).updateLocation(0, myYoffset);
				if ((parent.getSubelements().get(i)) == this) {
					myYoffset = difHeight;
				}
			}
		}
		updateLocation(0, 0);
		return this;
	}


	/**
	 * add a new button to the sublist of this multilist button.
	 * 
	 * @param theName String
	 * @param theValue int
	 * @return MultiListButton
	 */
	public MultiListButton add(String theName, float theValue) {
		int myHeight = -(height + 1);
		for (int i = 0; i < getSubelements().size(); i++) {
			myHeight += (getSubelements().get(i)).height + 1;
		}
		// negative direction, this is static now, make it dynamic depending on
		// the
		// location of the list.
		int xx = ((int) position.x + (width + 1));
		MultiListButton b = new MultiListButton(skatolo, theName, theValue, xx, (int) position.y + (height + 1) + myHeight, (int) width, (int) height, this, root);
		b.isMoveable = false;
		b.toUpperCase(isUpperCase);
		b.hide();
		skatolo.register(null, "", b);
		b.addListener(root);
		getSubelements().add(b);
		updateRect(xx, position.y, width, (height + 1) + myHeight);
		return b;
	}


	protected void onEnter() {
		if (!root.isUpdateLocation) {
			isActive = true;
			root.occupied(true);
			root.mostRecent = this;
			if (parent instanceof MultiListInterface) {
				((MultiListInterface) parent).close(this);
			}
			open();
		}
	}


	public void onLeave() {
		if (parent instanceof MultiListInterface) {
			if (!((MultiListInterface) parent).observe() && !root.isUpdateLocation && root.mostRecent == this) {
				isActive = false;
				root.occupied(false);
			}
		}
	}


	public void mouseReleasedOutside() {
		// !!! other than in the Button class, calling mouseReleased here
		// conflicts with mouseReleased();
	}


	public boolean observe() {
		return Hacks.inside(_myRect, controlWindow.getPointerX(), controlWindow.getPointerY());
	}


	public void close(MultiListInterface theInterface) {
		for (int i = 0; i < getSubelements().size(); i++) {
			if (theInterface != (MultiListInterface) getSubelements().get(i)) {
				((MultiListInterface) getSubelements().get(i)).close();
			}
		}

	}


	public void close() {
		for (int i = 0; i < getSubelements().size(); i++) {
			((MultiListButton) getSubelements().get(i)).close();
			((MultiListButton) getSubelements().get(i)).hide();
		}
	}


	public void open() {
		for (int i = 0; i < getSubelements().size(); i++) {
			((MultiListButton) getSubelements().get(i)).show();
		}
	}


	@Deprecated public List<MultiListButton> getChildren() {
		System.out.println("skatolo.MultiListButton.getChildren() is deprecated since 0.7.6, use getSubelement().\nFor convenience an empty List is returned here.");
		return new ArrayList<MultiListButton>();
	}

}
