/*
 * Decompiled with CFR 0.152.
 */
package com.legislate.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.legislate.model.CreateCollaboratorIdentityFieldV1DTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CollaboratorFieldsRequestDTO {
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="identityFields")
    private List<CreateCollaboratorIdentityFieldV1DTO> identityFields = new ArrayList<CreateCollaboratorIdentityFieldV1DTO>();
    @SerializedName(value="inviterId")
    private Long inviterId = null;
    @SerializedName(value="role")
    private List<RoleEnum> role = new ArrayList<RoleEnum>();
    @SerializedName(value="side")
    private SideEnum side = null;
    @SerializedName(value="signatoryId")
    private Long signatoryId = null;
    @SerializedName(value="userId")
    private Long userId = null;

    public CollaboratorFieldsRequestDTO email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="The unique email of the contract collaborator. Deprecated: Will be removed in v2.0.0")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CollaboratorFieldsRequestDTO identityFields(List<CreateCollaboratorIdentityFieldV1DTO> identityFields) {
        this.identityFields = identityFields;
        return this;
    }

    public CollaboratorFieldsRequestDTO addIdentityFieldsItem(CreateCollaboratorIdentityFieldV1DTO identityFieldsItem) {
        this.identityFields.add(identityFieldsItem);
        return this;
    }

    @Schema(required=true, description="The identity fields of the contract collaborator.")
    public List<CreateCollaboratorIdentityFieldV1DTO> getIdentityFields() {
        return this.identityFields;
    }

    public void setIdentityFields(List<CreateCollaboratorIdentityFieldV1DTO> identityFields) {
        this.identityFields = identityFields;
    }

    public CollaboratorFieldsRequestDTO inviterId(Long inviterId) {
        this.inviterId = inviterId;
        return this;
    }

    @Schema(required=true, description="The unique Id of the user who is inviting the collaborator to the contract.")
    public Long getInviterId() {
        return this.inviterId;
    }

    public void setInviterId(Long inviterId) {
        this.inviterId = inviterId;
    }

    public CollaboratorFieldsRequestDTO role(List<RoleEnum> role) {
        this.role = role;
        return this;
    }

    public CollaboratorFieldsRequestDTO addRoleItem(RoleEnum roleItem) {
        this.role.add(roleItem);
        return this;
    }

    @Schema(required=true, description="The role of contract collaborator.")
    public List<RoleEnum> getRole() {
        return this.role;
    }

    public void setRole(List<RoleEnum> role) {
        this.role = role;
    }

    public CollaboratorFieldsRequestDTO side(SideEnum side) {
        this.side = side;
        return this;
    }

    @Schema(required=true, description="The side of contract collaborator.")
    public SideEnum getSide() {
        return this.side;
    }

    public void setSide(SideEnum side) {
        this.side = side;
    }

    public CollaboratorFieldsRequestDTO signatoryId(Long signatoryId) {
        this.signatoryId = signatoryId;
        return this;
    }

    @Schema(description="The unique Id of the contract signatory who is going to sign the contract on behalf of the party / company.")
    public Long getSignatoryId() {
        return this.signatoryId;
    }

    public void setSignatoryId(Long signatoryId) {
        this.signatoryId = signatoryId;
    }

    public CollaboratorFieldsRequestDTO userId(Long userId) {
        this.userId = userId;
        return this;
    }

    @Schema(required=true, description="The unique Id of the contract collaborator you are adding to the contract.")
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollaboratorFieldsRequestDTO collaboratorFieldsRequestDTO = (CollaboratorFieldsRequestDTO)o;
        return Objects.equals(this.email, collaboratorFieldsRequestDTO.email) && Objects.equals(this.identityFields, collaboratorFieldsRequestDTO.identityFields) && Objects.equals(this.inviterId, collaboratorFieldsRequestDTO.inviterId) && Objects.equals(this.role, collaboratorFieldsRequestDTO.role) && Objects.equals((Object)this.side, (Object)collaboratorFieldsRequestDTO.side) && Objects.equals(this.signatoryId, collaboratorFieldsRequestDTO.signatoryId) && Objects.equals(this.userId, collaboratorFieldsRequestDTO.userId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.email, this.identityFields, this.inviterId, this.role, this.side, this.signatoryId, this.userId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CollaboratorFieldsRequestDTO {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    identityFields: ").append(this.toIndentedString(this.identityFields)).append("\n");
        sb.append("    inviterId: ").append(this.toIndentedString(this.inviterId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    side: ").append(this.toIndentedString((Object)this.side)).append("\n");
        sb.append("    signatoryId: ").append(this.toIndentedString(this.signatoryId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SideEnum {
        BOTH("both"),
        FIRST("first"),
        SECOND("second");

        private String value;

        private SideEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SideEnum fromValue(String input) {
            for (SideEnum b : SideEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SideEnum> {
            public void write(JsonWriter jsonWriter, SideEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public SideEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SideEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RoleEnum {
        COLLABORATOR("collaborator"),
        PARTY("party"),
        PARTY_WITH_SIGNATORY("party_with_signatory"),
        SIGNATORY("signatory"),
        SUPP_SIG("supp_sig"),
        WITNESS("witness");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RoleEnum fromValue(String input) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RoleEnum> {
            public void write(JsonWriter jsonWriter, RoleEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public RoleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RoleEnum.fromValue(value);
            }
        }
    }
}

