/*
 * Decompiled with CFR 0.152.
 */
package com.legislate.api;

import com.google.gson.reflect.TypeToken;
import com.legislate.ApiCallback;
import com.legislate.ApiClient;
import com.legislate.ApiException;
import com.legislate.ApiResponse;
import com.legislate.Configuration;
import com.legislate.Pair;
import com.legislate.ProgressRequestBody;
import com.legislate.ProgressResponseBody;
import com.legislate.model.ContractResponseDTO;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ContractTemplatesApi {
    private ApiClient apiClient;

    public ContractTemplatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContractTemplatesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getTemplateUsingGETCall(Long contractTypeId, Long teamId, Long templateId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/teams/{teamId}/contract-types/{contractTypeId}/templates/{templateId}".replaceAll("\\{contractTypeId\\}", this.apiClient.escapeString(contractTypeId.toString())).replaceAll("\\{teamId\\}", this.apiClient.escapeString(teamId.toString())).replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTemplateUsingGETValidateBeforeCall(Long contractTypeId, Long teamId, Long templateId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractTypeId == null) {
            throw new ApiException("Missing the required parameter 'contractTypeId' when calling getTemplateUsingGET(Async)");
        }
        if (teamId == null) {
            throw new ApiException("Missing the required parameter 'teamId' when calling getTemplateUsingGET(Async)");
        }
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling getTemplateUsingGET(Async)");
        }
        Call call = this.getTemplateUsingGETCall(contractTypeId, teamId, templateId, progressListener, progressRequestListener);
        return call;
    }

    public ContractResponseDTO getTemplateUsingGET(Long contractTypeId, Long teamId, Long templateId) throws ApiException {
        ApiResponse<ContractResponseDTO> resp = this.getTemplateUsingGETWithHttpInfo(contractTypeId, teamId, templateId);
        return resp.getData();
    }

    public ApiResponse<ContractResponseDTO> getTemplateUsingGETWithHttpInfo(Long contractTypeId, Long teamId, Long templateId) throws ApiException {
        Call call = this.getTemplateUsingGETValidateBeforeCall(contractTypeId, teamId, templateId, null, null);
        Type localVarReturnType = new TypeToken<ContractResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTemplateUsingGETAsync(Long contractTypeId, Long teamId, Long templateId, final ApiCallback<ContractResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTemplateUsingGETValidateBeforeCall(contractTypeId, teamId, templateId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTemplatesUsingGETCall(Long contractTypeId, Long teamId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/teams/{teamId}/contract-types/{contractTypeId}/templates".replaceAll("\\{contractTypeId\\}", this.apiClient.escapeString(contractTypeId.toString())).replaceAll("\\{teamId\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTemplatesUsingGETValidateBeforeCall(Long contractTypeId, Long teamId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractTypeId == null) {
            throw new ApiException("Missing the required parameter 'contractTypeId' when calling getTemplatesUsingGET(Async)");
        }
        if (teamId == null) {
            throw new ApiException("Missing the required parameter 'teamId' when calling getTemplatesUsingGET(Async)");
        }
        Call call = this.getTemplatesUsingGETCall(contractTypeId, teamId, progressListener, progressRequestListener);
        return call;
    }

    public ContractResponseDTO getTemplatesUsingGET(Long contractTypeId, Long teamId) throws ApiException {
        ApiResponse<ContractResponseDTO> resp = this.getTemplatesUsingGETWithHttpInfo(contractTypeId, teamId);
        return resp.getData();
    }

    public ApiResponse<ContractResponseDTO> getTemplatesUsingGETWithHttpInfo(Long contractTypeId, Long teamId) throws ApiException {
        Call call = this.getTemplatesUsingGETValidateBeforeCall(contractTypeId, teamId, null, null);
        Type localVarReturnType = new TypeToken<ContractResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTemplatesUsingGETAsync(Long contractTypeId, Long teamId, final ApiCallback<ContractResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTemplatesUsingGETValidateBeforeCall(contractTypeId, teamId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

