/*
 * Legislate API
 * The Legislate API is organized around REST. Our API has predictable resource-oriented URLs, accepts form-encoded request bodies, returns JSON-encoded responses, and uses standard HTTP response codes, authentication, and verbs.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.legislate.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.legislate.model.ContractFieldRequestDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * CreateContractRequestDTO
 */


public class CreateContractRequestDTO {
  @SerializedName("created_by_user_id")
  private Long createdByUserId = null;

  @SerializedName("fields")
  private List<ContractFieldRequestDTO> fields = null;

  @SerializedName("source_contract")
  private Long sourceContract = null;

  @SerializedName("template_id")
  private Long templateId = null;

  public CreateContractRequestDTO createdByUserId(Long createdByUserId) {
    this.createdByUserId = createdByUserId;
    return this;
  }

   /**
   * The unique Id of the user that is creating the contract.
   * @return createdByUserId
  **/
  @Schema(required = true, description = "The unique Id of the user that is creating the contract.")
  public Long getCreatedByUserId() {
    return createdByUserId;
  }

  public void setCreatedByUserId(Long createdByUserId) {
    this.createdByUserId = createdByUserId;
  }

  public CreateContractRequestDTO fields(List<ContractFieldRequestDTO> fields) {
    this.fields = fields;
    return this;
  }

  public CreateContractRequestDTO addFieldsItem(ContractFieldRequestDTO fieldsItem) {
    if (this.fields == null) {
      this.fields = new ArrayList<ContractFieldRequestDTO>();
    }
    this.fields.add(fieldsItem);
    return this;
  }

   /**
   * The list of fields that composes the contract.
   * @return fields
  **/
  @Schema(description = "The list of fields that composes the contract.")
  public List<ContractFieldRequestDTO> getFields() {
    return fields;
  }

  public void setFields(List<ContractFieldRequestDTO> fields) {
    this.fields = fields;
  }

  public CreateContractRequestDTO sourceContract(Long sourceContract) {
    this.sourceContract = sourceContract;
    return this;
  }

   /**
   * The unique ID of the contract to be copied.
   * @return sourceContract
  **/
  @Schema(description = "The unique ID of the contract to be copied.")
  public Long getSourceContract() {
    return sourceContract;
  }

  public void setSourceContract(Long sourceContract) {
    this.sourceContract = sourceContract;
  }

  public CreateContractRequestDTO templateId(Long templateId) {
    this.templateId = templateId;
    return this;
  }

   /**
   * The unique ID of the template.
   * @return templateId
  **/
  @Schema(required = true, description = "The unique ID of the template.")
  public Long getTemplateId() {
    return templateId;
  }

  public void setTemplateId(Long templateId) {
    this.templateId = templateId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateContractRequestDTO createContractRequestDTO = (CreateContractRequestDTO) o;
    return Objects.equals(this.createdByUserId, createContractRequestDTO.createdByUserId) &&
        Objects.equals(this.fields, createContractRequestDTO.fields) &&
        Objects.equals(this.sourceContract, createContractRequestDTO.sourceContract) &&
        Objects.equals(this.templateId, createContractRequestDTO.templateId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdByUserId, fields, sourceContract, templateId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateContractRequestDTO {\n");
    
    sb.append("    createdByUserId: ").append(toIndentedString(createdByUserId)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("    sourceContract: ").append(toIndentedString(sourceContract)).append("\n");
    sb.append("    templateId: ").append(toIndentedString(templateId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
