/*
 * Decompiled with CFR 0.152.
 */
package com.legislate.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ObtainIdentityFieldsDTO {
    @SerializedName(value="collaborator_id")
    private Long collaboratorId = null;
    @SerializedName(value="roles")
    private List<RolesEnum> roles = new ArrayList<RolesEnum>();
    @SerializedName(value="side")
    private SideEnum side = null;

    public ObtainIdentityFieldsDTO collaboratorId(Long collaboratorId) {
        this.collaboratorId = collaboratorId;
        return this;
    }

    @Schema(required=true, description="The id of the collaborator ")
    public Long getCollaboratorId() {
        return this.collaboratorId;
    }

    public void setCollaboratorId(Long collaboratorId) {
        this.collaboratorId = collaboratorId;
    }

    public ObtainIdentityFieldsDTO roles(List<RolesEnum> roles) {
        this.roles = roles;
        return this;
    }

    public ObtainIdentityFieldsDTO addRolesItem(RolesEnum rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @Schema(required=true, description="The role/s of the collaborator ")
    public List<RolesEnum> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RolesEnum> roles) {
        this.roles = roles;
    }

    public ObtainIdentityFieldsDTO side(SideEnum side) {
        this.side = side;
        return this;
    }

    @Schema(required=true, description="The side of the collaborator ")
    public SideEnum getSide() {
        return this.side;
    }

    public void setSide(SideEnum side) {
        this.side = side;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObtainIdentityFieldsDTO obtainIdentityFieldsDTO = (ObtainIdentityFieldsDTO)o;
        return Objects.equals(this.collaboratorId, obtainIdentityFieldsDTO.collaboratorId) && Objects.equals(this.roles, obtainIdentityFieldsDTO.roles) && Objects.equals((Object)this.side, (Object)obtainIdentityFieldsDTO.side);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.collaboratorId, this.roles, this.side});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObtainIdentityFieldsDTO {\n");
        sb.append("    collaboratorId: ").append(this.toIndentedString(this.collaboratorId)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    side: ").append(this.toIndentedString((Object)this.side)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SideEnum {
        BOTH("both"),
        FIRST("first"),
        SECOND("second");

        private String value;

        private SideEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SideEnum fromValue(String input) {
            for (SideEnum b : SideEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SideEnum> {
            public void write(JsonWriter jsonWriter, SideEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public SideEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SideEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RolesEnum {
        COLLABORATOR("collaborator"),
        PARTY("party"),
        PARTY_WITH_SIGNATORY("party_with_signatory"),
        SIGNATORY("signatory"),
        SUPP_SIG("supp_sig"),
        WITNESS("witness");

        private String value;

        private RolesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RolesEnum fromValue(String input) {
            for (RolesEnum b : RolesEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RolesEnum> {
            public void write(JsonWriter jsonWriter, RolesEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public RolesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RolesEnum.fromValue(value);
            }
        }
    }
}

