/*
 * Decompiled with CFR 0.152.
 */
package com.legislate.api;

import com.google.gson.reflect.TypeToken;
import com.legislate.ApiCallback;
import com.legislate.ApiClient;
import com.legislate.ApiException;
import com.legislate.ApiResponse;
import com.legislate.Configuration;
import com.legislate.Pair;
import com.legislate.ProgressRequestBody;
import com.legislate.ProgressResponseBody;
import com.legislate.model.CollaboratorResponseDTO;
import com.legislate.model.ContractResponseDTO;
import com.legislate.model.CreateContractRequestDTO;
import com.legislate.model.Link;
import com.legislate.model.UpdateContractRequestDTO;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContractsApi {
    private ApiClient apiClient;

    public ContractsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContractsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteContractUsingDELETECall(Long contractId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contracts/{contractId}".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteContractUsingDELETEValidateBeforeCall(Long contractId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling deleteContractUsingDELETE(Async)");
        }
        Call call = this.deleteContractUsingDELETECall(contractId, progressListener, progressRequestListener);
        return call;
    }

    public CollaboratorResponseDTO deleteContractUsingDELETE(Long contractId) throws ApiException {
        ApiResponse<CollaboratorResponseDTO> resp = this.deleteContractUsingDELETEWithHttpInfo(contractId);
        return resp.getData();
    }

    public ApiResponse<CollaboratorResponseDTO> deleteContractUsingDELETEWithHttpInfo(Long contractId) throws ApiException {
        Call call = this.deleteContractUsingDELETEValidateBeforeCall(contractId, null, null);
        Type localVarReturnType = new TypeToken<CollaboratorResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteContractUsingDELETEAsync(Long contractId, final ApiCallback<CollaboratorResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteContractUsingDELETEValidateBeforeCall(contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CollaboratorResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContractFileUsingGETCall(Long contractId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contracts/{contractId}/pdf".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/pdf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContractFileUsingGETValidateBeforeCall(Long contractId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling getContractFileUsingGET(Async)");
        }
        Call call = this.getContractFileUsingGETCall(contractId, progressListener, progressRequestListener);
        return call;
    }

    public byte[] getContractFileUsingGET(Long contractId) throws ApiException {
        ApiResponse<byte[]> resp = this.getContractFileUsingGETWithHttpInfo(contractId);
        return resp.getData();
    }

    public ApiResponse<byte[]> getContractFileUsingGETWithHttpInfo(Long contractId) throws ApiException {
        Call call = this.getContractFileUsingGETValidateBeforeCall(contractId, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContractFileUsingGETAsync(Long contractId, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContractFileUsingGETValidateBeforeCall(contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContractHtmlUsingGETCall(Long contractId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contracts/{contractId}/html".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/pdf", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContractHtmlUsingGETValidateBeforeCall(Long contractId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling getContractHtmlUsingGET(Async)");
        }
        Call call = this.getContractHtmlUsingGETCall(contractId, progressListener, progressRequestListener);
        return call;
    }

    public String getContractHtmlUsingGET(Long contractId) throws ApiException {
        ApiResponse<String> resp = this.getContractHtmlUsingGETWithHttpInfo(contractId);
        return resp.getData();
    }

    public ApiResponse<String> getContractHtmlUsingGETWithHttpInfo(Long contractId) throws ApiException {
        Call call = this.getContractHtmlUsingGETValidateBeforeCall(contractId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContractHtmlUsingGETAsync(Long contractId, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContractHtmlUsingGETValidateBeforeCall(contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContractUsingGETCall(Long contractId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contracts/{contractId}".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContractUsingGETValidateBeforeCall(Long contractId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling getContractUsingGET(Async)");
        }
        Call call = this.getContractUsingGETCall(contractId, progressListener, progressRequestListener);
        return call;
    }

    public ContractResponseDTO getContractUsingGET(Long contractId) throws ApiException {
        ApiResponse<ContractResponseDTO> resp = this.getContractUsingGETWithHttpInfo(contractId);
        return resp.getData();
    }

    public ApiResponse<ContractResponseDTO> getContractUsingGETWithHttpInfo(Long contractId) throws ApiException {
        Call call = this.getContractUsingGETValidateBeforeCall(contractId, null, null);
        Type localVarReturnType = new TypeToken<ContractResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContractUsingGETAsync(Long contractId, final ApiCallback<ContractResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContractUsingGETValidateBeforeCall(contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContractsUsingGETCall(Long teamId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/teams/{teamId}/contracts".replaceAll("\\{teamId\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContractsUsingGETValidateBeforeCall(Long teamId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (teamId == null) {
            throw new ApiException("Missing the required parameter 'teamId' when calling getContractsUsingGET(Async)");
        }
        Call call = this.getContractsUsingGETCall(teamId, progressListener, progressRequestListener);
        return call;
    }

    public List<ContractResponseDTO> getContractsUsingGET(Long teamId) throws ApiException {
        ApiResponse<List<ContractResponseDTO>> resp = this.getContractsUsingGETWithHttpInfo(teamId);
        return resp.getData();
    }

    public ApiResponse<List<ContractResponseDTO>> getContractsUsingGETWithHttpInfo(Long teamId) throws ApiException {
        Call call = this.getContractsUsingGETValidateBeforeCall(teamId, null, null);
        Type localVarReturnType = new TypeToken<List<ContractResponseDTO>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContractsUsingGETAsync(Long teamId, final ApiCallback<List<ContractResponseDTO>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContractsUsingGETValidateBeforeCall(teamId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ContractResponseDTO>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postContractUsingPOSTCall(CreateContractRequestDTO body, Long teamId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateContractRequestDTO localVarPostBody = body;
        String localVarPath = "/v1/teams/{teamId}/contracts".replaceAll("\\{teamId\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postContractUsingPOSTValidateBeforeCall(CreateContractRequestDTO body, Long teamId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postContractUsingPOST(Async)");
        }
        if (teamId == null) {
            throw new ApiException("Missing the required parameter 'teamId' when calling postContractUsingPOST(Async)");
        }
        Call call = this.postContractUsingPOSTCall(body, teamId, progressListener, progressRequestListener);
        return call;
    }

    public Link postContractUsingPOST(CreateContractRequestDTO body, Long teamId) throws ApiException {
        ApiResponse<Link> resp = this.postContractUsingPOSTWithHttpInfo(body, teamId);
        return resp.getData();
    }

    public ApiResponse<Link> postContractUsingPOSTWithHttpInfo(CreateContractRequestDTO body, Long teamId) throws ApiException {
        Call call = this.postContractUsingPOSTValidateBeforeCall(body, teamId, null, null);
        Type localVarReturnType = new TypeToken<Link>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postContractUsingPOSTAsync(CreateContractRequestDTO body, Long teamId, final ApiCallback<Link> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postContractUsingPOSTValidateBeforeCall(body, teamId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Link>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateContractUsingPATCHCall(UpdateContractRequestDTO body, Long contractId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateContractRequestDTO localVarPostBody = body;
        String localVarPath = "/v1/contracts/{contractId}".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateContractUsingPATCHValidateBeforeCall(UpdateContractRequestDTO body, Long contractId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateContractUsingPATCH(Async)");
        }
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling updateContractUsingPATCH(Async)");
        }
        Call call = this.updateContractUsingPATCHCall(body, contractId, progressListener, progressRequestListener);
        return call;
    }

    public ContractResponseDTO updateContractUsingPATCH(UpdateContractRequestDTO body, Long contractId) throws ApiException {
        ApiResponse<ContractResponseDTO> resp = this.updateContractUsingPATCHWithHttpInfo(body, contractId);
        return resp.getData();
    }

    public ApiResponse<ContractResponseDTO> updateContractUsingPATCHWithHttpInfo(UpdateContractRequestDTO body, Long contractId) throws ApiException {
        Call call = this.updateContractUsingPATCHValidateBeforeCall(body, contractId, null, null);
        Type localVarReturnType = new TypeToken<ContractResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateContractUsingPATCHAsync(UpdateContractRequestDTO body, Long contractId, final ApiCallback<ContractResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateContractUsingPATCHValidateBeforeCall(body, contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

