/*
 * Decompiled with CFR 0.152.
 */
package com.legislate.api;

import com.google.gson.reflect.TypeToken;
import com.legislate.ApiCallback;
import com.legislate.ApiClient;
import com.legislate.ApiException;
import com.legislate.ApiResponse;
import com.legislate.Configuration;
import com.legislate.Pair;
import com.legislate.ProgressRequestBody;
import com.legislate.ProgressResponseBody;
import com.legislate.model.ContractTypeResponseDTO;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContractTypesApi {
    private ApiClient apiClient;

    public ContractTypesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContractTypesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getContractTypePerTeamUsingGETCall(Long contractTypeId, Long teamId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/teams/{teamId}/contract-types/{contractTypeId}".replaceAll("\\{contractTypeId\\}", this.apiClient.escapeString(contractTypeId.toString())).replaceAll("\\{teamId\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContractTypePerTeamUsingGETValidateBeforeCall(Long contractTypeId, Long teamId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractTypeId == null) {
            throw new ApiException("Missing the required parameter 'contractTypeId' when calling getContractTypePerTeamUsingGET(Async)");
        }
        if (teamId == null) {
            throw new ApiException("Missing the required parameter 'teamId' when calling getContractTypePerTeamUsingGET(Async)");
        }
        Call call = this.getContractTypePerTeamUsingGETCall(contractTypeId, teamId, progressListener, progressRequestListener);
        return call;
    }

    public ContractTypeResponseDTO getContractTypePerTeamUsingGET(Long contractTypeId, Long teamId) throws ApiException {
        ApiResponse<ContractTypeResponseDTO> resp = this.getContractTypePerTeamUsingGETWithHttpInfo(contractTypeId, teamId);
        return resp.getData();
    }

    public ApiResponse<ContractTypeResponseDTO> getContractTypePerTeamUsingGETWithHttpInfo(Long contractTypeId, Long teamId) throws ApiException {
        Call call = this.getContractTypePerTeamUsingGETValidateBeforeCall(contractTypeId, teamId, null, null);
        Type localVarReturnType = new TypeToken<ContractTypeResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContractTypePerTeamUsingGETAsync(Long contractTypeId, Long teamId, final ApiCallback<ContractTypeResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContractTypePerTeamUsingGETValidateBeforeCall(contractTypeId, teamId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractTypeResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContractTypeUsingGETCall(Long contractTypeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract-types/{contractTypeId}".replaceAll("\\{contractTypeId\\}", this.apiClient.escapeString(contractTypeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContractTypeUsingGETValidateBeforeCall(Long contractTypeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractTypeId == null) {
            throw new ApiException("Missing the required parameter 'contractTypeId' when calling getContractTypeUsingGET(Async)");
        }
        Call call = this.getContractTypeUsingGETCall(contractTypeId, progressListener, progressRequestListener);
        return call;
    }

    public ContractTypeResponseDTO getContractTypeUsingGET(Long contractTypeId) throws ApiException {
        ApiResponse<ContractTypeResponseDTO> resp = this.getContractTypeUsingGETWithHttpInfo(contractTypeId);
        return resp.getData();
    }

    public ApiResponse<ContractTypeResponseDTO> getContractTypeUsingGETWithHttpInfo(Long contractTypeId) throws ApiException {
        Call call = this.getContractTypeUsingGETValidateBeforeCall(contractTypeId, null, null);
        Type localVarReturnType = new TypeToken<ContractTypeResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContractTypeUsingGETAsync(Long contractTypeId, final ApiCallback<ContractTypeResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContractTypeUsingGETValidateBeforeCall(contractTypeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractTypeResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContractTypesPerTeamUsingGETCall(Long teamId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/teams/{teamId}/contract-types".replaceAll("\\{teamId\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContractTypesPerTeamUsingGETValidateBeforeCall(Long teamId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (teamId == null) {
            throw new ApiException("Missing the required parameter 'teamId' when calling getContractTypesPerTeamUsingGET(Async)");
        }
        Call call = this.getContractTypesPerTeamUsingGETCall(teamId, progressListener, progressRequestListener);
        return call;
    }

    public List<ContractTypeResponseDTO> getContractTypesPerTeamUsingGET(Long teamId) throws ApiException {
        ApiResponse<List<ContractTypeResponseDTO>> resp = this.getContractTypesPerTeamUsingGETWithHttpInfo(teamId);
        return resp.getData();
    }

    public ApiResponse<List<ContractTypeResponseDTO>> getContractTypesPerTeamUsingGETWithHttpInfo(Long teamId) throws ApiException {
        Call call = this.getContractTypesPerTeamUsingGETValidateBeforeCall(teamId, null, null);
        Type localVarReturnType = new TypeToken<List<ContractTypeResponseDTO>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContractTypesPerTeamUsingGETAsync(Long teamId, final ApiCallback<List<ContractTypeResponseDTO>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContractTypesPerTeamUsingGETValidateBeforeCall(teamId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ContractTypeResponseDTO>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContractTypesUsingGETCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract-types";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContractTypesUsingGETValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getContractTypesUsingGETCall(progressListener, progressRequestListener);
        return call;
    }

    public List<ContractTypeResponseDTO> getContractTypesUsingGET() throws ApiException {
        ApiResponse<List<ContractTypeResponseDTO>> resp = this.getContractTypesUsingGETWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<List<ContractTypeResponseDTO>> getContractTypesUsingGETWithHttpInfo() throws ApiException {
        Call call = this.getContractTypesUsingGETValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<ContractTypeResponseDTO>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContractTypesUsingGETAsync(final ApiCallback<List<ContractTypeResponseDTO>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContractTypesUsingGETValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ContractTypeResponseDTO>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

