/*
 * Decompiled with CFR 0.152.
 */
package com.legislate.api;

import com.google.gson.reflect.TypeToken;
import com.legislate.ApiCallback;
import com.legislate.ApiClient;
import com.legislate.ApiException;
import com.legislate.ApiResponse;
import com.legislate.Configuration;
import com.legislate.Pair;
import com.legislate.ProgressRequestBody;
import com.legislate.ProgressResponseBody;
import com.legislate.model.CollaboratorFieldsRequestDTO;
import com.legislate.model.CompanyCreatedResponseDTO;
import com.legislate.model.CompanyFieldsDTO;
import com.legislate.model.ContractCollaboratorResponseDTO;
import com.legislate.model.IdentityFieldsCollaboratorRoleDTO;
import com.legislate.model.Link;
import com.legislate.model.ObtainIdentityFieldsDTO;
import com.legislate.model.UpdateCollaboratorIdentityFieldsRequestDTO;
import com.legislate.model.UpdateFieldsCollaboratorDTO;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CollaboratorsApi {
    private ApiClient apiClient;

    public CollaboratorsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CollaboratorsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteCollaboratorUsingDELETECall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/collaborators/{collaboratorId}".replaceAll("\\{collaboratorId\\}", this.apiClient.escapeString(collaboratorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCollaboratorUsingDELETEValidateBeforeCall(Long collaboratorId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling deleteCollaboratorUsingDELETE(Async)");
        }
        Call call = this.deleteCollaboratorUsingDELETECall(collaboratorId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCollaboratorUsingDELETE(Long collaboratorId) throws ApiException {
        this.deleteCollaboratorUsingDELETEWithHttpInfo(collaboratorId);
    }

    public ApiResponse<Void> deleteCollaboratorUsingDELETEWithHttpInfo(Long collaboratorId) throws ApiException {
        Call call = this.deleteCollaboratorUsingDELETEValidateBeforeCall(collaboratorId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCollaboratorUsingDELETEAsync(Long collaboratorId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCollaboratorUsingDELETEValidateBeforeCall(collaboratorId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getCollaboratorIdentityFieldsByCollaboratorUsingGETCall(ObtainIdentityFieldsDTO body, Long idTemplate, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ObtainIdentityFieldsDTO localVarPostBody = body;
        String localVarPath = "/v1/templates/{idTemplate}/updatefields".replaceAll("\\{idTemplate\\}", this.apiClient.escapeString(idTemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCollaboratorIdentityFieldsByCollaboratorUsingGETValidateBeforeCall(ObtainIdentityFieldsDTO body, Long idTemplate, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getCollaboratorIdentityFieldsByCollaboratorUsingGET(Async)");
        }
        if (idTemplate == null) {
            throw new ApiException("Missing the required parameter 'idTemplate' when calling getCollaboratorIdentityFieldsByCollaboratorUsingGET(Async)");
        }
        Call call = this.getCollaboratorIdentityFieldsByCollaboratorUsingGETCall(body, idTemplate, progressListener, progressRequestListener);
        return call;
    }

    public List<IdentityFieldsCollaboratorRoleDTO> getCollaboratorIdentityFieldsByCollaboratorUsingGET(ObtainIdentityFieldsDTO body, Long idTemplate) throws ApiException {
        ApiResponse<List<IdentityFieldsCollaboratorRoleDTO>> resp = this.getCollaboratorIdentityFieldsByCollaboratorUsingGETWithHttpInfo(body, idTemplate);
        return resp.getData();
    }

    public ApiResponse<List<IdentityFieldsCollaboratorRoleDTO>> getCollaboratorIdentityFieldsByCollaboratorUsingGETWithHttpInfo(ObtainIdentityFieldsDTO body, Long idTemplate) throws ApiException {
        Call call = this.getCollaboratorIdentityFieldsByCollaboratorUsingGETValidateBeforeCall(body, idTemplate, null, null);
        Type localVarReturnType = new TypeToken<List<IdentityFieldsCollaboratorRoleDTO>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCollaboratorIdentityFieldsByCollaboratorUsingGETAsync(ObtainIdentityFieldsDTO body, Long idTemplate, final ApiCallback<List<IdentityFieldsCollaboratorRoleDTO>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCollaboratorIdentityFieldsByCollaboratorUsingGETValidateBeforeCall(body, idTemplate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<IdentityFieldsCollaboratorRoleDTO>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCollaboratorIdentityFieldsUsingGETCall(Long idTemplate, List<String> roles, String side, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/templates/{idTemplate}/fields".replaceAll("\\{idTemplate\\}", this.apiClient.escapeString(idTemplate.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (roles != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "roles", roles));
        }
        if (side != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("side", side));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCollaboratorIdentityFieldsUsingGETValidateBeforeCall(Long idTemplate, List<String> roles, String side, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (idTemplate == null) {
            throw new ApiException("Missing the required parameter 'idTemplate' when calling getCollaboratorIdentityFieldsUsingGET(Async)");
        }
        if (roles == null) {
            throw new ApiException("Missing the required parameter 'roles' when calling getCollaboratorIdentityFieldsUsingGET(Async)");
        }
        if (side == null) {
            throw new ApiException("Missing the required parameter 'side' when calling getCollaboratorIdentityFieldsUsingGET(Async)");
        }
        Call call = this.getCollaboratorIdentityFieldsUsingGETCall(idTemplate, roles, side, progressListener, progressRequestListener);
        return call;
    }

    public List<IdentityFieldsCollaboratorRoleDTO> getCollaboratorIdentityFieldsUsingGET(Long idTemplate, List<String> roles, String side) throws ApiException {
        ApiResponse<List<IdentityFieldsCollaboratorRoleDTO>> resp = this.getCollaboratorIdentityFieldsUsingGETWithHttpInfo(idTemplate, roles, side);
        return resp.getData();
    }

    public ApiResponse<List<IdentityFieldsCollaboratorRoleDTO>> getCollaboratorIdentityFieldsUsingGETWithHttpInfo(Long idTemplate, List<String> roles, String side) throws ApiException {
        Call call = this.getCollaboratorIdentityFieldsUsingGETValidateBeforeCall(idTemplate, roles, side, null, null);
        Type localVarReturnType = new TypeToken<List<IdentityFieldsCollaboratorRoleDTO>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCollaboratorIdentityFieldsUsingGETAsync(Long idTemplate, List<String> roles, String side, final ApiCallback<List<IdentityFieldsCollaboratorRoleDTO>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCollaboratorIdentityFieldsUsingGETValidateBeforeCall(idTemplate, roles, side, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<IdentityFieldsCollaboratorRoleDTO>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCollaboratorUsingGETCall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/collaborators/{collaboratorId}".replaceAll("\\{collaboratorId\\}", this.apiClient.escapeString(collaboratorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCollaboratorUsingGETValidateBeforeCall(Long collaboratorId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling getCollaboratorUsingGET(Async)");
        }
        Call call = this.getCollaboratorUsingGETCall(collaboratorId, progressListener, progressRequestListener);
        return call;
    }

    public ContractCollaboratorResponseDTO getCollaboratorUsingGET(Long collaboratorId) throws ApiException {
        ApiResponse<ContractCollaboratorResponseDTO> resp = this.getCollaboratorUsingGETWithHttpInfo(collaboratorId);
        return resp.getData();
    }

    public ApiResponse<ContractCollaboratorResponseDTO> getCollaboratorUsingGETWithHttpInfo(Long collaboratorId) throws ApiException {
        Call call = this.getCollaboratorUsingGETValidateBeforeCall(collaboratorId, null, null);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCollaboratorUsingGETAsync(Long collaboratorId, final ApiCallback<ContractCollaboratorResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCollaboratorUsingGETValidateBeforeCall(collaboratorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCollaboratorsUsingGETCall(Long contractId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contracts/{contractId}/collaborators".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCollaboratorsUsingGETValidateBeforeCall(Long contractId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling getCollaboratorsUsingGET(Async)");
        }
        Call call = this.getCollaboratorsUsingGETCall(contractId, progressListener, progressRequestListener);
        return call;
    }

    public List<ContractCollaboratorResponseDTO> getCollaboratorsUsingGET(Long contractId) throws ApiException {
        ApiResponse<List<ContractCollaboratorResponseDTO>> resp = this.getCollaboratorsUsingGETWithHttpInfo(contractId);
        return resp.getData();
    }

    public ApiResponse<List<ContractCollaboratorResponseDTO>> getCollaboratorsUsingGETWithHttpInfo(Long contractId) throws ApiException {
        Call call = this.getCollaboratorsUsingGETValidateBeforeCall(contractId, null, null);
        Type localVarReturnType = new TypeToken<List<ContractCollaboratorResponseDTO>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCollaboratorsUsingGETAsync(Long contractId, final ApiCallback<List<ContractCollaboratorResponseDTO>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCollaboratorsUsingGETValidateBeforeCall(contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ContractCollaboratorResponseDTO>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postCollaboratorUsingPOSTCall(CollaboratorFieldsRequestDTO body, Long contractId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CollaboratorFieldsRequestDTO localVarPostBody = body;
        String localVarPath = "/v1/contracts/{contractId}/collaborators".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCollaboratorUsingPOSTValidateBeforeCall(CollaboratorFieldsRequestDTO body, Long contractId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postCollaboratorUsingPOST(Async)");
        }
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling postCollaboratorUsingPOST(Async)");
        }
        Call call = this.postCollaboratorUsingPOSTCall(body, contractId, progressListener, progressRequestListener);
        return call;
    }

    public Link postCollaboratorUsingPOST(CollaboratorFieldsRequestDTO body, Long contractId) throws ApiException {
        ApiResponse<Link> resp = this.postCollaboratorUsingPOSTWithHttpInfo(body, contractId);
        return resp.getData();
    }

    public ApiResponse<Link> postCollaboratorUsingPOSTWithHttpInfo(CollaboratorFieldsRequestDTO body, Long contractId) throws ApiException {
        Call call = this.postCollaboratorUsingPOSTValidateBeforeCall(body, contractId, null, null);
        Type localVarReturnType = new TypeToken<Link>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCollaboratorUsingPOSTAsync(CollaboratorFieldsRequestDTO body, Long contractId, final ApiCallback<Link> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCollaboratorUsingPOSTValidateBeforeCall(body, contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Link>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postCompanyUsingPOSTCall(CompanyFieldsDTO body, Long contractId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CompanyFieldsDTO localVarPostBody = body;
        String localVarPath = "/v1/contracts/{contractId}/company".replaceAll("\\{contractId\\}", this.apiClient.escapeString(contractId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCompanyUsingPOSTValidateBeforeCall(CompanyFieldsDTO body, Long contractId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postCompanyUsingPOST(Async)");
        }
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling postCompanyUsingPOST(Async)");
        }
        Call call = this.postCompanyUsingPOSTCall(body, contractId, progressListener, progressRequestListener);
        return call;
    }

    public CompanyCreatedResponseDTO postCompanyUsingPOST(CompanyFieldsDTO body, Long contractId) throws ApiException {
        ApiResponse<CompanyCreatedResponseDTO> resp = this.postCompanyUsingPOSTWithHttpInfo(body, contractId);
        return resp.getData();
    }

    public ApiResponse<CompanyCreatedResponseDTO> postCompanyUsingPOSTWithHttpInfo(CompanyFieldsDTO body, Long contractId) throws ApiException {
        Call call = this.postCompanyUsingPOSTValidateBeforeCall(body, contractId, null, null);
        Type localVarReturnType = new TypeToken<CompanyCreatedResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCompanyUsingPOSTAsync(CompanyFieldsDTO body, Long contractId, final ApiCallback<CompanyCreatedResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCompanyUsingPOSTValidateBeforeCall(body, contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CompanyCreatedResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCollaboratorBinaryFileSignatureUsingPATCHCall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/collaborators/{collaboratorId}/signature".replaceAll("\\{collaboratorId\\}", this.apiClient.escapeString(collaboratorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateCollaboratorBinaryFileSignatureUsingPATCHValidateBeforeCall(Long collaboratorId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling updateCollaboratorBinaryFileSignatureUsingPATCH(Async)");
        }
        Call call = this.updateCollaboratorBinaryFileSignatureUsingPATCHCall(collaboratorId, progressListener, progressRequestListener);
        return call;
    }

    public ContractCollaboratorResponseDTO updateCollaboratorBinaryFileSignatureUsingPATCH(Long collaboratorId) throws ApiException {
        ApiResponse<ContractCollaboratorResponseDTO> resp = this.updateCollaboratorBinaryFileSignatureUsingPATCHWithHttpInfo(collaboratorId);
        return resp.getData();
    }

    public ApiResponse<ContractCollaboratorResponseDTO> updateCollaboratorBinaryFileSignatureUsingPATCHWithHttpInfo(Long collaboratorId) throws ApiException {
        Call call = this.updateCollaboratorBinaryFileSignatureUsingPATCHValidateBeforeCall(collaboratorId, null, null);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateCollaboratorBinaryFileSignatureUsingPATCHAsync(Long collaboratorId, final ApiCallback<ContractCollaboratorResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateCollaboratorBinaryFileSignatureUsingPATCHValidateBeforeCall(collaboratorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCollaboratorFieldsUsingPATCHCall(UpdateCollaboratorIdentityFieldsRequestDTO body, Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateCollaboratorIdentityFieldsRequestDTO localVarPostBody = body;
        String localVarPath = "/v1/collaborators/{collaboratorId}/fields".replaceAll("\\{collaboratorId\\}", this.apiClient.escapeString(collaboratorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateCollaboratorFieldsUsingPATCHValidateBeforeCall(UpdateCollaboratorIdentityFieldsRequestDTO body, Long collaboratorId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateCollaboratorFieldsUsingPATCH(Async)");
        }
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling updateCollaboratorFieldsUsingPATCH(Async)");
        }
        Call call = this.updateCollaboratorFieldsUsingPATCHCall(body, collaboratorId, progressListener, progressRequestListener);
        return call;
    }

    public ContractCollaboratorResponseDTO updateCollaboratorFieldsUsingPATCH(UpdateCollaboratorIdentityFieldsRequestDTO body, Long collaboratorId) throws ApiException {
        ApiResponse<ContractCollaboratorResponseDTO> resp = this.updateCollaboratorFieldsUsingPATCHWithHttpInfo(body, collaboratorId);
        return resp.getData();
    }

    public ApiResponse<ContractCollaboratorResponseDTO> updateCollaboratorFieldsUsingPATCHWithHttpInfo(UpdateCollaboratorIdentityFieldsRequestDTO body, Long collaboratorId) throws ApiException {
        Call call = this.updateCollaboratorFieldsUsingPATCHValidateBeforeCall(body, collaboratorId, null, null);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateCollaboratorFieldsUsingPATCHAsync(UpdateCollaboratorIdentityFieldsRequestDTO body, Long collaboratorId, final ApiCallback<ContractCollaboratorResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateCollaboratorFieldsUsingPATCHValidateBeforeCall(body, collaboratorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCollaboratorRolesUsingPATCHCall(UpdateFieldsCollaboratorDTO body, Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateFieldsCollaboratorDTO localVarPostBody = body;
        String localVarPath = "/v1/collaborators/{collaboratorId}/roles".replaceAll("\\{collaboratorId\\}", this.apiClient.escapeString(collaboratorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateCollaboratorRolesUsingPATCHValidateBeforeCall(UpdateFieldsCollaboratorDTO body, Long collaboratorId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateCollaboratorRolesUsingPATCH(Async)");
        }
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling updateCollaboratorRolesUsingPATCH(Async)");
        }
        Call call = this.updateCollaboratorRolesUsingPATCHCall(body, collaboratorId, progressListener, progressRequestListener);
        return call;
    }

    public ContractCollaboratorResponseDTO updateCollaboratorRolesUsingPATCH(UpdateFieldsCollaboratorDTO body, Long collaboratorId) throws ApiException {
        ApiResponse<ContractCollaboratorResponseDTO> resp = this.updateCollaboratorRolesUsingPATCHWithHttpInfo(body, collaboratorId);
        return resp.getData();
    }

    public ApiResponse<ContractCollaboratorResponseDTO> updateCollaboratorRolesUsingPATCHWithHttpInfo(UpdateFieldsCollaboratorDTO body, Long collaboratorId) throws ApiException {
        Call call = this.updateCollaboratorRolesUsingPATCHValidateBeforeCall(body, collaboratorId, null, null);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateCollaboratorRolesUsingPATCHAsync(UpdateFieldsCollaboratorDTO body, Long collaboratorId, final ApiCallback<ContractCollaboratorResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateCollaboratorRolesUsingPATCHValidateBeforeCall(body, collaboratorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCollaboratorSignatureUsingPATCHCall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/collaborators/{collaboratorId}/user-signature".replaceAll("\\{collaboratorId\\}", this.apiClient.escapeString(collaboratorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"auth0_jwt"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateCollaboratorSignatureUsingPATCHValidateBeforeCall(Long collaboratorId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling updateCollaboratorSignatureUsingPATCH(Async)");
        }
        Call call = this.updateCollaboratorSignatureUsingPATCHCall(collaboratorId, progressListener, progressRequestListener);
        return call;
    }

    public ContractCollaboratorResponseDTO updateCollaboratorSignatureUsingPATCH(Long collaboratorId) throws ApiException {
        ApiResponse<ContractCollaboratorResponseDTO> resp = this.updateCollaboratorSignatureUsingPATCHWithHttpInfo(collaboratorId);
        return resp.getData();
    }

    public ApiResponse<ContractCollaboratorResponseDTO> updateCollaboratorSignatureUsingPATCHWithHttpInfo(Long collaboratorId) throws ApiException {
        Call call = this.updateCollaboratorSignatureUsingPATCHValidateBeforeCall(collaboratorId, null, null);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateCollaboratorSignatureUsingPATCHAsync(Long collaboratorId, final ApiCallback<ContractCollaboratorResponseDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateCollaboratorSignatureUsingPATCHValidateBeforeCall(collaboratorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

