/*
 * Legislate API
 * The Legislate API is organized around REST. Our API has predictable resource-oriented URLs, accepts form-encoded request bodies, returns JSON-encoded responses, and uses standard HTTP response codes, authentication, and verbs.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.legislate.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * ObtainIdentityFieldsDTO
 */


public class ObtainIdentityFieldsDTO {
  @SerializedName("collaborator_id")
  private Long collaboratorId = null;

  /**
   * Gets or Sets roles
   */
  @JsonAdapter(RolesEnum.Adapter.class)
  public enum RolesEnum {
    COLLABORATOR("collaborator"),
    PARTY("party"),
    PARTY_WITH_SIGNATORY("party_with_signatory"),
    SIGNATORY("signatory"),
    SUPP_SIG("supp_sig"),
    WITNESS("witness");

    private String value;

    RolesEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static RolesEnum fromValue(String input) {
      for (RolesEnum b : RolesEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<RolesEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RolesEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public RolesEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return RolesEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("roles")
  private List<RolesEnum> roles = new ArrayList<RolesEnum>();

  /**
   * The side of the collaborator 
   */
  @JsonAdapter(SideEnum.Adapter.class)
  public enum SideEnum {
    BOTH("both"),
    FIRST("first"),
    SECOND("second");

    private String value;

    SideEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static SideEnum fromValue(String input) {
      for (SideEnum b : SideEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<SideEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SideEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public SideEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return SideEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("side")
  private SideEnum side = null;

  public ObtainIdentityFieldsDTO collaboratorId(Long collaboratorId) {
    this.collaboratorId = collaboratorId;
    return this;
  }

   /**
   * The id of the collaborator 
   * @return collaboratorId
  **/
  @Schema(required = true, description = "The id of the collaborator ")
  public Long getCollaboratorId() {
    return collaboratorId;
  }

  public void setCollaboratorId(Long collaboratorId) {
    this.collaboratorId = collaboratorId;
  }

  public ObtainIdentityFieldsDTO roles(List<RolesEnum> roles) {
    this.roles = roles;
    return this;
  }

  public ObtainIdentityFieldsDTO addRolesItem(RolesEnum rolesItem) {
    this.roles.add(rolesItem);
    return this;
  }

   /**
   * The role/s of the collaborator 
   * @return roles
  **/
  @Schema(required = true, description = "The role/s of the collaborator ")
  public List<RolesEnum> getRoles() {
    return roles;
  }

  public void setRoles(List<RolesEnum> roles) {
    this.roles = roles;
  }

  public ObtainIdentityFieldsDTO side(SideEnum side) {
    this.side = side;
    return this;
  }

   /**
   * The side of the collaborator 
   * @return side
  **/
  @Schema(required = true, description = "The side of the collaborator ")
  public SideEnum getSide() {
    return side;
  }

  public void setSide(SideEnum side) {
    this.side = side;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ObtainIdentityFieldsDTO obtainIdentityFieldsDTO = (ObtainIdentityFieldsDTO) o;
    return Objects.equals(this.collaboratorId, obtainIdentityFieldsDTO.collaboratorId) &&
        Objects.equals(this.roles, obtainIdentityFieldsDTO.roles) &&
        Objects.equals(this.side, obtainIdentityFieldsDTO.side);
  }

  @Override
  public int hashCode() {
    return Objects.hash(collaboratorId, roles, side);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ObtainIdentityFieldsDTO {\n");
    
    sb.append("    collaboratorId: ").append(toIndentedString(collaboratorId)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
