/*
 * Legislate API
 * The Legislate API is organized around REST. Our API has predictable resource-oriented URLs, accepts form-encoded request bodies, returns JSON-encoded responses, and uses standard HTTP response codes, authentication, and verbs.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.legislate.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.legislate.model.RegisteredOfficeAddressDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * CompanyFieldsDTO
 */


public class CompanyFieldsDTO {
  @SerializedName("address")
  private RegisteredOfficeAddressDTO address = null;

  @SerializedName("company_name")
  private String companyName = null;

  @SerializedName("company_number")
  private String companyNumber = null;

  @SerializedName("contract_configuration_id")
  private Long contractConfigurationId = null;

  @SerializedName("created_by")
  private Long createdBy = null;

  @SerializedName("id")
  private Long id = null;

  @SerializedName("registered_office_address")
  private RegisteredOfficeAddressDTO registeredOfficeAddress = null;

  /**
   * Gets or Sets role
   */
  @JsonAdapter(RoleEnum.Adapter.class)
  public enum RoleEnum {
    COLLABORATOR("collaborator"),
    PARTY("party"),
    SIGNATORY("signatory"),
    SUPP_SIG("supp_sig"),
    WITNESS("witness");

    private String value;

    RoleEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static RoleEnum fromValue(String input) {
      for (RoleEnum b : RoleEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<RoleEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RoleEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public RoleEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return RoleEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("role")
  private RoleEnum role = null;

  /**
   * Gets or Sets side
   */
  @JsonAdapter(SideEnum.Adapter.class)
  public enum SideEnum {
    BOTH("both"),
    FIRST("first"),
    SECOND("second");

    private String value;

    SideEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static SideEnum fromValue(String input) {
      for (SideEnum b : SideEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return null;
    }
    public static class Adapter extends TypeAdapter<SideEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SideEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public SideEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return SideEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("side")
  private SideEnum side = null;

  @SerializedName("signatory_related_company")
  private Long signatoryRelatedCompany = null;

  public CompanyFieldsDTO address(RegisteredOfficeAddressDTO address) {
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @Schema(description = "")
  public RegisteredOfficeAddressDTO getAddress() {
    return address;
  }

  public void setAddress(RegisteredOfficeAddressDTO address) {
    this.address = address;
  }

  public CompanyFieldsDTO companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * Get companyName
   * @return companyName
  **/
  @Schema(description = "")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  public CompanyFieldsDTO companyNumber(String companyNumber) {
    this.companyNumber = companyNumber;
    return this;
  }

   /**
   * Get companyNumber
   * @return companyNumber
  **/
  @Schema(description = "")
  public String getCompanyNumber() {
    return companyNumber;
  }

  public void setCompanyNumber(String companyNumber) {
    this.companyNumber = companyNumber;
  }

  public CompanyFieldsDTO contractConfigurationId(Long contractConfigurationId) {
    this.contractConfigurationId = contractConfigurationId;
    return this;
  }

   /**
   * Get contractConfigurationId
   * @return contractConfigurationId
  **/
  @Schema(description = "")
  public Long getContractConfigurationId() {
    return contractConfigurationId;
  }

  public void setContractConfigurationId(Long contractConfigurationId) {
    this.contractConfigurationId = contractConfigurationId;
  }

  public CompanyFieldsDTO createdBy(Long createdBy) {
    this.createdBy = createdBy;
    return this;
  }

   /**
   * Get createdBy
   * @return createdBy
  **/
  @Schema(description = "")
  public Long getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Long createdBy) {
    this.createdBy = createdBy;
  }

  public CompanyFieldsDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(description = "")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public CompanyFieldsDTO registeredOfficeAddress(RegisteredOfficeAddressDTO registeredOfficeAddress) {
    this.registeredOfficeAddress = registeredOfficeAddress;
    return this;
  }

   /**
   * Get registeredOfficeAddress
   * @return registeredOfficeAddress
  **/
  @Schema(description = "")
  public RegisteredOfficeAddressDTO getRegisteredOfficeAddress() {
    return registeredOfficeAddress;
  }

  public void setRegisteredOfficeAddress(RegisteredOfficeAddressDTO registeredOfficeAddress) {
    this.registeredOfficeAddress = registeredOfficeAddress;
  }

  public CompanyFieldsDTO role(RoleEnum role) {
    this.role = role;
    return this;
  }

   /**
   * Get role
   * @return role
  **/
  @Schema(description = "")
  public RoleEnum getRole() {
    return role;
  }

  public void setRole(RoleEnum role) {
    this.role = role;
  }

  public CompanyFieldsDTO side(SideEnum side) {
    this.side = side;
    return this;
  }

   /**
   * Get side
   * @return side
  **/
  @Schema(description = "")
  public SideEnum getSide() {
    return side;
  }

  public void setSide(SideEnum side) {
    this.side = side;
  }

  public CompanyFieldsDTO signatoryRelatedCompany(Long signatoryRelatedCompany) {
    this.signatoryRelatedCompany = signatoryRelatedCompany;
    return this;
  }

   /**
   * Get signatoryRelatedCompany
   * @return signatoryRelatedCompany
  **/
  @Schema(description = "")
  public Long getSignatoryRelatedCompany() {
    return signatoryRelatedCompany;
  }

  public void setSignatoryRelatedCompany(Long signatoryRelatedCompany) {
    this.signatoryRelatedCompany = signatoryRelatedCompany;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyFieldsDTO companyFieldsDTO = (CompanyFieldsDTO) o;
    return Objects.equals(this.address, companyFieldsDTO.address) &&
        Objects.equals(this.companyName, companyFieldsDTO.companyName) &&
        Objects.equals(this.companyNumber, companyFieldsDTO.companyNumber) &&
        Objects.equals(this.contractConfigurationId, companyFieldsDTO.contractConfigurationId) &&
        Objects.equals(this.createdBy, companyFieldsDTO.createdBy) &&
        Objects.equals(this.id, companyFieldsDTO.id) &&
        Objects.equals(this.registeredOfficeAddress, companyFieldsDTO.registeredOfficeAddress) &&
        Objects.equals(this.role, companyFieldsDTO.role) &&
        Objects.equals(this.side, companyFieldsDTO.side) &&
        Objects.equals(this.signatoryRelatedCompany, companyFieldsDTO.signatoryRelatedCompany);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, companyName, companyNumber, contractConfigurationId, createdBy, id, registeredOfficeAddress, role, side, signatoryRelatedCompany);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyFieldsDTO {\n");
    
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyNumber: ").append(toIndentedString(companyNumber)).append("\n");
    sb.append("    contractConfigurationId: ").append(toIndentedString(contractConfigurationId)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    registeredOfficeAddress: ").append(toIndentedString(registeredOfficeAddress)).append("\n");
    sb.append("    role: ").append(toIndentedString(role)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    signatoryRelatedCompany: ").append(toIndentedString(signatoryRelatedCompany)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
