/*
 * Legislate API
 * The Legislate API is organized around REST. Our API has predictable resource-oriented URLs, accepts form-encoded request bodies, returns JSON-encoded responses, and uses standard HTTP response codes, authentication, and verbs.
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.legislate.api;

import com.legislate.ApiCallback;
import com.legislate.ApiClient;
import com.legislate.ApiException;
import com.legislate.ApiResponse;
import com.legislate.Configuration;
import com.legislate.Pair;
import com.legislate.ProgressRequestBody;
import com.legislate.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.legislate.model.CollaboratorFieldsRequestDTO;
import com.legislate.model.CompanyCreatedResponseDTO;
import com.legislate.model.CompanyFieldsDTO;
import com.legislate.model.ContractCollaboratorResponseDTO;
import com.legislate.model.IdentityFieldsCollaboratorRoleDTO;
import com.legislate.model.Link;
import com.legislate.model.ObtainIdentityFieldsDTO;
import com.legislate.model.UpdateCollaboratorIdentityFieldsRequestDTO;
import com.legislate.model.UpdateFieldsCollaboratorDTO;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollaboratorsApi {
    private ApiClient apiClient;

    public CollaboratorsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CollaboratorsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteCollaboratorUsingDELETE
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to delete. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCollaboratorUsingDELETECall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/collaborators/{collaboratorId}"
            .replaceAll("\\{" + "collaboratorId" + "\\}", apiClient.escapeString(collaboratorId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "auth0_jwt" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCollaboratorUsingDELETEValidateBeforeCall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'collaboratorId' is set
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling deleteCollaboratorUsingDELETE(Async)");
        }
        
        com.squareup.okhttp.Call call = deleteCollaboratorUsingDELETECall(collaboratorId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Delete a Collaborator by its id.
     * This operation will delete a Collaborator by its id.
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to delete. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteCollaboratorUsingDELETE(Long collaboratorId) throws ApiException {
        deleteCollaboratorUsingDELETEWithHttpInfo(collaboratorId);
    }

    /**
     * Delete a Collaborator by its id.
     * This operation will delete a Collaborator by its id.
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to delete. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteCollaboratorUsingDELETEWithHttpInfo(Long collaboratorId) throws ApiException {
        com.squareup.okhttp.Call call = deleteCollaboratorUsingDELETEValidateBeforeCall(collaboratorId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a Collaborator by its id. (asynchronously)
     * This operation will delete a Collaborator by its id.
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to delete. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteCollaboratorUsingDELETEAsync(Long collaboratorId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteCollaboratorUsingDELETEValidateBeforeCall(collaboratorId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getCollaboratorIdentityFieldsByCollaboratorUsingGET
     * @param body obtainIdentityFieldsDTO (required)
     * @param idTemplate The unique Id of the template of the contract which is associated with the collaborator. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCollaboratorIdentityFieldsByCollaboratorUsingGETCall(ObtainIdentityFieldsDTO body, Long idTemplate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/v1/templates/{idTemplate}/updatefields"
            .replaceAll("\\{" + "idTemplate" + "\\}", apiClient.escapeString(idTemplate.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "*/*"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "auth0_jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCollaboratorIdentityFieldsByCollaboratorUsingGETValidateBeforeCall(ObtainIdentityFieldsDTO body, Long idTemplate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getCollaboratorIdentityFieldsByCollaboratorUsingGET(Async)");
        }
        // verify the required parameter 'idTemplate' is set
        if (idTemplate == null) {
            throw new ApiException("Missing the required parameter 'idTemplate' when calling getCollaboratorIdentityFieldsByCollaboratorUsingGET(Async)");
        }
        
        com.squareup.okhttp.Call call = getCollaboratorIdentityFieldsByCollaboratorUsingGETCall(body, idTemplate, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get Identity fields due to role, side, template and collaboratorId
     * This operation will retrieve the fields need to be filled due to a side and a list of roles.
     * @param body obtainIdentityFieldsDTO (required)
     * @param idTemplate The unique Id of the template of the contract which is associated with the collaborator. (required)
     * @return List&lt;IdentityFieldsCollaboratorRoleDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<IdentityFieldsCollaboratorRoleDTO> getCollaboratorIdentityFieldsByCollaboratorUsingGET(ObtainIdentityFieldsDTO body, Long idTemplate) throws ApiException {
        ApiResponse<List<IdentityFieldsCollaboratorRoleDTO>> resp = getCollaboratorIdentityFieldsByCollaboratorUsingGETWithHttpInfo(body, idTemplate);
        return resp.getData();
    }

    /**
     * Get Identity fields due to role, side, template and collaboratorId
     * This operation will retrieve the fields need to be filled due to a side and a list of roles.
     * @param body obtainIdentityFieldsDTO (required)
     * @param idTemplate The unique Id of the template of the contract which is associated with the collaborator. (required)
     * @return ApiResponse&lt;List&lt;IdentityFieldsCollaboratorRoleDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<IdentityFieldsCollaboratorRoleDTO>> getCollaboratorIdentityFieldsByCollaboratorUsingGETWithHttpInfo(ObtainIdentityFieldsDTO body, Long idTemplate) throws ApiException {
        com.squareup.okhttp.Call call = getCollaboratorIdentityFieldsByCollaboratorUsingGETValidateBeforeCall(body, idTemplate, null, null);
        Type localVarReturnType = new TypeToken<List<IdentityFieldsCollaboratorRoleDTO>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Identity fields due to role, side, template and collaboratorId (asynchronously)
     * This operation will retrieve the fields need to be filled due to a side and a list of roles.
     * @param body obtainIdentityFieldsDTO (required)
     * @param idTemplate The unique Id of the template of the contract which is associated with the collaborator. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getCollaboratorIdentityFieldsByCollaboratorUsingGETAsync(ObtainIdentityFieldsDTO body, Long idTemplate, final ApiCallback<List<IdentityFieldsCollaboratorRoleDTO>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCollaboratorIdentityFieldsByCollaboratorUsingGETValidateBeforeCall(body, idTemplate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<IdentityFieldsCollaboratorRoleDTO>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getCollaboratorIdentityFieldsUsingGET
     * @param idTemplate The unique Id of the template of the contract which is associated with the collaborator. (required)
     * @param roles The role of the contract collaborator. (required)
     * @param side The side of the contract collaborator. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCollaboratorIdentityFieldsUsingGETCall(Long idTemplate, List<String> roles, String side, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/templates/{idTemplate}/fields"
            .replaceAll("\\{" + "idTemplate" + "\\}", apiClient.escapeString(idTemplate.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (roles != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "roles", roles));
        if (side != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("side", side));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "auth0_jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCollaboratorIdentityFieldsUsingGETValidateBeforeCall(Long idTemplate, List<String> roles, String side, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'idTemplate' is set
        if (idTemplate == null) {
            throw new ApiException("Missing the required parameter 'idTemplate' when calling getCollaboratorIdentityFieldsUsingGET(Async)");
        }
        // verify the required parameter 'roles' is set
        if (roles == null) {
            throw new ApiException("Missing the required parameter 'roles' when calling getCollaboratorIdentityFieldsUsingGET(Async)");
        }
        // verify the required parameter 'side' is set
        if (side == null) {
            throw new ApiException("Missing the required parameter 'side' when calling getCollaboratorIdentityFieldsUsingGET(Async)");
        }
        
        com.squareup.okhttp.Call call = getCollaboratorIdentityFieldsUsingGETCall(idTemplate, roles, side, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get Identity fields
     * This operation will retrieve the fields need to be filled due to a side and a list of roles.
     * @param idTemplate The unique Id of the template of the contract which is associated with the collaborator. (required)
     * @param roles The role of the contract collaborator. (required)
     * @param side The side of the contract collaborator. (required)
     * @return List&lt;IdentityFieldsCollaboratorRoleDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<IdentityFieldsCollaboratorRoleDTO> getCollaboratorIdentityFieldsUsingGET(Long idTemplate, List<String> roles, String side) throws ApiException {
        ApiResponse<List<IdentityFieldsCollaboratorRoleDTO>> resp = getCollaboratorIdentityFieldsUsingGETWithHttpInfo(idTemplate, roles, side);
        return resp.getData();
    }

    /**
     * Get Identity fields
     * This operation will retrieve the fields need to be filled due to a side and a list of roles.
     * @param idTemplate The unique Id of the template of the contract which is associated with the collaborator. (required)
     * @param roles The role of the contract collaborator. (required)
     * @param side The side of the contract collaborator. (required)
     * @return ApiResponse&lt;List&lt;IdentityFieldsCollaboratorRoleDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<IdentityFieldsCollaboratorRoleDTO>> getCollaboratorIdentityFieldsUsingGETWithHttpInfo(Long idTemplate, List<String> roles, String side) throws ApiException {
        com.squareup.okhttp.Call call = getCollaboratorIdentityFieldsUsingGETValidateBeforeCall(idTemplate, roles, side, null, null);
        Type localVarReturnType = new TypeToken<List<IdentityFieldsCollaboratorRoleDTO>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Identity fields (asynchronously)
     * This operation will retrieve the fields need to be filled due to a side and a list of roles.
     * @param idTemplate The unique Id of the template of the contract which is associated with the collaborator. (required)
     * @param roles The role of the contract collaborator. (required)
     * @param side The side of the contract collaborator. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getCollaboratorIdentityFieldsUsingGETAsync(Long idTemplate, List<String> roles, String side, final ApiCallback<List<IdentityFieldsCollaboratorRoleDTO>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCollaboratorIdentityFieldsUsingGETValidateBeforeCall(idTemplate, roles, side, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<IdentityFieldsCollaboratorRoleDTO>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getCollaboratorUsingGET
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to look up. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCollaboratorUsingGETCall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/collaborators/{collaboratorId}"
            .replaceAll("\\{" + "collaboratorId" + "\\}", apiClient.escapeString(collaboratorId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "auth0_jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCollaboratorUsingGETValidateBeforeCall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'collaboratorId' is set
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling getCollaboratorUsingGET(Async)");
        }
        
        com.squareup.okhttp.Call call = getCollaboratorUsingGETCall(collaboratorId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get contract collaborator details
     * 
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to look up. (required)
     * @return ContractCollaboratorResponseDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ContractCollaboratorResponseDTO getCollaboratorUsingGET(Long collaboratorId) throws ApiException {
        ApiResponse<ContractCollaboratorResponseDTO> resp = getCollaboratorUsingGETWithHttpInfo(collaboratorId);
        return resp.getData();
    }

    /**
     * Get contract collaborator details
     * 
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to look up. (required)
     * @return ApiResponse&lt;ContractCollaboratorResponseDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ContractCollaboratorResponseDTO> getCollaboratorUsingGETWithHttpInfo(Long collaboratorId) throws ApiException {
        com.squareup.okhttp.Call call = getCollaboratorUsingGETValidateBeforeCall(collaboratorId, null, null);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get contract collaborator details (asynchronously)
     * 
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to look up. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getCollaboratorUsingGETAsync(Long collaboratorId, final ApiCallback<ContractCollaboratorResponseDTO> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCollaboratorUsingGETValidateBeforeCall(collaboratorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getCollaboratorsUsingGET
     * @param contractId The unique Id of the contract associated with the collaborator you&#x27;d like to look up. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCollaboratorsUsingGETCall(Long contractId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/contracts/{contractId}/collaborators"
            .replaceAll("\\{" + "contractId" + "\\}", apiClient.escapeString(contractId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "auth0_jwt" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCollaboratorsUsingGETValidateBeforeCall(Long contractId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'contractId' is set
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling getCollaboratorsUsingGET(Async)");
        }
        
        com.squareup.okhttp.Call call = getCollaboratorsUsingGETCall(contractId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get collaborators for a given contract
     * 
     * @param contractId The unique Id of the contract associated with the collaborator you&#x27;d like to look up. (required)
     * @return List&lt;ContractCollaboratorResponseDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<ContractCollaboratorResponseDTO> getCollaboratorsUsingGET(Long contractId) throws ApiException {
        ApiResponse<List<ContractCollaboratorResponseDTO>> resp = getCollaboratorsUsingGETWithHttpInfo(contractId);
        return resp.getData();
    }

    /**
     * Get collaborators for a given contract
     * 
     * @param contractId The unique Id of the contract associated with the collaborator you&#x27;d like to look up. (required)
     * @return ApiResponse&lt;List&lt;ContractCollaboratorResponseDTO&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<ContractCollaboratorResponseDTO>> getCollaboratorsUsingGETWithHttpInfo(Long contractId) throws ApiException {
        com.squareup.okhttp.Call call = getCollaboratorsUsingGETValidateBeforeCall(contractId, null, null);
        Type localVarReturnType = new TypeToken<List<ContractCollaboratorResponseDTO>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get collaborators for a given contract (asynchronously)
     * 
     * @param contractId The unique Id of the contract associated with the collaborator you&#x27;d like to look up. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getCollaboratorsUsingGETAsync(Long contractId, final ApiCallback<List<ContractCollaboratorResponseDTO>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCollaboratorsUsingGETValidateBeforeCall(contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ContractCollaboratorResponseDTO>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postCollaboratorUsingPOST
     * @param body createCollaboratorRequestDTO (required)
     * @param contractId The unique Id of the contract associated with the collaborator you&#x27;d like to look up. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postCollaboratorUsingPOSTCall(CollaboratorFieldsRequestDTO body, Long contractId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/v1/contracts/{contractId}/collaborators"
            .replaceAll("\\{" + "contractId" + "\\}", apiClient.escapeString(contractId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "auth0_jwt" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postCollaboratorUsingPOSTValidateBeforeCall(CollaboratorFieldsRequestDTO body, Long contractId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postCollaboratorUsingPOST(Async)");
        }
        // verify the required parameter 'contractId' is set
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling postCollaboratorUsingPOST(Async)");
        }
        
        com.squareup.okhttp.Call call = postCollaboratorUsingPOSTCall(body, contractId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Create a collaborator given a contract
     * This operation will create a collaborator associated to the contract given
     * @param body createCollaboratorRequestDTO (required)
     * @param contractId The unique Id of the contract associated with the collaborator you&#x27;d like to look up. (required)
     * @return Link
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Link postCollaboratorUsingPOST(CollaboratorFieldsRequestDTO body, Long contractId) throws ApiException {
        ApiResponse<Link> resp = postCollaboratorUsingPOSTWithHttpInfo(body, contractId);
        return resp.getData();
    }

    /**
     * Create a collaborator given a contract
     * This operation will create a collaborator associated to the contract given
     * @param body createCollaboratorRequestDTO (required)
     * @param contractId The unique Id of the contract associated with the collaborator you&#x27;d like to look up. (required)
     * @return ApiResponse&lt;Link&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Link> postCollaboratorUsingPOSTWithHttpInfo(CollaboratorFieldsRequestDTO body, Long contractId) throws ApiException {
        com.squareup.okhttp.Call call = postCollaboratorUsingPOSTValidateBeforeCall(body, contractId, null, null);
        Type localVarReturnType = new TypeToken<Link>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a collaborator given a contract (asynchronously)
     * This operation will create a collaborator associated to the contract given
     * @param body createCollaboratorRequestDTO (required)
     * @param contractId The unique Id of the contract associated with the collaborator you&#x27;d like to look up. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postCollaboratorUsingPOSTAsync(CollaboratorFieldsRequestDTO body, Long contractId, final ApiCallback<Link> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postCollaboratorUsingPOSTValidateBeforeCall(body, contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Link>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postCompanyUsingPOST
     * @param body companyFieldsDTORequest (required)
     * @param contractId The unique Id of the contract configuration. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postCompanyUsingPOSTCall(CompanyFieldsDTO body, Long contractId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/v1/contracts/{contractId}/company"
            .replaceAll("\\{" + "contractId" + "\\}", apiClient.escapeString(contractId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "auth0_jwt" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postCompanyUsingPOSTValidateBeforeCall(CompanyFieldsDTO body, Long contractId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postCompanyUsingPOST(Async)");
        }
        // verify the required parameter 'contractId' is set
        if (contractId == null) {
            throw new ApiException("Missing the required parameter 'contractId' when calling postCompanyUsingPOST(Async)");
        }
        
        com.squareup.okhttp.Call call = postCompanyUsingPOSTCall(body, contractId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Create a company given a contract
     * This operation will create a company associated to the contract given
     * @param body companyFieldsDTORequest (required)
     * @param contractId The unique Id of the contract configuration. (required)
     * @return CompanyCreatedResponseDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CompanyCreatedResponseDTO postCompanyUsingPOST(CompanyFieldsDTO body, Long contractId) throws ApiException {
        ApiResponse<CompanyCreatedResponseDTO> resp = postCompanyUsingPOSTWithHttpInfo(body, contractId);
        return resp.getData();
    }

    /**
     * Create a company given a contract
     * This operation will create a company associated to the contract given
     * @param body companyFieldsDTORequest (required)
     * @param contractId The unique Id of the contract configuration. (required)
     * @return ApiResponse&lt;CompanyCreatedResponseDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CompanyCreatedResponseDTO> postCompanyUsingPOSTWithHttpInfo(CompanyFieldsDTO body, Long contractId) throws ApiException {
        com.squareup.okhttp.Call call = postCompanyUsingPOSTValidateBeforeCall(body, contractId, null, null);
        Type localVarReturnType = new TypeToken<CompanyCreatedResponseDTO>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a company given a contract (asynchronously)
     * This operation will create a company associated to the contract given
     * @param body companyFieldsDTORequest (required)
     * @param contractId The unique Id of the contract configuration. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postCompanyUsingPOSTAsync(CompanyFieldsDTO body, Long contractId, final ApiCallback<CompanyCreatedResponseDTO> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postCompanyUsingPOSTValidateBeforeCall(body, contractId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CompanyCreatedResponseDTO>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updateCollaboratorBinaryFileSignatureUsingPATCH
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateCollaboratorBinaryFileSignatureUsingPATCHCall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/collaborators/{collaboratorId}/signature"
            .replaceAll("\\{" + "collaboratorId" + "\\}", apiClient.escapeString(collaboratorId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "auth0_jwt" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateCollaboratorBinaryFileSignatureUsingPATCHValidateBeforeCall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'collaboratorId' is set
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling updateCollaboratorBinaryFileSignatureUsingPATCH(Async)");
        }
        
        com.squareup.okhttp.Call call = updateCollaboratorBinaryFileSignatureUsingPATCHCall(collaboratorId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Upload a signature to a collaborator
     * This operation will sign a contract.
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @return ContractCollaboratorResponseDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ContractCollaboratorResponseDTO updateCollaboratorBinaryFileSignatureUsingPATCH(Long collaboratorId) throws ApiException {
        ApiResponse<ContractCollaboratorResponseDTO> resp = updateCollaboratorBinaryFileSignatureUsingPATCHWithHttpInfo(collaboratorId);
        return resp.getData();
    }

    /**
     * Upload a signature to a collaborator
     * This operation will sign a contract.
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @return ApiResponse&lt;ContractCollaboratorResponseDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ContractCollaboratorResponseDTO> updateCollaboratorBinaryFileSignatureUsingPATCHWithHttpInfo(Long collaboratorId) throws ApiException {
        com.squareup.okhttp.Call call = updateCollaboratorBinaryFileSignatureUsingPATCHValidateBeforeCall(collaboratorId, null, null);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Upload a signature to a collaborator (asynchronously)
     * This operation will sign a contract.
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateCollaboratorBinaryFileSignatureUsingPATCHAsync(Long collaboratorId, final ApiCallback<ContractCollaboratorResponseDTO> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateCollaboratorBinaryFileSignatureUsingPATCHValidateBeforeCall(collaboratorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updateCollaboratorFieldsUsingPATCH
     * @param body fields (required)
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to update. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateCollaboratorFieldsUsingPATCHCall(UpdateCollaboratorIdentityFieldsRequestDTO body, Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/v1/collaborators/{collaboratorId}/fields"
            .replaceAll("\\{" + "collaboratorId" + "\\}", apiClient.escapeString(collaboratorId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "auth0_jwt" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateCollaboratorFieldsUsingPATCHValidateBeforeCall(UpdateCollaboratorIdentityFieldsRequestDTO body, Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateCollaboratorFieldsUsingPATCH(Async)");
        }
        // verify the required parameter 'collaboratorId' is set
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling updateCollaboratorFieldsUsingPATCH(Async)");
        }
        
        com.squareup.okhttp.Call call = updateCollaboratorFieldsUsingPATCHCall(body, collaboratorId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Update collaborator fields
     * This operation will update a collaborator details.
     * @param body fields (required)
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to update. (required)
     * @return ContractCollaboratorResponseDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ContractCollaboratorResponseDTO updateCollaboratorFieldsUsingPATCH(UpdateCollaboratorIdentityFieldsRequestDTO body, Long collaboratorId) throws ApiException {
        ApiResponse<ContractCollaboratorResponseDTO> resp = updateCollaboratorFieldsUsingPATCHWithHttpInfo(body, collaboratorId);
        return resp.getData();
    }

    /**
     * Update collaborator fields
     * This operation will update a collaborator details.
     * @param body fields (required)
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to update. (required)
     * @return ApiResponse&lt;ContractCollaboratorResponseDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ContractCollaboratorResponseDTO> updateCollaboratorFieldsUsingPATCHWithHttpInfo(UpdateCollaboratorIdentityFieldsRequestDTO body, Long collaboratorId) throws ApiException {
        com.squareup.okhttp.Call call = updateCollaboratorFieldsUsingPATCHValidateBeforeCall(body, collaboratorId, null, null);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update collaborator fields (asynchronously)
     * This operation will update a collaborator details.
     * @param body fields (required)
     * @param collaboratorId The unique Id of the contract collaborator you&#x27;d like to update. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateCollaboratorFieldsUsingPATCHAsync(UpdateCollaboratorIdentityFieldsRequestDTO body, Long collaboratorId, final ApiCallback<ContractCollaboratorResponseDTO> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateCollaboratorFieldsUsingPATCHValidateBeforeCall(body, collaboratorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updateCollaboratorRolesUsingPATCH
     * @param body fields (required)
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateCollaboratorRolesUsingPATCHCall(UpdateFieldsCollaboratorDTO body, Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/v1/collaborators/{collaboratorId}/roles"
            .replaceAll("\\{" + "collaboratorId" + "\\}", apiClient.escapeString(collaboratorId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "auth0_jwt" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateCollaboratorRolesUsingPATCHValidateBeforeCall(UpdateFieldsCollaboratorDTO body, Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateCollaboratorRolesUsingPATCH(Async)");
        }
        // verify the required parameter 'collaboratorId' is set
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling updateCollaboratorRolesUsingPATCH(Async)");
        }
        
        com.squareup.okhttp.Call call = updateCollaboratorRolesUsingPATCHCall(body, collaboratorId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Update collaborator role
     * This operation will update a collaborator fields.
     * @param body fields (required)
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @return ContractCollaboratorResponseDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ContractCollaboratorResponseDTO updateCollaboratorRolesUsingPATCH(UpdateFieldsCollaboratorDTO body, Long collaboratorId) throws ApiException {
        ApiResponse<ContractCollaboratorResponseDTO> resp = updateCollaboratorRolesUsingPATCHWithHttpInfo(body, collaboratorId);
        return resp.getData();
    }

    /**
     * Update collaborator role
     * This operation will update a collaborator fields.
     * @param body fields (required)
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @return ApiResponse&lt;ContractCollaboratorResponseDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ContractCollaboratorResponseDTO> updateCollaboratorRolesUsingPATCHWithHttpInfo(UpdateFieldsCollaboratorDTO body, Long collaboratorId) throws ApiException {
        com.squareup.okhttp.Call call = updateCollaboratorRolesUsingPATCHValidateBeforeCall(body, collaboratorId, null, null);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update collaborator role (asynchronously)
     * This operation will update a collaborator fields.
     * @param body fields (required)
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateCollaboratorRolesUsingPATCHAsync(UpdateFieldsCollaboratorDTO body, Long collaboratorId, final ApiCallback<ContractCollaboratorResponseDTO> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateCollaboratorRolesUsingPATCHValidateBeforeCall(body, collaboratorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updateCollaboratorSignatureUsingPATCH
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateCollaboratorSignatureUsingPATCHCall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/v1/collaborators/{collaboratorId}/user-signature"
            .replaceAll("\\{" + "collaboratorId" + "\\}", apiClient.escapeString(collaboratorId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "auth0_jwt" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateCollaboratorSignatureUsingPATCHValidateBeforeCall(Long collaboratorId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'collaboratorId' is set
        if (collaboratorId == null) {
            throw new ApiException("Missing the required parameter 'collaboratorId' when calling updateCollaboratorSignatureUsingPATCH(Async)");
        }
        
        com.squareup.okhttp.Call call = updateCollaboratorSignatureUsingPATCHCall(collaboratorId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Upload a signature to a collaborator
     * This operation will sign a contract.
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @return ContractCollaboratorResponseDTO
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ContractCollaboratorResponseDTO updateCollaboratorSignatureUsingPATCH(Long collaboratorId) throws ApiException {
        ApiResponse<ContractCollaboratorResponseDTO> resp = updateCollaboratorSignatureUsingPATCHWithHttpInfo(collaboratorId);
        return resp.getData();
    }

    /**
     * Upload a signature to a collaborator
     * This operation will sign a contract.
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @return ApiResponse&lt;ContractCollaboratorResponseDTO&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ContractCollaboratorResponseDTO> updateCollaboratorSignatureUsingPATCHWithHttpInfo(Long collaboratorId) throws ApiException {
        com.squareup.okhttp.Call call = updateCollaboratorSignatureUsingPATCHValidateBeforeCall(collaboratorId, null, null);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Upload a signature to a collaborator (asynchronously)
     * This operation will sign a contract.
     * @param collaboratorId The unique Id of the contract collaborator who is signing. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateCollaboratorSignatureUsingPATCHAsync(Long collaboratorId, final ApiCallback<ContractCollaboratorResponseDTO> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateCollaboratorSignatureUsingPATCHValidateBeforeCall(collaboratorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ContractCollaboratorResponseDTO>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
